/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.web;

import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import org.hswebframework.web.authorization.exception.AccessDenyException;
import org.hswebframework.web.authorization.exception.AuthenticationException;
import org.hswebframework.web.authorization.exception.UnAuthorizedException;
import org.hswebframework.web.authorization.token.TokenState;
import org.hswebframework.web.crud.web.ResponseMessage;
import org.hswebframework.web.exception.BusinessException;
import org.hswebframework.web.exception.NotFoundException;
import org.hswebframework.web.exception.ValidationException;
import org.hswebframework.web.logger.ReactiveLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.server.MediaTypeNotSupportedStatusException;
import org.springframework.web.server.MethodNotAllowedException;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebInputException;
import reactor.core.publisher.Mono;

@RestControllerAdvice
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@Order
public class CommonErrorControllerAdvice {
    private static final Logger log = LoggerFactory.getLogger(CommonErrorControllerAdvice.class);

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Mono<ResponseMessage<Object>> handleException(BusinessException e) {
        return Mono.just(ResponseMessage.error(e.getCode(), e.getMessage())).doOnEach(ReactiveLogger.onNext(r -> log.error(e.getMessage(), (Throwable)e)));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Mono<ResponseMessage<?>> handleException(UnsupportedOperationException e) {
        return Mono.just(ResponseMessage.error("unsupported", e.getMessage()));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public Mono<ResponseMessage<TokenState>> handleException(UnAuthorizedException e) {
        return Mono.just(ResponseMessage.error(401, "unauthorized", e.getMessage()).result(e.getState()));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    public Mono<ResponseMessage<?>> handleException(AccessDenyException e) {
        return Mono.just(ResponseMessage.error(403, e.getCode(), e.getMessage()));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public Mono<ResponseMessage<?>> handleException(NotFoundException e) {
        return Mono.just(ResponseMessage.error(404, "not_found", e.getMessage()));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<List<ValidationException.Detail>>> handleException(org.hswebframework.web.exception.ValidationException e) {
        return Mono.just(ResponseMessage.error(400, "illegal_argument", e.getMessage()).result(e.getDetails()));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<List<ValidationException.Detail>>> handleException(ConstraintViolationException e) {
        return this.handleException(new org.hswebframework.web.exception.ValidationException(e.getMessage(), e.getConstraintViolations()));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<List<ValidationException.Detail>>> handleException(BindException e) {
        return this.handleException(new org.hswebframework.web.exception.ValidationException(e.getMessage(), e.getBindingResult().getAllErrors().stream().filter(FieldError.class::isInstance).map(FieldError.class::cast).map(err -> new ValidationException.Detail(err.getField(), err.getDefaultMessage(), null)).collect(Collectors.toList())));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<List<ValidationException.Detail>>> handleException(WebExchangeBindException e) {
        return this.handleException(new org.hswebframework.web.exception.ValidationException(e.getMessage(), e.getBindingResult().getAllErrors().stream().filter(FieldError.class::isInstance).map(FieldError.class::cast).map(err -> new ValidationException.Detail(err.getField(), err.getDefaultMessage(), null)).collect(Collectors.toList())));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<List<ValidationException.Detail>>> handleException(MethodArgumentNotValidException e) {
        return this.handleException(new org.hswebframework.web.exception.ValidationException(e.getMessage(), e.getBindingResult().getAllErrors().stream().filter(FieldError.class::isInstance).map(FieldError.class::cast).map(err -> new ValidationException.Detail(err.getField(), err.getDefaultMessage(), null)).collect(Collectors.toList())));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<?>> handleException(ValidationException e) {
        return Mono.just(ResponseMessage.error(400, "illegal_argument", e.getMessage()));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.GATEWAY_TIMEOUT)
    public Mono<ResponseMessage<Object>> handleException(TimeoutException e) {
        return Mono.just(ResponseMessage.error(504, "timeout", e.getMessage())).doOnEach(ReactiveLogger.onNext(r -> log.error(e.getMessage(), (Throwable)e)));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @Order
    public Mono<ResponseMessage<Object>> handleException(RuntimeException e) {
        return Mono.just(ResponseMessage.error(e.getMessage())).doOnEach(ReactiveLogger.onNext(r -> log.error(e.getMessage(), (Throwable)e)));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Mono<ResponseMessage<Object>> handleException(NullPointerException e) {
        return Mono.just(ResponseMessage.error(e.getMessage())).doOnEach(ReactiveLogger.onNext(r -> log.error(e.getMessage(), (Throwable)e)));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<Object>> handleException(IllegalArgumentException e) {
        return Mono.just(ResponseMessage.error(400, "illegal_argument", e.getMessage())).doOnEach(ReactiveLogger.onNext(r -> log.error(e.getMessage(), (Throwable)e)));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<Object>> handleException(AuthenticationException e) {
        return Mono.just(ResponseMessage.error(400, e.getCode(), e.getMessage()));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.UNSUPPORTED_MEDIA_TYPE)
    public Mono<ResponseMessage<Object>> handleException(MediaTypeNotSupportedStatusException e) {
        return Mono.just(ResponseMessage.error(415, "unsupported_media_type", "\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u7c7b\u578b").result(e.getSupportedMediaTypes())).doOnEach(ReactiveLogger.onNext(r -> log.error(e.getMessage(), (Throwable)e)));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    public Mono<ResponseMessage<Object>> handleException(NotAcceptableStatusException e) {
        return Mono.just(ResponseMessage.error(406, "not_acceptable_media_type", "\u4e0d\u652f\u6301\u7684\u54cd\u5e94\u7c7b\u578b").result(e.getSupportedMediaTypes())).doOnEach(ReactiveLogger.onNext(r -> log.error(e.getMessage(), (Throwable)e)));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    public Mono<ResponseMessage<Object>> handleException(MethodNotAllowedException e) {
        return Mono.just(ResponseMessage.error(405, "method_not_allowed", "\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u65b9\u6cd5:" + e.getHttpMethod()).result(e.getSupportedMethods())).doOnEach(ReactiveLogger.onNext(r -> log.error(e.getMessage(), (Throwable)e)));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<List<ValidationException.Detail>>> handleException(ServerWebInputException e) {
        Object exception = e;
        do {
            if (!((exception = exception.getCause()) instanceof org.hswebframework.web.exception.ValidationException)) continue;
            return this.handleException((org.hswebframework.web.exception.ValidationException)exception);
        } while (exception != null && exception != e);
        return Mono.just(ResponseMessage.error(400, "illegal_argument", e.getMessage()));
    }
}

