/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.query;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.persistence.Table;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.core.Conditional;
import org.hswebframework.ezorm.core.GlobalConfig;
import org.hswebframework.ezorm.core.MethodReferenceColumn;
import org.hswebframework.ezorm.core.MethodReferenceConverter;
import org.hswebframework.ezorm.core.MethodReferenceInfo;
import org.hswebframework.ezorm.core.NestConditional;
import org.hswebframework.ezorm.core.ObjectPropertyOperator;
import org.hswebframework.ezorm.core.SimpleNestConditional;
import org.hswebframework.ezorm.core.StaticMethodReferenceColumn;
import org.hswebframework.ezorm.core.TermTypeConditionalSupport;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.reactive.ReactiveSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.wrapper.ColumnWrapperContext;
import org.hswebframework.ezorm.rdb.executor.wrapper.MapResultWrapper;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrappers;
import org.hswebframework.ezorm.rdb.mapping.defaults.record.DefaultRecord;
import org.hswebframework.ezorm.rdb.mapping.defaults.record.Record;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBFeatureType;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.operator.DatabaseOperator;
import org.hswebframework.ezorm.rdb.operator.builder.Paginator;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.NativeSql;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.dml.Join;
import org.hswebframework.ezorm.rdb.operator.dml.JoinType;
import org.hswebframework.ezorm.rdb.operator.dml.QueryOperator;
import org.hswebframework.ezorm.rdb.operator.dml.SelectColumnSupplier;
import org.hswebframework.ezorm.rdb.operator.dml.query.BuildParameterQueryOperator;
import org.hswebframework.ezorm.rdb.operator.dml.query.Selects;
import org.hswebframework.ezorm.rdb.operator.dml.query.SortOrder;
import org.hswebframework.web.api.crud.entity.EntityFactoryHolder;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.crud.query.JoinConditionalSpec;
import org.hswebframework.web.crud.query.JoinNestConditionalSpec;
import org.hswebframework.web.crud.query.QueryAnalyzer;
import org.hswebframework.web.crud.query.QueryAnalyzerImpl;
import org.hswebframework.web.crud.query.QueryHelper;
import org.hswebframework.web.crud.query.QueryHelperUtils;
import org.hswebframework.web.crud.query.ToHumpMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class DefaultQueryHelper
implements QueryHelper {
    private final DatabaseOperator database;
    private final Map<Class<?>, Table> nameMapping = new ConcurrentHashMap();
    private final Map<String, QueryAnalyzer> analyzerCaches = new ConcurrentHashMap<String, QueryAnalyzer>();
    static final ResultWrapper<Integer, ?> countWrapper = ResultWrappers.column((String)"_total", i -> ((Number)i).intValue());

    @Override
    public QueryAnalyzer analysis(String selectSql) {
        return this.analyzerCaches.computeIfAbsent(selectSql, sql -> new QueryAnalyzerImpl(this.database, (String)sql));
    }

    @Override
    public QueryHelper.NativeQuerySpec<Record> select(String sql, Object ... args) {
        return new NativeQuerySpecImpl<Record>(this, sql, args, DefaultRecord::new, false);
    }

    @Override
    public <T> QueryHelper.NativeQuerySpec<T> select(String sql, Supplier<T> newInstance, Object ... args) {
        NativeQuerySpecImpl<Object> impl = new NativeQuerySpecImpl<Object>(this, sql, args, map -> FastBeanCopier.copy((Object)map, (Supplier)newInstance, (String[])new String[0]), true);
        impl.setMapBuilder(ToHumpMap::new);
        return impl;
    }

    @Override
    public <R> QueryHelper.SelectColumnMapperSpec<R> select(Class<R> resultType) {
        return new QuerySpec<R>(resultType, this);
    }

    @Override
    public <R> QueryHelper.SelectSpec<R> select(Class<R> resultType, Consumer<QueryHelper.ColumnMapperSpec<R, ?>> mapperSpec) {
        QuerySpec<R> querySpec = new QuerySpec<R>(resultType, this);
        mapperSpec.accept(querySpec);
        return querySpec;
    }

    TableOrViewMetadata getTable(Class<?> type) {
        Table table = this.nameMapping.computeIfAbsent(type, this::parseTableName);
        if (StringUtils.hasText((String)table.schema())) {
            return (TableOrViewMetadata)this.database.getMetadata().getSchema(table.schema()).flatMap(schema -> schema.getTableOrView(table.name(), false)).orElseThrow(() -> new UnsupportedOperationException("table [" + table.schema() + "." + table.name() + "] not found"));
        }
        return (TableOrViewMetadata)((RDBSchemaMetadata)this.database.getMetadata().getCurrentSchema()).getTableOrView(table.name(), false).orElseThrow(() -> new UnsupportedOperationException("table [" + table.name() + "] not found"));
    }

    static RDBColumnMetadata getColumn(TableOrViewMetadata table, String column) {
        return (RDBColumnMetadata)table.getColumn(column).orElseThrow(() -> new UnsupportedOperationException("column [" + column + "] not found in [" + table.getName() + "]"));
    }

    Table parseTableName(Class<?> type) {
        Table table = (Table)AnnotatedElementUtils.findMergedAnnotation(type, Table.class);
        if (null == table) {
            throw new UnsupportedOperationException("type [" + type.getName() + "] not found @Table annotation");
        }
        return table;
    }

    @SafeVarargs
    private static <T> T[] toArray(T ... arr) {
        return arr;
    }

    public DefaultQueryHelper(DatabaseOperator database) {
        this.database = database;
    }

    static class NativeQuerySpecImpl<R>
    extends MapResultWrapper
    implements QueryHelper.NativeQuerySpec<R> {
        ContextView logContext = Context.empty();
        private final DefaultQueryHelper parent;
        private final QueryAnalyzer analyzer;
        private final Object[] args;
        private final Function<Map<String, Object>, R> mapper;
        private QueryParamEntity param;

        NativeQuerySpecImpl(DefaultQueryHelper parent, String sql, Object[] args, Function<Map<String, Object>, R> mapper, boolean nest) {
            this.parent = parent;
            this.analyzer = parent.analysis(sql);
            this.args = args;
            this.mapper = mapper;
            this.setWrapperNestObject(nest);
        }

        public void wrapColumn(ColumnWrapperContext<Map<String, Object>> context) {
            Map instance = (Map)context.getRowInstance();
            String column = context.getColumnLabel();
            QueryAnalyzer.Column col = this.analyzer.findColumn(column).orElse(null);
            if (col != null && !this.analyzer.columnIsExpression(column, context.getColumnIndex())) {
                Object val = col.metadata == null ? this.getCodec().decode(context.getResult()) : col.metadata.decode(context.getResult());
                this.doWrap(instance, column, val);
            } else {
                this.doWrap(instance, col == null ? QueryHelperUtils.toHump(column) : col.alias, this.getCodec().decode(context.getResult()));
            }
        }

        @Override
        public QueryHelper.NativeQuerySpec<R> logger(Logger logger) {
            this.logContext = Context.of(Logger.class, (Object)logger);
            return this;
        }

        @Override
        public Mono<Integer> count() {
            SqlRequest countSql = this.analyzer.refactorCount(this.param == null ? new QueryParamEntity() : this.param, this.args);
            return this.parent.database.sql().reactive().select(countSql, countWrapper).single((Object)0).contextWrite(this.logContext);
        }

        @Override
        public QueryHelper.ExecuteSpec<R> where(QueryParamEntity param) {
            this.param = param;
            return this;
        }

        @Override
        public Flux<R> fetch() {
            QueryParamEntity _param = this.param == null ? QueryParamEntity.of().noPaging() : this.param;
            SqlRequest request = this.analyzer.refactor(_param, this.args);
            if (_param.isPaging()) {
                request = this.createPagingSql(request, this.param.getPageIndex(), this.param.getPageSize());
            }
            return this.parent.database.sql().reactive().select(request, (ResultWrapper)this).map(this.mapper).contextWrite(this.logContext);
        }

        @Override
        public Flux<R> fetch(int pageIndex, int pageSize) {
            if (this.param == null) {
                this.param = new QueryParamEntity();
            }
            this.param.doPaging(pageIndex, pageSize);
            return this.fetch();
        }

        @Override
        public Mono<PagerResult<R>> fetchPaged() {
            if (this.param == null) {
                return this.fetchPaged(0, 25);
            }
            return this.fetchPaged(this.param);
        }

        private SqlRequest createPagingSql(SqlRequest request, int pageIndex, int pageSize) {
            PrepareSqlFragments sql = PrepareSqlFragments.of((String)request.getSql(), (Object[])request.getParameters());
            Paginator paginator = (Paginator)((RDBSchemaMetadata)this.parent.database.getMetadata().getCurrentSchema()).findFeatureNow(RDBFeatureType.paginator.getId());
            return paginator.doPaging((SqlFragments)sql, pageIndex, pageSize).toRequest();
        }

        @Override
        public Mono<PagerResult<R>> fetchPaged(int pageIndex, int pageSize) {
            return this.fetchPaged(this.param == null ? (QueryParamEntity)new QueryParamEntity().doPaging(pageIndex, pageSize) : (QueryParamEntity)this.param.clone().doPaging(pageIndex, pageSize));
        }

        public Mono<PagerResult<R>> fetchPaged(QueryParamEntity param) {
            SqlRequest listSql = this.analyzer.refactor(param, this.args);
            ReactiveSqlExecutor sqlExecutor = this.parent.database.sql().reactive();
            if (param.getTotal() != null) {
                return sqlExecutor.select(this.createPagingSql(listSql, param.getPageIndex(), param.getPageSize()), (ResultWrapper)this).map(this.mapper).collectList().map(list -> PagerResult.of((int)param.getTotal(), (List)list, (QueryParam)param)).contextWrite(this.logContext);
            }
            SqlRequest countSql = this.analyzer.refactorCount(param, this.args);
            if (param.isParallelPager()) {
                return Mono.zip((Mono)sqlExecutor.select(countSql, countWrapper).single((Object)0), (Mono)sqlExecutor.select(this.createPagingSql(listSql, param.getPageIndex(), param.getPageSize()), (ResultWrapper)this).map(this.mapper).collectList(), (total, list) -> PagerResult.of((int)total, (List)list, (QueryParam)param)).contextWrite(this.logContext);
            }
            return sqlExecutor.select(countSql, countWrapper).single((Object)0).flatMap(total -> {
                QueryParamEntity copy = param.clone();
                copy.rePaging(total.intValue());
                if (total == 0) {
                    return Mono.just((Object)PagerResult.of((int)0, new ArrayList(), (QueryParam)copy));
                }
                return sqlExecutor.select(this.createPagingSql(listSql, copy.getPageIndex(), copy.getPageSize()), (ResultWrapper)this).map(this.mapper).collectList().map(list -> PagerResult.of((int)total, (List)list, (QueryParam)copy));
            }).contextWrite(this.logContext);
        }
    }

    static class QuerySpec<R>
    implements QueryHelper.SelectSpec<R>,
    QueryHelper.FromSpec<R>,
    QueryHelper.SortSpec<R>,
    ResultWrapper<R, R>,
    QueryHelper.SelectColumnMapperSpec<R> {
        private static final Logger log = LoggerFactory.getLogger(QuerySpec.class);
        private final Class<R> clazz;
        private final DefaultQueryHelper parent;
        private final List<ColumnMapping<R>> mappings = new ArrayList<ColumnMapping<R>>();
        private TableOrViewMetadata table;
        private Class<?> from;
        private int joinIndex;
        private QueryOperator query;
        private List<JoinConditionalSpecImpl> joins;
        private QueryParamEntity param;
        final ContextView logContext;
        private Function<Flux<R>, Flux<R>> resultHandler = Function.identity();

        public QuerySpec(Class<R> clazz, DefaultQueryHelper parent) {
            this.clazz = EntityFactoryHolder.getMappedType(clazz);
            this.parent = parent;
            this.logContext = Context.of(Logger.class, (Object)LoggerFactory.getLogger(clazz));
        }

        private List<JoinConditionalSpecImpl> joins() {
            return this.joins == null ? (this.joins = new ArrayList<JoinConditionalSpecImpl>(3)) : this.joins;
        }

        private JoinConditionalSpecImpl getJoinByClass(Class<?> clazz) {
            if (this.joins != null) {
                for (JoinConditionalSpecImpl join : this.joins) {
                    if (!Objects.equals(join.mainClass, clazz)) continue;
                    return join;
                }
            }
            throw new IllegalArgumentException("join class [" + clazz + "] not found!");
        }

        private JoinConditionalSpecImpl getJoinByAlias(String alias) {
            if (this.joins != null) {
                for (JoinConditionalSpecImpl join : this.joins) {
                    if (!Objects.equals(join.alias, alias)) continue;
                    return join;
                }
            }
            throw new IllegalArgumentException("join alias [" + alias + "] not found!");
        }

        @Override
        public <From> QueryHelper.FromSpec<R> from(Class<From> clazz) {
            this.from = clazz;
            this.table = this.parent.getTable(this.from);
            this.query = this.parent.database.dml().query(this.table);
            return this;
        }

        private QueryOperator createQuery() {
            QueryOperator query = this.query.clone();
            for (ColumnMapping<R> mapping : this.mappings) {
                query.select(mapping.forSelect());
            }
            return query;
        }

        public Mono<Integer> count(QueryOperator query) {
            BuildParameterQueryOperator operator = (BuildParameterQueryOperator)query.clone();
            operator.getParameter().setAlias(operator.getParameter().getSelect());
            operator.getParameter().setSelect(new ArrayList());
            return this.count0(operator);
        }

        public Mono<Integer> count0(BuildParameterQueryOperator operator) {
            operator.getParameter().setPageIndex(null);
            operator.getParameter().setPageSize(null);
            operator.getParameter().setOrderBy(new ArrayList());
            return operator.select(new SelectColumnSupplier[]{Selects.count1().as("_total")}).fetch(countWrapper).reactive().single((Object)0).contextWrite(this.logContext);
        }

        @Override
        public Mono<Integer> count() {
            return this.count0((BuildParameterQueryOperator)this.query.clone());
        }

        @Override
        public Flux<R> fetch() {
            return (Flux)this.createQuery().fetch((ResultWrapper)this).reactive().contextWrite(this.logContext).as(this.resultHandler);
        }

        @Override
        public Flux<R> fetch(int pageIndex, int pageSize) {
            return (Flux)this.createQuery().paging(pageIndex, pageSize).fetch((ResultWrapper)this).reactive().contextWrite(this.logContext).as(this.resultHandler);
        }

        @Override
        public Mono<PagerResult<R>> fetchPaged() {
            if (this.param != null) {
                return this.fetchPaged(this.param);
            }
            return this.fetchPaged(0, 25);
        }

        @Override
        public Mono<PagerResult<R>> fetchPaged(int pageIndex, int pageSize) {
            return this.fetchPaged(this.param != null ? (QueryParamEntity)this.param.clone().doPaging(pageIndex, pageSize) : (QueryParamEntity)new QueryParamEntity().doPaging(pageIndex, pageSize));
        }

        private Mono<PagerResult<R>> fetchPaged(QueryParamEntity param) {
            if (param.getTotal() != null) {
                return ((Flux)this.createQuery().paging(param.getPageIndex(), param.getPageSize()).fetch((ResultWrapper)this).reactive().as(this.resultHandler)).collectList().map(list -> PagerResult.of((int)param.getTotal(), (List)list, (QueryParam)param)).contextWrite(this.logContext);
            }
            QueryOperator query = this.createQuery();
            if (param.isParallelPager()) {
                return Mono.zip(this.count(query), (Mono)((Flux)query.paging(param.getPageIndex(), param.getPageSize()).fetch((ResultWrapper)this).reactive().as(this.resultHandler)).collectList(), (total, list) -> PagerResult.of((int)total, (List)list, (QueryParam)param)).contextWrite(this.logContext);
            }
            return this.count(query).flatMap(i -> {
                QueryParamEntity copy = param.clone();
                copy.rePaging(i.intValue());
                if (i == 0) {
                    return Mono.just((Object)PagerResult.of((int)0, new ArrayList(), (QueryParam)copy));
                }
                return ((Flux)query.paging(copy.getPageIndex(), copy.getPageSize()).fetch((ResultWrapper)this).reactive().as(this.resultHandler)).collectList().map(list -> PagerResult.of((int)i, (List)list, (QueryParam)copy)).contextWrite(this.logContext);
            });
        }

        @Override
        public QueryHelper.SortSpec<R> where(QueryParamEntity param) {
            this.param = this.refactorParam(param.clone());
            this.query.setParam((QueryParam)this.param);
            return this;
        }

        private QueryParamEntity refactorParam(QueryParamEntity param) {
            for (Term term : param.getTerms()) {
                this.refactorTerm(term);
            }
            return param;
        }

        private void refactorTerm(Term term) {
            term.setColumn(this.refactorColumn(term.getColumn()));
        }

        @Override
        public QueryHelper.SortSpec<R> where(Consumer<Conditional<?>> dsl) {
            this.query.where(c -> dsl.accept(new ConditionalImpl(this, c)));
            return this;
        }

        private String createJoinAlias() {
            return "j_" + this.joinIndex++;
        }

        public <T> QueryHelper.JoinSpec<R> join(Class<T> type, String alias, JoinType joinType, Consumer<JoinConditionalSpec<?>> on) {
            TableOrViewMetadata joinTable = this.parent.getTable(type);
            Query condition = QueryParamEntity.newQuery();
            JoinConditionalSpecImpl spec = new JoinConditionalSpecImpl(this, type, joinTable, alias, (Conditional<?>)condition);
            this.joins().add(spec);
            on.accept(spec);
            QueryParamEntity param = (QueryParamEntity)condition.getParam();
            for (ColumnMapping<R> mapping : this.mappings) {
                ColumnMapping.All all;
                if (!(mapping instanceof ColumnMapping.All) || !(all = (ColumnMapping.All)mapping).propertyTypeIsCollection()) continue;
                if (all.tableType == null) {
                    if (!Objects.equals(all.table, spec.alias)) continue;
                    this.buildOnToMany(param, spec, all);
                    return this;
                }
                if (all.tableType != type) continue;
                this.buildOnToMany(param, spec, all);
                return this;
            }
            Join join = new Join();
            join.setAlias(spec.alias);
            join.setTerms(param.getTerms());
            join.setType(joinType);
            join.setTarget(spec.main.getFullName());
            this.query.join(new Join[]{join});
            return this;
        }

        private void buildOnToMany(QueryParamEntity param, JoinConditionalSpecImpl join, ColumnMapping.All<R, ?> mapping) {
            this.resultHandler = this.resultHandler.andThen(new Joiner(param.getTerms()).buildHandler(join, mapping));
        }

        @Override
        public <T> QueryHelper.JoinSpec<R> fullJoin(Class<T> type, Consumer<JoinConditionalSpec<?>> on) {
            return this.join(type, this.createJoinAlias(), JoinType.full, on);
        }

        @Override
        public <T> QueryHelper.JoinSpec<R> leftJoin(Class<T> type, Consumer<JoinConditionalSpec<?>> on) {
            return this.join(type, this.createJoinAlias(), JoinType.left, on);
        }

        @Override
        public <T> QueryHelper.JoinSpec<R> innerJoin(Class<T> type, Consumer<JoinConditionalSpec<?>> on) {
            return this.join(type, this.createJoinAlias(), JoinType.inner, on);
        }

        @Override
        public <T> QueryHelper.JoinSpec<R> rightJoin(Class<T> type, Consumer<JoinConditionalSpec<?>> on) {
            return this.join(type, this.createJoinAlias(), JoinType.right, on);
        }

        public R newRowInstance0() {
            return this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }

        public R newRowInstance() {
            return (R)EntityFactoryHolder.newInstance(this.clazz, this::newRowInstance0);
        }

        public void wrapColumn(ColumnWrapperContext<R> context) {
            if (context.getResult() == null) {
                return;
            }
            String[] column = context.getColumnLabel().split("[.]");
            ColumnMapping<Object> mapping = this.getMappingByColumn(column);
            if (null == mapping) {
                return;
            }
            mapping.applyValue(context.getRowInstance(), column, context.getResult());
        }

        public boolean completedWrapRow(R result) {
            return true;
        }

        public R getResult() {
            throw new UnsupportedOperationException();
        }

        public ColumnMapping<R> getMappingByColumn(String[] column) {
            for (ColumnMapping<R> mapping : this.mappings) {
                if (!mapping.match(column)) continue;
                return mapping;
            }
            return null;
        }

        @Override
        public QueryHelper.SelectColumnMapperSpec<R> all(Class<?> joinType) {
            this.mappings.add(new ColumnMapping.All(this, null, joinType, null));
            return this;
        }

        @Override
        public <V> QueryHelper.SelectColumnMapperSpec<R> all(Class<?> joinType, QueryHelper.Setter<R, V> setter) {
            this.mappings.add(new ColumnMapping.All<R, V>(this, null, joinType, setter));
            return this;
        }

        @Override
        public QueryHelper.SelectColumnMapperSpec<R> all(String table) {
            this.mappings.add(new ColumnMapping.All(this, table, null, null));
            return this;
        }

        @Override
        public <V> QueryHelper.SelectColumnMapperSpec<R> all(String table, QueryHelper.Setter<R, V> setter) {
            this.mappings.add(new ColumnMapping.All<R, V>(this, table, null, setter));
            return this;
        }

        @Override
        public <S, V> QueryHelper.SelectColumnMapperSpec<R> as(QueryHelper.Getter<S, V> column, QueryHelper.Setter<R, V> target) {
            this.mappings.add(new ColumnMapping.Default<R, S, V>(this, null, column, null, target));
            return this;
        }

        @Override
        public <S, V> QueryHelper.SelectColumnMapperSpec<R> as(QueryHelper.Getter<S, V> getter, String target) {
            this.mappings.add(new ColumnMapping.Default(this, null, getter, target, null));
            return this;
        }

        @Override
        public <V> QueryHelper.SelectColumnMapperSpec<R> as(String column, QueryHelper.Setter<R, V> target) {
            this.mappings.add(new ColumnMapping.Default(this, column, null, null, target));
            return this;
        }

        @Override
        public QueryHelper.SelectColumnMapperSpec<R> as(String column, String target) {
            this.mappings.add(new ColumnMapping.Default(this, column, null, target, null));
            return this;
        }

        @Override
        public QueryHelper.SortSpec<R> orderBy(String column, SortOrder.Order order) {
            SortOrder sortOrder = new SortOrder();
            sortOrder.setColumn(column);
            sortOrder.setOrder(order);
            this.query.orderBy(new SortOrder[]{sortOrder});
            return this;
        }

        @Override
        public <S> QueryHelper.SortSpec<R> orderBy(QueryHelper.Getter<S, ?> column, SortOrder.Order order) {
            MethodReferenceInfo referenceInfo = MethodReferenceConverter.parse(column);
            if (referenceInfo.getOwner() == this.from) {
                return this.orderBy(referenceInfo.getColumn(), order);
            }
            JoinConditionalSpecImpl join = this.getJoinByClass(referenceInfo.getOwner());
            return this.orderBy(join.alias + "." + referenceInfo.getColumn(), order);
        }

        public String refactorColumn(String column) {
            if (null == column) {
                return null;
            }
            if (column.contains(".")) {
                CharSequence[] joinColumn = column.split("[.]");
                for (ColumnMapping<R> mapping : this.mappings) {
                    if (!(mapping instanceof ColumnMapping.All) || !Objects.equals(joinColumn[0], ((ColumnMapping.All)mapping).targetProperty)) continue;
                    JoinConditionalSpecImpl join = ((ColumnMapping.All)mapping).getJoin();
                    joinColumn[0] = join.alias;
                    return String.join((CharSequence)".", joinColumn);
                }
            }
            return column;
        }

        class Joiner {
            private final List<Term> terms;
            private final List<Term> joinTerms = new ArrayList<Term>();

            public Joiner(List<Term> terms) {
                this.terms = terms;
                this.prepare(terms);
            }

            public void prepare(List<Term> terms) {
                for (Term term : terms) {
                    if (Objects.equals("eq", term.getTermType()) && term.getValue() instanceof JoinConditionalSpecImpl.ColumnRef) {
                        this.joinTerms.add(term);
                    }
                    if (term.getTerms() == null) continue;
                    this.prepare(term.getTerms());
                }
            }

            private Function<Flux<R>, Flux<R>> buildHandler(JoinConditionalSpecImpl join, ColumnMapping.All<R, ?> mapping) {
                if (this.joinTerms.size() == 1) {
                    return this.buildBatchHandler(join, mapping);
                }
                return flux -> flux.flatMap(data -> {
                    QueryParamEntity param = new QueryParamEntity();
                    param.setTerms(this.refactorTerms(data));
                    return ((QueryHelper.SelectColumnMapperSpec)QuerySpec.this.parent.select(join.mainClassSafe()).all(join.mainClass)).from(join.mainClass).where(param.noPaging()).fetch().collectList().map(list -> FastBeanCopier.copy(Collections.singletonMap(mapping.targetProperty, list), (Object)data, (String[])new String[0]));
                }, 16);
            }

            private List<Term> refactorTerms(R main) {
                return this.refactorTerms(this.terms.stream().map(Term::clone).collect(Collectors.toList()), main);
            }

            private List<Term> refactorTerms(List<Term> terms, R main) {
                for (Term term : terms) {
                    this.refactorTerms(main, term);
                    if (!CollectionUtils.isNotEmpty((Collection)term.getTerms())) continue;
                    this.refactorTerms(term.getTerms(), main);
                }
                return terms;
            }

            private void refactorTerms(R main, Term term) {
                if (term.getValue() instanceof JoinConditionalSpecImpl.ColumnRef) {
                    JoinConditionalSpecImpl.ColumnRef ref = (JoinConditionalSpecImpl.ColumnRef)term.getValue();
                    String mainProperty = ref.getColumn().getAlias();
                    Object value = FastBeanCopier.getProperty(main, (String)mainProperty);
                    if (value == null) {
                        term.setTermType("isnull");
                        term.setValue((Object)1);
                    } else {
                        term.setValue(value);
                    }
                }
            }

            private Function<Flux<R>, Flux<R>> buildBatchHandler(JoinConditionalSpecImpl join, ColumnMapping.All<R, ?> mapping) {
                Term term = this.joinTerms.get(0);
                JoinConditionalSpecImpl.ColumnRef ref = (JoinConditionalSpecImpl.ColumnRef)term.getValue();
                String joinProperty = term.getColumn();
                String mainProperty = ref.getColumn().getAlias();
                return flux -> QueryHelper.combineOneToMany(flux, t -> FastBeanCopier.getProperty((Object)t, (String)mainProperty), idList -> {
                    term.setColumn(joinProperty);
                    term.setTermType("in");
                    term.setValue(idList);
                    QueryParamEntity param = new QueryParamEntity();
                    param.setTerms(this.terms);
                    return ((QueryHelper.SelectColumnMapperSpec)QuerySpec.this.parent.select(join.mainClassSafe()).all(join.mainClass)).from(join.mainClass).where(param.noPaging()).fetch();
                }, r -> FastBeanCopier.getProperty((Object)r, (String)joinProperty), (t, list) -> FastBeanCopier.copy(Collections.singletonMap(mapping.targetProperty, list), (Object)t, (String[])new String[0]));
            }
        }
    }

    static class ConditionalImpl<T extends Conditional<T>>
    implements Conditional<T> {
        final QuerySpec<?> parent;
        final Conditional<T> real;

        public NestConditional<T> nest() {
            Term term = new Term();
            term.setType(Term.Type.and);
            this.real.accept(term);
            return new NestConditionalImpl<ConditionalImpl>(this.parent, this, term);
        }

        public NestConditional<T> orNest() {
            Term term = new Term();
            term.setType(Term.Type.or);
            this.real.accept(term);
            return new NestConditionalImpl<ConditionalImpl>(this.parent, this, term);
        }

        public T and() {
            this.real.and();
            return (T)((Conditional)this.castSelf());
        }

        public T or() {
            this.real.or();
            return (T)((Conditional)this.castSelf());
        }

        public T and(String column, String termType, Object value) {
            this.real.and(column, termType, value);
            return (T)((Conditional)this.castSelf());
        }

        public T or(String column, String termType, Object value) {
            this.real.or(column, termType, value);
            return (T)((Conditional)this.castSelf());
        }

        public T accept(String column, String termType, Object value) {
            return (T)super.accept(this.parent.refactorColumn(column), termType, value);
        }

        public <B> T accept(MethodReferenceColumn<B> column, String termType) {
            MethodReferenceInfo info = MethodReferenceConverter.parse(column);
            if (info.getOwner() == this.parent.from) {
                return (T)super.accept(column, termType);
            }
            JoinConditionalSpecImpl join = this.parent.getJoinByClass(info.getOwner());
            return (T)((Conditional)this.getAccepter().accept(join.alias + "." + info.getColumn(), termType, column.get()));
        }

        public <B> T accept(StaticMethodReferenceColumn<B> column, String termType, Object value) {
            MethodReferenceInfo info = MethodReferenceConverter.parse(column);
            if (info.getOwner() == this.parent.from) {
                return (T)super.accept(column, termType, value);
            }
            JoinConditionalSpecImpl join = this.parent.getJoinByClass(info.getOwner());
            return (T)((Conditional)this.getAccepter().accept(join.alias + "." + info.getColumn(), termType, value));
        }

        public TermTypeConditionalSupport.Accepter<T, Object> getAccepter() {
            return (column, termType, value) -> {
                this.real.getAccepter().accept(column, termType, value);
                return (Conditional)this.castSelf();
            };
        }

        public T accept(Term term) {
            this.real.accept(term);
            return (T)((Conditional)this.castSelf());
        }

        public ConditionalImpl(QuerySpec<?> parent, Conditional<T> real) {
            this.parent = parent;
            this.real = real;
        }
    }

    static class NestConditionalImpl<T extends TermTypeConditionalSupport>
    extends SimpleNestConditional<T> {
        final QuerySpec<?> parent;
        final Term term;

        public NestConditionalImpl(QuerySpec<?> parent, T target, Term term) {
            super(target, term);
            this.parent = parent;
            this.term = term;
        }

        public NestConditional<NestConditional<T>> nest() {
            return new NestConditionalImpl<NestConditionalImpl>(this.parent, this, this.term.nest());
        }

        public NestConditional<NestConditional<T>> orNest() {
            return new NestConditionalImpl<NestConditionalImpl>(this.parent, this, this.term.orNest());
        }

        public NestConditional<T> accept(String column, String termType, Object value) {
            return super.accept(this.parent.refactorColumn(column), termType, value);
        }

        public <B> NestConditional<T> accept(MethodReferenceColumn<B> column, String termType) {
            MethodReferenceInfo info = MethodReferenceConverter.parse(column);
            if (info.getOwner() == this.parent.from) {
                return super.accept(column, termType);
            }
            JoinConditionalSpecImpl join = this.parent.getJoinByClass(info.getOwner());
            return super.accept(join.alias + "." + info.getColumn(), termType, column.get());
        }

        public <B> NestConditional<T> accept(StaticMethodReferenceColumn<B> column, String termType, Object value) {
            MethodReferenceInfo info = MethodReferenceConverter.parse(column);
            if (info.getOwner() == this.parent.from) {
                return super.accept(column, termType, value);
            }
            JoinConditionalSpecImpl join = this.parent.getJoinByClass(info.getOwner());
            super.accept(join.alias + "." + info.getColumn(), termType, value);
            return this;
        }
    }

    static class JoinNestConditionalSpecImpl<T extends TermTypeConditionalSupport>
    extends SimpleNestConditional<T>
    implements JoinNestConditionalSpec<T> {
        final QuerySpec<?> parent;
        private final Term term;

        public JoinNestConditionalSpecImpl(QuerySpec<?> parent, T target, Term term) {
            super(target, term);
            this.parent = parent;
            this.term = term;
        }

        public NestConditional<T> accept(String column, String termType, Object value) {
            return (NestConditional)this.getAccepter().accept(this.parent.refactorColumn(column), termType, value);
        }

        @Override
        public JoinNestConditionalSpecImpl nest() {
            return new JoinNestConditionalSpecImpl<JoinNestConditionalSpecImpl>(this.parent, this, this.term.nest());
        }

        @Override
        public JoinNestConditionalSpecImpl orNest() {
            return new JoinNestConditionalSpecImpl<JoinNestConditionalSpecImpl>(this.parent, this, this.term.orNest());
        }

        @Override
        public <T1, T2> JoinNestConditionalSpecImpl<T> applyColumn(StaticMethodReferenceColumn<T1> joinColumn, String termType, String alias, StaticMethodReferenceColumn<T2> mainOrJoinColumn) {
            MethodReferenceInfo main = MethodReferenceConverter.parse(joinColumn);
            MethodReferenceInfo join = MethodReferenceConverter.parse(joinColumn);
            if (main.getOwner() == this.parent.from) {
                return this.applyColumn(join.getColumn(), termType, this.parent.table, this.parent.table.getName(), joinColumn.getColumn());
            }
            if (join.getOwner() == this.parent.from) {
                return this.applyColumn(joinColumn.getColumn(), termType, this.parent.table, this.parent.table.getName(), join.getColumn());
            }
            JoinConditionalSpecImpl spec = alias == null ? this.parent.getJoinByClass(join.getOwner()) : this.parent.getJoinByAlias(alias);
            return this.applyColumn(joinColumn.getColumn(), termType, spec.main, spec.alias, join.getColumn());
        }

        @Override
        public <T1, T2> JoinNestConditionalSpecImpl<T> applyColumn(StaticMethodReferenceColumn<T1> mainColumn, String termType, StaticMethodReferenceColumn<T2> joinColumn) {
            return this.applyColumn((StaticMethodReferenceColumn<T1>)joinColumn, termType, (String)null, joinColumn);
        }

        public JoinNestConditionalSpecImpl<T> applyColumn(String mainColumn, String termType, TableOrViewMetadata join, String alias, String column) {
            RDBColumnMetadata columnMetadata = (RDBColumnMetadata)join.getColumn(column).orElseThrow(() -> new IllegalArgumentException("column [" + column + "] not found"));
            this.getAccepter().accept(mainColumn, termType, (Object)new JoinConditionalSpecImpl.ColumnRef(columnMetadata, alias));
            return this;
        }

        public TermTypeConditionalSupport.Accepter<NestConditional<T>, Object> getAccepter() {
            return (column, termType, value) -> {
                super.getAccepter().accept(column, termType, value);
                return this;
            };
        }
    }

    static class JoinConditionalSpecImpl
    implements JoinConditionalSpec<JoinConditionalSpecImpl> {
        private final QuerySpec<?> parent;
        private final Class<?> mainClass;
        private final TableOrViewMetadata main;
        private String alias;
        private final Conditional<?> target;

        private Class<Object> mainClassSafe() {
            return this.mainClass;
        }

        @Override
        public <T, T2> JoinConditionalSpecImpl applyColumn(StaticMethodReferenceColumn<T> mainColumn, String termType, String alias, StaticMethodReferenceColumn<T2> joinColumn) {
            MethodReferenceInfo main = MethodReferenceConverter.parse(mainColumn);
            MethodReferenceInfo join = MethodReferenceConverter.parse(joinColumn);
            if (main.getOwner() == this.parent.from) {
                return this.applyColumn(join.getColumn(), termType, this.parent.table, this.parent.table.getName(), mainColumn.getColumn());
            }
            if (join.getOwner() == this.parent.from) {
                return this.applyColumn(mainColumn.getColumn(), termType, this.parent.table, this.parent.table.getName(), join.getColumn());
            }
            JoinConditionalSpecImpl spec = alias == null ? this.parent.getJoinByClass(join.getOwner()) : this.parent.getJoinByAlias(alias);
            return this.applyColumn(mainColumn.getColumn(), termType, spec.main, spec.alias, join.getColumn());
        }

        @Override
        public <T, T2> JoinConditionalSpecImpl applyColumn(StaticMethodReferenceColumn<T> mainColumn, String termType, StaticMethodReferenceColumn<T2> joinColumn) {
            return this.applyColumn(mainColumn, termType, (String)null, joinColumn);
        }

        public JoinConditionalSpecImpl applyColumn(String mainColumn, String termType, TableOrViewMetadata join, String alias, String column) {
            RDBColumnMetadata columnMetadata = (RDBColumnMetadata)join.getColumn(column).orElseThrow(() -> new IllegalArgumentException("column [" + column + "] not found"));
            this.getAccepter().accept(mainColumn, termType, (Object)new ColumnRef(columnMetadata, alias));
            return this;
        }

        @Override
        public JoinNestConditionalSpec<JoinConditionalSpecImpl> nest() {
            Term term = new Term();
            term.setType(Term.Type.and);
            this.target.accept(term);
            return new JoinNestConditionalSpecImpl<JoinConditionalSpecImpl>(this.parent, this, term);
        }

        @Override
        public JoinNestConditionalSpec<JoinConditionalSpecImpl> orNest() {
            Term term = new Term();
            term.setType(Term.Type.or);
            this.target.accept(term);
            return new JoinNestConditionalSpecImpl<JoinConditionalSpecImpl>(this.parent, this, term);
        }

        public JoinConditionalSpecImpl and() {
            this.target.and();
            return this;
        }

        public JoinConditionalSpecImpl or() {
            this.target.or();
            return this;
        }

        public JoinConditionalSpecImpl and(String column, String termType, Object value) {
            this.target.and(column, termType, value);
            return this;
        }

        public JoinConditionalSpecImpl or(String column, String termType, Object value) {
            this.target.or(column, termType, value);
            return this;
        }

        public TermTypeConditionalSupport.Accepter<JoinConditionalSpecImpl, Object> getAccepter() {
            return (column, termType, value) -> {
                this.target.getAccepter().accept(column, termType, value);
                return this;
            };
        }

        public JoinConditionalSpecImpl accept(Term term) {
            this.target.accept(term);
            return this;
        }

        @Override
        public JoinConditionalSpecImpl alias(String alias) {
            this.alias = alias;
            return this;
        }

        public JoinConditionalSpecImpl(QuerySpec<?> parent, Class<?> mainClass, TableOrViewMetadata main, String alias, Conditional<?> target) {
            this.parent = parent;
            this.mainClass = mainClass;
            this.main = main;
            this.alias = alias;
            this.target = target;
        }

        public static class ColumnRef
        implements NativeSql {
            private final RDBColumnMetadata column;
            private final String alias;

            public String getSql() {
                return this.column.getFullName(this.alias);
            }

            public ColumnRef(RDBColumnMetadata column, String alias) {
                this.column = column;
                this.alias = alias;
            }

            public RDBColumnMetadata getColumn() {
                return this.column;
            }

            public String getAlias() {
                return this.alias;
            }
        }
    }

    static abstract class ColumnMapping<R> {
        final QuerySpec<R> parent;

        public ColumnMapping(QuerySpec<R> parent) {
            this.parent = parent;
        }

        abstract SelectColumnSupplier[] forSelect();

        abstract boolean match(String[] var1);

        abstract void applyValue(R var1, String[] var2, Object var3);

        static class Default<R, S, V>
        extends ColumnMapping<R> {
            private final String column;
            private String alias;
            private final QueryHelper.Getter<S, V> getter;
            private final QueryHelper.Setter<R, V> setter;
            RDBColumnMetadata metadata;

            public Default(QuerySpec<R> parent, String column, QueryHelper.Getter<S, V> getter, String alias, QueryHelper.Setter<R, V> setter) {
                super(parent);
                this.column = column;
                this.alias = alias;
                this.getter = getter;
                this.setter = setter;
            }

            @Override
            boolean match(String[] column) {
                return column.length == 1 && Objects.equals(this.alias, column[0]);
            }

            @Override
            void applyValue(R result, String[] column, Object sqlValue) {
                if (this.setter != null) {
                    this.setter.accept(result, this.metadata.decode(sqlValue));
                    return;
                }
                GlobalConfig.getPropertyOperator().setProperty(result, column[0], this.metadata.decode(sqlValue));
            }

            @Override
            SelectColumnSupplier[] forSelect() {
                String string = this.alias = this.alias != null ? this.alias : MethodReferenceConverter.convertToColumn(this.setter);
                if (this.column != null) {
                    String[] nestMaybe = this.column.split("[.]");
                    if (nestMaybe.length == 2) {
                        JoinConditionalSpecImpl join = this.parent.getJoinByAlias(nestMaybe[0]);
                        this.metadata = DefaultQueryHelper.getColumn(join.main, nestMaybe[1]);
                    } else {
                        this.metadata = DefaultQueryHelper.getColumn(this.parent.table, this.column);
                    }
                    return DefaultQueryHelper.toArray(Selects.column((String)this.column).as(this.alias));
                }
                if (this.getter != null) {
                    MethodReferenceInfo info = MethodReferenceConverter.parse(this.getter);
                    if (info.getOwner() == this.parent.from) {
                        this.metadata = DefaultQueryHelper.getColumn(this.parent.table, info.getColumn());
                        return DefaultQueryHelper.toArray(Selects.column((String)info.getColumn()).as(this.alias));
                    }
                    JoinConditionalSpecImpl join = this.parent.getJoinByClass(info.getOwner());
                    this.metadata = DefaultQueryHelper.getColumn(join.main, info.getColumn());
                    return DefaultQueryHelper.toArray(Selects.column((String)(join.alias + "." + info.getColumn())).as(this.alias));
                }
                throw new IllegalArgumentException("column or getter can not be null");
            }
        }

        static class All<R, V>
        extends ColumnMapping<R> {
            private final String table;
            private final Class<?> tableType;
            private TableOrViewMetadata target;
            private final String alias;
            private final String targetProperty;
            private final ResolvableType propertyType;

            public All(QuerySpec<R> parent, String table, Class<?> tableType, QueryHelper.Setter<R, V> setter) {
                super(parent);
                this.table = table;
                this.tableType = tableType;
                String string = this.targetProperty = setter == null ? null : MethodReferenceConverter.convertToColumn(setter);
                if (this.targetProperty != null) {
                    Field field = ReflectionUtils.findField(parent.clazz, (String)this.targetProperty);
                    if (field == null) {
                        throw new NoSuchFieldException(parent.clazz.getName() + "." + this.targetProperty);
                    }
                    this.propertyType = ResolvableType.forField((Field)field, parent.clazz);
                } else {
                    this.propertyType = null;
                }
                String prefix = this.targetProperty == null ? "all" : this.targetProperty;
                int size = parent.mappings.size();
                this.alias = size == 0 ? prefix : prefix + "_" + size;
            }

            boolean propertyTypeIsCollection() {
                return this.propertyType != null && Collection.class.isAssignableFrom(this.propertyType.toClass());
            }

            @Override
            boolean match(String[] column) {
                return column.length >= 2 && Objects.equals(this.alias, column[0]);
            }

            @Override
            void applyValue(R result, String[] column, Object sqlValue) {
                RDBColumnMetadata metadata;
                if (column.length > 1 && (metadata = (RDBColumnMetadata)this.target.getColumn(column[1]).orElse(null)) != null) {
                    ObjectPropertyOperator operator = GlobalConfig.getPropertyOperator();
                    if (this.targetProperty == null) {
                        operator.setProperty(result, column[1], metadata.decode(sqlValue));
                    } else {
                        Object val = operator.getPropertyOrNew(result, this.targetProperty);
                        operator.setProperty(val, column[1], metadata.decode(sqlValue));
                    }
                }
            }

            SelectColumnSupplier[] toColumns(TableOrViewMetadata table, String owner) {
                return (SelectColumnSupplier[])table.getColumns().stream().map(column -> Selects.column((String)(owner == null ? column.getName() : owner + "." + column.getName())).as(this.alias + "." + column.getAlias())).toArray(SelectColumnSupplier[]::new);
            }

            JoinConditionalSpecImpl getJoin() {
                if (this.table != null) {
                    return this.parent.getJoinByAlias(this.table);
                }
                return this.parent.getJoinByClass(this.tableType);
            }

            @Override
            SelectColumnSupplier[] forSelect() {
                if (this.propertyTypeIsCollection()) {
                    return new SelectColumnSupplier[0];
                }
                if (this.tableType == this.parent.from) {
                    this.target = this.parent.table;
                    return this.toColumns(this.target, null);
                }
                JoinConditionalSpecImpl join = this.getJoin();
                this.target = join.main;
                return this.toColumns(this.target, join.alias);
            }
        }
    }
}

