/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.ParenthesisFromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.TableFunction;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.values.ValuesStatement;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.core.param.Sort;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBViewMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.metadata.dialect.Dialect;
import org.hswebframework.ezorm.rdb.operator.DatabaseOperator;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.AbstractTermsFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.AppendableSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.BatchSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.EmptySqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.TermFragmentBuilder;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.crud.query.QueryAnalyzer;
import org.hswebframework.web.crud.query.QueryHelperUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class QueryAnalyzerImpl
implements FromItemVisitor,
SelectItemVisitor,
SelectVisitor,
QueryAnalyzer {
    private final DatabaseOperator database;
    private String sql;
    private final SelectBody parsed;
    private QueryAnalyzer.Select select;
    private final Map<String, QueryAnalyzer.Join> joins = new LinkedHashMap<String, QueryAnalyzer.Join>();
    private final List<WithItem> withItems = new ArrayList<WithItem>();
    private QueryRefactor injector;
    private volatile Map<String, QueryAnalyzer.Column> columnMappings;
    private final Map<String, TableOrViewMetadata> virtualTable = new HashMap<String, TableOrViewMetadata>();
    static QueryAnalyzerTermsFragmentBuilder TERMS_BUILDER = new QueryAnalyzerTermsFragmentBuilder();

    @Override
    public String originalSql() {
        return this.sql;
    }

    @Override
    public SqlRequest refactor(QueryParamEntity entity, Object ... args) {
        if (this.injector == null) {
            this.initInjector();
        }
        return this.injector.refactor(entity, args);
    }

    @Override
    public SqlRequest refactorCount(QueryParamEntity entity, Object ... args) {
        if (this.injector == null) {
            this.initInjector();
        }
        return this.injector.refactorCount(entity, args);
    }

    @Override
    public QueryAnalyzer.Select select() {
        return this.select;
    }

    @Override
    public Optional<QueryAnalyzer.Column> findColumn(String name) {
        return Optional.ofNullable(this.getColumnMappings().get(name));
    }

    @Override
    public List<QueryAnalyzer.Join> joins() {
        return new ArrayList<QueryAnalyzer.Join>(this.joins.values());
    }

    QueryAnalyzerImpl(DatabaseOperator database, String sql) {
        this(database, QueryAnalyzerImpl.parse(sql));
        this.sql = sql;
    }

    @Override
    public boolean columnIsExpression(String name, int index) {
        if (index >= 0 && this.select.getColumnList().size() > index) {
            return this.select.getColumnList().get(index) instanceof ExpressionColumn;
        }
        return this.select.getColumns().get(name) instanceof ExpressionColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, QueryAnalyzer.Column> getColumnMappings() {
        if (this.columnMappings == null) {
            QueryAnalyzerImpl queryAnalyzerImpl = this;
            synchronized (queryAnalyzerImpl) {
                if (this.columnMappings == null) {
                    this.columnMappings = new HashMap<String, QueryAnalyzer.Column>();
                    if (this.select.table instanceof QueryAnalyzer.SelectTable) {
                        for (Map.Entry entry : ((QueryAnalyzer.SelectTable)this.select.getTable()).getColumns().entrySet()) {
                            QueryAnalyzer.Column column = (QueryAnalyzer.Column)entry.getValue();
                            QueryAnalyzer.Column col = new QueryAnalyzer.Column(column.getName(), column.getAlias(), this.select.table.alias, column.metadata);
                            this.columnMappings.put((String)entry.getKey(), col);
                            this.columnMappings.put(this.select.table.alias + "." + (String)entry.getKey(), col);
                            if (column instanceof ExpressionColumn || column.metadata == null) continue;
                            this.columnMappings.put(column.metadata.getName(), col);
                            this.columnMappings.put(this.select.table.alias + "." + column.metadata.getName(), col);
                            this.columnMappings.put(column.metadata.getAlias(), col);
                            this.columnMappings.put(this.select.table.alias + "." + column.metadata.getAlias(), col);
                        }
                        for (QueryAnalyzer.Column column : this.select.getColumnList()) {
                            this.columnMappings.put(column.getName(), column);
                            this.columnMappings.put(column.getAlias(), column);
                            if (null == column.getOwner()) continue;
                            this.columnMappings.put(column.getOwner() + "." + column.getName(), column);
                            this.columnMappings.put(column.getOwner() + "." + column.getAlias(), column);
                        }
                    } else {
                        for (RDBColumnMetadata rDBColumnMetadata : this.select.table.metadata.getColumns()) {
                            QueryAnalyzer.Column col = new QueryAnalyzer.Column(rDBColumnMetadata.getName(), rDBColumnMetadata.getAlias(), this.select.table.alias, rDBColumnMetadata);
                            this.columnMappings.put(rDBColumnMetadata.getName(), col);
                            this.columnMappings.put(rDBColumnMetadata.getAlias(), col);
                            this.columnMappings.put(this.select.table.alias + "." + rDBColumnMetadata.getName(), col);
                            this.columnMappings.put(this.select.table.alias + "." + rDBColumnMetadata.getAlias(), col);
                        }
                    }
                    for (QueryAnalyzer.Join join : this.joins.values()) {
                        if (join.table instanceof QueryAnalyzer.SelectTable) {
                            for (QueryAnalyzer.Column column : this.select.getColumnList()) {
                                this.columnMappings.putIfAbsent(column.getName(), column);
                                this.columnMappings.putIfAbsent(column.getAlias(), column);
                                this.columnMappings.put(column.getOwner() + "." + column.getName(), column);
                                this.columnMappings.put(column.getOwner() + "." + column.getAlias(), column);
                            }
                            continue;
                        }
                        for (QueryAnalyzer.Column column : join.table.metadata.getColumns()) {
                            QueryAnalyzer.Column col = new QueryAnalyzer.Column(column.getName(), column.getAlias(), join.alias, (RDBColumnMetadata)column);
                            this.columnMappings.putIfAbsent(column.getName(), col);
                            this.columnMappings.putIfAbsent(column.getAlias(), col);
                            this.columnMappings.put(join.alias + "." + column.getName(), col);
                            this.columnMappings.put(join.alias + "." + column.getAlias(), col);
                        }
                    }
                }
            }
        }
        return this.columnMappings;
    }

    private QueryAnalyzer.Column getColumnOrSelectColumn(String name) {
        QueryAnalyzer.Column column = this.select.getColumns().get(name);
        if (column != null) {
            return column;
        }
        column = this.select.getColumns().get(QueryHelperUtils.toSnake(name));
        if (column != null) {
            return column;
        }
        return this.getColumnMappings().get(name);
    }

    private static Select parse(String sql) {
        return (Select)CCJSqlParserUtil.parse((String)sql);
    }

    QueryAnalyzerImpl(DatabaseOperator database, SelectBody selectBody, QueryAnalyzerImpl parent) {
        this.database = database;
        this.virtualTable.putAll(parent.virtualTable);
        if (null != selectBody) {
            this.parsed = selectBody;
            selectBody.accept((SelectVisitor)this);
        } else {
            this.parsed = null;
        }
    }

    QueryAnalyzerImpl(DatabaseOperator database, SubSelect select, QueryAnalyzerImpl parent) {
        this.parsed = select.getSelectBody();
        this.database = database;
        this.virtualTable.putAll(parent.virtualTable);
        if (CollectionUtils.isNotEmpty((Collection)select.getWithItemsList())) {
            for (WithItem withItem : select.getWithItemsList()) {
                withItem.accept((SelectVisitor)this);
            }
        }
        if (this.parsed != null) {
            this.parsed.accept((SelectVisitor)this);
        }
    }

    QueryAnalyzerImpl(DatabaseOperator database, Select select) {
        this.parsed = select.getSelectBody();
        this.database = database;
        if (CollectionUtils.isNotEmpty((Collection)select.getWithItemsList())) {
            for (WithItem withItem : select.getWithItemsList()) {
                withItem.accept((SelectVisitor)this);
            }
        }
        if (this.parsed != null) {
            this.parsed.accept((SelectVisitor)this);
        }
    }

    private String parsePlainName(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        char firstChar = name.charAt(0);
        if (firstChar == '`' || firstChar == '\"' || firstChar == '[' || name.startsWith(this.database.getMetadata().getDialect().getQuoteStart())) {
            return new String(name.toCharArray(), 1, name.length() - 2);
        }
        return name;
    }

    public void visit(Table tableName) {
        RDBSchemaMetadata schemaMetadata;
        String schema = this.parsePlainName(tableName.getSchemaName());
        String name = this.parsePlainName(tableName.getName());
        if (schema != null) {
            schemaMetadata = (RDBSchemaMetadata)this.database.getMetadata().getSchema(schema).orElseThrow(() -> new IllegalStateException("schema " + schema + " not initialized"));
        } else {
            schemaMetadata = (RDBSchemaMetadata)this.database.getMetadata().getCurrentSchema();
            if (!this.virtualTable.containsKey(name)) {
                tableName.setSchemaName(schemaMetadata.getQuoteName());
            }
        }
        String alias = tableName.getAlias() == null ? tableName.getName() : tableName.getAlias().getName();
        TableOrViewMetadata tableMetadata = schemaMetadata.getTableOrView(name, false).orElseGet(() -> this.virtualTable.get(name));
        if (tableMetadata == null) {
            throw new IllegalStateException("table or view " + tableName.getName() + " not found in " + schemaMetadata.getName());
        }
        tableName.setName(tableMetadata.getRealName());
        QueryAnalyzer.Table table = new QueryAnalyzer.Table(this.parsePlainName(alias), tableMetadata);
        this.select = new QueryAnalyzer.Select(new ArrayList<QueryAnalyzer.Column>(), table);
    }

    public void visit(SubSelect subSelect) {
        this.visit(subSelect, subSelect.getAlias() == null ? null : subSelect.getAlias().getName());
    }

    public void visit(SubSelect subSelect, String alias) {
        SelectBody body = subSelect.getSelectBody();
        QueryAnalyzerImpl sub = new QueryAnalyzerImpl(this.database, body, this);
        LinkedHashMap<String, QueryAnalyzer.Column> columnMap = new LinkedHashMap<String, QueryAnalyzer.Column>();
        for (QueryAnalyzer.Column column : sub.select.getColumnList()) {
            columnMap.put(column.getAlias(), new QueryAnalyzer.Column(column.name, column.getAlias(), column.owner, column.metadata));
        }
        this.select = new QueryAnalyzer.Select(new ArrayList<QueryAnalyzer.Column>(), new QueryAnalyzer.SelectTable(this.parsePlainName(alias), columnMap, sub.select.table.metadata));
    }

    public void visit(SubJoin subjoin) {
        for (Join join : subjoin.getJoinList()) {
            join.getRightItem().accept((FromItemVisitor)this);
        }
    }

    public void visit(LateralSubSelect lateralSubSelect) {
        this.visit(lateralSubSelect.getSubSelect(), lateralSubSelect.getAlias() == null ? null : lateralSubSelect.getAlias().getName());
    }

    public void visit(ValuesList valuesList) {
        RDBColumnMetadata rDBColumnMetadata;
        if (valuesList.getAlias() == null) {
            throw new IllegalArgumentException("valuesList[" + valuesList + "] must have alias");
        }
        String name = this.parsePlainName(valuesList.getAlias().getName());
        FakeTable view = new FakeTable();
        if (valuesList.getColumnNames() != null) {
            for (String columnName : valuesList.getColumnNames()) {
                rDBColumnMetadata = view.getColumn(this.parsePlainName(columnName)).orElse(null);
            }
        }
        if (valuesList.getAlias().getAliasColumns() != null) {
            for (Alias.AliasColumn alias : valuesList.getAlias().getAliasColumns()) {
                rDBColumnMetadata = view.getColumn(this.parsePlainName(alias.name)).orElse(null);
            }
        }
        view.setName(name);
        view.setRealName(name);
        view.setSchema((RDBSchemaMetadata)this.database.getMetadata().getCurrentSchema());
        view.setAlias(name);
        QueryAnalyzer.Table table = new QueryAnalyzer.Table(name, (TableOrViewMetadata)view);
        this.select = new QueryAnalyzer.Select(new ArrayList<QueryAnalyzer.Column>(), table);
    }

    public void visit(TableFunction tableFunction) {
        if (tableFunction.getAlias() == null) {
            throw new IllegalArgumentException("table function[" + tableFunction + "] must have alias");
        }
        String name = this.parsePlainName(tableFunction.getAlias().getName());
        FakeTable view = new FakeTable();
        view.setName(name);
        view.setSchema((RDBSchemaMetadata)this.database.getMetadata().getCurrentSchema());
        view.setAlias(name);
        QueryAnalyzer.Table table = new QueryAnalyzer.Table(name, (TableOrViewMetadata)view);
        this.select = new QueryAnalyzer.Select(new ArrayList<QueryAnalyzer.Column>(), table);
    }

    public void visit(ParenthesisFromItem aThis) {
        aThis.getFromItem().accept((FromItemVisitor)this);
        String alias = this.parsePlainName(aThis.getAlias() == null ? null : aThis.getAlias().getName());
        if (alias != null) {
            this.select = this.select.newSelectAlias(alias);
        }
    }

    public void visit(AllColumns allColumns) {
        this.putSelectColumns(this.select.table, this.select.columnList);
        for (QueryAnalyzer.Join value : new HashSet<QueryAnalyzer.Join>(this.joins.values())) {
            this.putSelectColumns(value.table, this.select.columnList);
        }
    }

    private void putSelectColumns(QueryAnalyzer.Table table, List<QueryAnalyzer.Column> container) {
        if (table instanceof QueryAnalyzer.SelectTable) {
            QueryAnalyzer.SelectTable selectTable = (QueryAnalyzer.SelectTable)table;
            for (QueryAnalyzer.Column column : selectTable.columns.values()) {
                String alias = table == this.select.table ? column.getAlias() : table.alias + "." + column.getAlias();
                container.add(new QueryAnalyzer.Column(column.name, alias, table.alias, column.metadata));
            }
        } else {
            for (RDBColumnMetadata column : table.metadata.getColumns()) {
                String alias = table == this.select.table ? column.getAlias() : table.alias + "." + column.getAlias();
                container.add(new QueryAnalyzer.Column(column.getRealName(), alias, table.alias, column));
            }
        }
    }

    public void visit(AllTableColumns allTableColumns) {
        Table table = allTableColumns.getTable();
        String name = table.getName();
        if (Objects.equals(this.select.table.alias, name)) {
            this.putSelectColumns(this.select.table, this.select.columnList);
            return;
        }
        QueryAnalyzer.Join join = this.joins.get(this.parsePlainName(table.getName()));
        if (join == null) {
            throw new IllegalStateException("table " + table.getName() + " not found in join");
        }
        this.putSelectColumns(join.table, this.select.columnList);
    }

    private QueryAnalyzer.Table getTable(Table table) {
        QueryAnalyzer.Table meta;
        if (null == table) {
            return this.select.table;
        }
        String tableName = this.parsePlainName(table.getName());
        if (Objects.equals(tableName, this.select.table.alias)) {
            meta = this.select.table;
        } else {
            QueryAnalyzer.Join join = this.joins.get(tableName);
            if (join == null) {
                throw new IllegalStateException("table " + table + " not found in from or join");
            }
            meta = join.table;
        }
        return meta;
    }

    private void refactorAlias(Alias alias) {
        if (alias != null) {
            alias.setName(this.database.getMetadata().getDialect().quote(this.parsePlainName(alias.getName()), false));
        }
    }

    public void visit(SelectExpressionItem selectExpressionItem) {
        QueryAnalyzer.Column c;
        Expression expr = selectExpressionItem.getExpression();
        Alias alias = selectExpressionItem.getAlias();
        if (!(expr instanceof Column)) {
            String aliasName = this.parsePlainName(alias == null ? expr.toString() : alias.getName());
            this.refactorAlias(alias);
            this.select.columnList.add(new ExpressionColumn(aliasName, null, null, (SelectItem)selectExpressionItem));
            return;
        }
        Column column = (Column)expr;
        String columnName = this.parsePlainName(column.getColumnName());
        QueryAnalyzer.Table table = this.getTable(column.getTable());
        String aliasName = alias == null ? columnName : this.parsePlainName(alias.getName());
        RDBColumnMetadata metadata = table.getMetadata().getColumn(columnName).orElse(null);
        if (metadata == null && table instanceof QueryAnalyzer.SelectTable && null != (c = ((QueryAnalyzer.SelectTable)table).columns.get(columnName))) {
            if (c.metadata == null) {
                this.select.columnList.add(new QueryAnalyzer.Column(c.getName(), aliasName, table.alias, null));
                return;
            }
            metadata = c.metadata;
        }
        if (metadata == null) {
            throw new IllegalStateException("column [" + column.getColumnName() + "] not found in " + table.metadata.getName());
        }
        this.select.columnList.add(new QueryAnalyzer.Column(metadata.getRealName(), aliasName, table.alias, metadata));
    }

    public void visit(PlainSelect select) {
        FromItem from = select.getFromItem();
        if (from == null) {
            throw new IllegalArgumentException("select can not be without 'from'");
        }
        from.accept((FromItemVisitor)this);
        List joinList = select.getJoins();
        if (joinList != null) {
            for (Join join : joinList) {
                FromItem fromItem = join.getRightItem();
                QueryAnalyzerImpl joinAn = new QueryAnalyzerImpl(this.database, (SelectBody)null, this);
                fromItem.accept((FromItemVisitor)joinAn);
                QueryAnalyzer.Join.Type type = join.isLeft() ? QueryAnalyzer.Join.Type.left : (join.isRight() ? QueryAnalyzer.Join.Type.right : (join.isInner() ? QueryAnalyzer.Join.Type.inner : null));
                this.joins.put(joinAn.select.table.alias, new QueryAnalyzer.Join(joinAn.select.table.alias, type, joinAn.select.table));
            }
        }
        for (SelectItem selectItem : select.getSelectItems()) {
            selectItem.accept((SelectItemVisitor)this);
        }
    }

    public void visit(SetOperationList setOpList) {
        for (SelectBody body : setOpList.getSelects()) {
            body.accept((SelectVisitor)this);
        }
    }

    public void visit(WithItem withItem) {
        this.withItems.add(withItem);
        String name = withItem.getName();
        RDBViewMetadata view = new RDBViewMetadata();
        view.setName(name);
        view.setSchema((RDBSchemaMetadata)this.database.getMetadata().getCurrentSchema());
        this.virtualTable.put(name, (TableOrViewMetadata)view);
        if (withItem.getSubSelect() != null) {
            QueryAnalyzerImpl analyzer = new QueryAnalyzerImpl(this.database, withItem.getSubSelect(), this);
            for (QueryAnalyzer.Column column : analyzer.select.getColumnList()) {
                RDBColumnMetadata metadata = column.getMetadata() == null ? new RDBColumnMetadata() : column.metadata.clone();
                metadata.setName(column.getName());
                metadata.setAlias(column.getAlias());
                view.addColumn(metadata);
            }
        }
    }

    public void visit(ValuesStatement aThis) {
    }

    private void initInjector() {
        SimpleQueryRefactor injector = new SimpleQueryRefactor();
        this.parsed.accept((SelectVisitor)injector);
        for (WithItem withItem : this.withItems) {
            withItem.accept((SelectVisitor)injector);
        }
        this.injector = injector;
    }

    private static interface QueryRefactor {
        public SqlRequest refactor(QueryParamEntity var1, Object ... var2);

        public SqlRequest refactorCount(QueryParamEntity var1, Object ... var2);
    }

    static class ExpressionColumn
    extends QueryAnalyzer.Column {
        private final SelectItem expr;

        public ExpressionColumn(String alias, String owner, RDBColumnMetadata metadata, SelectItem expr) {
            super(alias, alias, owner, metadata);
            this.expr = expr;
        }

        @Override
        public ExpressionColumn moveOwner(String owner) {
            return new ExpressionColumn(this.alias, owner, this.metadata, this.expr);
        }
    }

    static class FakeTable
    extends RDBViewMetadata {
        FakeTable() {
        }

        public Optional<RDBColumnMetadata> getColumn(String name) {
            QueryHelperUtils.assertLegalColumn(name);
            RDBColumnMetadata fake = new RDBColumnMetadata();
            fake.setName(name);
            this.addColumn(fake);
            return Optional.of(fake);
        }
    }

    class SimpleQueryRefactor
    implements QueryRefactor,
    SelectVisitor {
        private String prefix = "";
        private String from;
        private String columns;
        private String where;
        private int prefixParameters;
        private String orderBy;
        private String suffix;
        private int suffixParameters;
        private boolean fastCount = true;
        private SqlFragments QUERY;
        private SqlFragments SUFFIX;
        private SqlFragments FAST_COUNT;
        private SqlFragments SLOW_COUNT;

        SimpleQueryRefactor() {
        }

        private void initColumns(StringBuilder columns) {
            int idx = 0;
            Dialect dialect = QueryAnalyzerImpl.this.database.getMetadata().getDialect();
            if (QueryAnalyzerImpl.this.select.columnList.size() == 1 && "*".equals(QueryAnalyzerImpl.this.select.columnList.get((int)0).name)) {
                columns.append(QueryAnalyzerImpl.this.select.columnList.get((int)0).owner).append('.').append('*');
                return;
            }
            for (QueryAnalyzer.Column column : QueryAnalyzerImpl.this.select.columnList) {
                if ("*".equals(column.name)) continue;
                if (idx++ > 0) {
                    columns.append(",");
                }
                if (column instanceof ExpressionColumn) {
                    columns.append(((ExpressionColumn)column).expr);
                    this.fastCount = false;
                    continue;
                }
                columns.append(column.owner).append('.').append(dialect.quote(column.name, column.metadata != null && !column.metadata.realNameDetected())).append(" as ").append(dialect.quote(column.alias, false));
            }
        }

        public void visit(PlainSelect plainSelect) {
            PrepareStatementVisitor visitor;
            StringBuilder from = new StringBuilder();
            StringBuilder columns = new StringBuilder();
            StringBuilder suffix = new StringBuilder();
            if (plainSelect.getDistinct() != null) {
                columns.append(plainSelect.getDistinct()).append(' ');
                this.fastCount = false;
            }
            this.initColumns(columns);
            if (plainSelect.getFromItem() != null) {
                from.append("FROM ");
                from.append(plainSelect.getFromItem());
                visitor = new PrepareStatementVisitor();
                plainSelect.getFromItem().accept((FromItemVisitor)visitor);
                this.prefixParameters += visitor.parameterSize;
            }
            if (plainSelect.getJoins() != null) {
                visitor = new PrepareStatementVisitor();
                for (Join join : plainSelect.getJoins()) {
                    if (join.isSimple()) {
                        from.append(", ").append(join);
                    } else {
                        from.append(" ").append(join);
                    }
                    if (null != join.getRightItem()) {
                        join.getRightItem().accept((FromItemVisitor)visitor);
                    }
                    if (null == join.getOnExpressions()) continue;
                    for (Expression onExpression : join.getOnExpressions()) {
                        onExpression.accept((ExpressionVisitor)visitor);
                    }
                }
                this.prefixParameters += visitor.parameterSize;
            }
            if (plainSelect.getWhere() != null) {
                visitor = new PrepareStatementVisitor();
                plainSelect.getWhere().accept((ExpressionVisitor)visitor);
                this.prefixParameters += visitor.parameterSize;
                this.where = plainSelect.getWhere().toString();
            }
            if (plainSelect.getOrderByElements() != null) {
                this.orderBy = PlainSelect.getFormatedList((List)plainSelect.getOrderByElements(), (String)"");
            }
            if (plainSelect.getGroupBy() != null) {
                this.fastCount = false;
                suffix.append(' ').append(plainSelect.getGroupBy());
            }
            suffix.append(' ');
            if (plainSelect.getHaving() != null) {
                visitor = new PrepareStatementVisitor();
                plainSelect.getHaving().accept((ExpressionVisitor)visitor);
                this.suffixParameters = visitor.parameterSize;
                suffix.append(" HAVING ").append(plainSelect.getHaving());
            }
            this.columns = columns.toString();
            this.from = from.toString();
            this.suffix = suffix.toString();
        }

        public void visit(SetOperationList setOpList) {
            StringBuilder from = new StringBuilder();
            StringBuilder columns = new StringBuilder();
            this.initColumns(columns);
            from.append("FROM (");
            from.append(setOpList);
            from.append(") ");
            from.append(QueryAnalyzerImpl.this.select.table.alias);
            this.from = from.toString();
            this.columns = columns.toString();
            this.suffix = "";
        }

        public void visit(WithItem withItem) {
            if (!StringUtils.hasText((String)this.prefix)) {
                this.prefix = this.prefix + "WITH ";
            }
            this.prefix = this.prefix + withItem;
            PrepareStatementVisitor visitor = new PrepareStatementVisitor();
            withItem.accept((SelectVisitor)visitor);
            this.prefixParameters += visitor.parameterSize;
        }

        public void visit(ValuesStatement aThis) {
            PrepareStatementVisitor visitor = new PrepareStatementVisitor();
            aThis.accept((SelectVisitor)visitor);
        }

        public Object[] getPrefixParameters(Object ... args) {
            if (this.prefixParameters == 0) {
                return new Object[0];
            }
            Assert.isTrue((args.length >= this.prefixParameters ? 1 : 0) != 0, (String)("Illegal prepare statement parameter size, expect: " + this.prefixParameters + ", actual: " + args.length));
            return Arrays.copyOfRange(args, 0, this.prefixParameters);
        }

        public Object[] getSuffixParameters(Object ... args) {
            if (this.suffixParameters == 0) {
                return new Object[0];
            }
            Assert.isTrue((args.length >= this.suffixParameters + this.prefixParameters ? 1 : 0) != 0, (String)("Illegal prepare statement parameter size, expect: " + this.suffixParameters + this.prefixParameters + ", actual: " + args.length));
            return Arrays.copyOfRange(args, this.prefixParameters, this.suffixParameters + this.prefixParameters);
        }

        @Override
        public SqlRequest refactor(QueryParamEntity param, Object ... args) {
            if (this.QUERY == null) {
                this.QUERY = SqlFragments.of((String[])new String[]{this.prefix, "SELECT", this.columns, this.from});
            }
            BatchSqlFragments sql = new BatchSqlFragments(StringUtils.hasText((String)this.where) ? 10 : 6, 2);
            sql.add(this.QUERY).addParameter(this.getPrefixParameters(args));
            this.appendWhere((AppendableSqlFragments)sql, param);
            sql.addSql(this.suffix).addParameter(this.getSuffixParameters(args));
            this.appendOrderBy((AppendableSqlFragments)sql, param);
            return sql.toRequest();
        }

        @Override
        public SqlRequest refactorCount(QueryParamEntity param, Object ... args) {
            BatchSqlFragments sql = new BatchSqlFragments(StringUtils.hasText((String)this.where) ? 10 : 7, 2);
            if (this.SUFFIX == null) {
                this.SUFFIX = SqlFragments.of((String[])new String[]{this.suffix});
            }
            if (this.fastCount) {
                if (this.FAST_COUNT == null) {
                    this.FAST_COUNT = SqlFragments.of((String[])new String[]{this.prefix, "SELECT count(1) as", QueryAnalyzerImpl.this.database.getMetadata().getDialect().quote("_total"), this.from});
                }
                sql.add(this.FAST_COUNT);
                sql.addParameter(this.getPrefixParameters(args));
                this.appendWhere((AppendableSqlFragments)sql, param);
                sql.add(this.SUFFIX);
            } else {
                if (this.SLOW_COUNT == null) {
                    this.SLOW_COUNT = SqlFragments.of((String[])new String[]{this.prefix, "SELECT count(1) as", QueryAnalyzerImpl.this.database.getMetadata().getDialect().quote("_total"), "from (SELECT", this.columns, this.from});
                }
                sql.add(this.SLOW_COUNT);
                sql.addParameter(this.getPrefixParameters(args));
                this.appendWhere((AppendableSqlFragments)sql, param);
                sql.add(this.SUFFIX);
                sql.addSql(") _t");
            }
            return sql.addParameter(this.getSuffixParameters(args)).toRequest();
        }

        private void appendOrderBy(AppendableSqlFragments sql, QueryParamEntity param) {
            if (CollectionUtils.isNotEmpty((Collection)param.getSorts())) {
                boolean customOrder;
                int index = 0;
                BatchSqlFragments orderByValue = null;
                BatchSqlFragments orderByColumn = null;
                for (Sort sort : param.getSorts()) {
                    String columnName;
                    String name = sort.getName();
                    QueryAnalyzer.Column column = QueryAnalyzerImpl.this.getColumnOrSelectColumn(name);
                    if (column == null) continue;
                    boolean desc = "desc".equalsIgnoreCase(sort.getOrder());
                    String string = columnName = column.getOwner() == null ? QueryAnalyzerImpl.this.database.getMetadata().getDialect().quote(column.getName(), false) : org.hswebframework.ezorm.core.utils.StringUtils.concat((Object[])new Object[]{column.getOwner(), ".", QueryAnalyzerImpl.this.database.getMetadata().getDialect().quote(column.getName())});
                    if (sort.getValue() != null) {
                        if (orderByValue == null) {
                            orderByValue = new BatchSqlFragments();
                            orderByValue.addSql("case");
                        }
                        orderByValue.addSql("when");
                        orderByValue.addSql(new String[]{columnName, "= ?"}).addParameter(new Object[]{sort.getValue()});
                        orderByValue.addSql("then").addSql(String.valueOf(desc ? 10000 + index++ : index++));
                        continue;
                    }
                    if (orderByColumn == null) {
                        orderByColumn = new BatchSqlFragments();
                    } else {
                        orderByColumn.addSql(",");
                    }
                    orderByColumn.addSql(columnName).addSql(desc ? "DESC" : "ASC");
                }
                boolean bl = customOrder = orderByValue != null || orderByColumn != null;
                if (customOrder || this.orderBy != null) {
                    sql.addSql(new String[]{"ORDER BY"});
                }
                if (orderByValue != null) {
                    orderByValue.addSql("else 10000 end");
                    sql.addFragments(orderByValue);
                }
                if (orderByColumn != null) {
                    if (orderByValue != null) {
                        sql.add(SqlFragments.COMMA);
                    }
                    sql.addFragments(orderByColumn);
                }
                if (this.orderBy != null) {
                    if (customOrder) {
                        sql.add(SqlFragments.COMMA);
                    }
                    sql.addSql(new String[]{this.orderBy});
                }
            } else if (this.orderBy != null) {
                sql.addSql(new String[]{"ORDER BY", this.orderBy});
            }
        }

        private void appendWhere(AppendableSqlFragments sql, QueryParamEntity param) {
            SqlFragments fragments = TERMS_BUILDER.createTermFragments(QueryAnalyzerImpl.this, (List<Term>)param.getTerms());
            if (fragments.isNotEmpty() || StringUtils.hasText((String)this.where)) {
                sql.add(SqlFragments.WHERE);
            }
            if (StringUtils.hasText((String)this.where)) {
                sql.add(SqlFragments.LEFT_BRACKET);
                sql.addSql(new String[]{this.where});
                sql.add(SqlFragments.RIGHT_BRACKET);
            }
            if (fragments.isNotEmpty()) {
                if (StringUtils.hasText((String)this.where)) {
                    sql.add(SqlFragments.AND);
                }
                sql.add(SqlFragments.LEFT_BRACKET);
                sql.addFragments(fragments);
                sql.add(SqlFragments.RIGHT_BRACKET);
            }
        }
    }

    static class QueryAnalyzerTermsFragmentBuilder
    extends AbstractTermsFragmentBuilder<QueryAnalyzerImpl> {
        QueryAnalyzerTermsFragmentBuilder() {
        }

        public SqlFragments createTermFragments(QueryAnalyzerImpl parameter, List<Term> terms) {
            return super.createTermFragments((Object)parameter, terms);
        }

        public SqlFragments createTermFragments(QueryAnalyzerImpl impl, Term term) {
            Dialect dialect = impl.database.getMetadata().getDialect();
            QueryAnalyzer.Table table = impl.select.table;
            String column = term.getColumn();
            QueryAnalyzer.Column col = impl.getColumnMappings().get(column);
            if (col == null) {
                throw new IllegalArgumentException("undefined column [" + column + "]");
            }
            if (!Objects.equals(impl.select.table.alias, col.getOwner())) {
                QueryAnalyzer.Join join = impl.joins.get(col.getOwner());
                if (null != join) {
                    table = join.table;
                } else {
                    throw new IllegalArgumentException("undefined column [" + column + "]");
                }
            }
            RDBColumnMetadata metadata = col.metadata;
            if (col.metadata == null) {
                metadata = table.metadata;
            }
            String colName = col.metadata != null ? col.metadata.getRealName() : col.name;
            String fullName = col.metadata != null ? col.getMetadata().getFullName(table.alias) : table.alias + "." + dialect.quote(colName, false);
            return metadata.findFeature(TermFragmentBuilder.createFeatureId((String)term.getTermType())).map(feature -> feature.createFragments(fullName, col.metadata, term)).orElse((SqlFragments)EmptySqlFragments.INSTANCE);
        }
    }

    static class PrepareStatementVisitor
    extends ExpressionVisitorAdapter
    implements FromItemVisitor,
    SelectVisitor {
        private int parameterSize;

        public PrepareStatementVisitor() {
            this.setSelectVisitor(this);
        }

        public void visit(JdbcParameter parameter) {
            ++this.parameterSize;
            super.visit(parameter);
        }

        public void visit(Table tableName) {
        }

        public void visit(SubJoin subjoin) {
            if (subjoin.getLeft() != null) {
                subjoin.getLeft().accept((FromItemVisitor)this);
            }
            if (CollectionUtils.isNotEmpty((Collection)subjoin.getJoinList())) {
                for (Join join : subjoin.getJoinList()) {
                    if (join.getRightItem() != null) {
                        join.getRightItem().accept((FromItemVisitor)this);
                    }
                    if (join.getOnExpressions() == null) continue;
                    join.getOnExpressions().forEach(expr -> expr.accept((ExpressionVisitor)this));
                }
            }
        }

        public void visit(LateralSubSelect lateralSubSelect) {
            if (lateralSubSelect.getSubSelect() != null) {
                lateralSubSelect.getSubSelect().accept((ExpressionVisitor)this);
            }
        }

        public void visit(ValuesList valuesList) {
            if (valuesList.getMultiExpressionList() != null) {
                for (ExpressionList expressionList : valuesList.getMultiExpressionList().getExpressionLists()) {
                    expressionList.getExpressions().forEach(expr -> expr.accept((ExpressionVisitor)this));
                }
            }
        }

        public void visit(TableFunction tableFunction) {
            tableFunction.getFunction().accept((ExpressionVisitor)this);
        }

        public void visit(ParenthesisFromItem aThis) {
            aThis.getFromItem().accept((FromItemVisitor)this);
        }

        public void visit(PlainSelect plainSelect) {
            plainSelect.getFromItem().accept((FromItemVisitor)this);
            if (plainSelect.getJoins() != null) {
                for (Join join : plainSelect.getJoins()) {
                    join.getRightItem().accept((FromItemVisitor)this);
                }
            }
            if (plainSelect.getSelectItems() != null) {
                for (SelectItem selectItem : plainSelect.getSelectItems()) {
                    selectItem.accept((SelectItemVisitor)this);
                }
            }
            if (plainSelect.getWhere() != null) {
                plainSelect.getWhere().accept((ExpressionVisitor)this);
            }
            if (plainSelect.getHaving() != null) {
                plainSelect.getHaving().accept((ExpressionVisitor)this);
            }
            if (plainSelect.getGroupBy() != null) {
                for (Expression expression : plainSelect.getGroupBy().getGroupByExpressionList().getExpressions()) {
                    expression.accept((ExpressionVisitor)this);
                }
            }
        }

        public void visit(SetOperationList setOpList) {
            if (CollectionUtils.isNotEmpty((Collection)setOpList.getSelects())) {
                for (SelectBody select : setOpList.getSelects()) {
                    select.accept((SelectVisitor)this);
                }
            }
            if (setOpList.getOffset() != null) {
                setOpList.getOffset().getOffset().accept((ExpressionVisitor)this);
            }
            if (setOpList.getLimit() != null) {
                if (setOpList.getLimit().getRowCount() != null) {
                    setOpList.getLimit().getRowCount().accept((ExpressionVisitor)this);
                }
                if (setOpList.getLimit().getOffset() != null) {
                    setOpList.getLimit().getOffset().accept((ExpressionVisitor)this);
                }
            }
        }

        public void visit(WithItem withItem) {
            if (CollectionUtils.isNotEmpty((Collection)withItem.getWithItemList())) {
                for (SelectItem selectItem : withItem.getWithItemList()) {
                    selectItem.accept((SelectItemVisitor)this);
                }
            }
            if (withItem.getSubSelect() != null) {
                withItem.getSubSelect().accept((ExpressionVisitor)this);
            }
        }

        public void visit(ValuesStatement aThis) {
            if (aThis.getExpressions() != null) {
                aThis.getExpressions().accept((ItemsListVisitor)this);
            }
        }

        public int getParameterSize() {
            return this.parameterSize;
        }
    }
}

