/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.service;

import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.hswebframework.web.cache.ReactiveCache;
import org.hswebframework.web.cache.ReactiveCacheManager;
import org.hswebframework.web.cache.supports.UnSupportedReactiveCache;
import org.hswebframework.web.crud.service.EnableCacheReactiveCrudService;
import org.springframework.beans.factory.annotation.Autowired;
import reactor.core.publisher.Flux;

public abstract class GenericReactiveCacheSupportCrudService<E, K>
implements EnableCacheReactiveCrudService<E, K> {
    @Autowired
    private ReactiveRepository<E, K> repository;
    @Autowired(required=false)
    private ReactiveCacheManager cacheManager;
    protected ReactiveCache<E> cache;

    @Override
    public ReactiveRepository<E, K> getRepository() {
        return this.repository;
    }

    @Override
    public ReactiveCache<E> getCache() {
        if (this.cache != null) {
            return this.cache;
        }
        if (this.cacheManager == null) {
            this.cache = UnSupportedReactiveCache.getInstance();
            return this.cache;
        }
        this.cache = this.cacheManager.getCache(this.getCacheName());
        return this.cache;
    }

    public String getCacheName() {
        return this.getClass().getSimpleName();
    }

    public Flux<E> getCacheAll() {
        return this.getCache().getFlux((Object)"@all", () -> EnableCacheReactiveCrudService.super.createQuery().fetch());
    }
}

