/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hswebframework.ezorm.rdb.mapping.SyncDelete;
import org.hswebframework.ezorm.rdb.mapping.SyncQuery;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.utils.RandomUtil;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.api.crud.entity.TreeSortSupportEntity;
import org.hswebframework.web.api.crud.entity.TreeSupportEntity;
import org.hswebframework.web.crud.service.CrudService;
import org.hswebframework.web.id.IDGenerator;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public interface TreeSortEntityService<E extends TreeSortSupportEntity<K>, K>
extends CrudService<E, K> {
    @Transactional(readOnly=true, transactionManager="transactionManager")
    default public List<E> queryResultToTree(QueryParamEntity paramEntity) {
        return TreeSupportEntity.list2tree(this.query(paramEntity), this::setChildren, this::createRootNodePredicate);
    }

    @Transactional(readOnly=true, transactionManager="transactionManager")
    default public List<E> queryIncludeChildrenTree(QueryParamEntity paramEntity) {
        return TreeSupportEntity.list2tree(this.queryIncludeChildren(paramEntity), this::setChildren, this::createRootNodePredicate);
    }

    @Transactional(readOnly=true, transactionManager="transactionManager")
    default public List<E> queryIncludeChildren(Collection<K> idList) {
        return this.findById(idList).stream().flatMap(e -> ((SyncQuery)((SyncQuery)this.createQuery().where()).like$("path", (Object)e.getPath())).fetch().stream()).collect(Collectors.toList());
    }

    @Transactional(readOnly=true, transactionManager="transactionManager")
    default public List<E> queryIncludeChildren(QueryParamEntity queryParam) {
        return this.query(queryParam).stream().flatMap(e -> ((SyncQuery)((SyncQuery)this.createQuery().where()).like$("path", (Object)e.getPath())).fetch().stream()).collect(Collectors.toList());
    }

    @Override
    default public void insert(E entityPublisher) {
        this.insert(Collections.singletonList(entityPublisher));
    }

    @Override
    default public int insert(Collection<E> entityPublisher) {
        return this.getRepository().insertBatch((Collection)entityPublisher.stream().flatMap(this::applyTreeProperty).flatMap(e -> TreeSupportEntity.expandTree2List((TreeSupportEntity)e, this.getIDGenerator()).stream()).collect(Collectors.toList()));
    }

    default public Stream<E> applyTreeProperty(E ele) {
        if (StringUtils.hasText((String)ele.getPath()) || ObjectUtils.isEmpty((Object)ele.getParentId())) {
            return Stream.of(ele);
        }
        this.checkCyclicDependency(ele.getId(), ele);
        this.findById(ele.getParentId()).ifPresent(parent -> ele.setPath(parent.getPath() + "-" + RandomUtil.randomChar((int)4)));
        return Stream.of(ele);
    }

    default public void checkCyclicDependency(K id, E ele) {
        if (ObjectUtils.isEmpty(id)) {
            return;
        }
        for (TreeSortSupportEntity e : this.queryIncludeChildren(Collections.singletonList(id))) {
            if (!Objects.equals(ele.getParentId(), e.getId())) continue;
            throw new IllegalArgumentException("\u4e0d\u80fd\u4fee\u6539\u7236\u8282\u70b9\u4e3a\u81ea\u5df1\u6216\u8005\u81ea\u5df1\u7684\u5b50\u8282\u70b9");
        }
    }

    @Override
    default public SaveResult save(List<E> entities) {
        return this.getRepository().save((Collection)entities.stream().flatMap(this::applyTreeProperty).flatMap(e -> TreeSupportEntity.expandTree2List((TreeSupportEntity)e, this.getIDGenerator()).stream()).collect(Collectors.toList()));
    }

    @Override
    default public int updateById(K id, E entity) {
        entity.setId(id);
        return this.save(entity).getTotal();
    }

    @Override
    default public int deleteById(Collection<K> idPublisher) {
        List dataList = this.findById(idPublisher);
        return dataList.stream().map(e -> ((SyncDelete)((SyncDelete)this.createDelete().where()).like$(() -> ((TreeSortSupportEntity)e).getPath())).execute()).mapToInt(Integer::intValue).sum();
    }

    public IDGenerator<K> getIDGenerator();

    public void setChildren(E var1, List<E> var2);

    default public List<E> getChildren(E entity) {
        return entity.getChildren();
    }

    default public Predicate<E> createRootNodePredicate(TreeSupportEntity.TreeHelper<E, K> helper) {
        return node -> {
            if (this.isRootNode(node)) {
                return true;
            }
            if (!ObjectUtils.isEmpty((Object)node.getParentId())) {
                return helper.getNode(node.getParentId()) == null;
            }
            return false;
        };
    }

    default public boolean isRootNode(E entity) {
        return ObjectUtils.isEmpty((Object)entity.getParentId()) || "-1".equals(String.valueOf(entity.getParentId()));
    }
}

