/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.web;

import jakarta.validation.ConstraintViolationException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.hswebframework.web.authorization.exception.AccessDenyException;
import org.hswebframework.web.authorization.exception.AuthenticationException;
import org.hswebframework.web.authorization.exception.UnAuthorizedException;
import org.hswebframework.web.authorization.token.TokenState;
import org.hswebframework.web.crud.web.ResponseMessage;
import org.hswebframework.web.exception.BusinessException;
import org.hswebframework.web.exception.I18nSupportException;
import org.hswebframework.web.exception.NotFoundException;
import org.hswebframework.web.exception.ValidationException;
import org.hswebframework.web.i18n.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.server.MethodNotAllowedException;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebInputException;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;

@RestControllerAdvice
@Order
public class CommonWebMvcErrorControllerAdvice {
    private static final Logger log = LoggerFactory.getLogger(CommonWebMvcErrorControllerAdvice.class);

    private String resolveMessage(Throwable e) {
        if (e instanceof I18nSupportException) {
            return LocaleUtils.resolveMessage((String)((I18nSupportException)e).getI18nCode(), (Object[])new Object[0]);
        }
        return e.getMessage() == null ? null : LocaleUtils.resolveMessage((String)e.getMessage(), (Object[])new Object[0]);
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResponseMessage<Object> handleException(BusinessException err) {
        String msg = this.resolveMessage((Throwable)err);
        return ResponseMessage.error(err.getStatus(), err.getCode(), msg);
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResponseMessage<Object> handleException(UnsupportedOperationException e) {
        log.warn(e.getLocalizedMessage(), (Throwable)e);
        String msg = this.resolveMessage(e);
        return ResponseMessage.error(500, "unsupported", msg);
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ResponseMessage<TokenState> handleException(UnAuthorizedException e) {
        return ResponseMessage.error(401, "unauthorized", this.resolveMessage((Throwable)e)).result(e.getState());
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    public ResponseMessage<Object> handleException(AccessDenyException e) {
        return ResponseMessage.error(403, e.getCode(), this.resolveMessage((Throwable)e));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ResponseMessage<Object> handleException(NotFoundException e) {
        return ResponseMessage.error(404, "not_found", this.resolveMessage((Throwable)e));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseMessage<List<ValidationException.Detail>> handleException(ValidationException e) {
        return ResponseMessage.error(400, "illegal_argument", this.resolveMessage((Throwable)e)).result(e.getDetails());
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseMessage<List<ValidationException.Detail>> handleException(ConstraintViolationException e) {
        return this.handleException(new ValidationException(e.getConstraintViolations()));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseMessage<List<ValidationException.Detail>> handleException(BindException e) {
        return this.handleException(new ValidationException(e.getMessage(), e.getBindingResult().getAllErrors().stream().filter(FieldError.class::isInstance).map(FieldError.class::cast).map(err -> new ValidationException.Detail(err.getField(), err.getDefaultMessage(), null)).collect(Collectors.toList()), new Object[0]));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseMessage<List<ValidationException.Detail>> handleException(WebExchangeBindException e) {
        return this.handleException(new ValidationException(e.getMessage(), e.getBindingResult().getAllErrors().stream().filter(FieldError.class::isInstance).map(FieldError.class::cast).map(err -> new ValidationException.Detail(err.getField(), err.getDefaultMessage(), null)).collect(Collectors.toList()), new Object[0]));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseMessage<List<ValidationException.Detail>> handleException(MethodArgumentNotValidException e) {
        return this.handleException(new ValidationException(e.getMessage(), e.getBindingResult().getAllErrors().stream().filter(FieldError.class::isInstance).map(FieldError.class::cast).map(err -> new ValidationException.Detail(err.getField(), err.getDefaultMessage(), null)).collect(Collectors.toList()), new Object[0]));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseMessage<?> handleException(jakarta.validation.ValidationException e) {
        return ResponseMessage.error(400, "illegal_argument", e.getMessage());
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.GATEWAY_TIMEOUT)
    public ResponseMessage<Object> handleException(TimeoutException e) {
        return ResponseMessage.error(504, "timeout", this.resolveMessage(e));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @Order
    public ResponseMessage<Object> handleException(RuntimeException e) {
        log.warn(e.getLocalizedMessage(), (Throwable)e);
        return ResponseMessage.error(this.resolveMessage(e));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResponseMessage<Object> handleException(NullPointerException e) {
        log.warn(e.getLocalizedMessage(), (Throwable)e);
        return ResponseMessage.error(e.getMessage());
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseMessage<Object> handleException(IllegalArgumentException e) {
        log.warn(e.getLocalizedMessage(), (Throwable)e);
        return ResponseMessage.error(400, "illegal_argument", this.resolveMessage(e));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseMessage<Object> handleException(AuthenticationException e) {
        log.warn(e.getLocalizedMessage(), (Throwable)e);
        return ResponseMessage.error(400, e.getCode(), this.resolveMessage((Throwable)e));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.UNSUPPORTED_MEDIA_TYPE)
    public ResponseMessage<Object> handleException(UnsupportedMediaTypeStatusException e) {
        log.warn(e.getLocalizedMessage(), (Throwable)e);
        return ResponseMessage.error(415, "unsupported_media_type", LocaleUtils.resolveMessage((String)"error.unsupported_media_type", (Object[])new Object[0])).result(e.getSupportedMediaTypes());
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    public ResponseMessage<Object> handleException(NotAcceptableStatusException e) {
        log.warn(e.getLocalizedMessage(), (Throwable)e);
        return ResponseMessage.error(406, "not_acceptable_media_type", LocaleUtils.resolveMessage((String)"error.not_acceptable_media_type", (Object[])new Object[0])).result(e.getSupportedMediaTypes());
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    public ResponseMessage<Object> handleException(MethodNotAllowedException e) {
        log.warn(e.getLocalizedMessage(), (Throwable)e);
        return ResponseMessage.error(406, "method_not_allowed", LocaleUtils.resolveMessage((String)"error.method_not_allowed", (Object[])new Object[0])).result(e.getSupportedMethods());
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseMessage<List<ValidationException.Detail>> handleException(ServerWebInputException e) {
        Object exception = e;
        do {
            if (!((exception = exception.getCause()) instanceof ValidationException)) continue;
            return this.handleException((ValidationException)exception);
        } while (exception != null && exception != e);
        if (exception == null) {
            return ResponseMessage.error(400, "illegal_argument", e.getMessage());
        }
        return ResponseMessage.error(400, "illegal_argument", this.resolveMessage((Throwable)exception));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseMessage<Object> handleException(I18nSupportException e) {
        return ResponseMessage.error(400, e.getI18nCode(), this.resolveMessage((Throwable)e));
    }
}

