/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.configuration;

import java.lang.reflect.AnnotatedElement;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.operator.DatabaseOperator;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.ddl.CreateTableSqlBuilder;
import org.hswebframework.web.api.crud.entity.EntityFactory;
import org.hswebframework.web.crud.annotation.DDL;
import org.hswebframework.web.crud.configuration.EasyormProperties;
import org.hswebframework.web.crud.configuration.EntityInfo;
import org.hswebframework.web.crud.configuration.EntityTableMetadataResolver;
import org.hswebframework.web.crud.events.EntityDDLEvent;
import org.hswebframework.web.event.GenericsPayloadApplicationEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.annotation.AnnotatedElementUtils;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public class AutoDDLProcessor
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutoDDLProcessor.class);
    private Set<EntityInfo> entities = new HashSet<EntityInfo>();
    @Autowired
    private DatabaseOperator operator;
    @Autowired
    private EasyormProperties properties;
    @Autowired
    private EntityTableMetadataResolver resolver;
    @Autowired
    private EntityFactory entityFactory;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    private boolean reactive;

    public void afterPropertiesSet() {
        RDBTableMetadata metadata;
        ArrayList readyToDDL = new ArrayList(this.entities.size());
        ArrayList nonDDL = new ArrayList();
        for (EntityInfo entityInfo : this.entities) {
            Class type2 = this.entityFactory.getInstanceType(entityInfo.getRealType(), true);
            DDL ddl = (DDL)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)type2, DDL.class);
            if (this.properties.isAutoDdl() && (ddl == null || ddl.value())) {
                readyToDDL.add(entityInfo.getEntityType());
                continue;
            }
            nonDDL.add(entityInfo.getEntityType());
        }
        if (!readyToDDL.isEmpty()) {
            if (this.reactive) {
                Flux.fromIterable(readyToDDL).doOnNext(type -> log.trace("auto ddl for {}", type)).map(type -> {
                    RDBTableMetadata metadata = this.resolver.resolve((Class<?>)type);
                    EntityDDLEvent event = new EntityDDLEvent(this, type, metadata);
                    this.eventPublisher.publishEvent((ApplicationEvent)new GenericsPayloadApplicationEvent((Object)this, event, new Class[]{type}));
                    return metadata;
                }).flatMap(meta -> this.operator.ddl().createOrAlter(meta).autoLoad(false).commit().reactive().subscribeOn(Schedulers.boundedElastic()), 8, 8).doOnError(err -> log.error(err.getMessage(), err)).then().block(Duration.ofMinutes(5L));
            } else {
                for (Class clazz : readyToDDL) {
                    log.trace("auto ddl for {}", (Object)clazz);
                    try {
                        metadata = this.resolver.resolve(clazz);
                        EntityDDLEvent event = new EntityDDLEvent(this, clazz, metadata);
                        this.eventPublisher.publishEvent((ApplicationEvent)new GenericsPayloadApplicationEvent((Object)this, event, new Class[]{clazz}));
                        this.operator.ddl().createOrAlter(metadata).autoLoad(false).commit().sync();
                    }
                    catch (Exception e) {
                        log.error(e.getLocalizedMessage(), (Throwable)e);
                        throw e;
                    }
                }
            }
        }
        for (Class clazz : nonDDL) {
            metadata = this.resolver.resolve(clazz);
            RDBSchemaMetadata schema = metadata.getSchema();
            RDBTableMetadata table = schema.getTable(metadata.getName()).orElse(null);
            if (table == null) {
                SqlRequest request = ((CreateTableSqlBuilder)schema.findFeatureNow(CreateTableSqlBuilder.ID)).build((Object)metadata);
                log.info("DDL SQL for {} \n{}", (Object)clazz, (Object)request.toNativeSql());
                schema.addTable(metadata);
                continue;
            }
            table.merge((TableOrViewMetadata)metadata);
        }
    }

    @Generated
    public Set<EntityInfo> getEntities() {
        return this.entities;
    }

    @Generated
    public DatabaseOperator getOperator() {
        return this.operator;
    }

    @Generated
    public EasyormProperties getProperties() {
        return this.properties;
    }

    @Generated
    public EntityTableMetadataResolver getResolver() {
        return this.resolver;
    }

    @Generated
    public EntityFactory getEntityFactory() {
        return this.entityFactory;
    }

    @Generated
    public ApplicationEventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    @Generated
    public boolean isReactive() {
        return this.reactive;
    }

    @Generated
    public void setEntities(Set<EntityInfo> entities) {
        this.entities = entities;
    }

    @Generated
    public void setOperator(DatabaseOperator operator) {
        this.operator = operator;
    }

    @Generated
    public void setProperties(EasyormProperties properties) {
        this.properties = properties;
    }

    @Generated
    public void setResolver(EntityTableMetadataResolver resolver) {
        this.resolver = resolver;
    }

    @Generated
    public void setEntityFactory(EntityFactory entityFactory) {
        this.entityFactory = entityFactory;
    }

    @Generated
    public void setEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Generated
    public void setReactive(boolean reactive) {
        this.reactive = reactive;
    }
}

