/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.configuration;

import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.Id;
import lombok.Generated;
import org.hswebframework.ezorm.rdb.mapping.defaults.DefaultReactiveRepository;
import org.hswebframework.ezorm.rdb.mapping.defaults.DefaultSyncRepository;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.crud.annotation.EnableEasyormRepository;
import org.hswebframework.web.crud.annotation.Reactive;
import org.hswebframework.web.crud.configuration.AutoDDLProcessor;
import org.hswebframework.web.crud.configuration.EntityInfo;
import org.hswebframework.web.crud.configuration.ReactiveRepositoryFactoryBean;
import org.hswebframework.web.crud.configuration.SyncRepositoryFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class EasyormRepositoryRegistrar
implements ImportBeanDefinitionRegistrar {
    @Generated
    private static final Logger log;
    private final ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private final MetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory();
    static final boolean mvcEnabled;
    static AtomicInteger count;

    private String getResourceClassName(Resource resource) {
        try {
            return this.metadataReaderFactory.getMetadataReader(resource).getClassMetadata().getClassName();
        }
        catch (IOException e) {
            return null;
        }
    }

    private Stream<Resource> doGetResources(String packageStr) {
        String path = "classpath*:".concat(packageStr.replace(".", "/")).concat("/**/*.class");
        String clazz = "classpath*:".concat(packageStr.replace(".", "/")).concat(".class");
        return Stream.concat(Arrays.stream(this.resourcePatternResolver.getResources(path)), Arrays.stream(this.resourcePatternResolver.getResources(clazz)));
    }

    protected Set<String> scanEntities(String[] packageStr) {
        return Stream.of(packageStr).flatMap(this::doGetResources).map(this::getResourceClassName).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private Class<?> findIdType(Class<?> entityType) {
        Class<?> idType;
        try {
            if (GenericEntity.class.isAssignableFrom(entityType)) {
                return GenericTypeResolver.resolveTypeArgument(entityType, GenericEntity.class);
            }
            Class[] ref = new Class[1];
            ReflectionUtils.doWithFields(entityType, field -> {
                if (field.isAnnotationPresent(Id.class)) {
                    ref[0] = field.getType();
                }
            });
            idType = ref[0];
            if (idType == null) {
                Method getId = ClassUtils.getMethod(entityType, (String)"getId", (Class[])new Class[0]);
                idType = getId.getReturnType();
            }
        }
        catch (Throwable e) {
            log.warn("unknown id type of entity:{}", entityType);
            idType = String.class;
        }
        return idType;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Class<?> entityType;
        Map attr = importingClassMetadata.getAnnotationAttributes(EnableEasyormRepository.class.getName());
        if (attr == null) {
            return;
        }
        boolean reactiveEnabled = Boolean.TRUE.equals(attr.get("reactive"));
        boolean nonReactiveEnabled = Boolean.TRUE.equals(attr.get("nonReactive")) || mvcEnabled;
        String[] arr = (String[])attr.get("value");
        Class[] anno = (Class[])attr.get("annotation");
        ConcurrentHashMap.KeySetView entityInfos = ConcurrentHashMap.newKeySet();
        for (String className : this.scanEntities(arr)) {
            entityType = ClassUtils.forName((String)className, null);
            if (Arrays.stream(anno).noneMatch(ann -> AnnotationUtils.getAnnotation((AnnotatedElement)entityType, (Class)ann) != null)) continue;
            Reactive reactive = (Reactive)AnnotationUtils.findAnnotation(entityType, Reactive.class);
            Class<?> idType = this.findIdType(entityType);
            EntityInfo entityInfo = new EntityInfo(entityType, entityType, idType, reactiveEnabled, nonReactiveEnabled);
            if (entityInfos.contains(entityInfo)) continue;
            entityInfos.add(entityInfo);
        }
        for (EntityInfo entityInfo : entityInfos) {
            RootBeanDefinition definition;
            ResolvableType repositoryType;
            String beanName;
            entityType = entityInfo.getEntityType();
            Class<?> idType = entityInfo.getIdType();
            Class<?> realType = entityInfo.getRealType();
            if (entityInfo.isReactive()) {
                beanName = entityType.getSimpleName().concat("ReactiveRepository");
                log.trace("Register bean ReactiveRepository<{},{}> {}", new Object[]{entityType.getName(), idType.getSimpleName(), beanName});
                repositoryType = ResolvableType.forClassWithGenerics(DefaultReactiveRepository.class, (Class[])new Class[]{entityType, idType});
                definition = new RootBeanDefinition();
                definition.setTargetType(repositoryType);
                definition.setBeanClass(ReactiveRepositoryFactoryBean.class);
                definition.setAutowireMode(2);
                definition.getPropertyValues().add("entityType", entityType);
                if (!registry.containsBeanDefinition(beanName)) {
                    registry.registerBeanDefinition(beanName, (BeanDefinition)definition);
                } else {
                    entityInfos.remove(entityInfo);
                }
            }
            if (!entityInfo.isNonReactive()) continue;
            beanName = entityType.getSimpleName().concat("SyncRepository");
            log.trace("Register bean SyncRepository<{},{}> {}", new Object[]{entityType.getName(), idType.getSimpleName(), beanName});
            repositoryType = ResolvableType.forClassWithGenerics(DefaultSyncRepository.class, (Class[])new Class[]{entityType, idType});
            definition = new RootBeanDefinition();
            definition.setTargetType(repositoryType);
            definition.setBeanClass(SyncRepositoryFactoryBean.class);
            definition.setAutowireMode(2);
            definition.getPropertyValues().add("entityType", entityType);
            if (!registry.containsBeanDefinition(beanName)) {
                registry.registerBeanDefinition(beanName, (BeanDefinition)definition);
                continue;
            }
            entityInfos.remove(entityInfo);
        }
        Map group = entityInfos.stream().collect(Collectors.groupingBy(EntityInfo::isReactive, Collectors.toSet()));
        for (Map.Entry entry : group.entrySet()) {
            RootBeanDefinition definition = new RootBeanDefinition();
            definition.setTargetType(AutoDDLProcessor.class);
            definition.setBeanClass(AutoDDLProcessor.class);
            definition.setAutowireMode(2);
            definition.getPropertyValues().add("entities", entityInfos);
            definition.getPropertyValues().add("reactive", (Object)entry.getKey());
            definition.setRole(2);
            definition.setSynthetic(true);
            registry.registerBeanDefinition(AutoDDLProcessor.class.getName() + "_" + count.incrementAndGet(), (BeanDefinition)definition);
        }
    }

    static {
        boolean mvcImported;
        log = LoggerFactory.getLogger(EasyormRepositoryRegistrar.class);
        try {
            Class.forName("org.springframework.web.servlet.DispatcherServlet");
            mvcImported = true;
        }
        catch (Throwable e) {
            mvcImported = false;
        }
        mvcEnabled = mvcImported;
        count = new AtomicInteger();
    }
}

