/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.configuration;

import lombok.Generated;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.hswebframework.ezorm.rdb.mapping.defaults.DefaultReactiveRepository;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.DatabaseOperator;
import org.hswebframework.web.crud.configuration.EntityResultWrapperFactory;
import org.hswebframework.web.crud.configuration.EntityTableMetadataResolver;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;

public class ReactiveRepositoryFactoryBean<E, PK>
implements FactoryBean<ReactiveRepository<E, PK>> {
    @Autowired
    private DatabaseOperator operator;
    @Autowired
    private EntityTableMetadataResolver resolver;
    private Class<E> entityType;
    @Autowired
    private EntityResultWrapperFactory wrapperFactory;

    public ReactiveRepository<E, PK> getObject() {
        RDBTableMetadata table = this.resolver.resolve(this.entityType);
        return new DefaultReactiveRepository(this.operator, table.getName(), this.entityType, this.wrapperFactory.getWrapper(this.entityType));
    }

    public Class<?> getObjectType() {
        return ReactiveRepository.class;
    }

    public boolean isSingleton() {
        return true;
    }

    @Generated
    public DatabaseOperator getOperator() {
        return this.operator;
    }

    @Generated
    public EntityTableMetadataResolver getResolver() {
        return this.resolver;
    }

    @Generated
    public Class<E> getEntityType() {
        return this.entityType;
    }

    @Generated
    public EntityResultWrapperFactory getWrapperFactory() {
        return this.wrapperFactory;
    }

    @Generated
    public void setOperator(DatabaseOperator operator) {
        this.operator = operator;
    }

    @Generated
    public void setResolver(EntityTableMetadataResolver resolver) {
        this.resolver = resolver;
    }

    @Generated
    public void setEntityType(Class<E> entityType) {
        this.entityType = entityType;
    }

    @Generated
    public void setWrapperFactory(EntityResultWrapperFactory wrapperFactory) {
        this.wrapperFactory = wrapperFactory;
    }
}

