/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.query;

import org.hswebframework.web.exception.BusinessException;
import org.hswebframework.web.recycler.Recycler;
import org.hswebframework.web.recycler.Recyclers;

public class QueryHelperUtils {
    static final Recycler<StringBuilder> SHARE = Recyclers.STRING_BUILDER;

    public static String toSnake(String col) {
        return (String)SHARE.doWith((Object)col, (builder, _col) -> {
            int len = _col.length();
            for (int i = 0; i < len; ++i) {
                char c = _col.charAt(i);
                if (Character.isUpperCase(c)) {
                    if (i != 0) {
                        builder.append('_');
                    }
                    builder.append(Character.toLowerCase(c));
                    continue;
                }
                builder.append(c);
            }
            return builder.toString();
        });
    }

    public static String toHump(String col) {
        return (String)SHARE.doWith((Object)col, (builder, _col) -> {
            boolean hasUpper = false;
            boolean hasLower = false;
            int len = _col.length();
            for (int i = 0; i < len; ++i) {
                char c = _col.charAt(i);
                if (Character.isLowerCase(c)) {
                    hasLower = true;
                }
                if (Character.isUpperCase(c)) {
                    hasUpper = true;
                }
                if (hasUpper && hasLower) {
                    return _col;
                }
                if (c == '_') {
                    if (i == len - 1) {
                        builder.append('_');
                        continue;
                    }
                    builder.append(Character.toUpperCase(_col.charAt(++i)));
                    continue;
                }
                builder.append(Character.toLowerCase(c));
            }
            return builder.toString();
        });
    }

    public static void assertLegalColumn(String col) {
        if (!QueryHelperUtils.isLegalColumn(col)) {
            throw new BusinessException.NoStackTrace("error.illegal_column_name", col);
        }
    }

    public static boolean isLegalColumn(String col) {
        int len = col.length();
        for (int i = 0; i < len; ++i) {
            char c = col.charAt(i);
            if (c == '_' || c == '$' || Character.isLetterOrDigit(c)) continue;
            return false;
        }
        return true;
    }
}

