/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.rdb.mapping.SyncDelete;
import org.hswebframework.ezorm.rdb.mapping.SyncQuery;
import org.hswebframework.ezorm.rdb.mapping.SyncRepository;
import org.hswebframework.ezorm.rdb.mapping.SyncUpdate;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.springframework.transaction.annotation.Transactional;

public interface CrudService<E, K> {
    public SyncRepository<E, K> getRepository();

    default public SyncQuery<E> createQuery() {
        return this.getRepository().createQuery();
    }

    default public SyncUpdate<E> createUpdate() {
        return this.getRepository().createUpdate();
    }

    default public SyncDelete createDelete() {
        return this.getRepository().createDelete();
    }

    @Transactional(readOnly=true, transactionManager="transactionManager")
    default public Optional<E> findById(K id) {
        return this.getRepository().findById(id);
    }

    @Transactional(readOnly=true, transactionManager="transactionManager")
    default public List<E> findById(Collection<K> id) {
        if (CollectionUtils.isEmpty(id)) {
            return Collections.emptyList();
        }
        return this.getRepository().findById(id);
    }

    @Transactional(rollbackFor={Throwable.class}, transactionManager="transactionManager")
    default public SaveResult save(Collection<E> entityArr) {
        return this.getRepository().save(entityArr);
    }

    @Transactional(rollbackFor={Throwable.class}, transactionManager="transactionManager")
    default public int insert(Collection<E> entityArr) {
        return this.getRepository().insertBatch(entityArr);
    }

    @Transactional(rollbackFor={Throwable.class}, transactionManager="transactionManager")
    default public void insert(E entityArr) {
        this.getRepository().insert(entityArr);
    }

    @Transactional(rollbackFor={Throwable.class}, transactionManager="transactionManager")
    default public int updateById(K id, E entityArr) {
        return this.getRepository().updateById(id, entityArr);
    }

    @Transactional(rollbackFor={Throwable.class}, transactionManager="transactionManager")
    default public SaveResult save(E entity) {
        return this.getRepository().save(Collections.singletonList(entity));
    }

    @Transactional(rollbackFor={Throwable.class}, transactionManager="transactionManager")
    default public SaveResult save(List<E> entities) {
        return this.getRepository().save(entities);
    }

    @Transactional(rollbackFor={Throwable.class}, transactionManager="transactionManager")
    default public int deleteById(Collection<K> idArr) {
        return this.getRepository().deleteById(idArr);
    }

    @Transactional(rollbackFor={Throwable.class}, transactionManager="transactionManager")
    default public int deleteById(K idArr) {
        return this.deleteById((K)Collections.singletonList(idArr));
    }

    @Transactional(readOnly=true, transactionManager="transactionManager")
    default public List<E> query(QueryParamEntity queryParam) {
        return ((SyncQuery)this.createQuery().setParam((QueryParam)queryParam)).fetch();
    }

    @Transactional(readOnly=true, transactionManager="transactionManager")
    default public PagerResult<E> queryPager(QueryParamEntity param) {
        int count;
        int n = count = param.getTotal() == null ? this.count((QueryParam)param) : param.getTotal().intValue();
        if (count == 0) {
            return PagerResult.of((int)0, Collections.emptyList(), (QueryParam)param);
        }
        param.rePaging(count);
        return PagerResult.of((int)count, this.query(param), (QueryParam)param);
    }

    @Transactional(readOnly=true, transactionManager="transactionManager")
    default public int count(QueryParam param) {
        return ((SyncQuery)this.getRepository().createQuery().setParam(param)).count();
    }
}

