/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.service;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.hswebframework.web.api.crud.entity.TreeSortSupportEntity;
import org.hswebframework.web.crud.service.TreeSortEntityService;
import org.hswebframework.web.crud.service.TreeSortServiceHelper;
import org.hswebframework.web.id.IDGenerator;
import reactor.core.publisher.Flux;

public class SyncTreeSortServiceHelper<E extends TreeSortSupportEntity<PK>, PK>
extends TreeSortServiceHelper<E, PK> {
    private final TreeSortEntityService<E, PK> service;

    public SyncTreeSortServiceHelper(TreeSortEntityService<E, PK> service) {
        this.service = service;
    }

    @Override
    protected IDGenerator<PK> getIdGenerator() {
        return this.service.getIDGenerator();
    }

    @Override
    protected void applyChildren(E parent, List<E> children) {
        this.service.setChildren(parent, children);
    }

    @Override
    protected boolean isRootNode(E node) {
        return this.service.isRootNode(node);
    }

    @Override
    public List<E> prepare(Collection<E> source) {
        return super.prepare(Flux.fromIterable(source)).toStream().collect(Collectors.toList());
    }

    @Override
    protected Flux<E> queryIncludeChildren(Collection<PK> idList) {
        return Flux.fromIterable(this.service.queryIncludeChildren(idList));
    }

    @Override
    protected Flux<E> queryById(Collection<PK> idList) {
        return Flux.fromIterable(this.service.findById(idList));
    }
}

