/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.rdb.mapping.SyncDelete;
import org.hswebframework.ezorm.rdb.mapping.SyncQuery;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.api.crud.entity.TreeSortSupportEntity;
import org.hswebframework.web.api.crud.entity.TreeSupportEntity;
import org.hswebframework.web.crud.service.CrudService;
import org.hswebframework.web.crud.service.SyncTreeSortServiceHelper;
import org.hswebframework.web.crud.service.TreeSortServiceHelper;
import org.hswebframework.web.id.IDGenerator;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;

public interface TreeSortEntityService<E extends TreeSortSupportEntity<K>, K>
extends CrudService<E, K> {
    @Transactional(readOnly=true, transactionManager="transactionManager")
    default public List<E> queryResultToTree(QueryParamEntity paramEntity) {
        return TreeSupportEntity.list2tree(this.query(paramEntity), this::setChildren, this::createRootNodePredicate);
    }

    @Transactional(readOnly=true, transactionManager="transactionManager")
    default public List<E> queryIncludeChildrenTree(QueryParamEntity paramEntity) {
        return TreeSupportEntity.list2tree(this.queryIncludeChildren(paramEntity), this::setChildren, this::createRootNodePredicate);
    }

    @Transactional(readOnly=true, transactionManager="transactionManager")
    default public List<E> queryIncludeChildren(Collection<K> idList) {
        return this.findById(idList).stream().flatMap(e -> ((SyncQuery)((SyncQuery)this.createQuery().where()).like$("path", (Object)e.getPath())).fetch().stream()).collect(Collectors.toList());
    }

    @Transactional(readOnly=true, transactionManager="transactionManager")
    default public List<E> queryIncludeChildren(QueryParamEntity queryParam) {
        return this.query(queryParam).stream().flatMap(e -> ((SyncQuery)((SyncQuery)this.createQuery().where()).like$("path", (Object)e.getPath())).fetch().stream()).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, transactionManager="transactionManager")
    default public void insert(E entityPublisher) {
        this.insert(Collections.singletonList(entityPublisher));
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, transactionManager="transactionManager")
    default public int insert(Collection<E> entityPublisher) {
        return ((TreeSortServiceHelper)new SyncTreeSortServiceHelper(this)).prepare(Flux.fromIterable(entityPublisher)).buffer(this.getBufferSize()).map(arg_0 -> this.getRepository().insertBatch(arg_0)).reduce(Math::addExact).blockOptional().orElse(0);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, transactionManager="transactionManager")
    default public SaveResult save(List<E> entities) {
        return ((TreeSortServiceHelper)new SyncTreeSortServiceHelper(this)).prepare(Flux.fromIterable(entities)).buffer(this.getBufferSize()).map(arg_0 -> this.getRepository().save(arg_0)).reduce(SaveResult::merge).blockOptional().orElse(SaveResult.of((int)0, (int)0));
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, transactionManager="transactionManager")
    default public int updateById(K id, E entity) {
        entity.setId(id);
        return this.save(entity).getTotal();
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, transactionManager="transactionManager")
    default public int deleteById(Collection<K> idPublisher) {
        List dataList = this.findById(idPublisher);
        return dataList.stream().map(e -> ((SyncDelete)((SyncDelete)this.createDelete().where()).like$(() -> ((TreeSortSupportEntity)e).getPath())).execute()).mapToInt(Integer::intValue).sum();
    }

    public IDGenerator<K> getIDGenerator();

    public void setChildren(E var1, List<E> var2);

    default public List<E> getChildren(E entity) {
        return entity.getChildren();
    }

    default public int getBufferSize() {
        return 200;
    }

    default public Predicate<E> createRootNodePredicate(TreeSupportEntity.TreeHelper<E, K> helper) {
        return node -> {
            if (this.isRootNode(node)) {
                return true;
            }
            if (!ObjectUtils.isEmpty((Object)node.getParentId())) {
                return helper.getNode(node.getParentId()) == null;
            }
            return false;
        };
    }

    default public boolean isRootNode(E entity) {
        return ObjectUtils.isEmpty((Object)entity.getParentId()) || "-1".equals(String.valueOf(entity.getParentId()));
    }
}

