/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.sql;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import lombok.Generated;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.jdbc.JdbcSyncSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.hswebframework.web.datasource.DataSourceHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DefaultJdbcExecutor
extends JdbcSyncSqlExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultJdbcExecutor.class);
    @Autowired
    private DataSource dataSource;

    public DefaultJdbcExecutor() {
    }

    public DefaultJdbcExecutor(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected String getDatasourceId() {
        return DataSourceHolder.switcher().datasource().current().orElse("default");
    }

    public Connection getConnection(SqlRequest sqlRequest) {
        DataSource dataSource = DataSourceHolder.isDynamicDataSourceReady() ? DataSourceHolder.currentDataSource().getNative() : this.dataSource;
        Connection connection = DataSourceUtils.getConnection((DataSource)dataSource);
        boolean isConnectionTransactional = DataSourceUtils.isConnectionTransactional((Connection)connection, (DataSource)dataSource);
        if (log.isDebugEnabled()) {
            log.debug("DataSource ({}) JDBC Connection [{}] will {}be managed by Spring", new Object[]{this.getDatasourceId(), connection, isConnectionTransactional ? "" : "not "});
        }
        return connection;
    }

    public void releaseConnection(Connection connection, SqlRequest sqlRequest) {
        if (log.isDebugEnabled()) {
            log.debug("Releasing DataSource ({}) JDBC Connection [{}]", (Object)this.getDatasourceId(), (Object)connection);
        }
        try {
            DataSource dataSource = DataSourceHolder.isDynamicDataSourceReady() ? DataSourceHolder.currentDataSource().getNative() : this.dataSource;
            DataSourceUtils.doReleaseConnection((Connection)connection, (DataSource)dataSource);
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
            try {
                connection.close();
            }
            catch (Exception e2) {
                log.error(e2.getMessage(), (Throwable)e2);
            }
        }
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED, transactionManager="transactionManager")
    public void execute(SqlRequest request) {
        super.execute(request);
    }

    @Transactional(rollbackFor={Throwable.class}, transactionManager="transactionManager")
    public int update(SqlRequest request) {
        return super.update(request);
    }

    @Transactional(readOnly=true, transactionManager="transactionManager")
    public <T, R> R select(SqlRequest request, ResultWrapper<T, R> wrapper) {
        return (R)super.select(request, wrapper);
    }
}

