/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.sql;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.Statement;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import lombok.Generated;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.reactive.r2dbc.R2dbcReactiveSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.hswebframework.web.exception.I18nSupportException;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.r2dbc.connection.ConnectionFactoryUtils;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

public class DefaultR2dbcExecutor
extends R2dbcReactiveSqlExecutor {
    @Autowired
    private ConnectionFactory defaultFactory;
    private boolean bindCustomSymbol = false;
    private String bindSymbol = "$";

    public String getBindSymbol() {
        return this.bindSymbol;
    }

    protected SqlRequest convertRequest(SqlRequest sqlRequest) {
        if (this.bindCustomSymbol) {
            return super.convertRequest(sqlRequest);
        }
        return sqlRequest;
    }

    protected Statement prepareStatement(Statement statement, SqlRequest request) {
        try {
            return super.prepareStatement(statement, request);
        }
        catch (Throwable e) {
            throw new I18nSupportException.NoStackTrace("error.sql.prepare", e, new Object[0]).withSource("sql.prepare", (Object)request);
        }
    }

    protected void bindNull(Statement statement, int index, Class type) {
        if (type == Date.class) {
            type = LocalDateTime.class;
        }
        if (this.bindCustomSymbol) {
            statement.bindNull(this.getBindSymbol() + (index + this.getBindFirstIndex()), type);
            return;
        }
        statement.bindNull(index, type);
    }

    protected void bind(Statement statement, int index, Object value) {
        if (value instanceof Date) {
            value = ((Date)value).toInstant().atZone(ZoneOffset.systemDefault()).toLocalDateTime();
        }
        if (this.bindCustomSymbol) {
            statement.bind(this.getBindSymbol() + (index + this.getBindFirstIndex()), value);
            return;
        }
        statement.bind(index, value);
    }

    protected Mono<Connection> getConnection() {
        return ConnectionFactoryUtils.getConnection((ConnectionFactory)this.defaultFactory);
    }

    protected <T> Flux<T> doInConnection(Function<Connection, Publisher<T>> handler) {
        Mono connectionMono = this.getConnection().map(connection -> new ConnectionCloseHolder((Connection)connection, this::closeConnection));
        return Flux.usingWhen((Publisher)connectionMono, holder -> (Publisher)handler.apply(holder.connection), ConnectionCloseHolder::close, (it, err) -> it.close(), ConnectionCloseHolder::close);
    }

    private Publisher<Void> closeConnection(Connection connection) {
        return ConnectionFactoryUtils.currentConnectionFactory((ConnectionFactory)this.defaultFactory).then().onErrorResume(Exception.class, ex -> Mono.from((Publisher)connection.close()));
    }

    protected void releaseConnection(SignalType type, Connection connection) {
    }

    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRES_NEW, transactionManager="connectionFactoryTransactionManager")
    public Mono<Void> execute(SqlRequest request) {
        return super.execute(request);
    }

    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRES_NEW, transactionManager="connectionFactoryTransactionManager")
    public Mono<Void> execute(Publisher<SqlRequest> request) {
        return super.execute(request);
    }

    @Transactional(rollbackFor={Throwable.class}, transactionManager="connectionFactoryTransactionManager")
    public Mono<Integer> update(Publisher<SqlRequest> request) {
        return super.update(request);
    }

    @Transactional(rollbackFor={Throwable.class}, transactionManager="connectionFactoryTransactionManager")
    public Mono<Integer> update(SqlRequest request) {
        return super.update(request);
    }

    @Transactional(rollbackFor={Throwable.class}, transactionManager="connectionFactoryTransactionManager")
    public Mono<Integer> update(String sql, Object ... args) {
        return super.update(sql, args);
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    public <E> Flux<E> select(Publisher<SqlRequest> request, ResultWrapper<E, ?> wrapper) {
        return super.select(request, wrapper);
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    public Flux<Map<String, Object>> select(String sql, Object ... args) {
        return super.select(sql, args);
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    public <E> Flux<E> select(String sql, ResultWrapper<E, ?> wrapper) {
        return super.select(sql, wrapper);
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    public <E> Flux<E> select(SqlRequest sqlRequest, ResultWrapper<E, ?> wrapper) {
        return super.select(sqlRequest, wrapper);
    }

    @Generated
    public void setDefaultFactory(ConnectionFactory defaultFactory) {
        this.defaultFactory = defaultFactory;
    }

    @Generated
    public void setBindCustomSymbol(boolean bindCustomSymbol) {
        this.bindCustomSymbol = bindCustomSymbol;
    }

    @Generated
    public void setBindSymbol(String bindSymbol) {
        this.bindSymbol = bindSymbol;
    }

    static class ConnectionCloseHolder
    extends AtomicBoolean {
        private static final long serialVersionUID = -8994138383301201380L;
        final transient Connection connection;
        final transient Function<Connection, Publisher<Void>> closeFunction;

        ConnectionCloseHolder(Connection connection, Function<Connection, Publisher<Void>> closeFunction) {
            this.connection = connection;
            this.closeFunction = closeFunction;
        }

        Mono<Void> close() {
            return Mono.defer(() -> {
                if (this.compareAndSet(false, true)) {
                    return Mono.from(this.closeFunction.apply(this.connection));
                }
                return Mono.empty();
            });
        }
    }
}

