/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.web;

import jakarta.validation.ConstraintViolationException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hswebframework.web.authorization.exception.AccessDenyException;
import org.hswebframework.web.authorization.exception.AuthenticationException;
import org.hswebframework.web.authorization.exception.UnAuthorizedException;
import org.hswebframework.web.authorization.token.TokenState;
import org.hswebframework.web.crud.web.ResponseMessage;
import org.hswebframework.web.exception.BusinessException;
import org.hswebframework.web.exception.I18nSupportException;
import org.hswebframework.web.exception.NotFoundException;
import org.hswebframework.web.exception.ValidationException;
import org.hswebframework.web.i18n.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.TransactionException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.reactive.resource.NoResourceFoundException;
import org.springframework.web.server.MethodNotAllowedException;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebInputException;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;
import reactor.core.publisher.Mono;

@RestControllerAdvice
@Order
public class CommonErrorControllerAdvice {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonErrorControllerAdvice.class);

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public Mono<ResponseMessage<Object>> handleException(NoResourceFoundException e) {
        return LocaleUtils.resolveMessageReactive((String)"error.resource_not_found", (Object[])new Object[0]).map(msg -> ResponseMessage.error(404, "error.resource_not_found", msg));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Mono<ResponseMessage<Object>> handleException(TransactionException e) {
        log.warn(e.getLocalizedMessage(), (Throwable)e);
        return LocaleUtils.resolveMessageReactive((String)"error.internal_server_error", (Object[])new Object[0]).map(msg -> ResponseMessage.error(500, "error." + e.getClass().getSimpleName(), msg));
    }

    @ExceptionHandler
    public Mono<ResponseEntity<ResponseMessage<Object>>> handleException(BusinessException e) {
        return LocaleUtils.resolveThrowable((I18nSupportException)e, (err, msg) -> ResponseMessage.error(err.getStatus(), err.getCode(), msg)).map(msg -> {
            HttpStatus status = HttpStatus.resolve((int)msg.getStatus());
            return ResponseEntity.status((HttpStatusCode)(status == null ? HttpStatus.BAD_REQUEST : status)).body(msg);
        });
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<Object>> handleException(UnsupportedOperationException e) {
        log.warn(e.getLocalizedMessage(), (Throwable)e);
        return LocaleUtils.resolveThrowable((Throwable)e, (err, msg) -> ResponseMessage.error(400, "unsupported", msg), (Object[])new Object[0]);
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public Mono<ResponseMessage<TokenState>> handleException(UnAuthorizedException e) {
        return LocaleUtils.resolveThrowable((I18nSupportException)e, (err, msg) -> ResponseMessage.error(401, "unauthorized", msg).result(e.getState()));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    public Mono<ResponseMessage<Object>> handleException(AccessDenyException e) {
        return LocaleUtils.resolveThrowable((I18nSupportException)e, (err, msg) -> ResponseMessage.error(403, e.getCode(), msg));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public Mono<ResponseMessage<Object>> handleException(NotFoundException e) {
        return LocaleUtils.resolveThrowable((I18nSupportException)e, (err, msg) -> ResponseMessage.error(404, "not_found", msg));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<List<ValidationException.Detail>>> handleException(ValidationException e) {
        return LocaleUtils.currentReactive().map(locale -> ResponseMessage.error(400, "illegal_argument", e.getLocalizedMessage(locale)).result(e.getDetails(locale)));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<List<ValidationException.Detail>>> handleException(ConstraintViolationException e) {
        return this.handleException(new ValidationException(e.getConstraintViolations()));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<List<ValidationException.Detail>>> handleException(BindException e) {
        return this.handleBindingResult(e.getBindingResult());
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<List<ValidationException.Detail>>> handleException(WebExchangeBindException e) {
        return this.handleBindingResult(e.getBindingResult());
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<List<ValidationException.Detail>>> handleException(MethodArgumentNotValidException e) {
        return this.handleBindingResult(e.getBindingResult());
    }

    private Mono<ResponseMessage<List<ValidationException.Detail>>> handleBindingResult(BindingResult result) {
        FieldError fieldError = result.getFieldError();
        ObjectError globalError = result.getGlobalError();
        String message = null != fieldError ? fieldError.getDefaultMessage() : (null != globalError ? globalError.getDefaultMessage() : "illegal_argument");
        List details = result.getFieldErrors().stream().map(err -> new ValidationException.Detail(err.getField(), err.getDefaultMessage(), null)).collect(Collectors.toList());
        return this.handleException(new ValidationException(message, details, new Object[0]));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<?>> handleException(jakarta.validation.ValidationException e) {
        return Mono.just(ResponseMessage.error(400, "illegal_argument", e.getLocalizedMessage()));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.GATEWAY_TIMEOUT)
    public Mono<ResponseMessage<Object>> handleException(TimeoutException e) {
        return LocaleUtils.resolveThrowable((Throwable)e, (err, msg) -> {
            log.warn(msg, (Throwable)err);
            return ResponseMessage.error(504, "timeout", msg);
        }, (Object[])new Object[0]);
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @Order
    public Mono<ResponseMessage<Object>> handleException(RuntimeException e) {
        log.warn(e.getLocalizedMessage(), (Throwable)e);
        return LocaleUtils.resolveMessageReactive((String)"error.internal_server_error", (Object[])new Object[0]).map(msg -> ResponseMessage.error(500, "internal_server_error", msg));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Mono<ResponseMessage<Object>> handleException(NullPointerException e) {
        log.warn(e.getLocalizedMessage(), (Throwable)e);
        return LocaleUtils.resolveMessageReactive((String)"error.internal_server_error", (Object[])new Object[0]).map(msg -> ResponseMessage.error(500, "internal_server_error", msg));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<Object>> handleException(IllegalArgumentException e) {
        return LocaleUtils.resolveThrowable((Throwable)e, (err, msg) -> {
            log.warn(msg, (Throwable)e);
            return ResponseMessage.error(400, "illegal_argument", msg);
        }, (Object[])new Object[0]);
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<Object>> handleException(AuthenticationException e) {
        return LocaleUtils.resolveThrowable((I18nSupportException)e, (err, msg) -> ResponseMessage.error(400, err.getCode(), msg));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.UNSUPPORTED_MEDIA_TYPE)
    public Mono<ResponseMessage<Object>> handleException(UnsupportedMediaTypeStatusException e) {
        log.warn(e.getLocalizedMessage(), (Throwable)e);
        return LocaleUtils.resolveMessageReactive((String)"error.unsupported_media_type", (Object[])new Object[0]).map(msg -> ResponseMessage.error(415, "unsupported_media_type", msg).result(e.getSupportedMediaTypes()));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    public Mono<ResponseMessage<Object>> handleException(NotAcceptableStatusException e) {
        log.warn(e.getLocalizedMessage(), (Throwable)e);
        return LocaleUtils.resolveMessageReactive((String)"error.not_acceptable_media_type", (Object[])new Object[0]).map(msg -> ResponseMessage.error(406, "not_acceptable_media_type", msg).result(e.getSupportedMediaTypes()));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    public Mono<ResponseMessage<Object>> handleException(MethodNotAllowedException e) {
        log.warn(e.getLocalizedMessage(), (Throwable)e);
        return LocaleUtils.resolveMessageReactive((String)"error.method_not_allowed", (Object[])new Object[0]).map(msg -> ResponseMessage.error(406, "method_not_allowed", msg).result(e.getSupportedMethods()));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<List<ValidationException.Detail>>> handleException(ServerWebInputException e) {
        Object exception = e;
        do {
            if (!((exception = exception.getCause()) instanceof ValidationException)) continue;
            return this.handleException((ValidationException)exception);
        } while (exception != null && exception != e);
        if (exception == null) {
            return Mono.just(ResponseMessage.error(400, "illegal_argument", e.getMessage()));
        }
        return LocaleUtils.resolveThrowable((Throwable)exception, (err, msg) -> ResponseMessage.error(400, "illegal_argument", msg), (Object[])new Object[0]);
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<Object>> handleException(I18nSupportException e) {
        return e.getLocalizedMessageReactive().map(msg -> ResponseMessage.error(400, e.getI18nCode(), msg));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<Object>> handleException(DataAccessException e) {
        return LocaleUtils.resolveMessageReactive((String)"error.data_access_failed", (Object[])new Object[0]).map(msg -> ResponseMessage.error(400, "data_access_failed", msg));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<Object>> handleException(DuplicateKeyException e) {
        return LocaleUtils.resolveMessageReactive((String)"error.duplicate_key", (Object[])new Object[0]).map(msg -> ResponseMessage.error(400, "duplicate_key", msg));
    }
}

