/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.web;

import io.r2dbc.spi.R2dbcException;
import lombok.Generated;
import org.hswebframework.web.crud.web.ResponseMessage;
import org.hswebframework.web.i18n.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import reactor.core.publisher.Mono;

@RestControllerAdvice
@Order
public class R2dbcErrorControllerAdvice {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(R2dbcErrorControllerAdvice.class);

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Mono<ResponseMessage<Object>> handleException(R2dbcException e) {
        log.error(e.getLocalizedMessage(), (Throwable)e);
        return LocaleUtils.resolveMessageReactive((String)"error.internal_server_error", (Object[])new Object[0]).map(msg -> ResponseMessage.error(500, "error." + e.getClass().getSimpleName(), msg));
    }
}

