/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.web;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import lombok.Generated;
import org.hswebframework.web.api.crud.entity.EntityFactoryHolder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ResponseMessage<T>
implements Serializable {
    private static final long serialVersionUID = 8992436576262574064L;
    @Schema(description="\u6d88\u606f\u63d0\u793a")
    private String message;
    @Schema(description="\u6570\u636e\u5185\u5bb9")
    private T result;
    @Schema(description="\u72b6\u6001\u7801")
    private int status;
    @Schema(description="\u4e1a\u52a1\u7801")
    private String code;
    @Schema(description="\u65f6\u95f4\u6233(\u6beb\u79d2)")
    private Long timestamp = System.currentTimeMillis();

    public static <T> ResponseMessage<T> ok() {
        return ResponseMessage.ok(null);
    }

    public static <T> ResponseMessage<T> ok(T result) {
        return ResponseMessage.of("success", result, 200, null, System.currentTimeMillis());
    }

    public static <T> ResponseMessage<T> error(String message) {
        return ResponseMessage.error("error", message);
    }

    public static <T> ResponseMessage<T> error(String code, String message) {
        return ResponseMessage.error(500, code, message);
    }

    public static <T> ResponseMessage<T> error(int status, String code, String message) {
        return ResponseMessage.of(message, null, status, code, System.currentTimeMillis());
    }

    public static <T> ResponseMessage<T> of(String message, T result, int status, String code, Long timestamp) {
        ResponseMessage msg = (ResponseMessage)EntityFactoryHolder.newInstance(ResponseMessage.class, ResponseMessage::new);
        msg.setMessage(message);
        msg.setResult(result);
        msg.setStatus(status);
        msg.setCode(code);
        msg.setTimestamp(timestamp);
        return msg;
    }

    public ResponseMessage<T> result(T result) {
        this.result = result;
        return this;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public T getResult() {
        return this.result;
    }

    @Generated
    public int getStatus() {
        return this.status;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setResult(T result) {
        this.result = result;
    }

    @Generated
    public void setStatus(int status) {
        this.status = status;
    }

    @Generated
    public void setCode(String code) {
        this.code = code;
    }

    @Generated
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }
}

