/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.web;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.hswebframework.web.crud.web.ResponseMessage;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.lang.NonNull;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.result.method.annotation.ResponseBodyResultHandler;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ResponseMessageWrapper
extends ResponseBodyResultHandler {
    private static MethodParameter param;
    private Set<String> excludes = new HashSet<String>();

    public ResponseMessageWrapper(List<HttpMessageWriter<?>> writers, RequestedContentTypeResolver resolver, ReactiveAdapterRegistry registry) {
        super(writers, resolver, registry);
        this.setOrder(90);
    }

    private static Mono<ResponseMessage<?>> methodForParams() {
        return Mono.empty();
    }

    public boolean supports(@NonNull HandlerResult result) {
        Class gen;
        if (!CollectionUtils.isEmpty(this.excludes) && result.getHandler() instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod)result.getHandler();
            String typeName = method.getMethod().getDeclaringClass().getName() + "." + method.getMethod().getName();
            for (String exclude : this.excludes) {
                if (!typeName.startsWith(exclude)) continue;
                return false;
            }
        }
        boolean isAlreadyResponse = (gen = result.getReturnType().resolveGeneric(new int[]{0})) == ResponseMessage.class || gen == ResponseEntity.class;
        boolean isStream = result.getReturnType().resolve() == Mono.class || result.getReturnType().resolve() == Flux.class;
        RequestMapping mapping = (RequestMapping)result.getReturnTypeSource().getMethodAnnotation(RequestMapping.class);
        if (mapping == null) {
            return false;
        }
        for (String produce : mapping.produces()) {
            MimeType mimeType = MimeType.valueOf((String)produce);
            if (!MediaType.TEXT_EVENT_STREAM.includes(mimeType) && !MediaType.APPLICATION_NDJSON.includes(mimeType)) continue;
            return false;
        }
        return isStream && super.supports(result) && !isAlreadyResponse;
    }

    public Mono<Void> handleResult(ServerWebExchange exchange, HandlerResult result) {
        Object body = result.getReturnValue();
        List accept = exchange.getRequest().getHeaders().getAccept();
        if (accept.contains(MediaType.TEXT_EVENT_STREAM) || accept.contains(MediaType.APPLICATION_NDJSON)) {
            return this.writeBody(body, result.getReturnTypeSource(), exchange);
        }
        String ignoreWrapper = exchange.getRequest().getHeaders().getFirst("X-Response-Wrapper");
        if ("Ignore".equals(ignoreWrapper)) {
            return this.writeBody(body, result.getReturnTypeSource(), exchange);
        }
        if (body instanceof Mono) {
            body = ((Mono)body).map(ResponseMessage::ok).switchIfEmpty(Mono.just(ResponseMessage.ok()));
        }
        if (body instanceof Flux) {
            body = ((Flux)body).collectList().map(ResponseMessage::ok).switchIfEmpty(Mono.just(ResponseMessage.ok()));
        }
        if (body == null) {
            body = Mono.just(ResponseMessage.ok());
        }
        return this.writeBody(body, param, exchange);
    }

    @Generated
    public void setExcludes(Set<String> excludes) {
        this.excludes = excludes;
    }

    @Generated
    public Set<String> getExcludes() {
        return this.excludes;
    }

    static {
        try {
            param = new MethodParameter(ResponseMessageWrapper.class.getDeclaredMethod("methodForParams", new Class[0]), -1);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }
}

