/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.web;

import io.swagger.v3.oas.annotations.Operation;
import java.util.Collection;
import java.util.List;
import org.hswebframework.ezorm.rdb.mapping.SyncRepository;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.web.api.crud.entity.RecordCreationEntity;
import org.hswebframework.web.api.crud.entity.RecordModifierEntity;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.SaveAction;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

public interface SaveController<E, K> {
    @Authorize(ignore=true)
    public SyncRepository<E, K> getRepository();

    @Authorize(ignore=true)
    default public E applyCreationEntity(Authentication authentication, E entity) {
        RecordCreationEntity creationEntity = (RecordCreationEntity)entity;
        creationEntity.setCreateTimeNow();
        creationEntity.setCreatorId(authentication.getUser().getId());
        creationEntity.setCreatorName(authentication.getUser().getName());
        return entity;
    }

    @Authorize(ignore=true)
    default public E applyModifierEntity(Authentication authentication, E entity) {
        RecordModifierEntity modifierEntity = (RecordModifierEntity)entity;
        modifierEntity.setModifyTimeNow();
        modifierEntity.setModifierId(authentication.getUser().getId());
        modifierEntity.setModifierName(authentication.getUser().getName());
        return entity;
    }

    @Authorize(ignore=true)
    default public E applyAuthentication(E entity, Authentication authentication) {
        if (entity instanceof RecordCreationEntity) {
            entity = this.applyCreationEntity(authentication, entity);
        }
        if (entity instanceof RecordModifierEntity) {
            entity = this.applyModifierEntity(authentication, entity);
        }
        return entity;
    }

    @PatchMapping
    @SaveAction
    @Operation(summary="\u4fdd\u5b58\u6570\u636e", description="\u5982\u679c\u4f20\u5165\u4e86id,\u5e76\u4e14\u5bf9\u5e94\u6570\u636e\u5b58\u5728,\u5219\u5c1d\u8bd5\u8986\u76d6,\u4e0d\u5b58\u5728\u5219\u65b0\u589e.")
    default public SaveResult save(@RequestBody List<E> payload) {
        return this.getRepository().save((Collection)Authentication.current().map(auth -> {
            for (Object e : payload) {
                this.applyAuthentication(e, (Authentication)auth);
            }
            return payload;
        }).orElse(payload));
    }

    @PostMapping(value={"/_batch"})
    @SaveAction
    @Operation(summary="\u6279\u91cf\u65b0\u589e\u6570\u636e")
    default public int add(@RequestBody List<E> payload) {
        return this.getRepository().insertBatch((Collection)Authentication.current().map(auth -> {
            for (Object e : payload) {
                this.applyAuthentication(e, (Authentication)auth);
            }
            return payload;
        }).orElse(payload));
    }

    @PostMapping
    @SaveAction
    @Operation(summary="\u65b0\u589e\u5355\u4e2a\u6570\u636e,\u5e76\u8fd4\u56de\u65b0\u589e\u540e\u7684\u6570\u636e.")
    default public E add(@RequestBody E payload) {
        this.getRepository().insert(Authentication.current().map(auth -> this.applyAuthentication(payload, (Authentication)auth)).orElse(payload));
        return payload;
    }

    @PutMapping(value={"/{id}"})
    @SaveAction
    @Operation(summary="\u6839\u636eID\u4fee\u6539\u6570\u636e")
    default public boolean update(@PathVariable K id, @RequestBody E payload) {
        return this.getRepository().updateById(id, Authentication.current().map(auth -> this.applyAuthentication(payload, (Authentication)auth)).orElse(payload)) > 0;
    }
}

