/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.Collections;
import java.util.List;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.rdb.mapping.SyncQuery;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryNoPagingOperation;
import org.hswebframework.web.api.crud.entity.QueryOperation;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.crud.service.CrudService;
import org.hswebframework.web.exception.NotFoundException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

public interface ServiceQueryController<E, K> {
    @Authorize(ignore=true)
    public CrudService<E, K> getService();

    @GetMapping(value={"/_query/no-paging"})
    @QueryAction
    @QueryOperation(summary="\u4f7f\u7528GET\u65b9\u5f0f\u5206\u9875\u52a8\u6001\u67e5\u8be2(\u4e0d\u8fd4\u56de\u603b\u6570)", description="\u6b64\u64cd\u4f5c\u4e0d\u8fd4\u56de\u5206\u9875\u603b\u6570,\u5982\u679c\u9700\u8981\u83b7\u53d6\u5168\u90e8\u6570\u636e,\u8bf7\u8bbe\u7f6e\u53c2\u6570paging=false")
    default public List<E> query(@Parameter(hidden=true) QueryParamEntity query) {
        return ((SyncQuery)this.getService().createQuery().setParam((QueryParam)query)).fetch();
    }

    @PostMapping(value={"/_query/no-paging"})
    @QueryAction
    @Operation(summary="\u4f7f\u7528POST\u65b9\u5f0f\u5206\u9875\u52a8\u6001\u67e5\u8be2(\u4e0d\u8fd4\u56de\u603b\u6570)", description="\u6b64\u64cd\u4f5c\u4e0d\u8fd4\u56de\u5206\u9875\u603b\u6570,\u5982\u679c\u9700\u8981\u83b7\u53d6\u5168\u90e8\u6570\u636e,\u8bf7\u8bbe\u7f6e\u53c2\u6570paging=false")
    default public List<E> postQuery(@RequestBody QueryParamEntity query) {
        return this.query(query);
    }

    @GetMapping(value={"/_query"})
    @QueryAction
    @QueryOperation(summary="\u4f7f\u7528GET\u65b9\u5f0f\u5206\u9875\u52a8\u6001\u67e5\u8be2")
    default public PagerResult<E> queryPager(@Parameter(hidden=true) QueryParamEntity query) {
        if (query.getTotal() != null) {
            return PagerResult.of((int)query.getTotal(), (List)((SyncQuery)this.getService().createQuery().setParam(query.rePaging(query.getTotal().intValue()))).fetch(), (QueryParam)query);
        }
        int total = ((SyncQuery)this.getService().createQuery().setParam((QueryParam)query.clone())).count();
        if (total == 0) {
            return PagerResult.of((int)0, Collections.emptyList(), (QueryParam)query);
        }
        return PagerResult.of((int)total, (List)((SyncQuery)this.getService().createQuery().setParam(query.rePaging(total))).fetch(), (QueryParam)query);
    }

    @PostMapping(value={"/_query"})
    @QueryAction
    @Operation(summary="\u4f7f\u7528POST\u65b9\u5f0f\u5206\u9875\u52a8\u6001\u67e5\u8be2")
    default public PagerResult<E> postQueryPager(@RequestBody QueryParamEntity query) {
        return this.queryPager(query);
    }

    @PostMapping(value={"/_count"})
    @QueryAction
    @Operation(summary="\u4f7f\u7528POST\u65b9\u5f0f\u67e5\u8be2\u603b\u6570")
    default public int postCount(@RequestBody QueryParamEntity query) {
        return this.count(query);
    }

    @GetMapping(value={"/_count"})
    @QueryAction
    @QueryNoPagingOperation(summary="\u4f7f\u7528GET\u65b9\u5f0f\u67e5\u8be2\u603b\u6570")
    default public int count(@Parameter(hidden=true) QueryParamEntity query) {
        return ((SyncQuery)this.getService().createQuery().setParam((QueryParam)query)).count();
    }

    @GetMapping(value={"/{id:.+}"})
    @QueryAction
    @Operation(summary="\u6839\u636eID\u67e5\u8be2")
    default public E getById(@PathVariable K id) {
        return this.getService().findById(id).orElseThrow(NotFoundException.NoStackTrace::new);
    }
}

