/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.List;
import org.hswebframework.web.api.crud.entity.QueryOperation;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.api.crud.entity.TreeSortSupportEntity;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.crud.service.TreeSortEntityService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

public interface TreeServiceQueryController<E extends TreeSortSupportEntity<K>, K> {
    @Authorize(ignore=true)
    public TreeSortEntityService<E, K> getService();

    @GetMapping(value={"/_query/tree"})
    @QueryAction
    @QueryOperation(summary="\u4f7f\u7528GET\u52a8\u6001\u67e5\u8be2\u5e76\u8fd4\u56de\u6811\u5f62\u7ed3\u6784")
    default public List<E> findAllTree(@Parameter(hidden=true) QueryParamEntity param) {
        return this.getService().queryResultToTree(param);
    }

    @GetMapping(value={"/_query/_children"})
    @QueryAction
    @QueryOperation(summary="\u4f7f\u7528GET\u52a8\u6001\u67e5\u8be2\u5e76\u8fd4\u56de\u5b50\u8282\u70b9\u6570\u636e")
    default public List<E> findAllChildren(@Parameter(hidden=true) QueryParamEntity param) {
        return this.getService().queryIncludeChildren(param);
    }

    @GetMapping(value={"/_query/_children/tree"})
    @QueryAction
    @QueryOperation(summary="\u4f7f\u7528GET\u52a8\u6001\u67e5\u8be2\u5e76\u8fd4\u56de\u5b50\u8282\u70b9\u6811\u5f62\u7ed3\u6784\u6570\u636e")
    default public List<E> findAllChildrenTree(@Parameter(hidden=true) QueryParamEntity param) {
        return this.getService().queryIncludeChildrenTree(param);
    }

    @PostMapping(value={"/_query/tree"})
    @QueryAction
    @Operation(summary="\u4f7f\u7528POST\u52a8\u6001\u67e5\u8be2\u5e76\u8fd4\u56de\u6811\u5f62\u7ed3\u6784")
    default public List<E> findAllTreePost(@RequestBody QueryParamEntity param) {
        return this.getService().queryResultToTree(param);
    }

    @PostMapping(value={"/_query/_children"})
    @QueryAction
    @Operation(summary="\u4f7f\u7528POST\u52a8\u6001\u67e5\u8be2\u5e76\u8fd4\u56de\u5b50\u8282\u70b9\u6570\u636e")
    default public List<E> findAllChildrenPost(@RequestBody QueryParamEntity param) {
        return this.getService().queryIncludeChildren(param);
    }

    @PostMapping(value={"/_query/_children/tree"})
    @QueryAction
    @Operation(summary="\u4f7f\u7528POST\u52a8\u6001\u67e5\u8be2\u5e76\u8fd4\u56de\u5b50\u8282\u70b9\u6811\u5f62\u7ed3\u6784\u6570\u636e")
    default public List<E> findAllChildrenTreePost(@RequestBody QueryParamEntity param) {
        return this.getService().queryIncludeChildrenTree(param);
    }
}

