/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.cache.supports;

import com.github.benmanes.caffeine.cache.Cache;
import java.util.Arrays;
import org.hswebframework.web.cache.supports.AbstractReactiveCache;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CaffeineReactiveCache<E>
extends AbstractReactiveCache<E> {
    private Cache<Object, Object> cache;

    @Override
    public Mono<Void> evictAll(Iterable<?> key) {
        return Mono.fromRunnable(() -> this.cache.invalidateAll(key));
    }

    @Override
    public Flux<E> getAll(Object ... keys) {
        return Flux.defer(() -> Flux.fromIterable(this.cache.getAllPresent(Arrays.asList(keys)).values()).map(e -> e));
    }

    @Override
    protected Mono<Object> getNow(Object key) {
        return Mono.justOrEmpty((Object)this.cache.getIfPresent(key));
    }

    @Override
    public Mono<Void> putNow(Object key, Object value) {
        this.cache.put(key, value);
        return Mono.empty();
    }

    @Override
    public Mono<Void> evict(Object key) {
        return Mono.fromRunnable(() -> this.cache.invalidate(key));
    }

    @Override
    public Mono<Void> clear() {
        return Mono.fromRunnable(() -> this.cache.invalidateAll());
    }

    public CaffeineReactiveCache(Cache<Object, Object> cache) {
        this.cache = cache;
    }
}

