/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.cache.supports;

import lombok.Generated;
import org.hswebframework.web.cache.ReactiveCache;
import org.hswebframework.web.cache.ReactiveCacheManager;
import org.hswebframework.web.cache.supports.AbstractReactiveCacheManager;
import org.hswebframework.web.cache.supports.RedisReactiveCache;
import org.springframework.data.redis.core.ReactiveRedisOperations;

public class RedisLocalReactiveCacheManager
extends AbstractReactiveCacheManager {
    private ReactiveRedisOperations<Object, Object> operations;
    private ReactiveCacheManager localCacheManager;
    private String redisCachePrefix = "spring-cache:";

    public RedisLocalReactiveCacheManager(ReactiveRedisOperations<Object, Object> operations, ReactiveCacheManager localCacheManager) {
        this.operations = operations;
        this.localCacheManager = localCacheManager;
    }

    @Override
    protected <E> ReactiveCache<E> createCache(String name) {
        return new RedisReactiveCache(this.redisCachePrefix.concat(name), this.operations, this.localCacheManager.getCache(name));
    }

    @Generated
    public void setRedisCachePrefix(String redisCachePrefix) {
        this.redisCachePrefix = redisCachePrefix;
    }

    @Generated
    public String getRedisCachePrefix() {
        return this.redisCachePrefix;
    }
}

