/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.datasource;

import org.hswebframework.web.datasource.DatabaseType;
import org.hswebframework.web.datasource.DynamicDataSourceService;
import org.hswebframework.web.datasource.JdbcDataSource;
import org.hswebframework.web.datasource.R2dbcDataSource;
import org.hswebframework.web.datasource.exception.DataSourceNotFoundException;
import org.hswebframework.web.datasource.switcher.DefaultJdbcSwitcher;
import org.hswebframework.web.datasource.switcher.DefaultR2dbcSwicher;
import org.hswebframework.web.datasource.switcher.JdbcSwitcher;
import org.hswebframework.web.datasource.switcher.R2dbcSwitcher;
import reactor.core.publisher.Mono;

public final class DataSourceHolder {
    static volatile DynamicDataSourceService dynamicDataSourceService;
    static volatile JdbcSwitcher jdbcSwitcher;
    static volatile R2dbcSwitcher r2dbcSwitcher;

    public static boolean isDynamicDataSourceReady() {
        return dynamicDataSourceService != null;
    }

    public static void checkDynamicDataSourceReady() {
        if (dynamicDataSourceService == null) {
            throw new UnsupportedOperationException("dataSourceService not ready");
        }
    }

    public static JdbcSwitcher switcher() {
        return jdbcSwitcher;
    }

    public static R2dbcSwitcher r2dbcSwitcher() {
        return r2dbcSwitcher;
    }

    public static JdbcDataSource defaultDataSource() {
        DataSourceHolder.checkDynamicDataSourceReady();
        return (JdbcDataSource)dynamicDataSourceService.getDefaultDataSource();
    }

    public static JdbcDataSource dataSource(String dataSourceId) {
        DataSourceHolder.checkDynamicDataSourceReady();
        return dynamicDataSourceService.getDataSource(dataSourceId);
    }

    public static JdbcDataSource currentDataSource() {
        return jdbcSwitcher.datasource().current().map(dynamicDataSourceService::getDataSource).orElseGet(DataSourceHolder::defaultDataSource);
    }

    public static Mono<R2dbcDataSource> currentR2dbc() {
        return r2dbcSwitcher.datasource().current().flatMap(dynamicDataSourceService::getR2dbcDataSource).switchIfEmpty(Mono.defer(() -> Mono.just((Object)dynamicDataSourceService.getDefaultDataSource()).map(R2dbcDataSource.class::cast)));
    }

    public static boolean currentIsDefault() {
        return !jdbcSwitcher.datasource().current().isPresent();
    }

    public static boolean existing(String id) {
        try {
            DataSourceHolder.checkDynamicDataSourceReady();
            return dynamicDataSourceService.getDataSource(id) != null;
        }
        catch (DataSourceNotFoundException e) {
            return false;
        }
    }

    public static boolean currentExisting() {
        if (DataSourceHolder.currentIsDefault()) {
            return true;
        }
        try {
            return DataSourceHolder.currentDataSource() != null;
        }
        catch (DataSourceNotFoundException e) {
            return false;
        }
    }

    public static DatabaseType currentDatabaseType() {
        return DataSourceHolder.currentDataSource().getType();
    }

    public static DatabaseType defaultDatabaseType() {
        return DataSourceHolder.defaultDataSource().getType();
    }

    static {
        jdbcSwitcher = new DefaultJdbcSwitcher();
        r2dbcSwitcher = new DefaultR2dbcSwicher();
    }
}

