/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.file.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterStyle;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.ResourceAction;
import org.hswebframework.web.authorization.exception.AccessDenyException;
import org.hswebframework.web.file.FileUploadProperties;
import org.hswebframework.web.file.service.FileStorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.http.codec.multipart.Part;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@Resource(id="file", name="\u6587\u4ef6\u4e0a\u4f20")
@RequestMapping(value={"/file"})
@Tag(name="\u6587\u4ef6\u4e0a\u4f20")
public class ReactiveFileController {
    private static final Logger log = LoggerFactory.getLogger(ReactiveFileController.class);
    private final FileUploadProperties properties;
    private final FileStorageService fileStorageService;

    public ReactiveFileController(FileUploadProperties properties, FileStorageService fileStorageService) {
        this.properties = properties;
        this.fileStorageService = fileStorageService;
    }

    @PostMapping(value={"/static"})
    @ResourceAction(id="upload-static", name="\u9759\u6001\u6587\u4ef6")
    @Operation(summary="\u4e0a\u4f20\u9759\u6001\u6587\u4ef6")
    public Mono<String> uploadStatic(@RequestPart(value="file") @Parameter(name="file", description="\u6587\u4ef6", style=ParameterStyle.FORM) Part part) {
        if (part instanceof FilePart) {
            FilePart filePart = (FilePart)part;
            if (this.properties.denied(filePart.filename(), filePart.headers().getContentType())) {
                throw new AccessDenyException();
            }
            return this.fileStorageService.saveFile(filePart);
        }
        return Mono.error(() -> new IllegalArgumentException("[file] part is not a file"));
    }
}

