/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.file;

import java.io.File;
import java.util.Date;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.hswebframework.utils.time.DateFormatter;
import org.hswebframework.web.id.IDGenerator;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.http.MediaType;

@ConfigurationProperties(prefix="hsweb.file.upload")
public class FileUploadProperties {
    private String staticFilePath = "./static";
    private String staticLocation = "/static";
    private Set<String> allowFiles;
    private Set<String> denyFiles;
    private Set<String> allowMediaType;
    private Set<String> denyMediaType;

    public boolean denied(String name, MediaType mediaType) {
        String suffix = name.contains(".") ? name.substring(name.lastIndexOf(".") + 1) : "";
        boolean defaultDeny = false;
        if (CollectionUtils.isNotEmpty(this.denyFiles)) {
            if (this.denyFiles.contains(suffix)) {
                return true;
            }
            defaultDeny = false;
        }
        if (CollectionUtils.isNotEmpty(this.allowFiles)) {
            if (this.allowFiles.contains(suffix)) {
                return false;
            }
            defaultDeny = true;
        }
        if (CollectionUtils.isNotEmpty(this.denyMediaType)) {
            if (this.denyMediaType.contains(mediaType.toString())) {
                return true;
            }
            defaultDeny = false;
        }
        if (CollectionUtils.isNotEmpty(this.allowMediaType)) {
            if (this.allowMediaType.contains(mediaType.toString())) {
                return false;
            }
            defaultDeny = true;
        }
        return defaultDeny;
    }

    public StaticFileInfo createStaticSavePath(String name) {
        String fileName = (String)IDGenerator.SNOW_FLAKE_STRING.generate();
        String filePath = DateFormatter.toString((Date)new Date(), (String)"yyyyMMdd");
        String absPath = this.staticFilePath.concat("/").concat(filePath);
        String suffix = name.contains(".") ? name.substring(name.lastIndexOf(".")) : "";
        new File(absPath).mkdirs();
        StaticFileInfo info = new StaticFileInfo();
        info.location = this.staticLocation + "/" + filePath + "/" + fileName + suffix;
        info.savePath = absPath + "/" + fileName + suffix;
        return info;
    }

    public String getStaticFilePath() {
        return this.staticFilePath;
    }

    public String getStaticLocation() {
        return this.staticLocation;
    }

    public Set<String> getAllowFiles() {
        return this.allowFiles;
    }

    public Set<String> getDenyFiles() {
        return this.denyFiles;
    }

    public Set<String> getAllowMediaType() {
        return this.allowMediaType;
    }

    public Set<String> getDenyMediaType() {
        return this.denyMediaType;
    }

    public void setStaticFilePath(String staticFilePath) {
        this.staticFilePath = staticFilePath;
    }

    public void setStaticLocation(String staticLocation) {
        this.staticLocation = staticLocation;
    }

    public void setAllowFiles(Set<String> allowFiles) {
        this.allowFiles = allowFiles;
    }

    public void setDenyFiles(Set<String> denyFiles) {
        this.denyFiles = denyFiles;
    }

    public void setAllowMediaType(Set<String> allowMediaType) {
        this.allowMediaType = allowMediaType;
    }

    public void setDenyMediaType(Set<String> denyMediaType) {
        this.denyMediaType = denyMediaType;
    }

    public static class StaticFileInfo {
        private String savePath;
        private String location;

        public String getSavePath() {
            return this.savePath;
        }

        public String getLocation() {
            return this.location;
        }

        public void setSavePath(String savePath) {
            this.savePath = savePath;
        }

        public void setLocation(String location) {
            this.location = location;
        }
    }
}

