/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.file.web;

import java.io.File;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.ResourceAction;
import org.hswebframework.web.authorization.exception.AccessDenyException;
import org.hswebframework.web.file.FileUploadProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.http.codec.multipart.Part;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@Resource(id="file", name="\u6587\u4ef6\u4e0a\u4f20")
@RequestMapping(value={"/file"})
public class ReactiveFileController {
    private static final Logger log = LoggerFactory.getLogger(ReactiveFileController.class);
    @Autowired
    private FileUploadProperties properties;

    @ResourceAction(id="upload-static", name="\u9759\u6001\u6587\u4ef6")
    @PostMapping(value={"/static"})
    public Mono<String> uploadStatic(@RequestPart(value="file") Part part) {
        if (part instanceof FilePart) {
            FilePart filePart = (FilePart)part;
            if (this.properties.denied(filePart.filename(), filePart.headers().getContentType())) {
                throw new AccessDenyException();
            }
            FileUploadProperties.StaticFileInfo name = this.properties.createStaticSavePath(filePart.filename());
            return ((FilePart)part).transferTo(new File(name.getSavePath())).thenReturn((Object)name.getLocation());
        }
        return Mono.error(() -> new IllegalArgumentException("[file] part is not a file"));
    }
}

