/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.csp.directive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.htmlunit.csp.Directive;
import org.htmlunit.csp.Policy;
import org.htmlunit.csp.value.MediaType;

public class PluginTypesDirective
extends Directive {
    private final List<MediaType> mediaTypes_ = new ArrayList<MediaType>();

    public PluginTypesDirective(List<String> values, Directive.DirectiveErrorConsumer errors) {
        super(values);
        int index = 0;
        for (String token : values) {
            Optional<MediaType> type = MediaType.parseMediaType(token);
            if (type.isPresent()) {
                this.addMediaType(type.get(), index, errors);
            } else {
                errors.add(Policy.Severity.Error, "Expecting media-type but found \"" + token + "\"", index);
            }
            ++index;
        }
    }

    private boolean addMediaType(MediaType type, int index, Directive.DirectiveErrorConsumer errors) {
        if (this.mediaTypes_.contains(type)) {
            errors.add(Policy.Severity.Warning, "Duplicate media type " + type.toString(), index);
            return false;
        }
        if (type.getType().equals("*") || type.getSubtype().equals("*")) {
            errors.add(Policy.Severity.Warning, "Media types can only be matched literally. Make sure using `*` is not an oversight.", index);
        }
        this.mediaTypes_.add(type);
        return true;
    }

    public List<MediaType> getMediaTypes() {
        return Collections.unmodifiableList(this.mediaTypes_);
    }
}

