/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.csp.directive;

import java.util.List;
import java.util.Locale;
import org.htmlunit.csp.Directive;
import org.htmlunit.csp.Policy;

public class SandboxDirective
extends Directive {
    private static final String ALLOW_DOWNLOADS = "allow-downloads";
    private boolean allowDownloads_;
    private boolean allowForms_;
    private boolean allowModals_;
    private boolean allowOrientationLock_;
    private boolean allowPointerLock_;
    private boolean allowPopups_;
    private boolean allowPopupsToEscapeSandbox_;
    private boolean allowPresentation_;
    private boolean allowSameOrigin_;
    private boolean allowScripts_;
    private boolean allowStorageAccessByUserActivation_;
    private boolean allowTopNavigation_;
    private boolean allowTopNavigationByUserActivation_;

    public SandboxDirective(List<String> values, Directive.DirectiveErrorConsumer errors) {
        super(values);
        int index = 0;
        for (String token : values) {
            String lowcaseToken;
            switch (lowcaseToken = token.toLowerCase(Locale.ROOT)) {
                case "allow-downloads": {
                    if (this.allowDownloads_) {
                        errors.add(Policy.Severity.Warning, "Duplicate sandbox keyword allow-downloads", index);
                        break;
                    }
                    this.allowDownloads_ = true;
                    break;
                }
                case "allow-forms": {
                    if (this.allowForms_) {
                        errors.add(Policy.Severity.Warning, "Duplicate sandbox keyword allow-forms", index);
                        break;
                    }
                    this.allowForms_ = true;
                    break;
                }
                case "allow-modals": {
                    if (this.allowModals_) {
                        errors.add(Policy.Severity.Warning, "Duplicate sandbox keyword allow-modals", index);
                        break;
                    }
                    this.allowModals_ = true;
                    break;
                }
                case "allow-orientation-lock": {
                    if (this.allowOrientationLock_) {
                        errors.add(Policy.Severity.Warning, "Duplicate sandbox keyword allow-orientation-lock", index);
                        break;
                    }
                    this.allowOrientationLock_ = true;
                    break;
                }
                case "allow-pointer-lock": {
                    if (this.allowPointerLock_) {
                        errors.add(Policy.Severity.Warning, "Duplicate sandbox keyword allow-pointer-lock", index);
                        break;
                    }
                    this.allowPointerLock_ = true;
                    break;
                }
                case "allow-popups": {
                    if (this.allowPopups_) {
                        errors.add(Policy.Severity.Warning, "Duplicate sandbox keyword allow-popups", index);
                        break;
                    }
                    this.allowPopups_ = true;
                    break;
                }
                case "allow-popups-to-escape-sandbox": {
                    if (this.allowPopupsToEscapeSandbox_) {
                        errors.add(Policy.Severity.Warning, "Duplicate sandbox keyword allow-popups-to-escape-sandbox", index);
                        break;
                    }
                    this.allowPopupsToEscapeSandbox_ = true;
                    break;
                }
                case "allow-presentation": {
                    if (this.allowPresentation_) {
                        errors.add(Policy.Severity.Warning, "Duplicate sandbox keyword allow-presentation", index);
                        break;
                    }
                    this.allowPresentation_ = true;
                    break;
                }
                case "allow-same-origin": {
                    if (this.allowSameOrigin_) {
                        errors.add(Policy.Severity.Warning, "Duplicate sandbox keyword allow-same-origin", index);
                        break;
                    }
                    this.allowSameOrigin_ = true;
                    break;
                }
                case "allow-scripts": {
                    if (this.allowScripts_) {
                        errors.add(Policy.Severity.Warning, "Duplicate sandbox keyword allow-scripts", index);
                        break;
                    }
                    this.allowScripts_ = true;
                    break;
                }
                case "allow-storage-access-by-user-activation": {
                    if (this.allowStorageAccessByUserActivation_) {
                        errors.add(Policy.Severity.Warning, "Duplicate sandbox keyword allow-storage-access-by-user-activation", index);
                        break;
                    }
                    this.allowStorageAccessByUserActivation_ = true;
                    break;
                }
                case "allow-top-navigation": {
                    if (this.allowTopNavigation_) {
                        errors.add(Policy.Severity.Warning, "Duplicate sandbox keyword allow-top-navigation", index);
                        break;
                    }
                    this.allowTopNavigation_ = true;
                    break;
                }
                case "allow-top-navigation-by-user-activation": {
                    if (this.allowTopNavigationByUserActivation_) {
                        errors.add(Policy.Severity.Warning, "Duplicate sandbox keyword allow-top-navigation-by-user-activation", index);
                        break;
                    }
                    this.allowTopNavigationByUserActivation_ = true;
                    break;
                }
                default: {
                    if (token.startsWith("'")) {
                        errors.add(Policy.Severity.Error, "Unrecognized sandbox keyword " + token + " - note that sandbox keywords do not have \"'\"s", index);
                        break;
                    }
                    errors.add(Policy.Severity.Error, "Unrecognized sandbox keyword " + token, index);
                }
            }
            ++index;
        }
    }

    public boolean allowDownloads() {
        return this.allowDownloads_;
    }

    public boolean allowForms() {
        return this.allowForms_;
    }

    public boolean allowModals() {
        return this.allowModals_;
    }

    public boolean allowOrientationLock() {
        return this.allowOrientationLock_;
    }

    public boolean allowPointerLock() {
        return this.allowPointerLock_;
    }

    public boolean allowPopups() {
        return this.allowPopups_;
    }

    public boolean allowPopupsToEscapeSandbox() {
        return this.allowPopupsToEscapeSandbox_;
    }

    public boolean allowPresentation() {
        return this.allowPresentation_;
    }

    public boolean allowSameOrigin() {
        return this.allowSameOrigin_;
    }

    public boolean allowScripts() {
        return this.allowScripts_;
    }

    public boolean allowStorageAccessByUserActivation() {
        return this.allowStorageAccessByUserActivation_;
    }

    public boolean allowTopNavigation() {
        return this.allowTopNavigation_;
    }

    public boolean allowTopNavigationByUserActivation() {
        return this.allowTopNavigationByUserActivation_;
    }
}

