/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cyberneko;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Locale;
import org.htmlunit.cyberneko.HTMLComponent;
import org.htmlunit.cyberneko.HTMLConfiguration;
import org.htmlunit.cyberneko.HTMLElements;
import org.htmlunit.cyberneko.HTMLErrorReporter;
import org.htmlunit.cyberneko.HTMLNamedEntitiesParser;
import org.htmlunit.cyberneko.HTMLUnicodeEntitiesParser;
import org.htmlunit.cyberneko.LocationItem;
import org.htmlunit.cyberneko.SynthesizedItem;
import org.htmlunit.cyberneko.io.PlaybackInputStream;
import org.htmlunit.cyberneko.util.MiniStack;
import org.htmlunit.cyberneko.xerces.util.EncodingTranslator;
import org.htmlunit.cyberneko.xerces.util.NamespaceSupport;
import org.htmlunit.cyberneko.xerces.util.StandardEncodingTranslator;
import org.htmlunit.cyberneko.xerces.util.URI;
import org.htmlunit.cyberneko.xerces.util.XMLAttributesImpl;
import org.htmlunit.cyberneko.xerces.xni.Augmentations;
import org.htmlunit.cyberneko.xerces.xni.QName;
import org.htmlunit.cyberneko.xerces.xni.XMLAttributes;
import org.htmlunit.cyberneko.xerces.xni.XMLDocumentHandler;
import org.htmlunit.cyberneko.xerces.xni.XMLLocator;
import org.htmlunit.cyberneko.xerces.xni.XMLString;
import org.htmlunit.cyberneko.xerces.xni.XNIException;
import org.htmlunit.cyberneko.xerces.xni.parser.XMLComponentManager;
import org.htmlunit.cyberneko.xerces.xni.parser.XMLConfigurationException;
import org.htmlunit.cyberneko.xerces.xni.parser.XMLDocumentSource;
import org.htmlunit.cyberneko.xerces.xni.parser.XMLInputSource;

public class HTMLScanner
implements XMLDocumentSource,
XMLLocator,
HTMLComponent {
    public static final String HTML_4_01_STRICT_PUBID = "-//W3C//DTD HTML 4.01//EN";
    public static final String HTML_4_01_STRICT_SYSID = "http://www.w3.org/TR/html4/strict.dtd";
    public static final String HTML_4_01_TRANSITIONAL_PUBID = "-//W3C//DTD HTML 4.01 Transitional//EN";
    public static final String HTML_4_01_TRANSITIONAL_SYSID = "http://www.w3.org/TR/html4/loose.dtd";
    public static final String HTML_4_01_FRAMESET_PUBID = "-//W3C//DTD HTML 4.01 Frameset//EN";
    public static final String HTML_4_01_FRAMESET_SYSID = "http://www.w3.org/TR/html4/frameset.dtd";
    public static final String AUGMENTATIONS = "http://cyberneko.org/html/features/augmentations";
    public static final String REPORT_ERRORS = "http://cyberneko.org/html/features/report-errors";
    public static final String SCRIPT_STRIP_COMMENT_DELIMS = "http://cyberneko.org/html/features/scanner/script/strip-comment-delims";
    public static final String SCRIPT_STRIP_CDATA_DELIMS = "http://cyberneko.org/html/features/scanner/script/strip-cdata-delims";
    public static final String STYLE_STRIP_COMMENT_DELIMS = "http://cyberneko.org/html/features/scanner/style/strip-comment-delims";
    public static final String STYLE_STRIP_CDATA_DELIMS = "http://cyberneko.org/html/features/scanner/style/strip-cdata-delims";
    public static final String IGNORE_SPECIFIED_CHARSET = "http://cyberneko.org/html/features/scanner/ignore-specified-charset";
    public static final String CDATA_SECTIONS = "http://cyberneko.org/html/features/scanner/cdata-sections";
    public static final String CDATA_EARLY_CLOSING = "http://cyberneko.org/html/features/scanner/cdata-early-closing";
    public static final String OVERRIDE_DOCTYPE = "http://cyberneko.org/html/features/override-doctype";
    public static final String INSERT_DOCTYPE = "http://cyberneko.org/html/features/insert-doctype";
    public static final String PARSE_NOSCRIPT_CONTENT = "http://cyberneko.org/html/features/parse-noscript-content";
    public static final String ALLOW_SELFCLOSING_IFRAME = "http://cyberneko.org/html/features/scanner/allow-selfclosing-iframe";
    public static final String ALLOW_SELFCLOSING_SCRIPT = "http://cyberneko.org/html/features/scanner/allow-selfclosing-script";
    public static final String ALLOW_SELFCLOSING_TAGS = "http://cyberneko.org/html/features/scanner/allow-selfclosing-tags";
    public static final String NORMALIZE_ATTRIBUTES = "http://cyberneko.org/html/features/scanner/normalize-attrs";
    public static final String PLAIN_ATTRIBUTE_VALUES = "http://cyberneko.org/html/features/scanner/plain-attr-values";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://cyberneko.org/html/features/augmentations", "http://cyberneko.org/html/features/report-errors", "http://cyberneko.org/html/features/scanner/script/strip-cdata-delims", "http://cyberneko.org/html/features/scanner/script/strip-comment-delims", "http://cyberneko.org/html/features/scanner/style/strip-cdata-delims", "http://cyberneko.org/html/features/scanner/style/strip-comment-delims", "http://cyberneko.org/html/features/scanner/ignore-specified-charset", "http://cyberneko.org/html/features/scanner/cdata-sections", "http://cyberneko.org/html/features/scanner/cdata-early-closing", "http://cyberneko.org/html/features/override-doctype", "http://cyberneko.org/html/features/insert-doctype", "http://cyberneko.org/html/features/scanner/normalize-attrs", "http://cyberneko.org/html/features/scanner/plain-attr-values", "http://cyberneko.org/html/features/parse-noscript-content", "http://cyberneko.org/html/features/scanner/allow-selfclosing-iframe", "http://cyberneko.org/html/features/scanner/allow-selfclosing-script", "http://cyberneko.org/html/features/scanner/allow-selfclosing-tags"};
    private static final Boolean[] RECOGNIZED_FEATURES_DEFAULTS = new Boolean[]{null, null, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE};
    public static final String NAMES_ELEMS = "http://cyberneko.org/html/properties/names/elems";
    public static final String NAMES_ATTRS = "http://cyberneko.org/html/properties/names/attrs";
    public static final String DEFAULT_ENCODING = "http://cyberneko.org/html/properties/default-encoding";
    public static final String ERROR_REPORTER = "http://cyberneko.org/html/properties/error-reporter";
    public static final String ENCODING_TRANSLATOR = "http://cyberneko.org/html/properties/encoding-translator";
    public static final String DOCTYPE_PUBID = "http://cyberneko.org/html/properties/doctype/pubid";
    public static final String DOCTYPE_SYSID = "http://cyberneko.org/html/properties/doctype/sysid";
    public static final String READER_BUFFER_SIZE = "http://cyberneko.org/html/properties/reader-buffer-size";
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://cyberneko.org/html/properties/names/elems", "http://cyberneko.org/html/properties/names/attrs", "http://cyberneko.org/html/properties/default-encoding", "http://cyberneko.org/html/properties/error-reporter", "http://cyberneko.org/html/properties/encoding-translator", "http://cyberneko.org/html/properties/doctype/pubid", "http://cyberneko.org/html/properties/doctype/sysid", "http://cyberneko.org/html/properties/reader-buffer-size"};
    private static final Object[] RECOGNIZED_PROPERTIES_DEFAULTS = new Object[]{null, null, "Windows-1252", null, StandardEncodingTranslator.INSTANCE, "-//W3C//DTD HTML 4.01 Transitional//EN", "http://www.w3.org/TR/html4/loose.dtd", 616};
    protected static final short STATE_CONTENT = 0;
    protected static final short STATE_MARKUP_BRACKET = 1;
    protected static final short STATE_START_DOCUMENT = 10;
    protected static final short STATE_END_DOCUMENT = 11;
    protected static final short NAMES_NO_CHANGE = 0;
    protected static final short NAMES_UPPERCASE = 1;
    protected static final short NAMES_LOWERCASE = 2;
    private static final int SCAN_TRUE = 0;
    private static final int SCAN_EOF = 1;
    private static final int SCAN_FALSE = 2;
    private static final int SCAN_SCANNER_CHANGED = 3;
    private static final boolean DEBUG_SCANNER = false;
    private static final boolean DEBUG_SCANNER_STATE = false;
    private static final boolean DEBUG_BUFFER = false;
    private static final boolean DEBUG_CHARSET = false;
    protected static final boolean DEBUG_CALLBACKS = false;
    private boolean fAugmentations_;
    boolean fReportErrors_;
    boolean fScriptStripCDATADelims_;
    boolean fScriptStripCommentDelims_;
    boolean fStyleStripCDATADelims_;
    boolean fStyleStripCommentDelims_;
    boolean fIgnoreSpecifiedCharset_;
    boolean fCDATASections_;
    boolean fCDATAEarlyClosing_;
    private boolean fOverrideDoctype_;
    boolean fInsertDoctype_;
    boolean fNormalizeAttributes_;
    boolean fPlainAttributeValues_;
    boolean fParseNoScriptContent_;
    boolean fAllowSelfclosingIframe_;
    boolean fAllowSelfclosingScript_;
    boolean fAllowSelfclosingTags_;
    protected short fNamesElems;
    protected short fNamesAttrs;
    protected String fDefaultIANAEncoding;
    protected HTMLErrorReporter fErrorReporter;
    protected EncodingTranslator fEncodingTranslator;
    protected String fDoctypePubid;
    protected String fDoctypeSysid;
    private int fReaderBufferSize;
    protected int fBeginLineNumber;
    protected int fBeginColumnNumber;
    protected int fBeginCharacterOffset;
    protected PlaybackInputStream fByteStream;
    protected CurrentEntity fCurrentEntity;
    protected final MiniStack<CurrentEntity> fCurrentEntityStack = new MiniStack();
    protected Scanner fScanner;
    protected short fScannerState;
    protected XMLDocumentHandler fDocumentHandler;
    protected String fIANAEncoding;
    protected String fJavaEncoding;
    protected int fElementCount;
    protected int fElementDepth;
    private String fFragmentSpecialScannerTag_;
    protected Scanner fContentScanner = new ContentScanner();
    protected final SpecialScanner fSpecialScanner = new SpecialScanner();
    protected final ScriptScanner fScriptScanner = new ScriptScanner();
    protected final XMLString fStringBuffer = new XMLString();
    final XMLString fStringBufferEntityRef = new XMLString();
    final XMLString fStringBufferPlainAttribValue = new XMLString();
    final XMLString fScanUntilEndTag = new XMLString();
    final XMLString fScanComment = new XMLString();
    private final XMLString fScanLiteral = new XMLString();
    final boolean[] fSingleBoolean = new boolean[]{false};
    final HTMLConfiguration htmlConfiguration_;
    private final LocationItem fLocationItem = new LocationItem();

    HTMLScanner(HTMLConfiguration htmlConfiguration) {
        this.htmlConfiguration_ = htmlConfiguration;
    }

    public void pushInputSource(XMLInputSource inputSource) {
        Reader reader = this.getReader(inputSource);
        this.fCurrentEntityStack.push(this.fCurrentEntity);
        String encoding = inputSource.getEncoding();
        String publicId = inputSource.getPublicId();
        String baseSystemId = inputSource.getBaseSystemId();
        String literalSystemId = inputSource.getSystemId();
        String systemId = HTMLScanner.systemId(literalSystemId, baseSystemId);
        this.fCurrentEntity = new CurrentEntity(reader, this.fReaderBufferSize, encoding, publicId, baseSystemId, literalSystemId, systemId);
    }

    private Reader getReader(XMLInputSource inputSource) {
        Reader reader = inputSource.getCharacterStream();
        if (reader == null) {
            try {
                if ("replacement".equalsIgnoreCase(this.fJavaEncoding)) {
                    return new StringReader("\ufffd");
                }
                return new InputStreamReader(inputSource.getByteStream(), this.fJavaEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return reader;
    }

    public void evaluateInputSource(XMLInputSource inputSource) {
        Scanner previousScanner = this.fScanner;
        short previousScannerState = this.fScannerState;
        CurrentEntity previousEntity = this.fCurrentEntity;
        Reader reader = this.getReader(inputSource);
        String encoding = inputSource.getEncoding();
        String publicId = inputSource.getPublicId();
        String baseSystemId = inputSource.getBaseSystemId();
        String literalSystemId = inputSource.getSystemId();
        String systemId = HTMLScanner.systemId(literalSystemId, baseSystemId);
        this.fCurrentEntity = new CurrentEntity(reader, this.fReaderBufferSize, encoding, publicId, baseSystemId, literalSystemId, systemId);
        this.setScanner(this.fContentScanner);
        this.setScannerState((short)0);
        try {
            int scan;
            while (0 == (scan = this.fScanner.scan(false))) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setScanner(this.fScanner instanceof PlainTextScanner ? new PlainTextScanner() : previousScanner);
        this.setScannerState(previousScannerState);
        this.fCurrentEntity = previousEntity;
    }

    public void cleanup(boolean closeall) {
        int size = this.fCurrentEntityStack.size();
        if (size > 0) {
            int i;
            if (this.fCurrentEntity != null) {
                this.fCurrentEntity.closeQuietly();
            }
            int n = i = closeall ? 0 : 1;
            while (i < size) {
                this.fCurrentEntity = this.fCurrentEntityStack.pop();
                this.fCurrentEntity.closeQuietly();
                ++i;
            }
        } else if (closeall && this.fCurrentEntity != null) {
            this.fCurrentEntity.closeQuietly();
        }
    }

    @Override
    public String getEncoding() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.encoding_ : null;
    }

    @Override
    public String getPublicId() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.publicId : null;
    }

    @Override
    public String getBaseSystemId() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.baseSystemId : null;
    }

    @Override
    public String getLiteralSystemId() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.literalSystemId : null;
    }

    @Override
    public String getSystemId() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.systemId : null;
    }

    @Override
    public int getLineNumber() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.getLineNumber() : -1;
    }

    @Override
    public int getColumnNumber() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.getColumnNumber() : -1;
    }

    @Override
    public String getXMLVersion() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.version : null;
    }

    @Override
    public int getCharacterOffset() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.getCharacterOffset() : -1;
    }

    @Override
    public Boolean getFeatureDefault(String featureId) {
        int length = RECOGNIZED_FEATURES != null ? RECOGNIZED_FEATURES.length : 0;
        for (int i = 0; i < length; ++i) {
            if (!RECOGNIZED_FEATURES[i].equals(featureId)) continue;
            return RECOGNIZED_FEATURES_DEFAULTS[i];
        }
        return null;
    }

    @Override
    public Object getPropertyDefault(String propertyId) {
        int length = RECOGNIZED_PROPERTIES != null ? RECOGNIZED_PROPERTIES.length : 0;
        for (int i = 0; i < length; ++i) {
            if (!RECOGNIZED_PROPERTIES[i].equals(propertyId)) continue;
            return RECOGNIZED_PROPERTIES_DEFAULTS[i];
        }
        return null;
    }

    @Override
    public String[] getRecognizedFeatures() {
        return RECOGNIZED_FEATURES;
    }

    @Override
    public String[] getRecognizedProperties() {
        return RECOGNIZED_PROPERTIES;
    }

    @Override
    public void reset(XMLComponentManager manager) throws XMLConfigurationException {
        int length;
        this.fAugmentations_ = manager.getFeature(AUGMENTATIONS);
        this.fReportErrors_ = manager.getFeature(REPORT_ERRORS);
        this.fScriptStripCDATADelims_ = manager.getFeature(SCRIPT_STRIP_CDATA_DELIMS);
        this.fScriptStripCommentDelims_ = manager.getFeature(SCRIPT_STRIP_COMMENT_DELIMS);
        this.fStyleStripCDATADelims_ = manager.getFeature(STYLE_STRIP_CDATA_DELIMS);
        this.fStyleStripCommentDelims_ = manager.getFeature(STYLE_STRIP_COMMENT_DELIMS);
        this.fIgnoreSpecifiedCharset_ = manager.getFeature(IGNORE_SPECIFIED_CHARSET);
        this.fCDATASections_ = manager.getFeature(CDATA_SECTIONS);
        this.fCDATAEarlyClosing_ = manager.getFeature(CDATA_EARLY_CLOSING);
        this.fOverrideDoctype_ = manager.getFeature(OVERRIDE_DOCTYPE);
        this.fInsertDoctype_ = manager.getFeature(INSERT_DOCTYPE);
        this.fNormalizeAttributes_ = manager.getFeature(NORMALIZE_ATTRIBUTES);
        this.fPlainAttributeValues_ = manager.getFeature(PLAIN_ATTRIBUTE_VALUES);
        this.fParseNoScriptContent_ = manager.getFeature(PARSE_NOSCRIPT_CONTENT);
        this.fAllowSelfclosingIframe_ = manager.getFeature(ALLOW_SELFCLOSING_IFRAME);
        this.fAllowSelfclosingScript_ = manager.getFeature(ALLOW_SELFCLOSING_SCRIPT);
        this.fAllowSelfclosingTags_ = manager.getFeature(ALLOW_SELFCLOSING_TAGS);
        this.fNamesElems = HTMLScanner.getNamesValue(String.valueOf(manager.getProperty(NAMES_ELEMS)));
        this.fNamesAttrs = HTMLScanner.getNamesValue(String.valueOf(manager.getProperty(NAMES_ATTRS)));
        this.fDefaultIANAEncoding = String.valueOf(manager.getProperty(DEFAULT_ENCODING));
        this.fErrorReporter = (HTMLErrorReporter)manager.getProperty(ERROR_REPORTER);
        this.fEncodingTranslator = (EncodingTranslator)manager.getProperty(ENCODING_TRANSLATOR);
        this.fDoctypePubid = String.valueOf(manager.getProperty(DOCTYPE_PUBID));
        this.fDoctypeSysid = String.valueOf(manager.getProperty(DOCTYPE_SYSID));
        this.fReaderBufferSize = Integer.parseInt(String.valueOf(manager.getProperty(READER_BUFFER_SIZE)));
        QName[] fragmentContextStack = (QName[])manager.getProperty("http://cyberneko.org/html/properties/balance-tags/fragment-context-stack");
        if (fragmentContextStack != null && (length = fragmentContextStack.length) > 0) {
            QName lastQname = fragmentContextStack[length - 1];
            String name = lastQname.getLocalpart();
            String nameLC = name.toLowerCase(Locale.ROOT);
            HTMLElements.Element elem = this.htmlConfiguration_.getHtmlElements().getElementLC(nameLC, null);
            if (elem != null && elem.isSpecial()) {
                this.fFragmentSpecialScannerTag_ = name;
            }
        }
    }

    @Override
    public void setFeature(String featureId, boolean state) {
        if (featureId.equals(AUGMENTATIONS)) {
            this.fAugmentations_ = state;
        } else if (featureId.equals(REPORT_ERRORS)) {
            this.fReportErrors_ = state;
        } else if (featureId.equals(IGNORE_SPECIFIED_CHARSET)) {
            this.fIgnoreSpecifiedCharset_ = state;
        } else if (featureId.equals(SCRIPT_STRIP_CDATA_DELIMS)) {
            this.fScriptStripCDATADelims_ = state;
        } else if (featureId.equals(SCRIPT_STRIP_COMMENT_DELIMS)) {
            this.fScriptStripCommentDelims_ = state;
        } else if (featureId.equals(STYLE_STRIP_CDATA_DELIMS)) {
            this.fStyleStripCDATADelims_ = state;
        } else if (featureId.equals(STYLE_STRIP_COMMENT_DELIMS)) {
            this.fStyleStripCommentDelims_ = state;
        } else if (featureId.equals(IGNORE_SPECIFIED_CHARSET)) {
            this.fIgnoreSpecifiedCharset_ = state;
        } else if (featureId.equals(CDATA_SECTIONS)) {
            this.fCDATASections_ = state;
        } else if (featureId.equals(CDATA_EARLY_CLOSING)) {
            this.fCDATAEarlyClosing_ = state;
        } else if (featureId.equals(OVERRIDE_DOCTYPE)) {
            this.fOverrideDoctype_ = state;
        } else if (featureId.equals(INSERT_DOCTYPE)) {
            this.fInsertDoctype_ = state;
        } else if (featureId.equals(NORMALIZE_ATTRIBUTES)) {
            this.fNormalizeAttributes_ = state;
        } else if (featureId.equals(PLAIN_ATTRIBUTE_VALUES)) {
            this.fPlainAttributeValues_ = state;
        } else if (featureId.equals(PARSE_NOSCRIPT_CONTENT)) {
            this.fParseNoScriptContent_ = state;
        } else if (featureId.equals(ALLOW_SELFCLOSING_IFRAME)) {
            this.fAllowSelfclosingIframe_ = state;
        } else if (featureId.equals(ALLOW_SELFCLOSING_SCRIPT)) {
            this.fAllowSelfclosingScript_ = state;
        } else if (featureId.equals(ALLOW_SELFCLOSING_TAGS)) {
            this.fAllowSelfclosingTags_ = state;
        }
    }

    @Override
    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        if (propertyId.equals(NAMES_ELEMS)) {
            this.fNamesElems = HTMLScanner.getNamesValue(String.valueOf(value));
        } else if (propertyId.equals(NAMES_ATTRS)) {
            this.fNamesAttrs = HTMLScanner.getNamesValue(String.valueOf(value));
        } else if (propertyId.equals(DEFAULT_ENCODING)) {
            this.fDefaultIANAEncoding = String.valueOf(value);
        } else if (propertyId.equals(ERROR_REPORTER)) {
            this.fErrorReporter = (HTMLErrorReporter)value;
        } else if (propertyId.equals(ENCODING_TRANSLATOR)) {
            this.fEncodingTranslator = (EncodingTranslator)value;
        } else if (propertyId.equals(DOCTYPE_PUBID)) {
            this.fDoctypePubid = String.valueOf(value);
        } else if (propertyId.equals(DOCTYPE_SYSID)) {
            this.fDoctypeSysid = String.valueOf(value);
        } else if (propertyId.equals(READER_BUFFER_SIZE)) {
            this.fReaderBufferSize = Integer.parseInt(String.valueOf(value));
        }
    }

    public void setInputSource(XMLInputSource source) throws IOException {
        this.fElementCount = 0;
        this.fElementDepth = -1;
        this.fByteStream = null;
        this.fCurrentEntityStack.clear();
        this.fBeginLineNumber = 1;
        this.fBeginColumnNumber = 1;
        this.fBeginCharacterOffset = 0;
        this.fJavaEncoding = this.fIANAEncoding = this.fDefaultIANAEncoding;
        String encoding = source.getEncoding();
        String publicId = source.getPublicId();
        String baseSystemId = source.getBaseSystemId();
        String literalSystemId = source.getSystemId();
        String systemId = HTMLScanner.systemId(literalSystemId, baseSystemId);
        Reader reader = source.getCharacterStream();
        if (reader == null) {
            InputStream inputStream = source.getByteStream();
            if (inputStream == null) {
                URL url = new URL(systemId);
                inputStream = url.openStream();
            }
            String[] encodings = new String[2];
            this.fByteStream = new PlaybackInputStream(inputStream);
            this.fByteStream.detectBomEncoding(encodings);
            if (encoding != null) {
                encodings[0] = encoding;
                encodings[1] = null;
            }
            if (encodings[0] == null) {
                encodings[0] = this.fDefaultIANAEncoding;
                if (this.fReportErrors_) {
                    this.fErrorReporter.reportWarning("HTML1000", null);
                }
            }
            if (encodings[1] == null) {
                encodings[1] = this.fEncodingTranslator.encodingNameFromLabel(encodings[0]);
                if (encodings[1] == null || !"replacement".equalsIgnoreCase(encodings[1]) && !Charset.isSupported(encodings[1])) {
                    encodings[1] = encodings[0];
                    if (this.fReportErrors_) {
                        this.fErrorReporter.reportWarning("HTML1001", new Object[]{encodings[0]});
                    }
                }
            }
            this.fIANAEncoding = encodings[0];
            this.fJavaEncoding = encodings[1];
            reader = "replacement".equalsIgnoreCase(this.fJavaEncoding) ? new StringReader("\ufffd") : new InputStreamReader((InputStream)this.fByteStream, this.fJavaEncoding);
        }
        this.fCurrentEntity = new CurrentEntity(reader, this.fReaderBufferSize, this.fIANAEncoding, publicId, baseSystemId, literalSystemId, systemId);
        if (this.fFragmentSpecialScannerTag_ != null) {
            if ("script".equalsIgnoreCase(this.fFragmentSpecialScannerTag_)) {
                this.setScanner(this.fScriptScanner);
            } else if ("plaintext".equalsIgnoreCase(this.fFragmentSpecialScannerTag_)) {
                this.setScanner(new PlainTextScanner());
            } else {
                this.setScanner(this.fSpecialScanner.setElementName(this.fFragmentSpecialScannerTag_));
                this.setScannerState((short)0);
            }
        } else {
            this.setScanner(this.fContentScanner);
            this.setScannerState((short)10);
        }
    }

    public boolean scanDocument(boolean complete) throws XNIException, IOException {
        do {
            int scan;
            if (2 != (scan = this.fScanner.scan(complete))) continue;
            return false;
        } while (complete);
        return true;
    }

    @Override
    public void setDocumentHandler(XMLDocumentHandler handler) {
        if (handler == null) {
            throw new NullPointerException("HTMLScanner always requires a non null document handler");
        }
        this.fDocumentHandler = handler;
    }

    @Override
    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    protected static String getValue(XMLAttributes attrs, String aname) {
        if (attrs != null) {
            int length = attrs.getLength();
            for (int i = 0; i < length; ++i) {
                if (!attrs.getQName(i).equalsIgnoreCase(aname)) continue;
                return attrs.getValue(i);
            }
        }
        return null;
    }

    public static String systemId(String systemId, String baseSystemId) {
        if (systemId == null || systemId.isEmpty()) {
            return systemId;
        }
        try {
            new URI(systemId);
            return systemId;
        }
        catch (URI.MalformedURIException malformedURIException) {
            String id = HTMLScanner.fixURI(systemId);
            URI uri = null;
            try {
                URI base;
                block17: {
                    if (baseSystemId == null || baseSystemId.isEmpty() || baseSystemId.equals(systemId)) {
                        String dir;
                        try {
                            dir = HTMLScanner.fixURI(System.getProperty("user.dir")).replaceAll(" ", "%20");
                        }
                        catch (SecurityException ignored) {
                            dir = "";
                        }
                        if (!dir.endsWith("/")) {
                            dir = dir + "/";
                        }
                        base = new URI("file", "", dir, null, null);
                    } else {
                        try {
                            base = new URI(HTMLScanner.fixURI(baseSystemId));
                        }
                        catch (URI.MalformedURIException e) {
                            String dir;
                            try {
                                dir = HTMLScanner.fixURI(System.getProperty("user.dir")).replaceAll(" ", "%20");
                            }
                            catch (SecurityException ignored) {
                                dir = "";
                            }
                            if (baseSystemId.indexOf(58) != -1) {
                                base = new URI("file", "", HTMLScanner.fixURI(baseSystemId), null, null);
                                break block17;
                            }
                            if (!dir.endsWith("/")) {
                                dir = dir + "/";
                            }
                            dir = dir + HTMLScanner.fixURI(baseSystemId);
                            base = new URI("file", "", dir, null, null);
                        }
                    }
                }
                uri = new URI(base, id);
            }
            catch (URI.MalformedURIException malformedURIException2) {
                // empty catch block
            }
            if (uri == null) {
                return systemId;
            }
            return uri.toString();
        }
    }

    protected static String fixURI(String str) {
        if ((str = str.replace(File.separatorChar, '/')).length() >= 2) {
            char ch1 = str.charAt(1);
            if (ch1 == ':') {
                char ch0 = String.valueOf(str.charAt(0)).toUpperCase(Locale.ROOT).charAt(0);
                if (ch0 >= 'A' && ch0 <= 'Z') {
                    str = "/" + str;
                }
            } else if (ch1 == '/' && str.charAt(0) == '/') {
                str = "file:" + str;
            }
        }
        return str;
    }

    protected static short getNamesValue(String value) {
        if ("lower".equals(value)) {
            return 2;
        }
        if ("upper".equals(value)) {
            return 1;
        }
        return 0;
    }

    protected void setScanner(Scanner scanner) {
        this.fScanner = scanner;
    }

    protected void setScannerState(short state) {
        this.fScannerState = state;
    }

    protected int scanDoctype() throws IOException {
        int c;
        String root = null;
        String pubid = null;
        String sysid = null;
        if (this.fCurrentEntity.skipSpaces()) {
            root = this.scanName(true, this.fNamesElems);
            if (root == null && this.fReportErrors_) {
                this.fErrorReporter.reportError("HTML1014", null);
            }
            if (this.fCurrentEntity.skipSpaces()) {
                int scanLiteral;
                if (this.fCurrentEntity.skip("PUBLIC")) {
                    this.fCurrentEntity.skipSpaces();
                    scanLiteral = this.scanLiteral();
                    if (1 == scanLiteral) {
                        return 1;
                    }
                    if (0 == scanLiteral) {
                        pubid = this.fScanLiteral.toString();
                    }
                    if (this.fCurrentEntity.skipSpaces()) {
                        scanLiteral = this.scanLiteral();
                        if (1 == scanLiteral) {
                            return 1;
                        }
                        if (0 == scanLiteral) {
                            sysid = this.fScanLiteral.toString();
                        }
                    }
                } else if (this.fCurrentEntity.skip("SYSTEM")) {
                    this.fCurrentEntity.skipSpaces();
                    scanLiteral = this.scanLiteral();
                    if (1 == scanLiteral) {
                        return 1;
                    }
                    if (0 == scanLiteral) {
                        sysid = this.fScanLiteral.toString();
                    }
                }
            }
        }
        while ((c = this.fCurrentEntity.read()) != -1) {
            if (c == 60) {
                this.fCurrentEntity.rewind();
                break;
            }
            if (c == 62) break;
            if (c != 91) continue;
            this.fCurrentEntity.skipMarkup(true);
            break;
        }
        if (this.fOverrideDoctype_) {
            pubid = this.fDoctypePubid;
            sysid = this.fDoctypeSysid;
        }
        this.fDocumentHandler.doctypeDecl(root, pubid, sysid, this.locationAugs(this.fCurrentEntity));
        return c == -1 ? 1 : 0;
    }

    protected int scanLiteral() throws IOException {
        int quote = this.fCurrentEntity.read();
        if (quote == 34 || quote == 39) {
            int c;
            XMLString str = this.fScanLiteral.clear();
            while ((c = this.fCurrentEntity.read()) != -1 && c != quote) {
                if (c == 10 || c == 13) {
                    this.fCurrentEntity.rewind();
                    this.fCurrentEntity.skipNewlines();
                    str.append(' ');
                    continue;
                }
                if (c == 60) {
                    this.fCurrentEntity.rewind();
                    break;
                }
                if (str.appendCodePoint(c) || !this.fReportErrors_) continue;
                this.fErrorReporter.reportError("HTML1005", new Object[]{"&#" + c + ';'});
            }
            if (c == -1) {
                if (this.fReportErrors_) {
                    this.fErrorReporter.reportError("HTML1007", null);
                }
                return 1;
            }
            return 0;
        }
        this.fCurrentEntity.rewind();
        return 2;
    }

    protected String scanName(boolean strict, short mode) throws IOException {
        int length;
        if (this.fCurrentEntity.offset_ == this.fCurrentEntity.length_ && this.fCurrentEntity.loadWholeBuffer() == -1) {
            return null;
        }
        int offset = this.fCurrentEntity.offset_;
        while (true) {
            if (this.fCurrentEntity.hasNext()) {
                char c = this.fCurrentEntity.getNextChar();
                if (strict && !Character.isLetterOrDigit(c) && c != '-' && c != '.' && c != ':' && c != '_') {
                    this.fCurrentEntity.rewind();
                } else if (!strict && (c == ' ' || c == '\n' || c == '=' || c == '/' || c == '>' || Character.isWhitespace(c))) {
                    this.fCurrentEntity.rewind();
                } else {
                    if (0 == mode) continue;
                    if (1 == mode && !Character.isUpperCase(c)) {
                        this.fCurrentEntity.buffer_[this.fCurrentEntity.offset_ - 1] = Character.toUpperCase(c);
                        continue;
                    }
                    if (2 != mode || Character.isLowerCase(c)) continue;
                    this.fCurrentEntity.buffer_[this.fCurrentEntity.offset_ - 1] = Character.toLowerCase(c);
                    continue;
                }
            }
            if (this.fCurrentEntity.offset_ != this.fCurrentEntity.length_) break;
            length = this.fCurrentEntity.length_ - offset;
            System.arraycopy(this.fCurrentEntity.buffer_, offset, this.fCurrentEntity.buffer_, 0, length);
            int count = this.fCurrentEntity.load(length);
            offset = 0;
            if (count == -1) break;
        }
        String name = (length = this.fCurrentEntity.offset_ - offset) > 0 ? new String(this.fCurrentEntity.buffer_, offset, length) : null;
        return name;
    }

    /*
     * Unable to fully structure code
     */
    protected String scanTagName() throws IOException {
        if (this.fCurrentEntity.offset_ == this.fCurrentEntity.length_ && this.fCurrentEntity.loadWholeBuffer() == -1) {
            return null;
        }
        offset = this.fCurrentEntity.offset_;
        isFirst = true;
        while (true) {
            block5: {
                block6: {
                    if (!this.fCurrentEntity.hasNext()) break block5;
                    c = this.fCurrentEntity.getNextChar();
                    if (!isFirst) break block6;
                    isFirst = false;
                    if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') ** GOTO lbl-1000
                    this.fCurrentEntity.rewind();
                    break block5;
                }
                if (c == '\t' || c == '\r' || c == '\n' || c == ' ' || c == '\u0000' || c == '/' || c == '>') {
                    this.fCurrentEntity.rewind();
                } else lbl-1000:
                // 2 sources

                {
                    if (0 == this.fNamesElems) continue;
                    if (1 == this.fNamesElems && !Character.isUpperCase(c)) {
                        this.fCurrentEntity.buffer_[this.fCurrentEntity.offset_ - 1] = Character.toUpperCase(c);
                        continue;
                    }
                    if (2 != this.fNamesElems || Character.isLowerCase(c)) continue;
                    this.fCurrentEntity.buffer_[this.fCurrentEntity.offset_ - 1] = Character.toLowerCase(c);
                    continue;
                }
            }
            if (this.fCurrentEntity.offset_ != this.fCurrentEntity.length_) break;
            length = this.fCurrentEntity.length_ - offset;
            System.arraycopy(this.fCurrentEntity.buffer_, offset, this.fCurrentEntity.buffer_, 0, length);
            count = this.fCurrentEntity.load(length);
            offset = 0;
            if (count == -1) break;
        }
        name = (length = this.fCurrentEntity.offset_ - offset) > 0 ? new String(this.fCurrentEntity.buffer_, offset, length) : null;
        return name;
    }

    protected int scanEntityRef(XMLString str, XMLString plainValue, boolean content) throws IOException {
        str.clearAndAppend('&');
        int nextChar = this.fCurrentEntity.readPreservingBufferContent();
        if (nextChar == -1) {
            if (plainValue != null) {
                plainValue.append(str);
            }
            return this.returnEntityRefString(str, content);
        }
        str.append((char)nextChar);
        if (35 == nextChar) {
            HTMLUnicodeEntitiesParser parser = new HTMLUnicodeEntitiesParser();
            do {
                if ((nextChar = this.fCurrentEntity.readPreservingBufferContent()) == -1) continue;
                str.append((char)nextChar);
            } while (nextChar != -1 && parser.parseNumeric(nextChar));
            String match = parser.getMatch();
            if (match == null) {
                this.fCurrentEntity.rewind(str.length() - 1);
                if (plainValue != null) {
                    plainValue.append('&');
                }
                str.clearAndAppend('&');
            } else {
                this.fCurrentEntity.rewind(parser.getRewindCount());
                if (plainValue != null) {
                    plainValue.append(str);
                }
                str.clear().append(match);
            }
            return this.returnEntityRefString(str, content);
        }
        int readCount = 1;
        HTMLNamedEntitiesParser.State result = null;
        HTMLNamedEntitiesParser.State lastMatchingResult = null;
        while (nextChar != -1) {
            HTMLNamedEntitiesParser.State intermediateResult = HTMLNamedEntitiesParser.get().lookup(nextChar, result);
            if (intermediateResult.endNode_) {
                result = intermediateResult;
                break;
            }
            if (intermediateResult == result) break;
            if (intermediateResult.isMatch_) {
                lastMatchingResult = intermediateResult;
            }
            result = intermediateResult;
            nextChar = this.fCurrentEntity.readPreservingBufferContent();
            if (nextChar == -1) continue;
            str.append((char)nextChar);
            ++readCount;
        }
        if (!result.isMatch_ && lastMatchingResult != null) {
            result = lastMatchingResult;
        }
        if (result.isMatch_) {
            this.fCurrentEntity.rewind(readCount - result.length_);
            if (result.endsWithSemicolon_) {
                if (plainValue != null) {
                    plainValue.append(str);
                }
                str.clear().append(result.resolvedValue_);
            } else {
                if (this.fReportErrors_) {
                    this.fErrorReporter.reportWarning("HTML1004", null);
                }
                if (content) {
                    if (plainValue != null) {
                        plainValue.append(str);
                    }
                    str.clear().append(result.resolvedValue_);
                } else {
                    int matchLength = result.length_ + 1;
                    if (matchLength < str.length()) {
                        nextChar = str.charAt(matchLength);
                        if (61 == nextChar || 48 <= nextChar && nextChar <= 57 || 65 <= nextChar && nextChar <= 90 || 97 <= nextChar && nextChar <= 122) {
                            str.shortenBy(str.length() - result.length_ - 1);
                            if (plainValue != null) {
                                plainValue.append(str);
                            }
                        } else {
                            if (plainValue != null) {
                                plainValue.append(str);
                            }
                            str.clear().append(result.resolvedValue_);
                        }
                    } else {
                        if (plainValue != null) {
                            plainValue.append(str);
                        }
                        str.clear().append(result.resolvedValue_);
                    }
                }
            }
        } else {
            this.fCurrentEntity.rewind(readCount);
            if (plainValue != null) {
                plainValue.append('&');
            }
            str.clearAndAppend('&');
        }
        return this.returnEntityRefString(str, content);
    }

    private int returnEntityRefString(XMLString str, boolean content) {
        if (content && this.fElementCount >= this.fElementDepth) {
            this.fDocumentHandler.characters(str, this.locationAugs(this.fCurrentEntity));
        }
        return -1;
    }

    protected final Augmentations locationAugs(CurrentEntity currentEntity) {
        if (this.fAugmentations_) {
            this.fLocationItem.setValues(this.fBeginLineNumber, this.fBeginColumnNumber, this.fBeginCharacterOffset, currentEntity.getLineNumber(), currentEntity.getColumnNumber(), currentEntity.getCharacterOffset());
            return this.fLocationItem;
        }
        return null;
    }

    protected final Augmentations synthesizedAugs() {
        if (this.fAugmentations_) {
            return SynthesizedItem.INSTANCE;
        }
        return null;
    }

    static boolean isEncodingCompatible(String encoding1, String encoding2) {
        try {
            try {
                return HTMLScanner.canRoundtrip(encoding1, encoding2);
            }
            catch (UnsupportedOperationException e) {
                try {
                    return HTMLScanner.canRoundtrip(encoding2, encoding1);
                }
                catch (UnsupportedOperationException ignored) {
                    return false;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
    }

    private static boolean canRoundtrip(String encodeCharset, String decodeCharset) throws UnsupportedEncodingException {
        String reference = "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html;charset=";
        byte[] bytesEncoding1 = "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html;charset=".getBytes(encodeCharset);
        String referenceWithEncoding2 = new String(bytesEncoding1, decodeCharset);
        return "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html;charset=".equals(referenceWithEncoding2);
    }

    public class ScriptScanner
    implements Scanner {
        final XMLString fScanScriptContent = new XMLString(128);

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int scan(boolean complete) throws IOException {
            int c;
            this.fScanScriptContent.clear();
            ScanScriptState state = ScanScriptState.DATA;
            int closeIndex = 0;
            int openIndex = 0;
            boolean invalidComment = false;
            block7: while ((c = HTMLScanner.this.fCurrentEntity.read()) != -1) {
                switch (state) {
                    case DATA: {
                        String next;
                        if (c == 45 && this.fScanScriptContent.endsWith("<!-")) {
                            state = ScanScriptState.ESCAPED;
                            break;
                        }
                        if (c != 60 || (next = HTMLScanner.this.fCurrentEntity.nextContent(8) + " ").length() < 8 || !"/script".equalsIgnoreCase(next.substring(0, 7)) || '>' != next.charAt(7) && !Character.isWhitespace(next.charAt(7))) break;
                        HTMLScanner.this.fCurrentEntity.rewind();
                        break block7;
                    }
                    case ESCAPED: {
                        if (c == 62) {
                            if (this.fScanScriptContent.endsWith("--")) {
                                state = ScanScriptState.DATA;
                                break;
                            }
                            if (!this.fScanScriptContent.endsWith("--!")) break;
                            state = ScanScriptState.DATA;
                            invalidComment = true;
                            break;
                        }
                        if (c != 60) break;
                        String next = HTMLScanner.this.fCurrentEntity.nextContent(8) + " ";
                        if (next.length() >= 8 && "/script".equalsIgnoreCase(next.substring(0, 7)) && ('>' == next.charAt(7) || Character.isWhitespace(next.charAt(7)))) {
                            HTMLScanner.this.fCurrentEntity.rewind();
                            break block7;
                        }
                        openIndex = 0;
                        state = ScanScriptState.ESCAPED_LT;
                        break;
                    }
                    case ESCAPED_LT: {
                        if (openIndex < 6) {
                            if (Character.toLowerCase(c) == "script".charAt(openIndex)) {
                                ++openIndex;
                                break;
                            }
                            state = ScanScriptState.ESCAPED;
                            break;
                        }
                        if (openIndex == 6) {
                            if (Character.isWhitespace(c)) {
                                ++openIndex;
                                break;
                            }
                            if (c == 62) {
                                state = ScanScriptState.DOUBLE_ESCAPED;
                                break;
                            }
                            state = ScanScriptState.ESCAPED;
                            break;
                        }
                        if (c != 62) break;
                        if (this.fScanScriptContent.endsWith("--")) {
                            state = ScanScriptState.DATA;
                            break;
                        }
                        state = ScanScriptState.DOUBLE_ESCAPED;
                        break;
                    }
                    case DOUBLE_ESCAPED: {
                        if (c == 62 && this.fScanScriptContent.endsWith("--")) {
                            state = ScanScriptState.DATA;
                            break;
                        }
                        if (c != 60) break;
                        state = ScanScriptState.DOUBLE_ESCAPED_LT;
                        break;
                    }
                    case DOUBLE_ESCAPED_LT: {
                        if (closeIndex < 7) {
                            if (Character.toLowerCase(c) == "/script".charAt(closeIndex)) {
                                ++closeIndex;
                                break;
                            }
                            if (c == 60) {
                                state = ScanScriptState.DOUBLE_ESCAPED_LT;
                                closeIndex = 0;
                                break;
                            }
                            state = ScanScriptState.DOUBLE_ESCAPED;
                            break;
                        }
                        if (c == 62) {
                            state = ScanScriptState.ESCAPED;
                            break;
                        }
                        if (Character.isWhitespace(c)) break;
                        if (c == 60) {
                            state = ScanScriptState.DOUBLE_ESCAPED_LT;
                            closeIndex = 0;
                            break;
                        }
                        state = ScanScriptState.DOUBLE_ESCAPED;
                    }
                }
                if (c == 13 || c == 10) {
                    HTMLScanner.this.fCurrentEntity.rewind();
                    int newlines = HTMLScanner.this.fCurrentEntity.skipNewlines();
                    for (int i = 0; i < newlines; ++i) {
                        this.fScanScriptContent.append('\n');
                    }
                    continue;
                }
                if (this.fScanScriptContent.appendCodePoint(c) || !HTMLScanner.this.fReportErrors_) continue;
                HTMLScanner.this.fErrorReporter.reportError("HTML1005", new Object[]{"&#" + c + ';'});
            }
            if (HTMLScanner.this.fScriptStripCommentDelims_) {
                if (invalidComment) {
                    this.fScanScriptContent.trimToContent("<!--", "--!>");
                } else {
                    this.fScanScriptContent.trimToContent("<!--", "-->");
                }
            }
            if (HTMLScanner.this.fScriptStripCDATADelims_) {
                this.fScanScriptContent.trimToContent("<![CDATA[", "]]>");
            }
            if (this.fScanScriptContent.length() > 0 && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                HTMLScanner.this.fDocumentHandler.characters(this.fScanScriptContent, HTMLScanner.this.locationAugs(HTMLScanner.this.fCurrentEntity));
            }
            HTMLScanner.this.setScanner(HTMLScanner.this.fContentScanner);
            HTMLScanner.this.setScannerState((short)0);
            return 0;
        }
    }

    public class PlainTextScanner
    implements Scanner {
        private final XMLString xmlString_ = new XMLString();

        @Override
        public int scan(boolean complete) throws IOException {
            this.scanCharacters(this.xmlString_, complete);
            return 2;
        }

        protected void scanCharacters(XMLString buffer, boolean complete) throws IOException {
            int c;
            while ((c = HTMLScanner.this.fCurrentEntity.read()) != -1) {
                if (!buffer.appendCodePoint(c) && HTMLScanner.this.fReportErrors_) {
                    HTMLScanner.this.fErrorReporter.reportError("HTML1005", new Object[]{"&#" + c + ';'});
                }
                if (c != 10) continue;
                HTMLScanner.this.fCurrentEntity.incLine();
            }
            if (buffer.length() > 0 && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                HTMLScanner.this.fDocumentHandler.characters(buffer, HTMLScanner.this.locationAugs(HTMLScanner.this.fCurrentEntity));
            }
            if (complete) {
                HTMLScanner.this.fDocumentHandler.endDocument(HTMLScanner.this.locationAugs(HTMLScanner.this.fCurrentEntity));
            }
        }
    }

    public class SpecialScanner
    implements Scanner {
        protected String fElementName;
        protected boolean fStyle;
        protected boolean fTextarea;
        protected boolean fTitle;
        private final QName fQName_ = new QName();
        private final XMLString charBuffer_ = new XMLString();

        public Scanner setElementName(String ename) {
            this.fElementName = ename;
            this.fStyle = "style".equalsIgnoreCase(this.fElementName);
            this.fTextarea = "textarea".equalsIgnoreCase(this.fElementName);
            this.fTitle = "title".equalsIgnoreCase(this.fElementName);
            return this;
        }

        @Override
        public int scan(boolean complete) throws IOException {
            do {
                switch (HTMLScanner.this.fScannerState) {
                    case 0: {
                        HTMLScanner.this.fBeginLineNumber = HTMLScanner.this.fCurrentEntity.getLineNumber();
                        HTMLScanner.this.fBeginColumnNumber = HTMLScanner.this.fCurrentEntity.getColumnNumber();
                        HTMLScanner.this.fBeginCharacterOffset = HTMLScanner.this.fCurrentEntity.getCharacterOffset();
                        int c = HTMLScanner.this.fCurrentEntity.read();
                        if (c == -1) {
                            if (HTMLScanner.this.fReportErrors_) {
                                HTMLScanner.this.fErrorReporter.reportError("HTML1007", null);
                            }
                            HTMLScanner.this.setScanner(HTMLScanner.this.fContentScanner);
                            if (HTMLScanner.this.fCurrentEntityStack.isEmpty()) {
                                HTMLScanner.this.setScannerState((short)11);
                            } else {
                                HTMLScanner.this.fCurrentEntity = HTMLScanner.this.fCurrentEntityStack.pop();
                                HTMLScanner.this.setScannerState((short)0);
                            }
                            return 0;
                        }
                        if (c == 60) {
                            HTMLScanner.this.setScannerState((short)1);
                            break;
                        }
                        if (c == 38) {
                            if (this.fTextarea || this.fTitle) {
                                HTMLScanner.this.scanEntityRef(this.charBuffer_, null, true);
                                break;
                            }
                            this.charBuffer_.clearAndAppend('&');
                        } else {
                            HTMLScanner.this.fCurrentEntity.rewind();
                            this.charBuffer_.clear();
                        }
                        this.scanCharacters(this.charBuffer_);
                        break;
                    }
                    case 1: {
                        int c = HTMLScanner.this.fCurrentEntity.read();
                        if (c == 47) {
                            String ename = HTMLScanner.this.scanName(true, HTMLScanner.this.fNamesElems);
                            if (ename != null) {
                                HTMLScanner.this.fCurrentEntity.skipSpaces();
                                if (ename.equalsIgnoreCase(this.fElementName)) {
                                    if (HTMLScanner.this.fCurrentEntity.read() == 62) {
                                        if (HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                                            this.fQName_.setValues(null, ename, ename, null);
                                            HTMLScanner.this.fDocumentHandler.endElement(this.fQName_, HTMLScanner.this.locationAugs(HTMLScanner.this.fCurrentEntity));
                                        }
                                        HTMLScanner.this.setScanner(HTMLScanner.this.fContentScanner);
                                        HTMLScanner.this.setScannerState((short)0);
                                        return 0;
                                    }
                                    HTMLScanner.this.fCurrentEntity.rewind();
                                }
                                this.charBuffer_.clear().append("</").append(ename);
                            } else {
                                this.charBuffer_.clear().append("</");
                            }
                        } else {
                            this.charBuffer_.clearAndAppend('<');
                            if (!this.charBuffer_.appendCodePoint(c) && HTMLScanner.this.fReportErrors_) {
                                HTMLScanner.this.fErrorReporter.reportError("HTML1005", new Object[]{"&#" + c + ';'});
                            }
                        }
                        this.scanCharacters(this.charBuffer_);
                        HTMLScanner.this.setScannerState((short)0);
                        break;
                    }
                }
            } while (complete);
            return 0;
        }

        protected void scanCharacters(XMLString buffer) throws IOException {
            block0: while (true) {
                int c;
                if ((c = HTMLScanner.this.fCurrentEntity.read()) == -1 || c == 60 || c == 38) {
                    if (c == -1) break;
                    HTMLScanner.this.fCurrentEntity.rewind();
                    break;
                }
                if (c == 13 || c == 10) {
                    HTMLScanner.this.fCurrentEntity.rewind();
                    int newlines = HTMLScanner.this.fCurrentEntity.skipNewlines();
                    int i = 0;
                    while (true) {
                        if (i >= newlines) continue block0;
                        buffer.append('\n');
                        ++i;
                    }
                }
                if (buffer.appendCodePoint(c) || !HTMLScanner.this.fReportErrors_) continue;
                HTMLScanner.this.fErrorReporter.reportError("HTML1005", new Object[]{"&#" + c + ';'});
            }
            if (this.fStyle) {
                if (HTMLScanner.this.fStyleStripCommentDelims_) {
                    buffer.trimToContent("<!--", "-->");
                }
                if (HTMLScanner.this.fStyleStripCDATADelims_) {
                    buffer.trimToContent("<![CDATA[", "]]>");
                }
            }
            if (buffer.length() > 0 && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                HTMLScanner.this.fDocumentHandler.characters(buffer, HTMLScanner.this.locationAugs(HTMLScanner.this.fCurrentEntity));
            }
        }
    }

    public class ContentScanner
    implements Scanner {
        private final QName qName_ = new QName();
        private final XMLAttributesImpl attributes_ = new XMLAttributesImpl();
        private String scanStartElement_;

        @Override
        public int scan(boolean complete) throws IOException {
            boolean next;
            block6: do {
                next = false;
                switch (HTMLScanner.this.fScannerState) {
                    case 0: {
                        HTMLScanner.this.fBeginLineNumber = HTMLScanner.this.fCurrentEntity.getLineNumber();
                        HTMLScanner.this.fBeginColumnNumber = HTMLScanner.this.fCurrentEntity.getColumnNumber();
                        HTMLScanner.this.fBeginCharacterOffset = HTMLScanner.this.fCurrentEntity.getCharacterOffset();
                        int c = HTMLScanner.this.fCurrentEntity.read();
                        if (c == -1) {
                            this.eof();
                            continue block6;
                        }
                        if (c == 60) {
                            HTMLScanner.this.setScannerState((short)1);
                            next = true;
                            break;
                        }
                        if (c == 38) {
                            HTMLScanner.this.scanEntityRef(HTMLScanner.this.fStringBuffer, null, true);
                            break;
                        }
                        HTMLScanner.this.fCurrentEntity.rewind();
                        this.scanCharacters();
                        break;
                    }
                    case 1: {
                        int c = HTMLScanner.this.fCurrentEntity.read();
                        if (c == -1) {
                            if (HTMLScanner.this.fReportErrors_) {
                                HTMLScanner.this.fErrorReporter.reportError("HTML1003", null);
                            }
                            if (HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                                HTMLScanner.this.fStringBuffer.clearAndAppend('<');
                                HTMLScanner.this.fDocumentHandler.characters(HTMLScanner.this.fStringBuffer, null);
                            }
                            this.eof();
                            continue block6;
                        }
                        if (c == 33) {
                            if (HTMLScanner.this.fCurrentEntity.skip("--->") || HTMLScanner.this.fCurrentEntity.skip("-->") || HTMLScanner.this.fCurrentEntity.skip("->") || HTMLScanner.this.fCurrentEntity.skip(">")) {
                                HTMLScanner.this.fDocumentHandler.comment(XMLString.EMPTY, HTMLScanner.this.locationAugs(HTMLScanner.this.fCurrentEntity));
                            } else if (HTMLScanner.this.fCurrentEntity.skip("-!>")) {
                                XMLString str = new XMLString();
                                str.append("-!");
                                HTMLScanner.this.fDocumentHandler.comment(str, HTMLScanner.this.locationAugs(HTMLScanner.this.fCurrentEntity));
                            } else if (HTMLScanner.this.fCurrentEntity.skip("--")) {
                                if (1 == this.scanComment()) {
                                    this.eof();
                                    continue block6;
                                }
                            } else if (HTMLScanner.this.fCurrentEntity.skip("[CDATA[")) {
                                if (1 == this.scanCDATA()) {
                                    this.eof();
                                    continue block6;
                                }
                            } else if (HTMLScanner.this.fCurrentEntity.skip("DOCTYPE")) {
                                if (1 == HTMLScanner.this.scanDoctype()) {
                                    this.eof();
                                    continue block6;
                                }
                            } else {
                                if (HTMLScanner.this.fReportErrors_) {
                                    HTMLScanner.this.fErrorReporter.reportError("HTML1002", null);
                                }
                                HTMLScanner.this.fCurrentEntity.skipMarkup(true);
                            }
                        } else if (c == 63) {
                            if (1 == this.scanPI()) {
                                this.eof();
                                continue block6;
                            }
                        } else if (c == 47) {
                            this.scanEndElement();
                        } else {
                            HTMLElements.Element elem;
                            String enameLC;
                            String ename;
                            HTMLScanner.this.fCurrentEntity.rewind();
                            ++HTMLScanner.this.fElementCount;
                            HTMLScanner.this.fSingleBoolean[0] = false;
                            int scanStartElement = this.scanStartElement(HTMLScanner.this.fSingleBoolean);
                            if (1 == scanStartElement) {
                                this.eof();
                                continue block6;
                            }
                            if (0 == scanStartElement) {
                                ename = this.scanStartElement_;
                                enameLC = ename.toLowerCase(Locale.ROOT);
                            } else {
                                ename = null;
                                enameLC = null;
                            }
                            HTMLScanner.this.fBeginLineNumber = HTMLScanner.this.fCurrentEntity.getLineNumber();
                            HTMLScanner.this.fBeginColumnNumber = HTMLScanner.this.fCurrentEntity.getColumnNumber();
                            HTMLScanner.this.fBeginCharacterOffset = HTMLScanner.this.fCurrentEntity.getCharacterOffset();
                            if ("script".equals(enameLC)) {
                                if (!HTMLScanner.this.fAllowSelfclosingScript_) {
                                    HTMLScanner.this.setScanner(HTMLScanner.this.fScriptScanner);
                                    HTMLScanner.this.setScannerState((short)0);
                                    return 0;
                                }
                            } else if (!HTMLScanner.this.fAllowSelfclosingTags_ && !HTMLScanner.this.fAllowSelfclosingIframe_ && "iframe".equals(enameLC)) {
                                this.scanUntilEndTag("iframe");
                            } else if (!HTMLScanner.this.fParseNoScriptContent_ && "noscript".equals(enameLC)) {
                                this.scanUntilEndTag("noscript");
                            } else if ("noframes".equals(enameLC)) {
                                this.scanUntilEndTag("noframes");
                            } else if ("noembed".equals(enameLC)) {
                                this.scanUntilEndTag("noembed");
                            } else if ("title".equals(enameLC) && HTMLScanner.this.htmlConfiguration_.getTagBalancer().fOpenedSvg) {
                                HTMLScanner.this.setScannerState((short)0);
                            } else if ("plaintext".equals(enameLC)) {
                                HTMLScanner.this.setScanner(new PlainTextScanner());
                            } else if (ename != null && (elem = HTMLScanner.this.htmlConfiguration_.getHtmlElements().getElementLC(enameLC, null)) != null && elem.isSpecial()) {
                                HTMLScanner.this.setScanner(HTMLScanner.this.fSpecialScanner.setElementName(ename));
                                HTMLScanner.this.setScannerState((short)0);
                                return 0;
                            }
                        }
                        HTMLScanner.this.setScannerState((short)0);
                        break;
                    }
                    case 10: {
                        if (HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                            HTMLScanner.this.fDocumentHandler.startDocument(HTMLScanner.this, HTMLScanner.this.fIANAEncoding, new NamespaceSupport(), HTMLScanner.this.locationAugs(HTMLScanner.this.fCurrentEntity));
                        }
                        if (HTMLScanner.this.fInsertDoctype_) {
                            HTMLScanner.this.fDocumentHandler.doctypeDecl(2 == HTMLScanner.this.fNamesElems ? "html" : "HTML", HTMLScanner.this.fDoctypePubid, HTMLScanner.this.fDoctypeSysid, HTMLScanner.this.synthesizedAugs());
                        }
                        HTMLScanner.this.setScannerState((short)0);
                        break;
                    }
                    case 11: {
                        if (HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth && complete) {
                            HTMLScanner.this.fDocumentHandler.endDocument(HTMLScanner.this.locationAugs(HTMLScanner.this.fCurrentEntity));
                        }
                        return 2;
                    }
                    default: {
                        throw new RuntimeException("unknown scanner state: " + HTMLScanner.this.fScannerState);
                    }
                }
                if (!(HTMLScanner.this.fScanner instanceof PlainTextScanner)) continue;
                return 0;
            } while (next || complete);
            return 0;
        }

        private void eof() {
            if (HTMLScanner.this.fCurrentEntityStack.isEmpty()) {
                HTMLScanner.this.setScannerState((short)11);
            } else {
                HTMLScanner.this.fCurrentEntity = HTMLScanner.this.fCurrentEntityStack.pop();
            }
        }

        private void scanUntilEndTag(String tagName) throws IOException {
            int c;
            HTMLScanner.this.fScanUntilEndTag.clear();
            String end = "/" + tagName;
            int lengthToScan = tagName.length() + 2;
            while ((c = HTMLScanner.this.fCurrentEntity.read()) != -1) {
                String next;
                if (c == 60 && (next = HTMLScanner.this.fCurrentEntity.nextContent(lengthToScan) + " ").length() >= lengthToScan && end.equalsIgnoreCase(next.substring(0, end.length())) && ('>' == next.charAt(lengthToScan - 1) || Character.isWhitespace(next.charAt(lengthToScan - 1)))) {
                    HTMLScanner.this.fCurrentEntity.rewind();
                    break;
                }
                if (c == 10 || c == 13) {
                    HTMLScanner.this.fCurrentEntity.rewind();
                    int newlines = HTMLScanner.this.fCurrentEntity.skipNewlines();
                    for (int i = 0; i < newlines; ++i) {
                        HTMLScanner.this.fScanUntilEndTag.append('\n');
                    }
                    continue;
                }
                if (HTMLScanner.this.fScanUntilEndTag.appendCodePoint(c) || !HTMLScanner.this.fReportErrors_) continue;
                HTMLScanner.this.fErrorReporter.reportError("HTML1005", new Object[]{"&#" + c + ';'});
            }
            if (HTMLScanner.this.fScanUntilEndTag.length() > 0) {
                HTMLScanner.this.fDocumentHandler.characters(HTMLScanner.this.fScanUntilEndTag, HTMLScanner.this.locationAugs(HTMLScanner.this.fCurrentEntity));
            }
        }

        protected void scanCharacters() throws IOException {
            int newlines;
            HTMLScanner.this.fStringBuffer.clear();
            while ((newlines = HTMLScanner.this.fCurrentEntity.skipNewlines()) != 0 || HTMLScanner.this.fCurrentEntity.offset_ != HTMLScanner.this.fCurrentEntity.length_) {
                int next;
                int offset;
                for (int i = offset = HTMLScanner.this.fCurrentEntity.offset_ - newlines; i < HTMLScanner.this.fCurrentEntity.offset_; ++i) {
                    HTMLScanner.this.fCurrentEntity.buffer_[i] = 10;
                }
                while (HTMLScanner.this.fCurrentEntity.hasNext()) {
                    char c = HTMLScanner.this.fCurrentEntity.getNextChar();
                    if (c != '<' && c != '&' && c != '\n' && c != '\r') continue;
                    HTMLScanner.this.fCurrentEntity.rewind();
                    break;
                }
                if (HTMLScanner.this.fCurrentEntity.offset_ > offset && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                    HTMLScanner.this.fStringBuffer.append(HTMLScanner.this.fCurrentEntity.buffer_, offset, HTMLScanner.this.fCurrentEntity.offset_ - offset);
                }
                boolean hasNext = HTMLScanner.this.fCurrentEntity.offset_ < HTMLScanner.this.fCurrentEntity.buffer_.length;
                int n = next = hasNext ? (int)HTMLScanner.this.fCurrentEntity.getCurrentChar() : -1;
                if (next != 38 && next != 60 && next != -1) continue;
                break;
            }
            if (HTMLScanner.this.fStringBuffer.length() != 0) {
                HTMLScanner.this.fDocumentHandler.characters(HTMLScanner.this.fStringBuffer, HTMLScanner.this.locationAugs(HTMLScanner.this.fCurrentEntity));
            }
        }

        protected int scanCDATA() throws IOException {
            HTMLScanner.this.fStringBuffer.clear();
            if (HTMLScanner.this.fCDATASections_) {
                if (HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                    HTMLScanner.this.fDocumentHandler.startCDATA(HTMLScanner.this.locationAugs(HTMLScanner.this.fCurrentEntity));
                }
            } else {
                HTMLScanner.this.fStringBuffer.append("[CDATA[");
            }
            int scanCData = this.scanCDataContent(HTMLScanner.this.fStringBuffer);
            if (HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                if (HTMLScanner.this.fCDATASections_) {
                    HTMLScanner.this.fDocumentHandler.characters(HTMLScanner.this.fStringBuffer, HTMLScanner.this.locationAugs(HTMLScanner.this.fCurrentEntity));
                    HTMLScanner.this.fDocumentHandler.endCDATA(HTMLScanner.this.locationAugs(HTMLScanner.this.fCurrentEntity));
                } else {
                    HTMLScanner.this.fDocumentHandler.comment(HTMLScanner.this.fStringBuffer, HTMLScanner.this.locationAugs(HTMLScanner.this.fCurrentEntity));
                }
            }
            return scanCData;
        }

        protected int scanComment() throws IOException {
            HTMLScanner.this.fScanComment.clear();
            int scanComment = this.scanCommentContent(HTMLScanner.this.fScanComment);
            if (HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                HTMLScanner.this.fDocumentHandler.comment(HTMLScanner.this.fScanComment, HTMLScanner.this.locationAugs(HTMLScanner.this.fCurrentEntity));
            }
            return scanComment;
        }

        protected int scanCommentContent(XMLString buffer) throws IOException {
            int c;
            block0: while (true) {
                int i;
                if ((c = HTMLScanner.this.fCurrentEntity.read()) == -1) {
                    if (HTMLScanner.this.fReportErrors_) {
                        HTMLScanner.this.fErrorReporter.reportError("HTML1007", null);
                    }
                    return 1;
                }
                if (c == 45) {
                    int count = 1;
                    while ((c = HTMLScanner.this.fCurrentEntity.read()) == 45) {
                        ++count;
                    }
                    if (c == -1) {
                        if (!HTMLScanner.this.fReportErrors_) break;
                        HTMLScanner.this.fErrorReporter.reportError("HTML1007", null);
                        break;
                    }
                    if (count < 2) {
                        buffer.append('-');
                        HTMLScanner.this.fCurrentEntity.rewind();
                        continue;
                    }
                    if (c == 33) {
                        c = HTMLScanner.this.fCurrentEntity.read();
                        if (c == -1) {
                            if (HTMLScanner.this.fReportErrors_) {
                                HTMLScanner.this.fErrorReporter.reportError("HTML1007", null);
                            }
                            return 1;
                        }
                        if (c == 62) {
                            for (i = 0; i < count - 2; ++i) {
                                buffer.append('-');
                            }
                            break;
                        }
                        for (i = 0; i < count; ++i) {
                            buffer.append('-');
                        }
                        buffer.append('!');
                        HTMLScanner.this.fCurrentEntity.rewind();
                        continue;
                    }
                    if (c == 62) {
                        for (i = 0; i < count - 2; ++i) {
                            buffer.append('-');
                        }
                        break;
                    }
                    for (i = 0; i < count; ++i) {
                        buffer.append('-');
                    }
                    HTMLScanner.this.fCurrentEntity.rewind();
                    continue;
                }
                if (c == 10 || c == 13) {
                    HTMLScanner.this.fCurrentEntity.rewind();
                    int newlines = HTMLScanner.this.fCurrentEntity.skipNewlines();
                    i = 0;
                    while (true) {
                        if (i >= newlines) continue block0;
                        buffer.append('\n');
                        ++i;
                    }
                }
                if (buffer.appendCodePoint(c) || !HTMLScanner.this.fReportErrors_) continue;
                HTMLScanner.this.fErrorReporter.reportError("HTML1005", new Object[]{"&#" + c + ';'});
            }
            return c == -1 ? 1 : 0;
        }

        protected int scanCDataContent(XMLString xmlString) throws IOException {
            int c;
            block0: while (true) {
                int i;
                if ((c = HTMLScanner.this.fCurrentEntity.read()) == -1) {
                    if (!HTMLScanner.this.fReportErrors_) break;
                    HTMLScanner.this.fErrorReporter.reportError("HTML1007", null);
                    break;
                }
                if (c == 93) {
                    int count = 1;
                    while ((c = HTMLScanner.this.fCurrentEntity.read()) == 93) {
                        ++count;
                    }
                    if (c == -1) {
                        if (!HTMLScanner.this.fReportErrors_) break;
                        HTMLScanner.this.fErrorReporter.reportError("HTML1007", null);
                        break;
                    }
                    if (count < 2) {
                        xmlString.append(']');
                        HTMLScanner.this.fCurrentEntity.rewind();
                        continue;
                    }
                    if (c != 62) {
                        for (i = 0; i < count; ++i) {
                            xmlString.append(']');
                        }
                        HTMLScanner.this.fCurrentEntity.rewind();
                        continue;
                    }
                    for (i = 0; i < count - 2; ++i) {
                        xmlString.append(']');
                    }
                    break;
                }
                if (HTMLScanner.this.fCDATAEarlyClosing_ && c == 62) {
                    return 2;
                }
                if (c == 10 || c == 13) {
                    HTMLScanner.this.fCurrentEntity.rewind();
                    int newlines = HTMLScanner.this.fCurrentEntity.skipNewlines();
                    i = 0;
                    while (true) {
                        if (i >= newlines) continue block0;
                        xmlString.append('\n');
                        ++i;
                    }
                }
                if (xmlString.appendCodePoint(c) || !HTMLScanner.this.fReportErrors_) continue;
                HTMLScanner.this.fErrorReporter.reportError("HTML1005", new Object[]{"&#" + c + ';'});
            }
            if (!HTMLScanner.this.fCDATASections_) {
                HTMLScanner.this.fStringBuffer.append("]]");
            }
            return c == -1 ? 1 : 2;
        }

        protected int scanPI() throws IOException {
            boolean xmlDeclNow;
            String target;
            if (HTMLScanner.this.fReportErrors_) {
                HTMLScanner.this.fErrorReporter.reportWarning("HTML1008", null);
            }
            if ((target = HTMLScanner.this.scanName(true, HTMLScanner.this.fNamesElems)) != null && !"xml".equalsIgnoreCase(target)) {
                int c;
                while ((c = HTMLScanner.this.fCurrentEntity.read()) != -1) {
                    if (c == 13 || c == 10) {
                        if (c == 13) {
                            c = HTMLScanner.this.fCurrentEntity.read();
                            if (c == -1) break;
                            if (c != 10) {
                                HTMLScanner.this.fCurrentEntity.rewind();
                            }
                        }
                        HTMLScanner.this.fCurrentEntity.incLine();
                        continue;
                    }
                    if (c == 32 || c == 9) continue;
                    HTMLScanner.this.fCurrentEntity.rewind();
                    break;
                }
                HTMLScanner.this.fStringBuffer.clear();
                while ((c = HTMLScanner.this.fCurrentEntity.read()) != -1) {
                    if (c == 63 || c == 47) {
                        char c0 = (char)c;
                        c = HTMLScanner.this.fCurrentEntity.read();
                        if (c == -1 || c == 62) break;
                        HTMLScanner.this.fStringBuffer.append(c0);
                        HTMLScanner.this.fCurrentEntity.rewind();
                        continue;
                    }
                    if (c == 13 || c == 10) {
                        HTMLScanner.this.fStringBuffer.append('\n');
                        if (c == 13) {
                            c = HTMLScanner.this.fCurrentEntity.read();
                            if (c == -1) break;
                            if (c != 10) {
                                HTMLScanner.this.fCurrentEntity.rewind();
                            }
                        }
                        HTMLScanner.this.fCurrentEntity.incLine();
                        continue;
                    }
                    if (c == 62) {
                        HTMLScanner.this.fStringBuffer.append(target);
                        HTMLScanner.this.fDocumentHandler.comment(HTMLScanner.this.fStringBuffer, HTMLScanner.this.locationAugs(HTMLScanner.this.fCurrentEntity));
                        return 0;
                    }
                    if (HTMLScanner.this.fStringBuffer.appendCodePoint(c) || !HTMLScanner.this.fReportErrors_) continue;
                    HTMLScanner.this.fErrorReporter.reportError("HTML1005", new Object[]{"&#" + c + ';'});
                }
                HTMLScanner.this.fDocumentHandler.processingInstruction(target, HTMLScanner.this.fStringBuffer, HTMLScanner.this.locationAugs(HTMLScanner.this.fCurrentEntity));
                return c == -1 ? 1 : 0;
            }
            int beginLineNumber = HTMLScanner.this.fBeginLineNumber;
            int beginColumnNumber = HTMLScanner.this.fBeginColumnNumber;
            int beginCharacterOffset = HTMLScanner.this.fBeginCharacterOffset;
            this.attributes_.removeAllAttributes();
            int aindex = 0;
            int scanAttribute = this.scanAttribute(this.attributes_, HTMLScanner.this.fSingleBoolean);
            while (0 == scanAttribute) {
                if (this.attributes_.getValue(aindex).isEmpty()) {
                    this.attributes_.removeAttributeAt(aindex);
                } else {
                    this.attributes_.getName(aindex, this.qName_);
                    this.qName_.setRawname(this.qName_.getRawname().toLowerCase(Locale.ROOT));
                    this.attributes_.setName(aindex, this.qName_);
                    ++aindex;
                }
                scanAttribute = this.scanAttribute(this.attributes_, HTMLScanner.this.fSingleBoolean);
            }
            if (1 == scanAttribute) {
                return 1;
            }
            String version = this.attributes_.getValue("version");
            String encoding = this.attributes_.getValue("encoding");
            String standalone = this.attributes_.getValue("standalone");
            boolean bl = xmlDeclNow = HTMLScanner.this.fIgnoreSpecifiedCharset_ || !this.changeEncoding(encoding);
            if (xmlDeclNow) {
                HTMLScanner.this.fBeginLineNumber = beginLineNumber;
                HTMLScanner.this.fBeginColumnNumber = beginColumnNumber;
                HTMLScanner.this.fBeginCharacterOffset = beginCharacterOffset;
                HTMLScanner.this.fDocumentHandler.xmlDecl(version, encoding, standalone, HTMLScanner.this.locationAugs(HTMLScanner.this.fCurrentEntity));
            }
            return 0;
        }

        protected int scanStartElement(boolean[] empty) throws IOException {
            int length;
            this.scanStartElement_ = HTMLScanner.this.scanTagName();
            int n = length = this.scanStartElement_ != null ? this.scanStartElement_.length() : 0;
            if (length == 0) {
                if (HTMLScanner.this.fReportErrors_) {
                    HTMLScanner.this.fErrorReporter.reportError("HTML1009", null);
                }
                if (HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                    HTMLScanner.this.fStringBuffer.clearAndAppend('<');
                    HTMLScanner.this.fDocumentHandler.characters(HTMLScanner.this.fStringBuffer, null);
                }
                return 2;
            }
            if (this.attributes_.getLength() != 0) {
                this.attributes_.removeAllAttributes();
            }
            int beginLineNumber = HTMLScanner.this.fBeginLineNumber;
            int beginColumnNumber = HTMLScanner.this.fBeginColumnNumber;
            int beginCharacterOffset = HTMLScanner.this.fBeginCharacterOffset;
            int scanAttribute = this.scanAttribute(this.attributes_, empty);
            while (0 == scanAttribute) {
                scanAttribute = this.scanAttribute(this.attributes_, empty);
            }
            if (1 == scanAttribute) {
                return 1;
            }
            HTMLScanner.this.fBeginLineNumber = beginLineNumber;
            HTMLScanner.this.fBeginColumnNumber = beginColumnNumber;
            HTMLScanner.this.fBeginCharacterOffset = beginCharacterOffset;
            if (HTMLScanner.this.fElementDepth == -1 && HTMLScanner.this.fByteStream != null) {
                String enameLC = this.scanStartElement_.toLowerCase(Locale.ROOT);
                if (!HTMLScanner.this.fIgnoreSpecifiedCharset_ && "meta".equals(enameLC)) {
                    String httpEquiv = HTMLScanner.getValue(this.attributes_, "http-equiv");
                    if ("content-type".equalsIgnoreCase(httpEquiv)) {
                        int index1;
                        String content = HTMLScanner.getValue(this.attributes_, "content");
                        if (content != null && (index1 = (content = this.removeSpaces(content)).toLowerCase(Locale.ROOT).indexOf("charset=")) != -1) {
                            int index2 = content.indexOf(59, index1);
                            String charset = index2 != -1 ? content.substring(index1 + 8, index2) : content.substring(index1 + 8);
                            this.changeEncoding(charset);
                        }
                    } else {
                        String metaCharset = HTMLScanner.getValue(this.attributes_, "charset");
                        if (metaCharset != null) {
                            this.changeEncoding(metaCharset);
                        }
                    }
                } else if ("body".equals(enameLC)) {
                    HTMLScanner.this.fByteStream.clear();
                    HTMLScanner.this.fByteStream = null;
                } else {
                    HTMLElements.Element element = HTMLScanner.this.htmlConfiguration_.getHtmlElements().getElementLC(enameLC, null);
                    if (element == null || element.parent != null && element.parent.length > 0 && element.parent[0].code == 18) {
                        HTMLScanner.this.fByteStream.clear();
                        HTMLScanner.this.fByteStream = null;
                    }
                }
            }
            if (HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                this.qName_.setValues(null, this.scanStartElement_, this.scanStartElement_, null);
                if (empty[0] && !"br".equalsIgnoreCase(this.scanStartElement_)) {
                    HTMLScanner.this.fDocumentHandler.emptyElement(this.qName_, this.attributes_, HTMLScanner.this.locationAugs(HTMLScanner.this.fCurrentEntity));
                } else {
                    HTMLScanner.this.fDocumentHandler.startElement(this.qName_, this.attributes_, HTMLScanner.this.locationAugs(HTMLScanner.this.fCurrentEntity));
                }
            }
            return 0;
        }

        private String removeSpaces(String content) {
            StringBuilder sb = null;
            for (int i = content.length() - 1; i >= 0; --i) {
                if (!Character.isWhitespace(content.charAt(i))) continue;
                if (sb == null) {
                    sb = new StringBuilder(content);
                }
                sb.deleteCharAt(i);
            }
            return sb == null ? content : sb.toString();
        }

        private boolean changeEncoding(String charset) {
            if (charset == null || HTMLScanner.this.fByteStream == null) {
                return false;
            }
            charset = charset.trim();
            boolean encodingChanged = false;
            try {
                String javaEncoding = HTMLScanner.this.fEncodingTranslator.encodingNameFromLabel(charset);
                if (javaEncoding == null || !"replacement".equalsIgnoreCase(javaEncoding) && !Charset.isSupported(javaEncoding)) {
                    javaEncoding = charset;
                    if (HTMLScanner.this.fReportErrors_) {
                        HTMLScanner.this.fErrorReporter.reportError("HTML1001", new Object[]{charset});
                    }
                }
                if (!javaEncoding.equals(HTMLScanner.this.fJavaEncoding)) {
                    if ("replacement".equalsIgnoreCase(javaEncoding)) {
                        HTMLScanner.this.fJavaEncoding = javaEncoding;
                        HTMLScanner.this.fCurrentEntity.setStream(new StringReader("\ufffd"), javaEncoding);
                        HTMLScanner.this.fByteStream.playback();
                        HTMLScanner.this.fElementDepth = 0;
                        HTMLScanner.this.fElementCount = 0;
                        encodingChanged = true;
                    } else if (!HTMLScanner.isEncodingCompatible(javaEncoding, HTMLScanner.this.fJavaEncoding)) {
                        if (HTMLScanner.this.fReportErrors_) {
                            HTMLScanner.this.fErrorReporter.reportError("HTML1015", new Object[]{javaEncoding, HTMLScanner.this.fJavaEncoding});
                        }
                    } else {
                        HTMLScanner.this.fJavaEncoding = javaEncoding;
                        HTMLScanner.this.fCurrentEntity.setStream(new InputStreamReader((InputStream)HTMLScanner.this.fByteStream, javaEncoding), javaEncoding);
                        HTMLScanner.this.fByteStream.playback();
                        HTMLScanner.this.fElementDepth = HTMLScanner.this.fElementCount;
                        HTMLScanner.this.fElementCount = 0;
                        encodingChanged = true;
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                if (HTMLScanner.this.fReportErrors_) {
                    HTMLScanner.this.fErrorReporter.reportError("HTML1010", new Object[]{charset});
                }
                HTMLScanner.this.fByteStream.clear();
                HTMLScanner.this.fByteStream = null;
            }
            return encodingChanged;
        }

        protected int scanAttribute(XMLAttributesImpl attributes, boolean[] empty) throws IOException {
            boolean skippedSpaces = HTMLScanner.this.fCurrentEntity.skipSpaces();
            HTMLScanner.this.fBeginLineNumber = HTMLScanner.this.fCurrentEntity.getLineNumber();
            HTMLScanner.this.fBeginColumnNumber = HTMLScanner.this.fCurrentEntity.getColumnNumber();
            HTMLScanner.this.fBeginCharacterOffset = HTMLScanner.this.fCurrentEntity.getCharacterOffset();
            int c = HTMLScanner.this.fCurrentEntity.read();
            if (c <= 62) {
                if (c == -1) {
                    if (HTMLScanner.this.fReportErrors_) {
                        HTMLScanner.this.fErrorReporter.reportError("HTML1007", null);
                    }
                    return 1;
                }
                if (c == 62) {
                    return 2;
                }
                if (c == 47 && HTMLScanner.this.fCurrentEntity.hasNext()) {
                    c = HTMLScanner.this.fCurrentEntity.getNextChar();
                    if (c == 62) {
                        empty[0] = true;
                        return 2;
                    }
                    HTMLScanner.this.fCurrentEntity.rewind();
                }
                if (c == 60 && HTMLScanner.this.fReportErrors_) {
                    HTMLScanner.this.fErrorReporter.reportError("HTML1016", null);
                }
            }
            HTMLScanner.this.fCurrentEntity.rewind();
            String aname = HTMLScanner.this.scanName(false, HTMLScanner.this.fNamesAttrs);
            if (aname == null) {
                if (HTMLScanner.this.fReportErrors_) {
                    HTMLScanner.this.fErrorReporter.reportError("HTML1011", null);
                }
                HTMLScanner.this.fCurrentEntity.skipSpaces();
                if (!HTMLScanner.this.fCurrentEntity.hasNext() || '=' != HTMLScanner.this.fCurrentEntity.getNextChar()) {
                    HTMLScanner.this.fCurrentEntity.rewind();
                    empty[0] = HTMLScanner.this.fCurrentEntity.skipMarkup(false);
                    return 2;
                }
                aname = '=' + HTMLScanner.this.scanName(false, HTMLScanner.this.fNamesElems);
            }
            if (HTMLScanner.this.fReportErrors_ && !skippedSpaces) {
                HTMLScanner.this.fErrorReporter.reportError("HTML1013", new Object[]{aname});
            }
            HTMLScanner.this.fCurrentEntity.skipSpaces();
            c = HTMLScanner.this.fCurrentEntity.read();
            if (c == -1) {
                if (HTMLScanner.this.fReportErrors_) {
                    HTMLScanner.this.fErrorReporter.reportError("HTML1007", null);
                }
                return 1;
            }
            if (c == 47) {
                this.qName_.setValues(null, aname, aname, null);
                attributes.addAttribute(this.qName_, "CDATA", "", true);
                return 0;
            }
            if (c == 62) {
                this.qName_.setValues(null, aname, aname, null);
                attributes.addAttribute(this.qName_, "CDATA", "", true);
                return 2;
            }
            if (c == 61) {
                HTMLScanner.this.fCurrentEntity.skipSpaces();
                c = HTMLScanner.this.fCurrentEntity.read();
                if (c == 34 || c == 39) {
                    XMLString attribValue = HTMLScanner.this.fStringBuffer.clear();
                    if (HTMLScanner.this.fPlainAttributeValues_) {
                        XMLString plainAttribValue = HTMLScanner.this.fStringBufferPlainAttribValue.clear();
                        if (1 == this.scanAttributeQuotedValue(c, HTMLScanner.this.fCurrentEntity, attribValue, plainAttribValue, HTMLScanner.this.fNormalizeAttributes_)) {
                            return 1;
                        }
                        if (HTMLScanner.this.fNormalizeAttributes_ && attribValue.length() > 0) {
                            attribValue.trimTrailing();
                        }
                        this.qName_.setValues(null, aname, aname, null);
                        attributes.addAttribute(this.qName_, "CDATA", attribValue.toString(), plainAttribValue.toString(), true);
                    } else {
                        if (1 == this.scanAttributeQuotedValue(c, HTMLScanner.this.fCurrentEntity, attribValue, null, HTMLScanner.this.fNormalizeAttributes_)) {
                            return 1;
                        }
                        if (HTMLScanner.this.fNormalizeAttributes_ && attribValue.length() > 0) {
                            attribValue.trimTrailing();
                        }
                        this.qName_.setValues(null, aname, aname, null);
                        attributes.addAttribute(this.qName_, "CDATA", attribValue.toString(), true);
                    }
                    return 0;
                }
                if (c == -1) {
                    if (HTMLScanner.this.fReportErrors_) {
                        HTMLScanner.this.fErrorReporter.reportError("HTML1007", null);
                    }
                    return 1;
                }
                if (c == 62) {
                    this.qName_.setValues(null, aname, aname, null);
                    attributes.addAttribute(this.qName_, "CDATA", "", true);
                    return 2;
                }
                HTMLScanner.this.fCurrentEntity.rewind();
                XMLString attribValue = HTMLScanner.this.fStringBuffer.clear();
                if (HTMLScanner.this.fPlainAttributeValues_) {
                    XMLString nonNormalizedAttribValue = HTMLScanner.this.fStringBufferPlainAttribValue.clear();
                    if (1 == this.scanAttributeUnquotedValue(HTMLScanner.this.fCurrentEntity, attribValue, nonNormalizedAttribValue)) {
                        return 1;
                    }
                    this.qName_.setValues(null, aname, aname, null);
                    attributes.addAttribute(this.qName_, "CDATA", attribValue.toString(), nonNormalizedAttribValue.toString(), true);
                } else {
                    if (1 == this.scanAttributeUnquotedValue(HTMLScanner.this.fCurrentEntity, attribValue, null)) {
                        return 1;
                    }
                    this.qName_.setValues(null, aname, aname, null);
                    attributes.addAttribute(this.qName_, "CDATA", attribValue.toString(), true);
                }
                return 0;
            }
            this.qName_.setValues(null, aname, aname, null);
            attributes.addAttribute(this.qName_, "CDATA", "", true);
            HTMLScanner.this.fCurrentEntity.rewind();
            return 0;
        }

        protected int scanAttributeUnquotedValue(CurrentEntity currentEntity, XMLString attribValue, XMLString plainAttribValue) throws IOException {
            while (true) {
                int c;
                if ((c = currentEntity.read()) == -1) {
                    if (HTMLScanner.this.fReportErrors_) {
                        HTMLScanner.this.fErrorReporter.reportError("HTML1007", null);
                    }
                    return 1;
                }
                if (c == 62 || Character.isWhitespace(c)) break;
                if (c == 38) {
                    HTMLScanner.this.scanEntityRef(HTMLScanner.this.fStringBufferEntityRef, plainAttribValue, false);
                    attribValue.append(HTMLScanner.this.fStringBufferEntityRef);
                    continue;
                }
                if (!attribValue.appendCodePoint(c) && HTMLScanner.this.fReportErrors_) {
                    HTMLScanner.this.fErrorReporter.reportError("HTML1005", new Object[]{"&#" + c + ';'});
                }
                if (plainAttribValue == null) continue;
                plainAttribValue.appendCodePoint(c);
            }
            currentEntity.rewind();
            return 0;
        }

        protected int scanAttributeQuotedValue(int currentQuote, CurrentEntity currentEntity, XMLString attribValue, XMLString plainAttribValue, boolean normalizeAttributes) throws IOException {
            boolean isStart = true;
            boolean prevSpace = false;
            while (true) {
                boolean acceptSpace = !normalizeAttributes || !isStart && !prevSpace;
                int c = currentEntity.read();
                if (c == -1) {
                    if (HTMLScanner.this.fReportErrors_) {
                        HTMLScanner.this.fErrorReporter.reportError("HTML1007", null);
                    }
                    return 1;
                }
                if (c == 32 || c == 9) {
                    if (acceptSpace) {
                        attribValue.append((char)(normalizeAttributes ? 32 : (char)c));
                    }
                    if (plainAttribValue != null) {
                        plainAttribValue.append((char)c);
                    }
                    prevSpace = true;
                    continue;
                }
                if (c == 10) {
                    if (acceptSpace) {
                        attribValue.append(normalizeAttributes ? (char)' ' : '\n');
                    }
                    if (plainAttribValue != null) {
                        plainAttribValue.append('\n');
                    }
                    currentEntity.incLine();
                    prevSpace = true;
                    continue;
                }
                if (c == 13) {
                    int c2 = currentEntity.read();
                    if (c2 != 10 && c2 != -1) {
                        currentEntity.rewind();
                    }
                    if (acceptSpace) {
                        attribValue.append(normalizeAttributes ? (char)' ' : '\n');
                    }
                    if (plainAttribValue != null) {
                        plainAttribValue.append('\n');
                    }
                    currentEntity.incLine();
                    prevSpace = true;
                    continue;
                }
                if (c == 38) {
                    isStart = false;
                    int ce = HTMLScanner.this.scanEntityRef(HTMLScanner.this.fStringBufferEntityRef, plainAttribValue, false);
                    if (ce != -1) {
                        if (!attribValue.appendCodePoint(ce) && HTMLScanner.this.fReportErrors_) {
                            HTMLScanner.this.fErrorReporter.reportError("HTML1005", new Object[]{"&#" + ce + ';'});
                        }
                    } else {
                        attribValue.append(HTMLScanner.this.fStringBufferEntityRef);
                    }
                    prevSpace = false;
                    continue;
                }
                if (c == currentQuote) break;
                isStart = false;
                if (!attribValue.appendCodePoint(c) && HTMLScanner.this.fReportErrors_) {
                    HTMLScanner.this.fErrorReporter.reportError("HTML1005", new Object[]{"&#" + c + ';'});
                }
                if (plainAttribValue != null) {
                    plainAttribValue.appendCodePoint(c);
                }
                prevSpace = false;
            }
            return 0;
        }

        protected void scanEndElement() throws IOException {
            String ename = HTMLScanner.this.scanTagName();
            if (HTMLScanner.this.fReportErrors_ && ename == null) {
                HTMLScanner.this.fErrorReporter.reportError("HTML1012", null);
            }
            HTMLScanner.this.fCurrentEntity.skipMarkup(false);
            if (ename != null && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                this.qName_.setValues(null, ename, ename, null);
                HTMLScanner.this.fDocumentHandler.endElement(this.qName_, HTMLScanner.this.locationAugs(HTMLScanner.this.fCurrentEntity));
            }
        }
    }

    private static enum ScanScriptState {
        DATA,
        ESCAPED,
        ESCAPED_LT,
        DOUBLE_ESCAPED,
        DOUBLE_ESCAPED_LT;

    }

    static final class CurrentEntity {
        private Reader reader_;
        String encoding_;
        public final String publicId;
        public final String baseSystemId;
        public final String literalSystemId;
        final String systemId;
        public final String version = "1.0";
        private int lineNumber_ = 1;
        private int columnNumber_ = 1;
        private int characterOffset_ = 0;
        char[] buffer_;
        int offset_ = 0;
        int length_ = 0;
        private boolean endReached_ = false;

        CurrentEntity(Reader reader, int readerBufferSize, String encoding, String publicId, String baseSystemId, String literalSystemId, String systemId) {
            this.reader_ = reader;
            this.buffer_ = new char[readerBufferSize];
            this.encoding_ = encoding;
            this.publicId = publicId;
            this.baseSystemId = baseSystemId;
            this.literalSystemId = literalSystemId;
            this.systemId = systemId;
        }

        char getCurrentChar() {
            return this.buffer_[this.offset_];
        }

        char getNextChar() {
            ++this.characterOffset_;
            ++this.columnNumber_;
            return this.buffer_[this.offset_++];
        }

        void closeQuietly() {
            try {
                this.reader_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        boolean hasNext() {
            return this.offset_ < this.length_;
        }

        int load(int loadOffset) throws IOException {
            int count;
            if (loadOffset == this.buffer_.length) {
                int adjust = this.buffer_.length / 4;
                char[] array = new char[this.buffer_.length + adjust];
                System.arraycopy(this.buffer_, 0, array, 0, this.length_);
                this.buffer_ = array;
            }
            if ((count = this.reader_.read(this.buffer_, loadOffset, this.buffer_.length - loadOffset)) == -1) {
                this.length_ = loadOffset;
                this.endReached_ = true;
            } else {
                this.length_ = count + loadOffset;
            }
            this.offset_ = loadOffset;
            return count;
        }

        int loadWholeBuffer() throws IOException {
            int count = this.reader_.read(this.buffer_, 0, this.buffer_.length);
            if (count == -1) {
                this.length_ = 0;
                this.endReached_ = true;
            } else {
                this.length_ = count;
            }
            this.offset_ = 0;
            return count;
        }

        int read() throws IOException {
            if (this.offset_ == this.length_) {
                if (this.endReached_) {
                    return -1;
                }
                if (this.loadWholeBuffer() == -1) {
                    return -1;
                }
            }
            char c = this.buffer_[this.offset_];
            ++this.offset_;
            ++this.characterOffset_;
            ++this.columnNumber_;
            return c;
        }

        protected String nextContent(int len) throws IOException {
            int c;
            int nbRead;
            int originalOffset = this.offset_;
            int originalColumnNumber = this.getColumnNumber();
            int originalCharacterOffset = this.getCharacterOffset();
            char[] buff = new char[len];
            for (nbRead = 0; nbRead < len && (this.offset_ != this.length_ || this.load(this.length_) != -1) && (c = this.read()) != -1; ++nbRead) {
                buff[nbRead] = (char)c;
            }
            this.offset_ = originalOffset;
            this.columnNumber_ = originalColumnNumber;
            this.characterOffset_ = originalCharacterOffset;
            return new String(buff, 0, nbRead);
        }

        protected int readPreservingBufferContent() throws IOException {
            if (this.offset_ == this.length_ && this.load(this.length_) == -1) {
                return -1;
            }
            char c = this.getNextChar();
            return c;
        }

        private void debugBufferIfNeeded(String prefix) {
            this.debugBufferIfNeeded(prefix, "");
        }

        private void debugBufferIfNeeded(String prefix, String suffix) {
            System.out.print(prefix);
            System.out.print('[');
            System.out.print(this.length_);
            System.out.print(' ');
            System.out.print(this.offset_);
            if (this.length_ > 0) {
                System.out.print(" \"");
                block6: for (int i = 0; i < this.length_; ++i) {
                    if (i == this.offset_) {
                        System.out.print('^');
                    }
                    char c = this.buffer_[i];
                    switch (c) {
                        case '\r': {
                            System.out.print("\\r");
                            continue block6;
                        }
                        case '\n': {
                            System.out.print("\\n");
                            continue block6;
                        }
                        case '\t': {
                            System.out.print("\\t");
                            continue block6;
                        }
                        case '\"': {
                            System.out.print("\\\"");
                            continue block6;
                        }
                        default: {
                            System.out.print(c);
                        }
                    }
                }
                if (this.offset_ == this.length_) {
                    System.out.print('^');
                }
                System.out.print('\"');
            }
            System.out.print(']');
            System.out.print(suffix);
            System.out.println();
        }

        void setStream(Reader inputStreamReader, String encoding) {
            this.reader_ = inputStreamReader;
            this.offset_ = 0;
            this.length_ = 0;
            this.characterOffset_ = 0;
            this.lineNumber_ = 1;
            this.columnNumber_ = 1;
            this.encoding_ = encoding;
        }

        void rewind() {
            --this.offset_;
            --this.characterOffset_;
            --this.columnNumber_;
        }

        void rewind(int i) {
            this.offset_ -= i;
            this.characterOffset_ -= i;
            this.columnNumber_ -= i;
        }

        void incLine() {
            ++this.lineNumber_;
            this.columnNumber_ = 1;
        }

        void incLine(int nbLines) {
            this.lineNumber_ += nbLines;
            this.columnNumber_ = 1;
        }

        public int getLineNumber() {
            return this.lineNumber_;
        }

        void resetBuffer(XMLString xmlBuffer, int lineNumber, int columnNumber, int characterOffset) {
            this.lineNumber_ = lineNumber;
            this.columnNumber_ = columnNumber;
            this.characterOffset_ = characterOffset;
            this.buffer_ = xmlBuffer.getChars();
            this.offset_ = 0;
            this.length_ = xmlBuffer.length();
        }

        int getColumnNumber() {
            return this.columnNumber_;
        }

        int getCharacterOffset() {
            return this.characterOffset_;
        }

        protected boolean skip(String expectedInUpperCase) throws IOException {
            int length = expectedInUpperCase != null ? expectedInUpperCase.length() : 0;
            for (int i = 0; i < length; ++i) {
                char c1;
                char c0;
                if (this.offset_ == this.length_) {
                    System.arraycopy(this.buffer_, this.offset_ - i, this.buffer_, 0, i);
                    if (this.load(i) == -1) {
                        this.offset_ = 0;
                        return false;
                    }
                }
                if ((c0 = expectedInUpperCase.charAt(i)) == (c1 = Character.toUpperCase(this.getNextChar()))) continue;
                this.rewind(i + 1);
                return false;
            }
            return true;
        }

        protected boolean skipMarkup(boolean balance) throws IOException {
            int depth = 1;
            boolean slashgt = false;
            block0: while (this.offset_ != this.length_ || this.loadWholeBuffer() != -1) {
                while (this.hasNext()) {
                    char c = this.getNextChar();
                    if (balance && c == '<') {
                        ++depth;
                        continue;
                    }
                    if (c == '>') {
                        if (--depth != 0) continue;
                        break block0;
                    }
                    if (c == '/') {
                        if (this.offset_ == this.length_ && this.loadWholeBuffer() == -1) break block0;
                        c = this.getNextChar();
                        if (c == '>') {
                            slashgt = true;
                            if (--depth != 0) continue;
                            break block0;
                        }
                        this.rewind();
                        continue;
                    }
                    if (c != '\r' && c != '\n') continue;
                    this.rewind();
                    this.skipNewlines();
                }
            }
            return slashgt;
        }

        protected boolean skipSpaces() throws IOException {
            boolean spaces = false;
            while (this.offset_ != this.length_ || this.loadWholeBuffer() != -1) {
                char c = this.getNextChar();
                if (c == '\n' || c == '\r') {
                    spaces = true;
                    this.rewind();
                    this.skipNewlines();
                    continue;
                }
                if (Character.isWhitespace(c)) {
                    spaces = true;
                    continue;
                }
                this.rewind();
                break;
            }
            return spaces;
        }

        protected int skipNewlines() throws IOException {
            if (this.offset_ == this.length_ && this.loadWholeBuffer() == -1) {
                return 0;
            }
            char c = this.getCurrentChar();
            int newlines = 0;
            if (c == '\n' || c == '\r') {
                do {
                    if ((c = this.getNextChar()) == '\n') {
                        ++newlines;
                        if (this.offset_ != this.length_) continue;
                        this.offset_ = newlines;
                        if (this.load(newlines) != -1) continue;
                        break;
                    }
                    if (c == '\r') {
                        ++newlines;
                        if (this.offset_ == this.length_) {
                            this.offset_ = newlines;
                            if (this.load(newlines) == -1) break;
                        }
                        if (this.getCurrentChar() != '\n') continue;
                        ++this.offset_;
                        ++this.characterOffset_;
                        continue;
                    }
                    this.rewind();
                    break;
                } while (this.offset_ < this.length_ - 1);
                this.incLine(newlines);
            }
            return newlines;
        }
    }

    public static interface Scanner {
        public int scan(boolean var1) throws IOException;
    }
}

