/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client;

import io.helidon.http.ClientResponseHeaders;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.Method;
import io.helidon.webclient.api.ClientRequest;
import io.helidon.webclient.api.HttpClientRequest;
import io.helidon.webclient.api.HttpClientResponse;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.api.WebClientConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.KotlinExtensionsKt;
import org.http4k.client.ExtKt;
import org.http4k.core.Body;
import org.http4k.core.BodyMode;
import org.http4k.core.ParametersKt;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.core.Uri;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JA\u0010\u0003\u001a!\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u0004j\u0002`\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0087\u0002\u00a2\u0006\u0002\b\u000fJ!\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011*\u00020\f2\u0006\u0010\b\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lorg/http4k/client/HelidonClient;", "", "()V", "invoke", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lkotlin/ParameterName;", "name", "request", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "client", "Lio/helidon/webclient/api/WebClient;", "bodyMode", "Lorg/http4k/core/BodyMode;", "create", "makeHelidonRequest", "Lio/helidon/webclient/api/HttpClientRequest;", "kotlin.jvm.PlatformType", "makeHelidonRequest$http4k_client_helidon", "http4k-client-helidon"})
@SourceDebugExtension(value={"SMAP\nHelidonClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelidonClient.kt\norg/http4k/client/HelidonClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,63:1\n1477#2:64\n1502#2,3:65\n1505#2,3:75\n1549#2:79\n1620#2,3:80\n1789#2,2:86\n1549#2:88\n1620#2,3:89\n1791#2:92\n372#3,7:68\n215#4:78\n216#4:85\n37#5,2:83\n*S KotlinDebug\n*F\n+ 1 HelidonClient.kt\norg/http4k/client/HelidonClient\n*L\n51#1:64\n51#1:65,3\n51#1:75,3\n58#1:79\n58#1:80,3\n53#1:86,2\n61#1:88\n61#1:89,3\n53#1:92\n51#1:68,7\n57#1:78\n57#1:85\n58#1:83,2\n*E\n"})
public final class HelidonClient {
    @NotNull
    public static final HelidonClient INSTANCE = new HelidonClient();

    private HelidonClient() {
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final Function1<Request, Response> create(@NotNull WebClient client, @NotNull BodyMode bodyMode) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)bodyMode, (String)"bodyMode");
        return (Function1)new Function1<Request, Response>(client, bodyMode){
            final /* synthetic */ WebClient $client;
            final /* synthetic */ BodyMode $bodyMode;
            {
                this.$client = $client;
                this.$bodyMode = $bodyMode;
            }

            @NotNull
            public Response invoke(@NotNull Request request) {
                Response response;
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                try {
                    HttpClientResponse httpClientResponse = HelidonClient.INSTANCE.makeHelidonRequest$http4k_client_helidon(this.$client, request).submit((Object)request.getBody().getPayload().array());
                    Intrinsics.checkNotNullExpressionValue((Object)httpClientResponse, (String)"submit(...)");
                    response = this.asHttp4k(httpClientResponse);
                }
                catch (UncheckedIOException e) {
                    Response response2;
                    IOException iOException = e.getCause();
                    if (iOException instanceof UnknownHostException) {
                        response2 = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.UNKNOWN_HOST, (Exception)e), null, (int)2, null);
                    } else if (iOException instanceof ConnectException) {
                        response2 = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.UNKNOWN_HOST, (Exception)e), null, (int)2, null);
                    } else if (iOException instanceof SocketTimeoutException) {
                        response2 = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.CLIENT_TIMEOUT, (Exception)e), null, (int)2, null);
                    } else {
                        throw e;
                    }
                    response = response2;
                }
                return response;
            }

            /*
             * WARNING - void declaration
             */
            private final Response asHttp4k(HttpClientResponse $this$asHttp4k) {
                void $this$fold$iv;
                ClientResponseHeaders clientResponseHeaders = $this$asHttp4k.headers();
                Intrinsics.checkNotNullExpressionValue((Object)clientResponseHeaders, (String)"headers(...)");
                Iterable iterable = (Iterable)clientResponseHeaders;
                Response initial$iv = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)new Status($this$asHttp4k.status().code(), $this$asHttp4k.status().reasonPhrase()), null, (int)2, null);
                boolean $i$f$fold = false;
                Response accumulator$iv = initial$iv;
                for (T element$iv : $this$fold$iv) {
                    void next;
                    Header header = (Header)element$iv;
                    Response acc = accumulator$iv;
                    boolean bl = false;
                    List list = next.allValues();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"allValues(...)");
                    Iterable $this$fold$iv2 = list;
                    boolean $i$f$fold2 = false;
                    Response accumulator$iv2 = acc;
                    for (T element$iv2 : $this$fold$iv2) {
                        void value;
                        String string = (String)element$iv2;
                        Response acc2 = accumulator$iv2;
                        boolean bl2 = false;
                        String string2 = next.name();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name(...)");
                        accumulator$iv2 = acc2.header(string2, (String)value);
                    }
                    accumulator$iv = accumulator$iv2;
                }
                InputStream inputStream = $this$asHttp4k.inputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream(...)");
                return accumulator$iv.body((Body)this.$bodyMode.invoke((Object)inputStream));
            }
        };
    }

    public static /* synthetic */ Function1 create$default(WebClient webClient, BodyMode bodyMode, int n, Object object) {
        if ((n & 1) != 0) {
            WebClient webClient2 = ((WebClientConfig.Builder)WebClient.builder().followRedirects(false)).build();
            Intrinsics.checkNotNullExpressionValue((Object)webClient2, (String)"build(...)");
            webClient = webClient2;
        }
        if ((n & 2) != 0) {
            bodyMode = (BodyMode)BodyMode.Memory.INSTANCE;
        }
        return HelidonClient.create(webClient, bodyMode);
    }

    /*
     * WARNING - void declaration
     */
    public final HttpClientRequest makeHelidonRequest$http4k_client_helidon(@NotNull WebClient $this$makeHelidonRequest, @NotNull Request request) {
        void $this$fold$iv;
        void initial$iv;
        Object object;
        Object value$iv$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        Object element$iv$iv2;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$makeHelidonRequest, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Iterable $this$groupBy$iv = request.getHeaders();
        boolean $i$f$groupBy22 = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv2 : $this$groupByTo$iv$iv) {
            Object object2;
            Pair it = (Pair)element$iv$iv2;
            boolean bl = false;
            String key$iv$iv = (String)it.getFirst();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv2);
        }
        $this$groupBy$iv = destination$iv$iv.entrySet();
        ClientRequest $i$f$groupBy22 = ((HttpClientRequest)$this$makeHelidonRequest.method(Method.create((String)request.getMethod().name()))).uri(Uri.copy$default((Uri)request.getUri(), null, null, null, null, null, (String)"", null, (int)95, null).toString());
        HttpClientRequest $this$makeHelidonRequest_u24lambda_u243 = (HttpClientRequest)$i$f$groupBy22;
        boolean bl = false;
        Map $this$forEach$iv = ParametersKt.toParametersMap((List)ParametersKt.queries((Uri)request.getUri()));
        boolean $i$f$forEach = false;
        element$iv$iv2 = $this$forEach$iv.entrySet().iterator();
        while (element$iv$iv2.hasNext()) {
            void $this$toTypedArray$iv;
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            Map.Entry element$iv;
            Map.Entry it = element$iv = (Map.Entry)element$iv$iv2.next();
            boolean bl3 = false;
            $this$getOrPut$iv$iv$iv = (Iterable)it.getValue();
            String string = (String)it.getKey();
            value$iv$iv$iv = $this$makeHelidonRequest_u24lambda_u243;
            boolean $i$f$map = false;
            void var17_34 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void value;
                object = (String)item$iv$iv2;
                collection = destination$iv$iv2;
                boolean bl4 = false;
                void v1 = value;
                collection.add(v1 != null ? KotlinExtensionsKt.urlEncoded((String)v1) : null);
            }
            collection = (List)destination$iv$iv2;
            $this$map$iv = collection;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            value$iv$iv$iv.queryParam(string, Arrays.copyOf(stringArray, stringArray.length));
        }
        boolean $i$f$fold = false;
        HttpClientRequest accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void next;
            element$iv$iv2 = (Map.Entry)element$iv;
            HttpClientRequest acc = accumulator$iv;
            boolean bl5 = false;
            Iterable bl3 = (Iterable)next.getValue();
            HeaderName headerName = HeaderNames.create((String)((String)next.getKey()), (String)((String)next.getKey()));
            HttpClientRequest httpClientRequest = acc;
            boolean $i$f$map = false;
            void $i$f$toTypedArray = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Object item$iv$iv2;
                item$iv$iv2 = (Pair)item$iv$iv;
                object = destination$iv$iv3;
                boolean bl6 = false;
                object.add((String)it.getSecond());
            }
            object = (List)destination$iv$iv3;
            accumulator$iv = (HttpClientRequest)httpClientRequest.header(headerName, (List)object);
        }
        return accumulator$iv;
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final Function1<Request, Response> create(@NotNull WebClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return HelidonClient.create$default(client, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final Function1<Request, Response> create() {
        return HelidonClient.create$default(null, null, 3, null);
    }
}

