/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client;

import java.io.InputStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jetty.client.BufferingResponseListener;
import org.eclipse.jetty.client.ByteBufferRequestContent;
import org.eclipse.jetty.client.ContentResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.InputStreamRequestContent;
import org.eclipse.jetty.client.InputStreamResponseListener;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.http4k.client.DualSyncAsyncHttpHandler;
import org.http4k.client.ExtKt;
import org.http4k.client.JettyClient;
import org.http4k.client.PreCannedJettyHttpClients;
import org.http4k.core.BodyMode;
import org.http4k.core.HttpMessage;
import org.http4k.core.ParametersKt;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nH\u0087\u0002\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lorg/http4k/client/JettyClient;", "", "()V", "invoke", "Lorg/http4k/client/DualSyncAsyncHttpHandler;", "client", "Lorg/eclipse/jetty/client/HttpClient;", "bodyMode", "Lorg/http4k/core/BodyMode;", "requestModifier", "Lkotlin/Function1;", "Lorg/eclipse/jetty/client/Request;", "create", "http4k-client-jetty"})
public final class JettyClient {
    @NotNull
    public static final JettyClient INSTANCE = new JettyClient();

    private JettyClient() {
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final DualSyncAsyncHttpHandler create(@NotNull HttpClient client, @NotNull BodyMode bodyMode, @NotNull Function1<? super org.eclipse.jetty.client.Request, ? extends org.eclipse.jetty.client.Request> requestModifier) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)bodyMode, (String)"bodyMode");
        Intrinsics.checkNotNullParameter(requestModifier, (String)"requestModifier");
        if (!client.isRunning()) {
            client.start();
        }
        return new DualSyncAsyncHttpHandler(client, bodyMode, requestModifier){
            final /* synthetic */ HttpClient $client;
            final /* synthetic */ BodyMode $bodyMode;
            final /* synthetic */ Function1<org.eclipse.jetty.client.Request, org.eclipse.jetty.client.Request> $requestModifier;
            {
                this.$client = $client;
                this.$bodyMode = $bodyMode;
                this.$requestModifier = $requestModifier;
            }

            public void close() {
                this.$client.stop();
            }

            @NotNull
            public Response invoke(@NotNull Request request) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                return this.send(this.$client, request);
            }

            public void invoke(@NotNull Request request, @NotNull Function1<? super Response, Unit> fn) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter(fn, (String)"fn");
                this.sendAsync(this.$client, request, fn);
            }

            private final Response send(HttpClient $this$send, Request request) {
                BodyMode bodyMode;
                org.eclipse.jetty.client.Request request2 = this.newRequest($this$send, request);
                BodyMode bodyMode2 = this.$bodyMode;
                org.eclipse.jetty.client.Request $this$send_u24lambda_u242 = request2;
                boolean bl = false;
                try {
                    Response response;
                    bodyMode = bodyMode2;
                    if (Intrinsics.areEqual((Object)bodyMode, (Object)BodyMode.Memory.INSTANCE)) {
                        ContentResponse it = $this$send_u24lambda_u242.send();
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)it);
                        Response response2 = this.toHttp4kResponse((org.eclipse.jetty.client.Response)it);
                        String string = it.getContentAsString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContentAsString(...)");
                        response = response2.body(string);
                    } else if (Intrinsics.areEqual((Object)bodyMode, (Object)BodyMode.Stream.INSTANCE)) {
                        InputStreamResponseListener $this$send_u24lambda_u242_u24lambda_u241 = new InputStreamResponseListener();
                        boolean bl3 = false;
                        $this$send_u24lambda_u242.send((Response.CompleteListener)$this$send_u24lambda_u242_u24lambda_u241);
                        org.eclipse.jetty.client.Response response3 = $this$send_u24lambda_u242_u24lambda_u241.get(this.timeoutOrMax($this$send_u24lambda_u242), TimeUnit.MILLISECONDS);
                        Intrinsics.checkNotNullExpressionValue((Object)response3, (String)"get(...)");
                        HttpMessage httpMessage = (HttpMessage)this.toHttp4kResponse(response3);
                        InputStream inputStream = $this$send_u24lambda_u242_u24lambda_u241.getInputStream();
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                        response = (Response)HttpMessage.DefaultImpls.body$default((HttpMessage)httpMessage, (InputStream)inputStream, null, (int)2, null);
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    bodyMode = response;
                }
                catch (ExecutionException e) {
                    Response response;
                    Throwable throwable = e.getCause();
                    if (throwable instanceof UnknownHostException) {
                        response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.UNKNOWN_HOST, (Exception)e), null, (int)2, null);
                    } else if (throwable instanceof ConnectException) {
                        response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.CONNECTION_REFUSED, (Exception)e), null, (int)2, null);
                    } else {
                        throw e;
                    }
                    bodyMode = response;
                }
                catch (TimeoutException e) {
                    bodyMode = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.CLIENT_TIMEOUT, (Exception)e), null, (int)2, null);
                }
                return bodyMode;
            }

            private final void sendAsync(HttpClient $this$sendAsync, Request request, Function1<? super Response, Unit> fn) {
                org.eclipse.jetty.client.Request request2 = this.newRequest($this$sendAsync, request);
                BodyMode bodyMode = this.$bodyMode;
                org.eclipse.jetty.client.Request $this$sendAsync_u24lambda_u243 = request2;
                boolean bl = false;
                BodyMode bodyMode2 = bodyMode;
                if (Intrinsics.areEqual((Object)bodyMode2, (Object)BodyMode.Memory.INSTANCE)) {
                    $this$sendAsync_u24lambda_u243.send((Response.CompleteListener)new BufferingResponseListener(this, fn){
                        final /* synthetic */ invoke.2 this$0;
                        final /* synthetic */ Function1<Response, Unit> $fn;
                        {
                            this.this$0 = $receiver;
                            this.$fn = $fn;
                        }

                        public void onComplete(@NotNull Result result) {
                            Response response;
                            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                            if (result.isFailed()) {
                                Throwable throwable = result.getFailure();
                                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"getFailure(...)");
                                response = invoke.2.access$asHttp4kResponse(this.this$0, throwable);
                            } else {
                                org.eclipse.jetty.client.Response response2 = result.getResponse();
                                Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"getResponse(...)");
                                Response response3 = invoke.2.access$toHttp4kResponse(this.this$0, response2);
                                String string = this.getContentAsString();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContentAsString(...)");
                                response = response3.body(string);
                            }
                            Response response4 = response;
                            this.$fn.invoke((Object)response4);
                        }
                    });
                } else if (Intrinsics.areEqual((Object)bodyMode2, (Object)BodyMode.Stream.INSTANCE)) {
                    $this$sendAsync_u24lambda_u243.send((Response.CompleteListener)new InputStreamResponseListener($this$sendAsync, fn, this){
                        final /* synthetic */ HttpClient $this_sendAsync;
                        final /* synthetic */ Function1<Response, Unit> $fn;
                        final /* synthetic */ invoke.2 this$0;
                        {
                            this.$this_sendAsync = $receiver;
                            this.$fn = $fn;
                            this.this$0 = $receiver2;
                        }

                        public void onHeaders(@NotNull org.eclipse.jetty.client.Response response) {
                            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                            super.onHeaders(response);
                            this.$this_sendAsync.getExecutor().execute(() -> invoke.sendAsync.1.2.onHeaders$lambda$0(this.$fn, this.this$0, response, this));
                        }

                        public void onFailure(@NotNull org.eclipse.jetty.client.Response response, @NotNull Throwable failure) {
                            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                            Intrinsics.checkNotNullParameter((Object)failure, (String)"failure");
                            super.onFailure(response, failure);
                            this.$fn.invoke((Object)invoke.2.access$asHttp4kResponse(this.this$0, failure));
                        }

                        private static final void onHeaders$lambda$0(Function1 $fn, invoke.2 this$0, org.eclipse.jetty.client.Response $response, invoke.sendAsync.1.2 this$1) {
                            Intrinsics.checkNotNullParameter((Object)$fn, (String)"$fn");
                            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                            Intrinsics.checkNotNullParameter((Object)$response, (String)"$response");
                            Intrinsics.checkNotNullParameter((Object)((Object)this$1), (String)"this$1");
                            HttpMessage httpMessage = (HttpMessage)invoke.2.access$toHttp4kResponse(this$0, $response);
                            InputStream inputStream = this$1.getInputStream();
                            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                            $fn.invoke((Object)HttpMessage.DefaultImpls.body$default((HttpMessage)httpMessage, (InputStream)inputStream, null, (int)2, null));
                        }
                    });
                }
            }

            private final org.eclipse.jetty.client.Request newRequest(HttpClient $this$newRequest, Request request) {
                org.eclipse.jetty.client.Request request2;
                org.eclipse.jetty.client.Request request3;
                Request.Content content;
                org.eclipse.jetty.client.Request request4 = $this$newRequest.newRequest(request.getUri().toString()).method(request.getMethod().name()).headers(arg_0 -> invoke.2.newRequest$lambda$5(request, arg_0));
                BodyMode bodyMode = this.$bodyMode;
                if (Intrinsics.areEqual((Object)bodyMode, (Object)BodyMode.Memory.INSTANCE)) {
                    ByteBuffer[] byteBufferArray = new ByteBuffer[]{request.getBody().getPayload()};
                    content = (Request.Content)new ByteBufferRequestContent(byteBufferArray);
                } else if (Intrinsics.areEqual((Object)bodyMode, (Object)BodyMode.Stream.INSTANCE)) {
                    content = (Request.Content)new InputStreamRequestContent(request.getBody().getStream());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                bodyMode = request4.body(content);
                org.eclipse.jetty.client.Request jettyRequest = (org.eclipse.jetty.client.Request)this.$requestModifier.invoke((Object)bodyMode);
                boolean bl = false;
                Long l = request.getBody().getLength();
                if (l != null) {
                    long len = ((Number)l).longValue();
                    boolean bl2 = false;
                    request3 = jettyRequest.headers(arg_0 -> invoke.2.newRequest$lambda$8$lambda$7$lambda$6(len, arg_0));
                } else {
                    request3 = request2 = null;
                }
                return request2 == null ? jettyRequest : request2;
            }

            private final long timeoutOrMax(org.eclipse.jetty.client.Request $this$timeoutOrMax) {
                return $this$timeoutOrMax.getTimeout() <= 0L ? Long.MAX_VALUE : $this$timeoutOrMax.getTimeout();
            }

            private final Response toHttp4kResponse(org.eclipse.jetty.client.Response $this$toHttp4kResponse) {
                Response response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)new Status($this$toHttp4kResponse.getStatus(), $this$toHttp4kResponse.getReason()), null, (int)2, null);
                HttpFields httpFields = $this$toHttp4kResponse.getHeaders();
                Intrinsics.checkNotNullExpressionValue((Object)httpFields, (String)"getHeaders(...)");
                return response.headers(this.toHttp4kHeaders(httpFields));
            }

            /*
             * WARNING - void declaration
             */
            private final List<Pair<String, String>> toHttp4kHeaders(HttpFields $this$toHttp4kHeaders) {
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = (Iterable)$this$toHttp4kHeaders;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    void $this$mapTo$iv$iv;
                    HttpField it = (HttpField)element$iv$iv;
                    boolean bl = false;
                    String[] stringArray = it.getValues();
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getValues(...)");
                    Object[] $this$map$iv = stringArray;
                    boolean $i$f$map = false;
                    Object[] objectArray = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>($this$map$iv.length);
                    boolean $i$f$mapTo = false;
                    for (void item$iv$iv : $this$mapTo$iv$iv) {
                        void hValue;
                        String string = (String)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl2 = false;
                        collection.add(TuplesKt.to((Object)it.getName(), (Object)hValue));
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                return (List)destination$iv$iv;
            }

            private final Response asHttp4kResponse(Throwable $this$asHttp4kResponse) {
                return Response.Companion.create$default((Response.Companion)Response.Companion, (Status)($this$asHttp4kResponse instanceof TimeoutException ? Status.CLIENT_TIMEOUT : Status.SERVICE_UNAVAILABLE).description("Client Error: caused by " + $this$asHttp4kResponse.getLocalizedMessage()), null, (int)2, null);
            }

            private static final void newRequest$lambda$5(Request $request, HttpFields.Mutable fields) {
                Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
                Map $this$forEach$iv = ParametersKt.toParametersMap((List)$request.getHeaders());
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> it = element$iv = iterator.next();
                    boolean bl = false;
                    fields.put((String)it.getKey(), (List)it.getValue());
                }
            }

            private static final void newRequest$lambda$8$lambda$7$lambda$6(long $len, HttpFields.Mutable headers) {
                headers.add("content-length", String.valueOf($len));
            }

            public static final /* synthetic */ Response access$asHttp4kResponse(invoke.2 $this, Throwable $receiver) {
                return $this.asHttp4kResponse($receiver);
            }

            public static final /* synthetic */ Response access$toHttp4kResponse(invoke.2 $this, org.eclipse.jetty.client.Response $receiver) {
                return $this.toHttp4kResponse($receiver);
            }
        };
    }

    public static /* synthetic */ DualSyncAsyncHttpHandler create$default(HttpClient httpClient, BodyMode bodyMode, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            httpClient = PreCannedJettyHttpClients.INSTANCE.defaultJettyHttpClient();
        }
        if ((n & 2) != 0) {
            bodyMode = (BodyMode)BodyMode.Memory.INSTANCE;
        }
        if ((n & 4) != 0) {
            function1 = invoke.1.INSTANCE;
        }
        return JettyClient.create(httpClient, bodyMode, (Function1<? super org.eclipse.jetty.client.Request, ? extends org.eclipse.jetty.client.Request>)function1);
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final DualSyncAsyncHttpHandler create(@NotNull HttpClient client, @NotNull BodyMode bodyMode) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)bodyMode, (String)"bodyMode");
        return JettyClient.create$default(client, bodyMode, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final DualSyncAsyncHttpHandler create(@NotNull HttpClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return JettyClient.create$default(client, null, null, 6, null);
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final DualSyncAsyncHttpHandler create() {
        return JettyClient.create$default(null, null, null, 7, null);
    }
}

