/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.http4k.client.JettyNonBlockingWebsocket;
import org.http4k.core.Uri;
import org.http4k.websocket.Websocket;
import org.http4k.websocket.WsClient;
import org.http4k.websocket.WsMessage;
import org.http4k.websocket.WsStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00070\u0006j\u0002`\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010\u0017\u001a\u00020\u0001J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0014H\u0016R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/http4k/client/JettyBlockingWebsocket;", "Lorg/http4k/websocket/WsClient;", "uri", "Lorg/http4k/core/Uri;", "headers", "Lorg/http4k/core/Headers;", "", "Lkotlin/Pair;", "", "timeout", "Ljava/time/Duration;", "client", "Lorg/eclipse/jetty/websocket/client/WebSocketClient;", "<init>", "(Lorg/http4k/core/Uri;Ljava/util/List;Ljava/time/Duration;Lorg/eclipse/jetty/websocket/client/WebSocketClient;)V", "connected", "Ljava/util/concurrent/CompletableFuture;", "queue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lkotlin/Function0;", "Lorg/http4k/websocket/WsMessage;", "websocket", "Lorg/http4k/client/JettyNonBlockingWebsocket;", "awaitConnected", "received", "Lkotlin/sequences/Sequence;", "close", "", "status", "Lorg/http4k/websocket/WsStatus;", "send", "message", "http4k-client-jetty"})
final class JettyBlockingWebsocket
implements WsClient {
    @NotNull
    private final CompletableFuture<WsClient> connected;
    @NotNull
    private final LinkedBlockingQueue<Function0<WsMessage>> queue;
    @NotNull
    private final JettyNonBlockingWebsocket websocket;

    public JettyBlockingWebsocket(@NotNull Uri uri, @NotNull List<Pair<String, String>> headers, @NotNull Duration timeout, @NotNull WebSocketClient client) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.connected = new CompletableFuture();
        this.queue = new LinkedBlockingQueue();
        this.websocket = new JettyNonBlockingWebsocket(uri, headers, timeout, client, (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this.connected){

            public final void invoke(Throwable p0) {
                ((CompletableFuture)this.receiver).completeExceptionally(p0);
            }
        }), (Function1<? super Websocket, Unit>)((Function1)arg_0 -> JettyBlockingWebsocket.websocket$lambda$5(this, arg_0)));
    }

    @NotNull
    public final WsClient awaitConnected() {
        WsClient wsClient;
        try {
            wsClient = this.connected.get();
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            throw throwable;
        }
        return wsClient;
    }

    @NotNull
    public Sequence<WsMessage> received() {
        return SequencesKt.generateSequence(() -> JettyBlockingWebsocket.received$lambda$6(this));
    }

    public void close(@NotNull WsStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        this.websocket.close(status);
    }

    public void send(@NotNull WsMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.websocket.send(message);
    }

    private static final WsMessage websocket$lambda$5$lambda$1$lambda$0(WsMessage $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return $it;
    }

    private static final Unit websocket$lambda$5$lambda$1(JettyBlockingWebsocket this$0, WsMessage it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((Collection)this$0.queue).add(() -> JettyBlockingWebsocket.websocket$lambda$5$lambda$1$lambda$0(it));
        return Unit.INSTANCE;
    }

    private static final Unit websocket$lambda$5$lambda$2(JettyBlockingWebsocket this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((Collection)this$0.queue).add(new Function0(it){
            final /* synthetic */ Throwable $it;
            {
                this.$it = $it;
            }

            public final Void invoke() {
                throw this.$it;
            }
        });
        return Unit.INSTANCE;
    }

    private static final WsMessage websocket$lambda$5$lambda$4$lambda$3() {
        return null;
    }

    private static final Unit websocket$lambda$5$lambda$4(JettyBlockingWebsocket this$0, WsStatus it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((Collection)this$0.queue).add(JettyBlockingWebsocket::websocket$lambda$5$lambda$4$lambda$3);
        return Unit.INSTANCE;
    }

    private static final Unit websocket$lambda$5(JettyBlockingWebsocket this$0, Websocket ws) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)ws, (String)"ws");
        ws.onMessage(arg_0 -> JettyBlockingWebsocket.websocket$lambda$5$lambda$1(this$0, arg_0));
        ws.onError(arg_0 -> JettyBlockingWebsocket.websocket$lambda$5$lambda$2(this$0, arg_0));
        ws.onClose(arg_0 -> JettyBlockingWebsocket.websocket$lambda$5$lambda$4(this$0, arg_0));
        this$0.connected.complete(this$0);
        return Unit.INSTANCE;
    }

    private static final WsMessage received$lambda$6(JettyBlockingWebsocket this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return (WsMessage)this$0.queue.take().invoke();
    }
}

