/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.exceptions.WebSocketException;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.http4k.client.JettyWebsocketClientKt;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Uri;
import org.http4k.websocket.PushPullAdaptingWebSocket;
import org.http4k.websocket.Websocket;
import org.http4k.websocket.WsMessage;
import org.http4k.websocket.WsStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001!Bo\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\"\u0010\u0004\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006j\u0002`\b0\u0005j\u0002`\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u0012\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00110\u000fj\u0002`\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 H\u0016R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00110\u000fj\u0002`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00060\u0018R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/http4k/client/JettyNonBlockingWebsocket;", "Lorg/http4k/websocket/PushPullAdaptingWebSocket;", "uri", "Lorg/http4k/core/Uri;", "headers", "", "Lkotlin/Pair;", "", "Lorg/http4k/core/Parameter;", "Lorg/http4k/core/Headers;", "timeout", "Ljava/time/Duration;", "client", "Lorg/eclipse/jetty/websocket/client/WebSocketClient;", "onError", "Lkotlin/Function1;", "", "", "onConnect", "Lorg/http4k/websocket/Websocket;", "Lorg/http4k/websocket/WsConsumer;", "<init>", "(Lorg/http4k/core/Uri;Ljava/util/List;Ljava/time/Duration;Lorg/eclipse/jetty/websocket/client/WebSocketClient;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "listener", "Lorg/http4k/client/JettyNonBlockingWebsocket$Listener;", "req", "Lorg/http4k/core/Request;", "send", "message", "Lorg/http4k/websocket/WsMessage;", "close", "status", "Lorg/http4k/websocket/WsStatus;", "Listener", "http4k-client-jetty"})
final class JettyNonBlockingWebsocket
extends PushPullAdaptingWebSocket {
    @NotNull
    private final Function1<Websocket, Unit> onConnect;
    @NotNull
    private final Listener listener;
    @NotNull
    private final Request req;

    public JettyNonBlockingWebsocket(@NotNull Uri uri, @NotNull List<Pair<String, String>> headers, @NotNull Duration timeout, @NotNull WebSocketClient client, @NotNull Function1<? super Throwable, Unit> onError, @NotNull Function1<? super Websocket, Unit> onConnect) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        Intrinsics.checkNotNullParameter(onConnect, (String)"onConnect");
        this.onConnect = onConnect;
        this.listener = new Listener();
        this.req = Request.Companion.create$default((Request.Companion)Request.Companion, (Method)Method.GET, (Uri)uri, null, (int)4, null).headers(headers);
        this.onError(onError);
        client.connect((Object)this.listener, URI.create(uri.toString()), JettyWebsocketClientKt.access$clientUpgradeRequest(headers, timeout)).whenComplete((arg_0, arg_1) -> JettyNonBlockingWebsocket._init_$lambda$1((arg_0, arg_1) -> JettyNonBlockingWebsocket._init_$lambda$0(this, arg_0, arg_1), arg_0, arg_1));
    }

    public void send(@NotNull WsMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Listener $this$send_u24lambda_u244 = this.listener;
        boolean bl = false;
        if (!$this$send_u24lambda_u244.isOpen()) {
            throw new WebSocketException("Connection to " + this.req.getUri() + " is closed.");
        }
        try {
            switch (WhenMappings.$EnumSwitchMapping$0[message.getMode().ordinal()]) {
                case 1: {
                    Void void_ = (Void)Callback.Completable.with(arg_0 -> JettyNonBlockingWebsocket.send$lambda$4$lambda$2($this$send_u24lambda_u244, message, arg_0)).get();
                    break;
                }
                case 2: {
                    Void void_ = (Void)Callback.Completable.with(arg_0 -> JettyNonBlockingWebsocket.send$lambda$4$lambda$3($this$send_u24lambda_u244, message, arg_0)).get();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        catch (Throwable error) {
            this.triggerError(error);
        }
    }

    public void close(@NotNull WsStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Listener $this$close_u24lambda_u246 = this.listener;
        boolean bl = false;
        if ($this$close_u24lambda_u246.isOpen()) {
            Callback.Completable.with(arg_0 -> JettyNonBlockingWebsocket.close$lambda$6$lambda$5($this$close_u24lambda_u246, status, arg_0)).get();
        }
    }

    private static final Unit _init_$lambda$0(JettyNonBlockingWebsocket this$0, Session session, Throwable error) {
        Intrinsics.checkNotNull((Object)error);
        this$0.triggerError(error);
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void send$lambda$4$lambda$2(Listener $this_with, WsMessage $message, Callback.Completable it) {
        $this_with.getSession().sendBinary($message.getBody().getPayload(), (Callback)it);
    }

    private static final void send$lambda$4$lambda$3(Listener $this_with, WsMessage $message, Callback.Completable it) {
        $this_with.getSession().sendText($message.getBody().toString(), (Callback)it);
    }

    private static final void close$lambda$6$lambda$5(Listener $this_with, WsStatus $status, Callback.Completable it) {
        $this_with.getSession().close($status.getCode(), $status.getDescription(), (Callback)it);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/http4k/client/JettyNonBlockingWebsocket$Listener;", "Lorg/eclipse/jetty/websocket/api/Session$Listener$AbstractAutoDemanding;", "<init>", "(Lorg/http4k/client/JettyNonBlockingWebsocket;)V", "onWebSocketOpen", "", "session", "Lorg/eclipse/jetty/websocket/api/Session;", "onWebSocketClose", "statusCode", "", "reason", "", "onWebSocketText", "message", "onWebSocketBinary", "payload", "Ljava/nio/ByteBuffer;", "callback", "Lorg/eclipse/jetty/websocket/api/Callback;", "onWebSocketError", "cause", "", "http4k-client-jetty"})
    public final class Listener
    extends Session.Listener.AbstractAutoDemanding {
        public void onWebSocketOpen(@NotNull Session session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            super.onWebSocketOpen(session);
            JettyNonBlockingWebsocket.this.onConnect.invoke((Object)JettyNonBlockingWebsocket.this);
        }

        public void onWebSocketClose(int statusCode, @Nullable String reason) {
            String string = reason;
            if (string == null) {
                string = "";
            }
            JettyNonBlockingWebsocket.this.triggerClose(new WsStatus(statusCode, string));
        }

        public void onWebSocketText(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            try {
                JettyNonBlockingWebsocket.this.triggerMessage(new WsMessage(message, null, 2, null));
            }
            catch (Throwable e) {
                JettyNonBlockingWebsocket.this.triggerError(e);
            }
        }

        public void onWebSocketBinary(@NotNull ByteBuffer payload, @NotNull Callback callback) {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            try {
                byte[] byArray = BufferUtil.toArray((ByteBuffer)payload);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toArray(...)");
                byte[] byArray2 = byArray;
                JettyNonBlockingWebsocket.this.triggerMessage(new WsMessage((InputStream)new ByteArrayInputStream(byArray2), null, 2, null));
                callback.succeed();
            }
            catch (Throwable e) {
                JettyNonBlockingWebsocket.this.triggerError(e);
                callback.fail(e);
            }
        }

        public void onWebSocketError(@NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            JettyNonBlockingWebsocket.this.triggerError(cause);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WsMessage.Mode.values().length];
            try {
                nArray[WsMessage.Mode.Binary.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WsMessage.Mode.Text.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

