/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import okhttp3.OkHttpClient;
import org.http4k.client.OkHttpBlockingWebsocket;
import org.http4k.client.OkHttpNonBlockingWebsocket;
import org.http4k.core.Uri;
import org.http4k.websocket.Websocket;
import org.http4k.websocket.WsClient;
import org.http4k.websocket.WsMessage;
import org.http4k.websocket.WsStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\"\u0010\u0004\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006j\u0002`\b0\u0005j\u0002`\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u0017\u001a\u00020\u0001J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0014H\u0016R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/http4k/client/OkHttpBlockingWebsocket;", "Lorg/http4k/websocket/WsClient;", "uri", "Lorg/http4k/core/Uri;", "headers", "", "Lkotlin/Pair;", "", "Lorg/http4k/core/Parameter;", "Lorg/http4k/core/Headers;", "timeout", "Ljava/time/Duration;", "client", "Lokhttp3/OkHttpClient;", "(Lorg/http4k/core/Uri;Ljava/util/List;Ljava/time/Duration;Lokhttp3/OkHttpClient;)V", "connected", "Ljava/util/concurrent/CompletableFuture;", "queue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lkotlin/Function0;", "Lorg/http4k/websocket/WsMessage;", "websocket", "Lorg/http4k/client/OkHttpNonBlockingWebsocket;", "awaitConnected", "close", "", "status", "Lorg/http4k/websocket/WsStatus;", "received", "Lkotlin/sequences/Sequence;", "send", "message", "http4k-client-okhttp"})
final class OkHttpBlockingWebsocket
implements WsClient {
    @NotNull
    private final CompletableFuture<WsClient> connected;
    @NotNull
    private final LinkedBlockingQueue<Function0<WsMessage>> queue;
    @NotNull
    private final OkHttpNonBlockingWebsocket websocket;

    public OkHttpBlockingWebsocket(@NotNull Uri uri, @NotNull List<Pair<String, String>> headers, @NotNull Duration timeout, @NotNull OkHttpClient client) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.connected = new CompletableFuture();
        this.queue = new LinkedBlockingQueue();
        this.websocket = new OkHttpNonBlockingWebsocket(uri, headers, timeout, client, (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this.connected){

            public final void invoke(Throwable p0) {
                ((CompletableFuture)this.receiver).completeExceptionally(p0);
            }
        }), (Function1<? super Websocket, Unit>)((Function1)new Function1<Websocket, Unit>(this){
            final /* synthetic */ OkHttpBlockingWebsocket this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Websocket ws) {
                Intrinsics.checkNotNullParameter((Object)ws, (String)"ws");
                ws.onMessage((Function1)new Function1<WsMessage, Unit>(this.this$0){
                    final /* synthetic */ OkHttpBlockingWebsocket this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull WsMessage it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        ((Collection)OkHttpBlockingWebsocket.access$getQueue$p(this.this$0)).add(new Function0<WsMessage>(it){
                            final /* synthetic */ WsMessage $it;
                            {
                                this.$it = $it;
                                super(0);
                            }

                            @NotNull
                            public final WsMessage invoke() {
                                return this.$it;
                            }
                        });
                    }
                });
                ws.onError((Function1)new Function1<Throwable, Unit>(this.this$0){
                    final /* synthetic */ OkHttpBlockingWebsocket this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Throwable it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        ((Collection)OkHttpBlockingWebsocket.access$getQueue$p(this.this$0)).add(new Function0(it){
                            final /* synthetic */ Throwable $it;
                            {
                                this.$it = $it;
                                super(0);
                            }

                            @NotNull
                            public final Void invoke() {
                                throw this.$it;
                            }
                        });
                    }
                });
                ws.onClose((Function1)new Function1<WsStatus, Unit>(this.this$0){
                    final /* synthetic */ OkHttpBlockingWebsocket this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull WsStatus it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        ((Collection)OkHttpBlockingWebsocket.access$getQueue$p(this.this$0)).add(websocket.1.INSTANCE);
                    }
                });
                OkHttpBlockingWebsocket.access$getConnected$p(this.this$0).complete(this.this$0);
            }
        }));
    }

    @NotNull
    public final WsClient awaitConnected() {
        WsClient wsClient;
        try {
            wsClient = this.connected.get();
            Intrinsics.checkNotNull((Object)wsClient);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            throw throwable;
        }
        return wsClient;
    }

    @NotNull
    public Sequence<WsMessage> received() {
        return SequencesKt.generateSequence((Function0)((Function0)new Function0<WsMessage>(this){
            final /* synthetic */ OkHttpBlockingWebsocket this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final WsMessage invoke() {
                return (WsMessage)((Function0)OkHttpBlockingWebsocket.access$getQueue$p(this.this$0).take()).invoke();
            }
        }));
    }

    public void close(@NotNull WsStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        this.websocket.close(status);
    }

    public void send(@NotNull WsMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.websocket.send(message);
    }

    public static final /* synthetic */ LinkedBlockingQueue access$getQueue$p(OkHttpBlockingWebsocket $this) {
        return $this.queue;
    }

    public static final /* synthetic */ CompletableFuture access$getConnected$p(OkHttpBlockingWebsocket $this) {
        return $this.connected;
    }
}

