package org.http4k.connect.amazon.evidently

import dev.forkhandles.result4k.Result
import kotlin.String
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import org.http4k.connect.RemoteFailure
import org.http4k.connect.amazon.evidently.actions.BatchEvaluateFeature
import org.http4k.connect.amazon.evidently.actions.BatchEvaluationRequest
import org.http4k.connect.amazon.evidently.actions.BatchEvaluationResultWrapper
import org.http4k.connect.amazon.evidently.actions.CreateFeature
import org.http4k.connect.amazon.evidently.actions.CreateProject
import org.http4k.connect.amazon.evidently.actions.CreateProjectResponse
import org.http4k.connect.amazon.evidently.actions.DeleteFeature
import org.http4k.connect.amazon.evidently.actions.DeleteProject
import org.http4k.connect.amazon.evidently.actions.EvaluateFeature
import org.http4k.connect.amazon.evidently.actions.EvaluatedFeature
import org.http4k.connect.amazon.evidently.actions.UpdateFeature
import org.http4k.connect.amazon.evidently.model.EntityId
import org.http4k.connect.amazon.evidently.model.EvaluationContext
import org.http4k.connect.amazon.evidently.model.EvaluationStrategy
import org.http4k.connect.amazon.evidently.model.FeatureName
import org.http4k.connect.amazon.evidently.model.FeatureResponse
import org.http4k.connect.amazon.evidently.model.ProjectName
import org.http4k.connect.amazon.evidently.model.VariableValue
import org.http4k.connect.amazon.evidently.model.VariationConfig
import org.http4k.connect.amazon.evidently.model.VariationName

/**
 * @see org.http4k.connect.amazon.evidently.actions.BatchEvaluateFeature
 */
public fun Evidently.batchEvaluateFeature(project: ProjectName,
    requests: List<BatchEvaluationRequest>): Result<BatchEvaluationResultWrapper, RemoteFailure> =
    invoke(BatchEvaluateFeature(project, requests))

/**
 * @see org.http4k.connect.amazon.evidently.actions.CreateFeature
 */
public fun Evidently.createFeature(
  project: ProjectName,
  defaultVariation: VariationName,
  description: String? = null,
  entityOverrides: Map<EntityId, VariationName>? = null,
  evaluationStrategy: EvaluationStrategy? = null,
  name: FeatureName,
  tags: Map<String, String>? = null,
  variations: Map<VariationName, VariableValue>,
): Result<FeatureResponse, RemoteFailure> = invoke(CreateFeature(project, defaultVariation,
    description, entityOverrides, evaluationStrategy, name, tags, variations))

/**
 * @see org.http4k.connect.amazon.evidently.actions.CreateProject
 */
public fun Evidently.createProject(
  name: ProjectName,
  description: String? = null,
  tags: Map<String, String>? = null,
): Result<CreateProjectResponse, RemoteFailure> = invoke(CreateProject(name, description, tags))

/**
 * @see org.http4k.connect.amazon.evidently.actions.DeleteFeature
 */
public fun Evidently.deleteFeature(project: ProjectName, name: FeatureName):
    Result<Unit, RemoteFailure> = invoke(DeleteFeature(project, name))

/**
 * @see org.http4k.connect.amazon.evidently.actions.DeleteProject
 */
public fun Evidently.deleteProject(name: ProjectName): Result<Unit, RemoteFailure> =
    invoke(DeleteProject(name))

/**
 * @see org.http4k.connect.amazon.evidently.actions.EvaluateFeature
 */
public fun Evidently.evaluateFeature(
  project: ProjectName,
  feature: FeatureName,
  entityId: EntityId,
  evaluationContext: EvaluationContext? = null,
): Result<EvaluatedFeature, RemoteFailure> = invoke(EvaluateFeature(project, feature, entityId,
    evaluationContext))

/**
 * @see org.http4k.connect.amazon.evidently.actions.UpdateFeature
 */
public fun Evidently.updateFeature(
  project: ProjectName,
  feature: FeatureName,
  addOrUpdateVariations: List<VariationConfig>? = null,
  defaultVariation: VariationName? = null,
  description: String? = null,
  entityOverrides: Map<EntityId, VariationName>? = null,
  evaluationStrategy: EvaluationStrategy? = null,
  removeVariations: List<VariationName>? = null,
): Result<FeatureResponse, RemoteFailure> = invoke(UpdateFeature(project, feature,
    addOrUpdateVariations, defaultVariation, description, entityOverrides, evaluationStrategy,
    removeVariations))
