package org.http4k.connect.amazon.iamidentitycenter

import dev.forkhandles.result4k.Result
import kotlin.String
import kotlin.collections.List
import org.http4k.connect.RemoteFailure
import org.http4k.connect.amazon.iamidentitycenter.model.ClientId
import org.http4k.connect.amazon.iamidentitycenter.model.ClientName
import org.http4k.connect.amazon.iamidentitycenter.model.ClientSecret
import org.http4k.connect.amazon.iamidentitycenter.model.DeviceCode
import org.http4k.connect.amazon.iamidentitycenter.oidc.action.AuthorizationStarted
import org.http4k.connect.amazon.iamidentitycenter.oidc.action.CreateToken
import org.http4k.connect.amazon.iamidentitycenter.oidc.action.DeviceToken
import org.http4k.connect.amazon.iamidentitycenter.oidc.action.RegisterClient
import org.http4k.connect.amazon.iamidentitycenter.oidc.action.RegisteredClient
import org.http4k.connect.amazon.iamidentitycenter.oidc.action.StartDeviceAuthorization
import org.http4k.core.Uri

/**
 * @see org.http4k.connect.amazon.iamidentitycenter.oidc.action.CreateToken
 */
public fun OIDC.createToken(
  clientId: ClientId,
  clientSecret: ClientSecret,
  deviceCode: DeviceCode,
): Result<DeviceToken, RemoteFailure> = invoke(CreateToken(clientId, clientSecret, deviceCode))

/**
 * @see org.http4k.connect.amazon.iamidentitycenter.oidc.action.RegisterClient
 */
public fun OIDC.registerClient(clientName: ClientName, scopes: List<String>? = null):
    Result<RegisteredClient, RemoteFailure> = invoke(RegisterClient(clientName, scopes))

/**
 * @see org.http4k.connect.amazon.iamidentitycenter.oidc.action.StartDeviceAuthorization
 */
public fun OIDC.startDeviceAuthorization(
  clientId: ClientId,
  clientSecret: ClientSecret,
  startUrl: Uri,
): Result<AuthorizationStarted, RemoteFailure> = invoke(StartDeviceAuthorization(clientId,
    clientSecret, startUrl))
