package org.http4k.connect.amazon.iamidentitycenter

import dev.forkhandles.result4k.Result
import org.http4k.connect.RemoteFailure
import org.http4k.connect.amazon.core.model.AwsAccount
import org.http4k.connect.amazon.iamidentitycenter.model.AccessToken
import org.http4k.connect.amazon.iamidentitycenter.model.RoleName
import org.http4k.connect.amazon.iamidentitycenter.sso.action.FederatedCredentials
import org.http4k.connect.amazon.iamidentitycenter.sso.action.GetFederatedCredentials

/**
 * @see org.http4k.connect.amazon.iamidentitycenter.sso.action.GetFederatedCredentials
 */
public fun SSO.getFederatedCredentials(
  account: AwsAccount,
  roleName: RoleName,
  accessToken: AccessToken,
): Result<FederatedCredentials, RemoteFailure> = invoke(GetFederatedCredentials(account, roleName,
    accessToken))
