/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.server;

import java.time.Duration;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.server.Http4kServer;
import org.http4k.server.Jetty;
import org.http4k.server.JettyInfraKt;
import org.http4k.server.PolyServerConfig;
import org.http4k.server.ServerConfig;
import org.http4k.sse.Sse;
import org.http4k.websocket.Websocket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0019\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nBC\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00122\u0010\u000b\u001a\u001a\u0012\u0016\b\u0001\u0012\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\rj\u0002`\u000f0\f\"\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\rj\u0002`\u000f\u00a2\u0006\u0002\u0010\u0010BK\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00122\u0010\u000b\u001a\u001a\u0012\u0016\b\u0001\u0012\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\rj\u0002`\u000f0\f\"\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\rj\u0002`\u000f\u00a2\u0006\u0002\u0010\u0011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0012J\u008b\u0001\u0010\u0015\u001a\u00020\u00162)\u0010\u0017\u001a%\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u001c\u0018\u00010\rj\u0004\u0018\u0001`\u001d2*\u0010\u001e\u001a&\u0012\u0004\u0012\u00020\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\rj\u0002`!\u0018\u00010\rj\u0004\u0018\u0001`\"2*\u0010#\u001a&\u0012\u0004\u0012\u00020\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020 0\rj\u0002`%\u0018\u00010\rj\u0004\u0018\u0001`&H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006'"}, d2={"Lorg/http4k/server/Jetty;", "Lorg/http4k/server/PolyServerConfig;", "port", "", "(I)V", "stopMode", "Lorg/http4k/server/ServerConfig$StopMode;", "(ILorg/http4k/server/ServerConfig$StopMode;)V", "server", "Lorg/eclipse/jetty/server/Server;", "(ILorg/eclipse/jetty/server/Server;)V", "inConnectors", "", "Lkotlin/Function1;", "Lorg/eclipse/jetty/server/ServerConnector;", "Lorg/http4k/server/ConnectorBuilder;", "(I[Lkotlin/jvm/functions/Function1;)V", "(ILorg/http4k/server/ServerConfig$StopMode;[Lkotlin/jvm/functions/Function1;)V", "(ILorg/http4k/server/ServerConfig$StopMode;Lorg/eclipse/jetty/server/Server;)V", "getStopMode", "()Lorg/http4k/server/ServerConfig$StopMode;", "toServer", "Lorg/http4k/server/Http4kServer;", "http", "Lorg/http4k/core/Request;", "Lkotlin/ParameterName;", "name", "request", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "ws", "Lorg/http4k/websocket/Websocket;", "", "Lorg/http4k/websocket/WsConsumer;", "Lorg/http4k/websocket/WsHandler;", "sse", "Lorg/http4k/sse/Sse;", "Lorg/http4k/sse/SseConsumer;", "Lorg/http4k/sse/SseHandler;", "http4k-server-jetty"})
@SourceDebugExtension(value={"SMAP\njetty.kt\nKotlin\n*S Kotlin\n*F\n+ 1 jetty.kt\norg/http4k/server/Jetty\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n13579#2,2:48\n1#3:50\n*S KotlinDebug\n*F\n+ 1 jetty.kt\norg/http4k/server/Jetty\n*L\n16#1:48,2\n*E\n"})
public final class Jetty
implements PolyServerConfig {
    private final int port;
    @NotNull
    private final ServerConfig.StopMode stopMode;
    @NotNull
    private final Server server;

    public Jetty(int port, @NotNull ServerConfig.StopMode stopMode, @NotNull Server server) {
        Intrinsics.checkNotNullParameter((Object)stopMode, (String)"stopMode");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.port = port;
        this.stopMode = stopMode;
        this.server = server;
        ServerConfig.StopMode stopMode2 = this.getStopMode();
        if (stopMode2 instanceof ServerConfig.StopMode.Graceful) {
            Server server2;
            Server $this$_init__u24lambda_u242 = server2 = this.server;
            boolean bl = false;
            $this$_init__u24lambda_u242.setStopTimeout(((ServerConfig.StopMode.Graceful)this.getStopMode()).getTimeout().toMillis());
        } else if (stopMode2 instanceof ServerConfig.StopMode.Immediate) {
            throw new ServerConfig.UnsupportedStopMode(this.getStopMode());
        }
    }

    @NotNull
    public ServerConfig.StopMode getStopMode() {
        return this.stopMode;
    }

    public Jetty(int port) {
        Duration duration = Duration.ofSeconds(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(5)");
        this(port, (ServerConfig.StopMode)new ServerConfig.StopMode.Graceful(duration));
    }

    public /* synthetic */ Jetty(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 8000;
        }
        this(n);
    }

    public Jetty(int port, @NotNull ServerConfig.StopMode stopMode) {
        Intrinsics.checkNotNullParameter((Object)stopMode, (String)"stopMode");
        Function1[] function1Array = new Function1[]{JettyInfraKt.http(port)};
        this(port, stopMode, function1Array);
    }

    public /* synthetic */ Jetty(int n, ServerConfig.StopMode stopMode, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 8000;
        }
        this(n, stopMode);
    }

    public Jetty(int port, @NotNull Server server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Duration duration = Duration.ofSeconds(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(5)");
        this(port, (ServerConfig.StopMode)new ServerConfig.StopMode.Graceful(duration), server);
    }

    public /* synthetic */ Jetty(int n, Server server, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 8000;
        }
        this(n, server);
    }

    public Jetty(int port, Function1<? super Server, ? extends ServerConnector> ... inConnectors) {
        Intrinsics.checkNotNullParameter(inConnectors, (String)"inConnectors");
        Duration duration = Duration.ofSeconds(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(5)");
        this(port, (ServerConfig.StopMode)new ServerConfig.StopMode.Graceful(duration), Arrays.copyOf(inConnectors, inConnectors.length));
    }

    /*
     * WARNING - void declaration
     */
    public Jetty(int port, @NotNull ServerConfig.StopMode stopMode, Function1<? super Server, ? extends ServerConnector> ... inConnectors) {
        Server server;
        Intrinsics.checkNotNullParameter((Object)stopMode, (String)"stopMode");
        Intrinsics.checkNotNullParameter(inConnectors, (String)"inConnectors");
        Server server2 = server = new Server();
        ServerConfig.StopMode stopMode2 = stopMode;
        int n = port;
        Jetty jetty = this;
        boolean bl = false;
        Function1<? super Server, ? extends ServerConnector>[] $this$forEach$iv = inConnectors;
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (int i = 0; i < n2; ++i) {
            void $this$_init__u24lambda_u241;
            Function1<? super Server, ? extends ServerConnector> element$iv;
            Function1<? super Server, ? extends ServerConnector> it = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            $this$_init__u24lambda_u241.addConnector((Connector)it.invoke((Object)$this$_init__u24lambda_u241));
        }
        Unit unit = Unit.INSTANCE;
        jetty(n, stopMode2, server);
    }

    @NotNull
    public Http4kServer toServer(@Nullable Function1<? super Request, ? extends Response> http3, @Nullable Function1<? super Request, ? extends Function1<? super Websocket, Unit>> ws, @Nullable Function1<? super Request, ? extends Function1<? super Sse, Unit>> sse) {
        block2: {
            Function1<? super Request, ? extends Response> it;
            Function1<? super Request, ? extends Response> function1 = http3;
            if (function1 != null) {
                it = function1;
                boolean bl = false;
                this.server.insertHandler(JettyInfraKt.toJettyHandler(http3, this.getStopMode() instanceof ServerConfig.StopMode.Graceful));
            }
            Function1<? super Request, ? extends Function1<? super Sse, Unit>> function12 = sse;
            if (function12 != null) {
                it = function12;
                boolean bl = false;
                this.server.insertHandler((HandlerWrapper)JettyInfraKt.toJettySseHandler(sse));
            }
            Function1<? super Request, ? extends Function1<? super Websocket, Unit>> function13 = ws;
            if (function13 == null) break block2;
            it = function13;
            boolean bl = false;
            this.server.insertHandler((HandlerWrapper)JettyInfraKt.toJettyWsHandler(ws));
        }
        return new Http4kServer(this){
            final /* synthetic */ Jetty this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Http4kServer start() {
                toServer.4 var1_1 = this;
                Jetty jetty = this.this$0;
                toServer.4 $this$start_u24lambda_u240 = var1_1;
                boolean bl = false;
                Jetty.access$getServer$p(jetty).start();
                return var1_1;
            }

            @NotNull
            public Http4kServer stop() {
                toServer.4 var1_1 = this;
                Jetty jetty = this.this$0;
                toServer.4 $this$stop_u24lambda_u241 = var1_1;
                boolean bl = false;
                Jetty.access$getServer$p(jetty).stop();
                return var1_1;
            }

            public int port() {
                return Jetty.access$getPort$p(this.this$0) > 0 ? Jetty.access$getPort$p(this.this$0) : Jetty.access$getServer$p(this.this$0).getURI().getPort();
            }

            public void block() {
                Http4kServer.DefaultImpls.block((Http4kServer)this);
            }

            public void close() {
                Http4kServer.DefaultImpls.close((Http4kServer)this);
            }
        };
    }

    @NotNull
    public Http4kServer toServer(@NotNull Function1<? super Request, ? extends Response> http3) {
        return PolyServerConfig.DefaultImpls.toServer((PolyServerConfig)this, http3);
    }

    @NotNull
    public Http4kServer toSseServer(@NotNull Function1<? super Request, ? extends Function1<? super Sse, Unit>> sse) {
        return PolyServerConfig.DefaultImpls.toSseServer((PolyServerConfig)this, sse);
    }

    @NotNull
    public Http4kServer toWsServer(@NotNull Function1<? super Request, ? extends Function1<? super Websocket, Unit>> ws) {
        return PolyServerConfig.DefaultImpls.toWsServer((PolyServerConfig)this, ws);
    }

    public static final /* synthetic */ int access$getPort$p(Jetty $this) {
        return $this.port;
    }

    public static final /* synthetic */ Server access$getServer$p(Jetty $this) {
        return $this.server;
    }
}

