/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.server;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.thread.Scheduler;
import org.http4k.core.ContentType;
import org.http4k.server.JettyEventStreamEmitter;
import org.http4k.servlet.jakarta.Http4kJakartaServletAdapterKt;
import org.http4k.sse.Sse;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B7\u0012&\u0010\u0002\u001a\"\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003j\u0002`\u00070\u0003j\u0002`\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ(\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0002\u001a\"\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003j\u0002`\u00070\u0003j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/http4k/server/JettyEventStreamHandler;", "Lorg/eclipse/jetty/server/handler/HandlerWrapper;", "sse", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lorg/http4k/sse/Sse;", "", "Lorg/http4k/sse/SseConsumer;", "Lorg/http4k/sse/SseHandler;", "heartBeatDuration", "Ljava/time/Duration;", "(Lkotlin/jvm/functions/Function1;Ljava/time/Duration;)V", "handle", "target", "", "baseRequest", "Lorg/eclipse/jetty/server/Request;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "Companion", "http4k-server-jetty"})
@SourceDebugExtension(value={"SMAP\nJettyEventStreamHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JettyEventStreamHandler.kt\norg/http4k/server/JettyEventStreamHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1#2:175\n*E\n"})
public final class JettyEventStreamHandler
extends HandlerWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<org.http4k.core.Request, Function1<Sse, Unit>> sse;
    @NotNull
    private final Duration heartBeatDuration;

    public JettyEventStreamHandler(@NotNull Function1<? super org.http4k.core.Request, ? extends Function1<? super Sse, Unit>> sse, @NotNull Duration heartBeatDuration) {
        Intrinsics.checkNotNullParameter(sse, (String)"sse");
        Intrinsics.checkNotNullParameter((Object)heartBeatDuration, (String)"heartBeatDuration");
        this.sse = sse;
        this.heartBeatDuration = heartBeatDuration;
    }

    public /* synthetic */ JettyEventStreamHandler(Function1 function1, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofSeconds(15L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(15)");
            duration = duration2;
        }
        this((Function1<? super org.http4k.core.Request, ? extends Function1<? super Sse, Unit>>)function1, duration);
    }

    public void handle(@NotNull String target, @NotNull Request baseRequest, @NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        org.http4k.core.Request connectRequest;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)baseRequest, (String)"baseRequest");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (!baseRequest.isHandled() && JettyEventStreamHandler.Companion.isEventStream(request) && (connectRequest = Http4kJakartaServletAdapterKt.asHttp4kRequest((HttpServletRequest)request)) != null) {
            JettyEventStreamHandler.Companion.writeEventStreamResponse(response);
            AsyncContext async = JettyEventStreamHandler.Companion.startAsyncWithNoTimeout(request);
            ServletOutputStream output = async.getResponse().getOutputStream();
            Scheduler scheduler = baseRequest.getHttpChannel().getConnector().getScheduler();
            Server server = baseRequest.getHttpChannel().getConnector().getServer();
            Intrinsics.checkNotNullExpressionValue((Object)output, (String)"output");
            OutputStream outputStream = (OutputStream)output;
            Intrinsics.checkNotNullExpressionValue((Object)scheduler, (String)"scheduler");
            JettyEventStreamEmitter jettyEventStreamEmitter = new JettyEventStreamEmitter(connectRequest, outputStream, this.heartBeatDuration, scheduler, (Function1<? super JettyEventStreamEmitter, Unit>)((Function1)new Function1<JettyEventStreamEmitter, Unit>(async, server){
                final /* synthetic */ AsyncContext $async;
                final /* synthetic */ Server $server;
                {
                    this.$async = $async;
                    this.$server = $server;
                    super(1);
                }

                public final void invoke(@NotNull JettyEventStreamEmitter it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$async.complete();
                    this.$server.removeEventListener((EventListener)((Object)it));
                }
            }));
            EventListener p0 = (EventListener)((Object)jettyEventStreamEmitter);
            boolean bl = false;
            server.addEventListener(p0);
            JettyEventStreamEmitter emitter2 = jettyEventStreamEmitter;
            ((Function1)this.sse.invoke((Object)connectRequest)).invoke((Object)emitter2);
            baseRequest.setHandled(true);
        }
        if (!baseRequest.isHandled()) {
            super.handle(target, baseRequest, request, response);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0002J\u0014\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007*\u00020\u0005H\u0002J\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/http4k/server/JettyEventStreamHandler$Companion;", "", "()V", "isEventStream", "", "Ljakarta/servlet/http/HttpServletRequest;", "startAsyncWithNoTimeout", "Ljakarta/servlet/AsyncContext;", "kotlin.jvm.PlatformType", "writeEventStreamResponse", "", "Ljakarta/servlet/http/HttpServletResponse;", "http4k-server-jetty"})
    @SourceDebugExtension(value={"SMAP\nJettyEventStreamHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JettyEventStreamHandler.kt\norg/http4k/server/JettyEventStreamHandler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n1747#2,3:175\n*S KotlinDebug\n*F\n+ 1 JettyEventStreamHandler.kt\norg/http4k/server/JettyEventStreamHandler$Companion\n*L\n54#1:175,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isEventStream(HttpServletRequest $this$isEventStream) {
            String it;
            if (!Intrinsics.areEqual((Object)$this$isEventStream.getMethod(), (Object)"GET")) return false;
            Enumeration enumeration = $this$isEventStream.getHeaders("Accept");
            Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getHeaders(\"Accept\")");
            ArrayList arrayList = Collections.list(enumeration);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(this)");
            Iterable $this$any$iv = arrayList;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (String)element$iv;
                boolean bl = false;
            } while (!StringsKt.equals((String)it, (String)ContentType.Companion.getTEXT_EVENT_STREAM().getValue(), (boolean)true));
            return true;
        }

        private final void writeEventStreamResponse(HttpServletResponse $this$writeEventStreamResponse) {
            $this$writeEventStreamResponse.setStatus(200);
            $this$writeEventStreamResponse.setCharacterEncoding(StandardCharsets.UTF_8.name());
            $this$writeEventStreamResponse.setContentType(ContentType.Companion.getTEXT_EVENT_STREAM().getValue());
            $this$writeEventStreamResponse.addHeader("Connection", "close");
            $this$writeEventStreamResponse.flushBuffer();
        }

        private final AsyncContext startAsyncWithNoTimeout(HttpServletRequest $this$startAsyncWithNoTimeout) {
            AsyncContext asyncContext;
            AsyncContext $this$startAsyncWithNoTimeout_u24lambda_u241 = asyncContext = $this$startAsyncWithNoTimeout.startAsync();
            boolean bl = false;
            $this$startAsyncWithNoTimeout_u24lambda_u241.setTimeout(0L);
            return asyncContext;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

