/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerKeepAliveHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.server.Http4kChannelHandler;
import org.http4k.server.Http4kServer;
import org.http4k.server.Netty;
import org.http4k.server.PolyServerConfig;
import org.http4k.server.ServerConfig;
import org.http4k.server.WebSocketServerHandler;
import org.http4k.sse.SseResponse;
import org.http4k.websocket.WsResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007Jk\u0010\u0010\u001a\u00020\u00112)\u0010\u0012\u001a%\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0013j\u0004\u0018\u0001`\u00192\u001a\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0013j\u0004\u0018\u0001`\u001c2\u001a\u0010\u001d\u001a\u0016\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u0013j\u0004\u0018\u0001`\u001fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lorg/http4k/server/Netty;", "Lorg/http4k/server/PolyServerConfig;", "port", "", "(I)V", "stopMode", "Lorg/http4k/server/ServerConfig$StopMode;", "(ILorg/http4k/server/ServerConfig$StopMode;)V", "getPort", "()I", "shutdownTimeoutMillis", "", "getShutdownTimeoutMillis", "()J", "getStopMode", "()Lorg/http4k/server/ServerConfig$StopMode;", "toServer", "Lorg/http4k/server/Http4kServer;", "http", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lkotlin/ParameterName;", "name", "request", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "ws", "Lorg/http4k/websocket/WsResponse;", "Lorg/http4k/websocket/WsHandler;", "sse", "Lorg/http4k/sse/SseResponse;", "Lorg/http4k/sse/SseHandler;", "http4k-server-netty"})
public final class Netty
implements PolyServerConfig {
    private final int port;
    @NotNull
    private final ServerConfig.StopMode stopMode;
    private final long shutdownTimeoutMillis;

    public Netty(int port, @NotNull ServerConfig.StopMode stopMode) {
        long l;
        Intrinsics.checkNotNullParameter((Object)stopMode, (String)"stopMode");
        this.port = port;
        this.stopMode = stopMode;
        ServerConfig.StopMode stopMode2 = this.getStopMode();
        if (stopMode2 instanceof ServerConfig.StopMode.Graceful) {
            l = ((ServerConfig.StopMode.Graceful)this.getStopMode()).getTimeout().toMillis();
        } else if (stopMode2 instanceof ServerConfig.StopMode.Immediate) {
            l = 0L;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.shutdownTimeoutMillis = l;
    }

    public /* synthetic */ Netty(int n, ServerConfig.StopMode stopMode, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 8000;
        }
        this(n, stopMode);
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public ServerConfig.StopMode getStopMode() {
        return this.stopMode;
    }

    public Netty(int port) {
        Duration duration = Duration.ofSeconds(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        this(port, (ServerConfig.StopMode)new ServerConfig.StopMode.Graceful(duration));
    }

    public /* synthetic */ Netty(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 8000;
        }
        this(n);
    }

    public final long getShutdownTimeoutMillis() {
        return this.shutdownTimeoutMillis;
    }

    @NotNull
    public Http4kServer toServer(@Nullable Function1<? super Request, ? extends Response> http, @Nullable Function1<? super Request, WsResponse> ws, @Nullable Function1<? super Request, SseResponse> sse) {
        return new Http4kServer(sse, this, ws, http){
            @NotNull
            private final NioEventLoopGroup masterGroup;
            @NotNull
            private final NioEventLoopGroup workerGroup;
            @Nullable
            private ChannelFuture closeFuture;
            private InetSocketAddress address;
            final /* synthetic */ Netty this$0;
            final /* synthetic */ Function1<Request, WsResponse> $ws;
            final /* synthetic */ Function1<Request, Response> $http;
            {
                this.this$0 = $receiver;
                this.$ws = $ws;
                this.$http = $http;
                if ($sse != null) {
                    throw new UnsupportedOperationException("Netty does not support sse");
                }
                this.masterGroup = new NioEventLoopGroup();
                this.workerGroup = new NioEventLoopGroup();
            }

            @NotNull
            public Http4kServer start() {
                toServer.1 var1_1 = this;
                Netty netty = this.this$0;
                Function1<Request, WsResponse> function1 = this.$ws;
                Function1<Request, Response> function12 = this.$http;
                toServer.1 $this$start_u24lambda_u241 = var1_1;
                boolean bl = false;
                ServerBootstrap bootstrap = new ServerBootstrap();
                ((ServerBootstrap)((ServerBootstrap)bootstrap.group((EventLoopGroup)$this$start_u24lambda_u241.masterGroup, (EventLoopGroup)$this$start_u24lambda_u241.workerGroup).channelFactory(toServer.1::start$lambda$1$lambda$0)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(function1, function12){
                    final /* synthetic */ Function1<Request, WsResponse> $ws;
                    final /* synthetic */ Function1<Request, Response> $http;
                    {
                        this.$ws = $ws;
                        this.$http = $http;
                    }

                    public void initChannel(@NotNull SocketChannel ch) {
                        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
                        ch.pipeline().addLast("codec", (ChannelHandler)new HttpServerCodec());
                        ch.pipeline().addLast("keepAlive", (ChannelHandler)new HttpServerKeepAliveHandler());
                        ch.pipeline().addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(Integer.MAX_VALUE));
                        if (this.$ws != null) {
                            ch.pipeline().addLast("websocket", (ChannelHandler)new WebSocketServerHandler(this.$ws));
                        }
                        ch.pipeline().addLast("streamer", (ChannelHandler)new ChunkedWriteHandler());
                        if (this.$http != null) {
                            ch.pipeline().addLast("httpHandler", (ChannelHandler)new Http4kChannelHandler(this.$http));
                        }
                    }
                }).option(ChannelOption.SO_BACKLOG, (Object)1000)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
                Channel channel = bootstrap.bind(netty.getPort()).sync().channel();
                SocketAddress socketAddress = channel.localAddress();
                Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
                $this$start_u24lambda_u241.address = (InetSocketAddress)socketAddress;
                $this$start_u24lambda_u241.closeFuture = channel.closeFuture();
                return var1_1;
            }

            @NotNull
            public toServer.1 stop() {
                toServer.1 var1_1 = this;
                Netty netty = this.this$0;
                toServer.1 $this$stop_u24lambda_u242 = var1_1;
                boolean bl = false;
                ChannelFuture channelFuture = $this$stop_u24lambda_u242.closeFuture;
                if (channelFuture != null) {
                    channelFuture.cancel(false);
                }
                long sleepTime = Math.min(2000L, netty.getShutdownTimeoutMillis());
                $this$stop_u24lambda_u242.workerGroup.shutdownGracefully(sleepTime, netty.getShutdownTimeoutMillis(), TimeUnit.MILLISECONDS).sync();
                $this$stop_u24lambda_u242.masterGroup.shutdownGracefully(sleepTime, netty.getShutdownTimeoutMillis(), TimeUnit.MILLISECONDS).sync();
                return var1_1;
            }

            public int port() {
                int n;
                if (this.this$0.getPort() > 0) {
                    n = this.this$0.getPort();
                } else {
                    InetSocketAddress inetSocketAddress = this.address;
                    if (inetSocketAddress == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"address");
                        inetSocketAddress = null;
                    }
                    n = inetSocketAddress.getPort();
                }
                return n;
            }

            public void block() {
                Http4kServer.DefaultImpls.block((Http4kServer)this);
            }

            public void close() {
                Http4kServer.DefaultImpls.close((Http4kServer)this);
            }

            private static final ServerChannel start$lambda$1$lambda$0() {
                return (ServerChannel)new NioServerSocketChannel();
            }
        };
    }

    @NotNull
    public Http4kServer toServer(@NotNull Function1<? super Request, ? extends Response> http) {
        return PolyServerConfig.DefaultImpls.toServer((PolyServerConfig)this, http);
    }

    @NotNull
    public Http4kServer toSseServer(@NotNull Function1<? super Request, SseResponse> sse) {
        return PolyServerConfig.DefaultImpls.toSseServer((PolyServerConfig)this, sse);
    }

    @NotNull
    public Http4kServer toWsServer(@NotNull Function1<? super Request, WsResponse> ws) {
        return PolyServerConfig.DefaultImpls.toWsServer((PolyServerConfig)this, ws);
    }
}

