/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.RequestSource;
import org.http4k.core.Uri;
import org.http4k.server.Http4kWsChannelHandler;
import org.http4k.websocket.Websocket;
import org.http4k.websocket.WsResponse;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u0012\u001a\u00020\u0004*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/http4k/server/WebSocketServerHandler;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "wsHandler", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lorg/http4k/websocket/WsResponse;", "Lorg/http4k/websocket/WsHandler;", "(Lkotlin/jvm/functions/Function1;)V", "channelRead", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "msg", "", "requiresWsUpgrade", "", "httpRequest", "Lio/netty/handler/codec/http/HttpRequest;", "asRequest", "address", "Ljava/net/InetSocketAddress;", "http4k-server-netty"})
@SourceDebugExtension(value={"SMAP\nWebSocketServerHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSocketServerHandler.kt\norg/http4k/server/WebSocketServerHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1549#2:73\n1620#2,3:74\n*S KotlinDebug\n*F\n+ 1 WebSocketServerHandler.kt\norg/http4k/server/WebSocketServerHandler\n*L\n69#1:73\n69#1:74,3\n*E\n"})
public final class WebSocketServerHandler
extends ChannelInboundHandlerAdapter {
    @NotNull
    private final Function1<Request, WsResponse> wsHandler;

    public WebSocketServerHandler(@NotNull Function1<? super Request, WsResponse> wsHandler) {
        Intrinsics.checkNotNullParameter(wsHandler, (String)"wsHandler");
        this.wsHandler = wsHandler;
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (msg instanceof HttpRequest) {
            if (this.requiresWsUpgrade((HttpRequest)msg)) {
                SocketAddress socketAddress = ctx.channel().remoteAddress();
                Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
                InetSocketAddress address = (InetSocketAddress)socketAddress;
                Request upgradeRequest = this.asRequest((HttpRequest)msg, address);
                WsResponse wsConsumer = (WsResponse)this.wsHandler.invoke((Object)upgradeRequest);
                WebSocketServerProtocolConfig config = WebSocketServerProtocolConfig.newBuilder().handleCloseFrames(false).websocketPath(upgradeRequest.getUri().toString()).checkStartsWith(true).build();
                ctx.pipeline().addAfter(ctx.name(), "handshakeListener", (ChannelHandler)new ChannelInboundHandlerAdapter(wsConsumer){
                    final /* synthetic */ WsResponse $wsConsumer;
                    {
                        this.$wsConsumer = $wsConsumer;
                    }

                    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) {
                        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                        if (evt instanceof WebSocketServerProtocolHandler.HandshakeComplete) {
                            ctx.pipeline().addAfter(ctx.name(), Http4kWsChannelHandler.class.getName(), (ChannelHandler)new Http4kWsChannelHandler((Function1<? super Websocket, Unit>)((Function1)this.$wsConsumer)));
                        }
                    }
                });
                ctx.pipeline().addAfter(ctx.name(), WebSocketServerProtocolHandler.class.getName(), (ChannelHandler)new WebSocketServerProtocolHandler(config));
                ctx.fireChannelRead(msg);
            } else {
                ctx.fireChannelRead(msg);
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private final boolean requiresWsUpgrade(HttpRequest httpRequest) {
        return httpRequest.headers().containsValue((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.UPGRADE, true) && httpRequest.headers().containsValue((CharSequence)HttpHeaderValues.UPGRADE, (CharSequence)HttpHeaderValues.WEBSOCKET, true);
    }

    /*
     * WARNING - void declaration
     */
    private final Request asRequest(HttpRequest $this$asRequest, InetSocketAddress address) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string = $this$asRequest.method().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        Method method = Method.valueOf((String)string);
        String string2 = $this$asRequest.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"uri(...)");
        Request request = Request.Companion.create$default((Request.Companion)Request.Companion, (Method)method, (Uri)Uri.Companion.of(string2), null, (int)4, null);
        HttpHeaders httpHeaders = $this$asRequest.headers();
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"headers(...)");
        Iterable iterable = (Iterable)httpHeaders;
        Request request2 = request;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getKey(), it.getValue()));
        }
        Request request3 = request2.headers((List)destination$iv$iv);
        String string3 = address.getAddress().getHostAddress();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getHostAddress(...)");
        return request3.source(new RequestSource(string3, Integer.valueOf(address.getPort()), null, 4, null));
    }
}

