/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.testing;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.HttpMessage;
import org.http4k.testing.ApprovalContent;
import org.http4k.testing.ApprovalFailed;
import org.http4k.testing.ApprovalSource;
import org.http4k.testing.ApprovalTransformer;
import org.http4k.testing.Approver;
import org.http4k.testing.ReadResource;
import org.http4k.testing.ReadWriteResource;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\b\u0002\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\u0002\u0010\nJ\u001f\u0010\u000b\u001a\u00020\f\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/http4k/testing/NamedResourceApprover;", "Lorg/http4k/testing/Approver;", "name", "", "approvalContent", "Lorg/http4k/testing/ApprovalContent;", "approvalSource", "Lorg/http4k/testing/ApprovalSource;", "transformer", "Lorg/http4k/testing/ApprovalTransformer;", "(Ljava/lang/String;Lorg/http4k/testing/ApprovalContent;Lorg/http4k/testing/ApprovalSource;Lorg/http4k/testing/ApprovalTransformer;)V", "assertApproved", "", "T", "Lorg/http4k/core/HttpMessage;", "httpMessage", "(Lorg/http4k/core/HttpMessage;)V", "withNameSuffix", "suffix", "http4k-testing-approval"})
public final class NamedResourceApprover
implements Approver {
    @NotNull
    private final String name;
    @NotNull
    private final ApprovalContent approvalContent;
    @NotNull
    private final ApprovalSource approvalSource;
    @NotNull
    private final ApprovalTransformer<?> transformer;

    public NamedResourceApprover(@NotNull String name, @NotNull ApprovalContent approvalContent, @NotNull ApprovalSource approvalSource, @NotNull ApprovalTransformer<?> transformer) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)approvalContent, (String)"approvalContent");
        Intrinsics.checkNotNullParameter((Object)approvalSource, (String)"approvalSource");
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        this.name = name;
        this.approvalContent = approvalContent;
        this.approvalSource = approvalSource;
        this.transformer = transformer;
    }

    public /* synthetic */ NamedResourceApprover(String string, ApprovalContent approvalContent, ApprovalSource approvalSource, ApprovalTransformer approvalTransformer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            approvalTransformer = ApprovalTransformer.Companion.StringWithNormalisedLineEndings();
        }
        this(string, approvalContent, approvalSource, approvalTransformer);
    }

    @Override
    @NotNull
    public NamedResourceApprover withNameSuffix(@NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        return new NamedResourceApprover(this.name + '.' + suffix, this.approvalContent, this.approvalSource, null, 8, null);
    }

    @Override
    public <T extends HttpMessage> void assertApproved(@NotNull T httpMessage) {
        Intrinsics.checkNotNullParameter(httpMessage, (String)"httpMessage");
        ReadResource approved = this.approvalSource.approvedFor(this.name);
        ReadWriteResource actual = this.approvalSource.actualFor(this.name);
        byte[] actualBytes = ByteStreamsKt.readBytes((InputStream)this.approvalContent.invoke(httpMessage));
        InputStream $this$assertApproved_u24lambda_u240 = approved.input();
        boolean bl = false;
        actual.output();
        if ($this$assertApproved_u24lambda_u240 == null) {
            if (!(actualBytes.length == 0)) {
                actual.output().write(actualBytes);
                throw new ApprovalFailed("No approved content found", actual, approved);
            }
        } else {
            try {
                Assertions.assertEquals((Object)this.transformer.invoke(this.approvalContent.invoke($this$assertApproved_u24lambda_u240)), (Object)this.transformer.invoke(new ByteArrayInputStream(actualBytes)));
            }
            catch (AssertionError e) {
                ByteStreamsKt.copyTo$default((InputStream)new ByteArrayInputStream(actualBytes), (OutputStream)actual.output(), (int)0, (int)2, null);
                throw new AssertionError((Object)(new ApprovalFailed("Mismatch", actual, approved).getMessage() + '\n' + ((Throwable)((Object)e)).getMessage()));
            }
        }
    }
}

