/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http20;

import java.nio.ByteBuffer;
import org.http4s.blaze.http.http20.FrameHandler;
import org.http4s.blaze.http.http20.Http2Exception$;
import org.http4s.blaze.http.http20.Http2Settings;
import org.http4s.blaze.http.http20.Http2Settings$Setting$;
import org.http4s.blaze.http.http20.bits$;
import org.http4s.blaze.http.http20.bits$Flags$;
import org.http4s.blaze.http.http20.bits$FrameTypes$;
import org.http4s.blaze.http.http20.bits$Masks$;
import org.http4s.blaze.http.http20.package;
import org.http4s.blaze.http.http20.package$BufferUnderflow$;
import org.http4s.blaze.http.http20.package$Continue$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}caB\u0001\u0003!\u0003\rI!\u0004\u0002\u0013\u0011R$\bO\r\u0019Ge\u0006lW\rR3d_\u0012,'O\u0003\u0002\u0004\t\u00051\u0001\u000e\u001e;qeAR!!\u0002\u0004\u0002\t!$H\u000f\u001d\u0006\u0003\u000f!\tQA\u00197bu\u0016T!!\u0003\u0006\u0002\r!$H\u000f\u001d\u001bt\u0015\u0005Y\u0011aA8sO\u000e\u00011C\u0001\u0001\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\")Q\u0003\u0001C\u0001-\u00051A%\u001b8ji\u0012\"\u0012a\u0006\t\u0003\u001faI!!\u0007\t\u0003\tUs\u0017\u000e\u001e\u0005\b7\u0001\u0011\rQ\"\u0005\u001d\u0003\u001dA\u0017M\u001c3mKJ,\u0012!\b\t\u0003=}i\u0011AA\u0005\u0003A\t\u0011AB\u0012:b[\u0016D\u0015M\u001c3mKJDqA\t\u0001C\u0002\u001bE1%A\u0007iiR\u0004(gU3ui&twm]\u000b\u0002IA\u0011a$J\u0005\u0003M\t\u0011Q\u0002\u0013;uaJ\u001aV\r\u001e;j]\u001e\u001c\b\"\u0002\u0015\u0001\t\u0003I\u0013\u0001\u00043fG>$WMQ;gM\u0016\u0014HC\u0001\u00162!\tYcF\u0004\u0002\u001fY%\u0011QFA\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0003GA\u0006IiR\u0004(GU3tk2$(BA\u0017\u0003\u0011\u0015\u0011t\u00051\u00014\u0003\u0019\u0011WO\u001a4feB\u0011A'O\u0007\u0002k)\u0011agN\u0001\u0004]&|'\"\u0001\u001d\u0002\t)\fg/Y\u0005\u0003uU\u0012!BQ=uK\n+hMZ3s\u0011\u0015a\u0004\u0001\"\u0001>\u0003Ayg.\u0012=uK:\u001c\u0018n\u001c8Ge\u0006lW\rF\u0003+}\r+%\nC\u0003@w\u0001\u0007\u0001)\u0001\u0003d_\u0012,\u0007CA\bB\u0013\t\u0011\u0005CA\u0002J]RDQ\u0001R\u001eA\u0002\u0001\u000b\u0001b\u001d;sK\u0006l\u0017\n\u001a\u0005\u0006\rn\u0002\raR\u0001\u0006M2\fwm\u001d\t\u0003\u001f!K!!\u0013\t\u0003\t\tKH/\u001a\u0005\u0006em\u0002\ra\r\u0005\u0006\u0019\u0002!I!T\u0001\u0010I\u0016\u001cw\u000eZ3ECR\fgI]1nKR!!FT(Q\u0011\u0015\u00114\n1\u00014\u0011\u0015!5\n1\u0001A\u0011\u001515\n1\u0001H\u0011\u0015\u0011\u0006\u0001\"\u0003T\u0003E!WmY8eK\"+\u0017\rZ3s\rJ\fW.\u001a\u000b\u0005UQ+f\u000bC\u00033#\u0002\u00071\u0007C\u0003E#\u0002\u0007\u0001\tC\u0003G#\u0002\u0007q\tC\u0003Y\u0001\u0011%\u0011,A\neK\u000e|G-\u001a)sS>\u0014\u0018\u000e^=Ge\u0006lW\r\u0006\u0003+5nc\u0006\"\u0002\u001aX\u0001\u0004\u0019\u0004\"\u0002#X\u0001\u0004\u0001\u0005\"\u0002$X\u0001\u00049\u0005\"\u00020\u0001\t\u0013y\u0016aC4fiB\u0013\u0018n\u001c:jif$\"\u0001Y2\u0011\u0005-\n\u0017B\u000121\u0005!\u0001&/[8sSRL\b\"\u0002\u001a^\u0001\u0004\u0019\u0004\"B3\u0001\t\u00131\u0017\u0001\u00063fG>$WMU:u'R\u0014X-Y7Ge\u0006lW\rF\u0002+O\"DQA\r3A\u0002MBQ\u0001\u00123A\u0002\u0001CQA\u001b\u0001\u0005\n-\f1\u0003Z3d_\u0012,7+\u001a;uS:<7O\u0012:b[\u0016$BA\u000b7n]\")!'\u001ba\u0001g!)A)\u001ba\u0001\u0001\")a)\u001ba\u0001\u000f\")\u0001\u000f\u0001C\u0005c\u00061B-Z2pI\u0016\u0004Vo\u001d5Qe>l\u0017n]3Ge\u0006lW\r\u0006\u0003+eN$\b\"\u0002\u001ap\u0001\u0004\u0019\u0004\"\u0002#p\u0001\u0004\u0001\u0005\"\u0002$p\u0001\u00049\u0005\"\u0002<\u0001\t\u00139\u0018a\u00043fG>$W\rU5oO\u001a\u0013\u0018-\\3\u0015\t)B\u0018P\u001f\u0005\u0006eU\u0004\ra\r\u0005\u0006\tV\u0004\r\u0001\u0011\u0005\u0006\rV\u0004\ra\u0012\u0005\u0006y\u0002!I!`\u0001\u0012I\u0016\u001cw\u000eZ3H_\u0006;\u0018-\u001f$sC6,Gc\u0001\u0016\u007f\u007f\")!g\u001fa\u0001g!)Ai\u001fa\u0001\u0001\"9\u00111\u0001\u0001\u0005\n\u0005\u0015\u0011a\u00063fG>$WmV5oI><X\u000b\u001d3bi\u00164%/Y7f)\u0015Q\u0013qAA\u0005\u0011\u0019\u0011\u0014\u0011\u0001a\u0001g!1A)!\u0001A\u0002\u0001Cq!!\u0004\u0001\t\u0013\ty!A\feK\u000e|G-Z\"p]RLg.^1uS>tgI]1nKR9!&!\u0005\u0002\u0014\u0005U\u0001B\u0002\u001a\u0002\f\u0001\u00071\u0007\u0003\u0004E\u0003\u0017\u0001\r\u0001\u0011\u0005\u0007\r\u0006-\u0001\u0019A$\t\u001d\u0005e\u0001\u0001\"A\u0001\u0006\u0003\u0005\t\u0011\"\u0003\u0002\u001c\u0005YtN]4%QR$\b\u000fN:%E2\f'0\u001a\u0013iiR\u0004H\u0005\u001b;uaJ\u0002D\u0005\u0013;uaJ\u0002dI]1nK\u0012+7m\u001c3fe\u0012\"\u0003O]8u_\u0016\u0013(o\u001c:\u0015\t\u0005u\u00111\u0005\t\u0004W\u0005}\u0011bAA\u0011a\t)QI\u001d:pe\"A\u0011QEA\f\u0001\u0004\t9#A\u0002ng\u001e\u0004B!!\u000b\u000289!\u00111FA\u001a!\r\ti\u0003E\u0007\u0003\u0003_Q1!!\r\r\u0003\u0019a$o\\8u}%\u0019\u0011Q\u0007\t\u0002\rA\u0013X\rZ3g\u0013\u0011\tI$a\u000f\u0003\rM#(/\u001b8h\u0015\r\t)\u0004\u0005\u0005\b\u0003\u007f\u0001A\u0011BA!\u0003)\u0001(o\u001c;p\u000bJ\u0014xN\u001d\u000b\u0007\u0003;\t\u0019%!\u0012\t\u0011\u0005\u0015\u0012Q\ba\u0001\u0003OAq!a\u0012\u0002>\u0001\u0007\u0001)\u0001\u0004tiJ,\u0017-\u001c\u0005\b\u0003\u0017\u0002A\u0011BA'\u00031a\u0017.\\5u!\u0006$G-\u001b8h)\u0011\ty%!\u0016\u0011\u0007-\n\t&C\u0002\u0002TA\u0012!\"T1zE\u0016,%O]8s\u0011\u0019\u0011\u0014\u0011\na\u0001g!\"\u0011\u0011JA-!\ry\u00111L\u0005\u0004\u0003;\u0002\"AB5oY&tW\r")
public interface Http20FrameDecoder {
    public FrameHandler handler();

    public Http2Settings http2Settings();

    public static /* synthetic */ package.Http2Result decodeBuffer$(Http20FrameDecoder $this, ByteBuffer buffer) {
        return $this.decodeBuffer(buffer);
    }

    default public package.Http2Result decodeBuffer(ByteBuffer buffer) {
        package.Http2Result http2Result;
        if (buffer.remaining() < bits$.MODULE$.HeaderSize()) {
            return package$BufferUnderflow$.MODULE$;
        }
        buffer.mark();
        int len = (buffer.get() & 0xFF) << 16 | (buffer.get() & 0xFF) << 8 | buffer.get() & 0xFF;
        byte frameType = buffer.get();
        byte flags = buffer.get();
        int streamId = buffer.getInt() & bits$Masks$.MODULE$.STREAMID();
        if (len > this.http2Settings().maxFrameSize()) {
            http2Result = new package.Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HTTP2 packet is to large to handle."})).s((Seq)Nil$.MODULE$), streamId, true));
        } else if (this.handler().inHeaderSequence() && frameType != bits$FrameTypes$.MODULE$.CONTINUATION()) {
            http2Result = this.org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received frame type ", " while in in headers sequence"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)frameType)})));
        } else if (len > buffer.remaining()) {
            buffer.reset();
            http2Result = package$BufferUnderflow$.MODULE$;
        } else {
            int oldLimit = buffer.limit();
            int endOfFrame = buffer.position() + len;
            buffer.limit(endOfFrame);
            byte by = frameType;
            package.Http2Result http2Result2 = bits$FrameTypes$.MODULE$.DATA() == by ? this.decodeDataFrame(buffer, streamId, flags) : (bits$FrameTypes$.MODULE$.HEADERS() == by ? this.decodeHeaderFrame(buffer, streamId, flags) : (bits$FrameTypes$.MODULE$.PRIORITY() == by ? this.decodePriorityFrame(buffer, streamId, flags) : (bits$FrameTypes$.MODULE$.RST_STREAM() == by ? this.decodeRstStreamFrame(buffer, streamId) : (bits$FrameTypes$.MODULE$.SETTINGS() == by ? this.decodeSettingsFrame(buffer, streamId, flags) : (bits$FrameTypes$.MODULE$.PUSH_PROMISE() == by ? this.decodePushPromiseFrame(buffer, streamId, flags) : (bits$FrameTypes$.MODULE$.PING() == by ? this.decodePingFrame(buffer, streamId, flags) : (bits$FrameTypes$.MODULE$.GOAWAY() == by ? this.decodeGoAwayFrame(buffer, streamId) : (bits$FrameTypes$.MODULE$.WINDOW_UPDATE() == by ? this.decodeWindowUpdateFrame(buffer, streamId) : (bits$FrameTypes$.MODULE$.CONTINUATION() == by ? this.decodeContinuationFrame(buffer, streamId, flags) : this.onExtensionFrame(by, streamId, flags, buffer.slice()))))))))));
            package.Http2Result r = http2Result2;
            buffer.limit(oldLimit);
            buffer.position(endOfFrame);
            http2Result = r;
        }
        return http2Result;
    }

    public static /* synthetic */ package.Http2Result onExtensionFrame$(Http20FrameDecoder $this, int code, int streamId, byte flags, ByteBuffer buffer) {
        return $this.onExtensionFrame(code, streamId, flags, buffer);
    }

    default public package.Http2Result onExtensionFrame(int code, int streamId, byte flags, ByteBuffer buffer) {
        return this.handler().onExtensionFrame(code, streamId, flags, buffer);
    }

    private package.Http2Result decodeDataFrame(ByteBuffer buffer, int streamId, byte flags) {
        package.MaybeError r;
        if (streamId == 0) {
            return this.org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError("Data frame with streamID 0x0");
        }
        int payload = buffer.remaining();
        if (bits$Flags$.MODULE$.PADDED(flags) && !(r = this.limitPadding(buffer)).success()) {
            return r;
        }
        return this.handler().onDataFrame(streamId, bits$Flags$.MODULE$.END_STREAM(flags), buffer.slice(), payload);
    }

    private package.Http2Result decodeHeaderFrame(ByteBuffer buffer, int streamId, byte flags) {
        package.MaybeError r;
        if (streamId == 0) {
            return this.org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError("Headers frame with streamID 0x0");
        }
        if (bits$Flags$.MODULE$.PADDED(flags) && !(r = this.limitPadding(buffer)).success()) {
            return r;
        }
        None$ priority = bits$Flags$.MODULE$.PRIORITY(flags) ? new Some((Object)this.getPriority(buffer)) : None$.MODULE$;
        return priority.isDefined() && ((package.Priority)priority.get()).dependentStreamId() == streamId ? this.protoError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Header stream depends on itself"})).s((Seq)Nil$.MODULE$), streamId) : this.handler().onHeadersFrame(streamId, (Option<package.Priority>)priority, bits$Flags$.MODULE$.END_HEADERS(flags), bits$Flags$.MODULE$.END_STREAM(flags), buffer.slice());
    }

    private package.Http2Result decodePriorityFrame(ByteBuffer buffer, int streamId, byte flags) {
        if (streamId == 0) {
            return this.org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError("Priority frame with streamID 0x0");
        }
        if (buffer.remaining() != 5) {
            String msg = "Invalid PRIORITY frame size, required 5, received" + buffer.remaining();
            return new package.Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().apply(msg, streamId, false));
        }
        package.Priority priority = this.getPriority(buffer);
        return priority.dependentStreamId() == 0 ? this.org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError("Priority frame with stream dependency 0x0") : (priority.dependentStreamId() == streamId ? this.protoError("Priority frame depends on itself", streamId) : this.handler().onPriorityFrame(streamId, priority));
    }

    private package.Priority getPriority(ByteBuffer buffer) {
        int rawInt = buffer.getInt();
        int priority = (buffer.get() & 0xFF) + 1;
        boolean ex = bits$Flags$.MODULE$.DepExclusive(rawInt);
        return new package.Priority(bits$Flags$.MODULE$.DepID(rawInt), ex, priority);
    }

    private package.Http2Result decodeRstStreamFrame(ByteBuffer buffer, int streamId) {
        if (buffer.remaining() != 4) {
            String msg = "Invalid RST_STREAM frame size, required 4, received " + buffer.remaining();
            return new package.Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().apply(msg, streamId, true));
        }
        if (streamId == 0) {
            return this.org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError("RST_STREAM frame with stream ID 0");
        }
        int code = buffer.getInt();
        return this.handler().onRstStreamFrame(streamId, code);
    }

    private package.Http2Result decodeSettingsFrame(ByteBuffer buffer, int streamId, byte flags) {
        int len = buffer.remaining();
        boolean isAck = bits$Flags$.MODULE$.ACK(flags);
        int settingsCount = len / 6;
        if (len % 6 != 0) {
            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SETTINGS frame payload must be multiple of 6 bytes, size: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)len)}));
            return new package.Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().apply(msg, streamId, true));
        }
        if (isAck && settingsCount != 0) {
            String msg = "SETTINGS ACK frame with settings payload";
            return new package.Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().apply(msg, streamId, true));
        }
        if (streamId != 0) {
            return this.org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SETTINGS frame with invalid stream id: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)streamId)})));
        }
        ArrayBuffer settings = new ArrayBuffer(settingsCount);
        this.go$1(settingsCount, buffer, settings);
        return this.handler().onSettingsFrame(isAck, (Seq<Http2Settings.Setting>)settings);
    }

    private package.Http2Result decodePushPromiseFrame(ByteBuffer buffer, int streamId, byte flags) {
        package.MaybeError r;
        if (streamId == 0) {
            return this.org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError("Data frame with streamID 0x0");
        }
        if (bits$Flags$.MODULE$.PADDED(flags) && !(r = this.limitPadding(buffer)).success()) {
            return r;
        }
        int promisedId = buffer.getInt() & bits$Masks$.MODULE$.int31();
        return this.handler().onPushPromiseFrame(streamId, promisedId, bits$Flags$.MODULE$.END_HEADERS(flags), buffer.slice());
    }

    private package.Http2Result decodePingFrame(ByteBuffer buffer, int streamId, byte flags) {
        int pingSize = 8;
        if (streamId != 0) {
            return this.org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError("PING frame with streamID != 0x0");
        }
        if (buffer.remaining() != pingSize) {
            String msg = "Invalid PING frame size. Expected 4, received " + buffer.remaining();
            return new package.Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().apply(msg, true));
        }
        byte[] pingBytes = new byte[pingSize];
        buffer.get(pingBytes);
        return this.handler().onPingFrame(bits$Flags$.MODULE$.ACK(flags), pingBytes);
    }

    private package.Http2Result decodeGoAwayFrame(ByteBuffer buffer, int streamId) {
        if (buffer.remaining() < 8) {
            String msg = "GOAWAY frame is wrong size. Expected  > 8, received " + buffer.remaining();
            return new package.Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().apply(msg, true));
        }
        if (streamId != 0) {
            return this.org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError("GOAWAY frame with streamID != 0x0");
        }
        int lastStream = bits$Flags$.MODULE$.DepID(buffer.getInt());
        long code = (long)buffer.getInt() & 0xFFFFFFFFL;
        return this.handler().onGoAwayFrame(lastStream, code, buffer.slice());
    }

    private package.Http2Result decodeWindowUpdateFrame(ByteBuffer buffer, int streamId) {
        if (buffer.remaining() != 4) {
            String msg = "WINDOW_UPDATE frame frame is wrong size. Expected 8, received " + buffer.remaining();
            return new package.Error(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().apply(msg, streamId, true));
        }
        int size = buffer.getInt() & bits$Masks$.MODULE$.int31();
        return this.handler().onWindowUpdateFrame(streamId, size);
    }

    private package.Http2Result decodeContinuationFrame(ByteBuffer buffer, int streamId, byte flags) {
        package.Http2Result http2Result;
        if (streamId <= 0) {
            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CONTINUATION frame with invalid stream dependency: 0x", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Integer.toHexString(streamId)}));
            http2Result = this.org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError(msg);
        } else {
            http2Result = this.handler().onContinuationFrame(streamId, bits$Flags$.MODULE$.END_HEADERS(flags), buffer.slice());
        }
        return http2Result;
    }

    public static /* synthetic */ package.Error org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError$(Http20FrameDecoder $this, String msg) {
        return $this.org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError(msg);
    }

    default public package.Error org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError(String msg) {
        return new package.Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().apply(msg, true));
    }

    private package.Error protoError(String msg, int stream) {
        return new package.Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().apply(msg, stream, true));
    }

    private package.MaybeError limitPadding(ByteBuffer buffer) {
        Product product;
        int padding = buffer.get() & 0xFF;
        if (padding > 0) {
            if (padding >= buffer.remaining()) {
                product = this.org$http4s$blaze$http$http20$Http20FrameDecoder$$protoError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Padding, ", ", exceeds payload length: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)padding), BoxesRunTime.boxToInteger((int)buffer.remaining())})));
            } else {
                buffer.limit(buffer.limit() - padding);
                product = package$Continue$.MODULE$;
            }
        } else {
            product = package$Continue$.MODULE$;
        }
        return product;
    }

    private void go$1(int remaining, ByteBuffer buffer$1, ArrayBuffer settings$1) {
        while (remaining > 0) {
            int id = buffer$1.getShort() & 0xFFFF;
            long value = (long)buffer$1.getInt() & 0xFFFFFFFFL;
            settings$1.$plus$eq((Object)Http2Settings$Setting$.MODULE$.apply(id, value));
            --remaining;
        }
    }

    public static void $init$(Http20FrameDecoder $this) {
    }
}

