/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.nio.ByteBuffer;
import org.http4s.blaze.http.http2.FrameSerializer$;
import org.http4s.blaze.http.http2.HeaderEncoder;
import org.http4s.blaze.http.http2.Http2Settings;
import org.http4s.blaze.http.http2.Priority;
import org.http4s.blaze.util.BufferTools$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0007\u000f\reA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\tK\u0001\u0011\t\u0011)A\u0005M!)\u0011\u0006\u0001C\u0001U!1a\u0006\u0001Q\u0005\n=BQa\r\u0001\u0005\u0002QBQA\u000f\u0001\u0005\u0002mBQ!\u0012\u0001\u0005\u0002\u0019CQA\u0013\u0001\u0005\u0002-CQ\u0001\u0016\u0001\u0005\u0002UCQa\u0016\u0001\u0005\u0002aCQa\u0018\u0001\u0005\u0002\u0001DQA\u001c\u0001\u0005\u0002=\u0014AB\u0012:b[\u0016,enY8eKJT!a\u0004\t\u0002\u000b!$H\u000f\u001d\u001a\u000b\u0005E\u0011\u0012\u0001\u00025uiBT!a\u0005\u000b\u0002\u000b\td\u0017M_3\u000b\u0005U1\u0012A\u00025uiB$4OC\u0001\u0018\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0004\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0004B]f\u0014VMZ\u0001\u000fe\u0016lw\u000e^3TKR$\u0018N\\4t!\t\u00113%D\u0001\u000f\u0013\t!cBA\u0007IiR\u0004(gU3ui&twm]\u0001\u000eQ\u0016\fG-\u001a:F]\u000e|G-\u001a:\u0011\u0005\t:\u0013B\u0001\u0015\u000f\u00055AU-\u00193fe\u0016s7m\u001c3fe\u00061A(\u001b8jiz\"2a\u000b\u0017.!\t\u0011\u0003\u0001C\u0003!\u0007\u0001\u0007\u0011\u0005C\u0003&\u0007\u0001\u0007a%\u0001\u0007nCb4%/Y7f'&TX-F\u00011!\tY\u0012'\u0003\u000239\t\u0019\u0011J\u001c;\u0002\u001fM,G/T1y)\u0006\u0014G.Z*ju\u0016$\"!\u000e\u001d\u0011\u0005m1\u0014BA\u001c\u001d\u0005\u0011)f.\u001b;\t\u000be*\u0001\u0019\u0001\u0019\u0002\tML'0Z\u0001\u0014g\u0016\u001c8/[8o/&tGm\\<Va\u0012\fG/\u001a\u000b\u0003y\u0011\u0003\"!\u0010\"\u000e\u0003yR!a\u0010!\u0002\u00079LwNC\u0001B\u0003\u0011Q\u0017M^1\n\u0005\rs$A\u0003\"zi\u0016\u0014UO\u001a4fe\")\u0011H\u0002a\u0001a\u0005\u00112\u000f\u001e:fC6<\u0016N\u001c3poV\u0003H-\u0019;f)\rat)\u0013\u0005\u0006\u0011\u001e\u0001\r\u0001M\u0001\tgR\u0014X-Y7JI\")\u0011h\u0002a\u0001a\u0005I\u0001/\u001b8h\rJ\fW.\u001a\u000b\u0003y1CQ!\u0014\u0005A\u00029\u000bA\u0001Z1uCB\u00191dT)\n\u0005Ac\"!B!se\u0006L\bCA\u000eS\u0013\t\u0019FD\u0001\u0003CsR,\u0017a\u00029j]\u001e\f5m\u001b\u000b\u0003yYCQ!T\u0005A\u00029\u000b\u0001B]:u\rJ\fW.\u001a\u000b\u0004yeS\u0006\"\u0002%\u000b\u0001\u0004\u0001\u0004\"B.\u000b\u0001\u0004a\u0016!C3se>\u00148i\u001c3f!\tYR,\u0003\u0002_9\t!Aj\u001c8h\u0003%!\u0017\r^1Ge\u0006lW\r\u0006\u0003bO\"l\u0007c\u00012fy5\t1M\u0003\u0002e9\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0019\u001c'aA*fc\")\u0001j\u0003a\u0001a!)\u0011n\u0003a\u0001U\u0006IQM\u001c3TiJ,\u0017-\u001c\t\u00037-L!\u0001\u001c\u000f\u0003\u000f\t{w\u000e\\3b]\")Qj\u0003a\u0001y\u0005Y\u0001.Z1eKJ4%/Y7f)\u0015\t\u0007/\u001d<x\u0011\u0015AE\u00021\u00011\u0011\u0015\u0011H\u00021\u0001t\u0003!\u0001(/[8sSRL\bC\u0001\u0012u\u0013\t)hB\u0001\u0005Qe&|'/\u001b;z\u0011\u0015IG\u00021\u0001k\u0011\u0015AH\u00021\u0001z\u0003\u001dAW-\u00193feN\u0004\"A\u001f@\u000f\u0005mdX\"\u0001\t\n\u0005u\u0004\u0012a\u00029bG.\fw-Z\u0005\u0004\u007f\u0006\u0005!a\u0002%fC\u0012,'o\u001d\u0006\u0003{B\u0001")
public final class FrameEncoder {
    private final Http2Settings remoteSettings;
    private final HeaderEncoder headerEncoder;

    private int maxFrameSize() {
        return this.remoteSettings.maxFrameSize();
    }

    public void setMaxTableSize(int size) {
        this.headerEncoder.maxTableSize(size);
    }

    public ByteBuffer sessionWindowUpdate(int size) {
        return this.streamWindowUpdate(0, size);
    }

    public ByteBuffer streamWindowUpdate(int streamId, int size) {
        return FrameSerializer$.MODULE$.mkWindowUpdateFrame(streamId, size);
    }

    public ByteBuffer pingFrame(byte[] data) {
        return FrameSerializer$.MODULE$.mkPingFrame(false, data);
    }

    public ByteBuffer pingAck(byte[] data) {
        return FrameSerializer$.MODULE$.mkPingFrame(true, data);
    }

    public ByteBuffer rstFrame(int streamId, long errorCode) {
        return FrameSerializer$.MODULE$.mkRstStreamFrame(streamId, errorCode);
    }

    public Seq<ByteBuffer> dataFrame(int streamId, boolean endStream, ByteBuffer data) {
        ArrayBuffer arrayBuffer;
        int limit = this.maxFrameSize();
        if (data.remaining() <= limit) {
            arrayBuffer = FrameSerializer$.MODULE$.mkDataFrame(streamId, endStream, 0, data);
        } else {
            ArrayBuffer acc = new ArrayBuffer();
            while (data.hasRemaining()) {
                ByteBuffer thisData = BufferTools$.MODULE$.takeSlice(data, package$.MODULE$.min(data.remaining(), limit));
                boolean eos = endStream && !data.hasRemaining();
                acc.$plus$plus$eq(FrameSerializer$.MODULE$.mkDataFrame(streamId, eos, 0, thisData));
            }
            arrayBuffer = acc;
        }
        return arrayBuffer;
    }

    public Seq<ByteBuffer> headerFrame(int streamId, Priority priority, boolean endStream, Seq<Tuple2<String, String>> headers) {
        ArrayBuffer arrayBuffer;
        int headersPrioritySize;
        ByteBuffer rawHeaders = this.headerEncoder.encodeHeaders(headers);
        int limit = this.maxFrameSize();
        int n = headersPrioritySize = priority.isDefined() ? 5 : 0;
        if (rawHeaders.remaining() + headersPrioritySize <= limit) {
            arrayBuffer = FrameSerializer$.MODULE$.mkHeaderFrame(streamId, priority, true, endStream, 0, rawHeaders);
        } else {
            ArrayBuffer acc = new ArrayBuffer();
            ByteBuffer headersBuf = BufferTools$.MODULE$.takeSlice(rawHeaders, limit - headersPrioritySize);
            acc.$plus$plus$eq(FrameSerializer$.MODULE$.mkHeaderFrame(streamId, priority, false, endStream, 0, headersBuf));
            while (rawHeaders.hasRemaining()) {
                int size = package$.MODULE$.min(limit, rawHeaders.remaining());
                ByteBuffer continueBuf = BufferTools$.MODULE$.takeSlice(rawHeaders, size);
                boolean endHeaders = !rawHeaders.hasRemaining();
                acc.$plus$plus$eq(FrameSerializer$.MODULE$.mkContinuationFrame(streamId, endHeaders, continueBuf));
            }
            arrayBuffer = acc;
        }
        return arrayBuffer;
    }

    public FrameEncoder(Http2Settings remoteSettings, HeaderEncoder headerEncoder) {
        this.remoteSettings = remoteSettings;
        this.headerEncoder = headerEncoder;
    }
}

