/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2StreamException;
import org.http4s.blaze.http.http2.OutboundStreamState;
import org.http4s.blaze.http.http2.SessionCore;
import org.http4s.blaze.http.http2.StreamFlowWindow;
import org.http4s.blaze.http.http2.StreamFrame;
import org.http4s.blaze.http.http2.StreamStateImpl;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.Promise;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0005\u00154Q\u0001D\u0007\u0002\naA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\u0006I\u0001!\t!\n\u0005\u0007Q\u0001\u0001\u000b\u0015B\u0015\t\r=\u0002\u0001\u0015)\u00031\u0011\u0019\u0019\u0004\u0001)C\u0005i!)\u0001\b\u0001D\ts!)Q\b\u0001C#}!)!\t\u0001C#\u0007\")q\n\u0001C#!\")\u0011\u000b\u0001C#%\")1\u000b\u0001C+)\n9r*\u001e;c_VtGm\u0015;sK\u0006l7\u000b^1uK&k\u0007\u000f\u001c\u0006\u0003\u001d=\tQ\u0001\u001b;uaJR!\u0001E\t\u0002\t!$H\u000f\u001d\u0006\u0003%M\tQA\u00197bu\u0016T!\u0001F\u000b\u0002\r!$H\u000f\u001d\u001bt\u0015\u00051\u0012aA8sO\u000e\u00011c\u0001\u0001\u001a;A\u0011!dG\u0007\u0002\u001b%\u0011A$\u0004\u0002\u0010'R\u0014X-Y7Ti\u0006$X-S7qYB\u0011!DH\u0005\u0003?5\u00111cT;uE>,h\u000eZ*ue\u0016\fWn\u0015;bi\u0016\fqa]3tg&|g\u000e\u0005\u0002\u001bE%\u00111%\u0004\u0002\f'\u0016\u001c8/[8o\u0007>\u0014X-\u0001\u0004=S:LGO\u0010\u000b\u0003M\u001d\u0002\"A\u0007\u0001\t\u000b\u0001\u0012\u0001\u0019A\u0011\u0002\u00191\f'0_*ue\u0016\fW.\u00133\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\u0007%sG/\u0001\bmCjLh\t\\8x/&tGm\\<\u0011\u0005i\t\u0014B\u0001\u001a\u000e\u0005A\u0019FO]3b[\u001acwn^,j]\u0012|w/\u0001\fv]&t\u0017\u000e^5bY&TX\rZ#yG\u0016\u0004H/[8o)\u0005)\u0004C\u0001\u00167\u0013\t94FA\u0004O_RD\u0017N\\4\u0002\u001dI,w-[:uKJ\u001cFO]3b[R\t!\bE\u0002+w%J!\u0001P\u0016\u0003\r=\u0003H/[8o\u0003-Ig.\u001b;jC2L'0\u001a3\u0016\u0003}\u0002\"A\u000b!\n\u0005\u0005[#a\u0002\"p_2,\u0017M\\\u0001\u0005]\u0006lW-F\u0001E!\t)EJ\u0004\u0002G\u0015B\u0011qiK\u0007\u0002\u0011*\u0011\u0011jF\u0001\u0007yI|w\u000e\u001e \n\u0005-[\u0013A\u0002)sK\u0012,g-\u0003\u0002N\u001d\n11\u000b\u001e:j]\u001eT!aS\u0016\u0002\u0011M$(/Z1n\u0013\u0012,\u0012!K\u0001\u000bM2|woV5oI><X#\u0001\u0019\u0002#%tgo\\6f'R\u0014X-Y7Xe&$X\rF\u0002V1v\u0003\"A\u000b,\n\u0005][#\u0001B+oSRDQ!W\u0006A\u0002i\u000b1!\\:h!\tQ2,\u0003\u0002]\u001b\tY1\u000b\u001e:fC64%/Y7f\u0011\u0015q6\u00021\u0001`\u0003\u0005\u0001\bc\u00011d+6\t\u0011M\u0003\u0002cW\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\u0011\f'a\u0002)s_6L7/\u001a")
public abstract class OutboundStreamStateImpl
extends StreamStateImpl
implements OutboundStreamState {
    private final SessionCore session;
    private int lazyStreamId;
    private StreamFlowWindow lazyFlowWindow;

    private Nothing$ uninitializedException() {
        throw new IllegalStateException("Stream uninitialized");
    }

    public abstract Option<Object> registerStream();

    @Override
    public final boolean initialized() {
        return this.lazyStreamId != -1;
    }

    public final String name() {
        String id = this.initialized() ? Integer.toString(this.streamId()) : "uninitialized";
        return new StringBuilder(21).append("OutboundStreamState(").append(id).append(")").toString();
    }

    @Override
    public final int streamId() {
        if (!this.initialized()) {
            throw this.uninitializedException();
        }
        return this.lazyStreamId;
    }

    @Override
    public final StreamFlowWindow flowWindow() {
        if (!this.initialized()) {
            throw this.uninitializedException();
        }
        return this.lazyFlowWindow;
    }

    @Override
    public final void invokeStreamWrite(StreamFrame msg, Promise<BoxedUnit> p) {
        if (this.initialized()) {
            super.invokeStreamWrite(msg, p);
        } else if (this.session.state().closing()) {
            Http2StreamException ex = Http2Exception$.MODULE$.REFUSED_STREAM().rst(0, "Session closed before stream was initialized");
            p.failure((Throwable)ex);
        } else {
            Option<Object> option = this.registerStream();
            if (option instanceof Some) {
                Some some = (Some)option;
                int freshId = BoxesRunTime.unboxToInt((Object)some.value());
                this.lazyFlowWindow = this.session.sessionFlowControl().newStreamFlowWindow(freshId);
                this.lazyStreamId = freshId;
                if (this.logger().isDebugEnabled()) {
                    this.logger().debug(new StringBuilder(36).append("Created new OutboundStream with id ").append(freshId).append(".").toString());
                }
                super.invokeStreamWrite(msg, p);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                this.session.invokeDrain((Duration)Duration$.MODULE$.Inf());
                Http2StreamException ex = Http2Exception$.MODULE$.REFUSED_STREAM().rst(0, "Session is out of outbound stream IDs");
                p.failure((Throwable)ex);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
        }
    }

    public OutboundStreamStateImpl(SessionCore session) {
        this.session = session;
        super(session);
        this.lazyStreamId = -1;
        this.lazyFlowWindow = null;
    }
}

