/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.nio.ByteBuffer;
import org.http4s.blaze.http.http2.FrameDecoder$;
import org.http4s.blaze.http.http2.Http2Exception;
import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2Settings;
import org.http4s.blaze.http.http2.MutableHttp2Settings;
import org.http4s.blaze.http.http2.MutableHttp2Settings$;
import org.http4s.blaze.http.http2.SettingsDecoder;
import org.http4s.blaze.http.http2.bits$;
import org.http4s.blaze.http.http2.bits$Flags$;
import org.http4s.blaze.http.http2.bits$FrameTypes$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ReusableBuilder;
import scala.package$;
import scala.util.Either;
import scala.util.Right$;

public final class SettingsDecoder$ {
    public static final SettingsDecoder$ MODULE$ = new SettingsDecoder$();

    public Either<Http2Exception, SettingsDecoder.SettingsFrame> decodeSettingsFrame(ByteBuffer buffer) {
        int len = FrameDecoder$.MODULE$.getLengthField(buffer);
        Predef$.MODULE$.assert(len + bits$.MODULE$.HeaderSize() - bits$.MODULE$.LengthFieldSize() == buffer.remaining());
        byte tpe = buffer.get();
        if (tpe != bits$FrameTypes$.MODULE$.SETTINGS()) {
            return package$.MODULE$.Left().apply((Object)Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Expected SETTINGS frame"));
        }
        byte flags = buffer.get();
        int streamId = FrameDecoder$.MODULE$.getStreamId(buffer);
        return this.decodeSettingsFrame(buffer, streamId, flags);
    }

    public Either<Http2Exception, SettingsDecoder.SettingsFrame> decodeSettingsFrame(ByteBuffer buffer, int streamId, byte flags) {
        SettingsDecoder.SettingsFrame settingsFrame;
        int len = buffer.remaining();
        boolean isAck = bits$Flags$.MODULE$.ACK(flags);
        if (len % 6 != 0) {
            String msg = new StringBuilder(58).append("SETTINGS frame payload must be multiple of 6 bytes, size: ").append(len).toString();
            return package$.MODULE$.Left().apply((Object)Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway(msg));
        }
        if (isAck && len != 0) {
            int settingsCount = len / 6;
            String msg = new StringBuilder(52).append("SETTINGS ACK frame with settings payload (").append(settingsCount).append(" settings)").toString();
            return package$.MODULE$.Left().apply((Object)Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway(msg));
        }
        if (streamId != 0) {
            return package$.MODULE$.Left().apply((Object)Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(new StringBuilder(39).append("SETTINGS frame with invalid stream id: ").append(streamId).toString()));
        }
        Right$ right$ = package$.MODULE$.Right();
        if (isAck) {
            settingsFrame = new SettingsDecoder.SettingsFrame((Option<Seq<Http2Settings.Setting>>)None$.MODULE$);
        } else {
            ReusableBuilder settings = package$.MODULE$.Vector().newBuilder();
            while (buffer.hasRemaining()) {
                int id = buffer.getShort() & 0xFFFF;
                int value = buffer.getInt();
                settings.$plus$eq((Object)new Http2Settings.Setting(id, value));
            }
            settingsFrame = new SettingsDecoder.SettingsFrame((Option<Seq<Http2Settings.Setting>>)new Some(settings.result()));
        }
        return right$.apply((Object)settingsFrame);
    }

    public Either<Http2Exception, MutableHttp2Settings> settingsFromFrame(Seq<Http2Settings.Setting> settings) {
        MutableHttp2Settings next = MutableHttp2Settings$.MODULE$.default();
        Option<Http2Exception> option = next.updateSettings(settings);
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Right().apply((Object)next);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Http2Exception ex = (Http2Exception)some.value();
            return package$.MODULE$.Left().apply((Object)ex);
        }
        throw new MatchError(option);
    }

    private SettingsDecoder$() {
    }
}

