/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.http4s.blaze.http.HeaderNames$;
import org.http4s.blaze.http.util.HeaderLike;
import org.http4s.blaze.http.util.HeaderLike$;
import org.http4s.blaze.http.util.HeaderTools;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class HeaderTools$ {
    public static final HeaderTools$ MODULE$ = new HeaderTools$();
    private static final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz").withLocale(Locale.US).withZone(ZoneId.of("GMT"));
    private static volatile HeaderTools.CachedDateHeader dateTime = new HeaderTools.CachedDateHeader(0L, "");

    private DateTimeFormatter dateFormat() {
        return dateFormat;
    }

    private HeaderTools.CachedDateHeader dateTime() {
        return dateTime;
    }

    private void dateTime_$eq(HeaderTools.CachedDateHeader x$1) {
        dateTime = x$1;
    }

    private String getDateHeader() {
        HeaderTools.CachedDateHeader cached = this.dateTime();
        long current = System.currentTimeMillis();
        if (current - cached.acquired() <= 1000L) {
            return cached.header();
        }
        String next = new java.lang.StringBuilder(8).append("date: ").append(this.dateFormat().format(Instant.now())).append("\r\n").toString();
        this.dateTime_$eq(new HeaderTools.CachedDateHeader(current, next));
        return next;
    }

    public boolean isKeepAlive(Option<String> connectionHeader, int minorVersion) {
        Option<String> option = connectionHeader;
        if (option instanceof Some) {
            Some some = (Some)option;
            String headerValue = (String)some.value();
            if (headerValue.equalsIgnoreCase("keep-alive")) {
                return true;
            }
            if (headerValue.equalsIgnoreCase("close")) {
                return false;
            }
            return headerValue.equalsIgnoreCase("upgrade");
        }
        if (None$.MODULE$.equals(option)) {
            return minorVersion != 0;
        }
        throw new MatchError(option);
    }

    public <H> HeaderTools.SpecialHeaders renderHeaders(StringBuilder sb, Iterable<H> headers, HeaderLike<H> evidence$1) {
        None$ transferEncoding = None$.MODULE$;
        None$ contentLength = None$.MODULE$;
        None$ connection = None$.MODULE$;
        boolean hasDateheader = false;
        HeaderLike<H> hl = HeaderLike$.MODULE$.apply(evidence$1);
        for (Object header : headers) {
            BoxedUnit boxedUnit;
            String k = hl.getKey(header);
            String v = hl.getValue(header);
            if (k.equalsIgnoreCase(HeaderNames$.MODULE$.TransferEncoding())) {
                transferEncoding = new Some((Object)v);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (k.equalsIgnoreCase(HeaderNames$.MODULE$.ContentLength())) {
                contentLength = new Some((Object)v);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (k.equalsIgnoreCase(HeaderNames$.MODULE$.Connection())) {
                connection = new Some((Object)v);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (!hasDateheader && k.equalsIgnoreCase(HeaderNames$.MODULE$.Date())) {
                hasDateheader = true;
            }
            sb.append(k);
            Object object = v.length() > 0 ? sb.append(": ").append(v) : BoxedUnit.UNIT;
            boxedUnit = sb.append("\r\n");
        }
        Object object = !hasDateheader ? sb.append(this.getDateHeader()) : BoxedUnit.UNIT;
        return new HeaderTools.SpecialHeaders((Option<String>)transferEncoding, (Option<String>)contentLength, (Option<String>)connection);
    }

    private HeaderTools$() {
    }
}

