/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.http4s.blaze.http.http2.PingManager$;
import org.http4s.blaze.http.http2.PingManager$Idle$;
import org.http4s.blaze.http.http2.SessionCore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.Product;
import scala.collection.Iterator;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t=e\u0001\u0002%J\tQC\u0001b\u0017\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\u0006A\u0002!\t!\u0019\u0005\u0007I\u0002\u0001\u000b\u0011B3\t\r-\u0004\u0001\u0015)\u0003m\u0011\u001d\u00119\u0007\u0001C\u0001\u0005SBqA!\u001d\u0001\t\u0003\u0011\u0019\bC\u0004\u0003\f\u0002!\tA!$\b\u000b9L\u0005\u0012B8\u0007\u000b!K\u0005\u0012\u00029\t\u000b\u0001LA\u0011A9\u0007\u000fIL\u0001\u0013aI\u0015g\u001e9!QB\u0005\t\n\u0006\rfaBAO\u0013!%\u0015q\u0014\u0005\u0007A6!\t!!)\t\u0013\u0005\u0005S\"!A\u0005B\u0005\r\u0003\"CA+\u001b\u0005\u0005I\u0011AA,\u0011%\ty&DA\u0001\n\u0003\t)\u000bC\u0005\u0002n5\t\t\u0011\"\u0011\u0002p!I\u0011QP\u0007\u0002\u0002\u0013\u0005\u0011\u0011\u0016\u0005\n\u0003\u001fk\u0011\u0011!C!\u0003#C\u0011\"a%\u000e\u0003\u0003%\t%!&\t\u0013\u00055V\"!A\u0005\n\u0005=fABA\\\u0013\u0011\u000bI\f\u0003\u0006\u0002<^\u0011)\u001a!C\u0001\u0003{C!\"!2\u0018\u0005#\u0005\u000b\u0011BA`\u0011)\t9m\u0006BK\u0002\u0013\u0005\u0011\u0011\u001a\u0005\u000b\u0003G<\"\u0011#Q\u0001\n\u0005-\u0007B\u00021\u0018\t\u0003\t)\u000fC\u0005\u0002$]\t\t\u0011\"\u0001\u0002n\"I\u0011\u0011F\f\u0012\u0002\u0013\u0005\u00111\u001f\u0005\n\u0003o<\u0012\u0013!C\u0001\u0003sD\u0011\"!\u0011\u0018\u0003\u0003%\t%a\u0011\t\u0013\u0005Us#!A\u0005\u0002\u0005]\u0003\"CA0/\u0005\u0005I\u0011AA\u007f\u0011%\tigFA\u0001\n\u0003\ny\u0007C\u0005\u0002~]\t\t\u0011\"\u0001\u0003\u0002!I\u0011\u0011R\f\u0002\u0002\u0013\u0005#Q\u0001\u0005\n\u0003\u001f;\u0012\u0011!C!\u0003#C\u0011\"a%\u0018\u0003\u0003%\t%!&\t\u0013\u0005]u#!A\u0005B\t%q!\u0003B\b\u0013\u0005\u0005\t\u0012\u0002B\t\r%\t9,CA\u0001\u0012\u0013\u0011\u0019\u0002\u0003\u0004aU\u0011\u0005!1\u0006\u0005\n\u0003'S\u0013\u0011!C#\u0003+C\u0011B!\f+\u0003\u0003%\tIa\f\t\u0013\tU\"&!A\u0005\u0002\n]\u0002\"CAWU\u0005\u0005I\u0011BAX\r\u0011)\u0018\u0002\u0012<\t\u0015\u0005E\u0001G!f\u0001\n\u0003\t\u0019\u0002\u0003\u0006\u0002\u001cA\u0012\t\u0012)A\u0005\u0003+Aa\u0001\u0019\u0019\u0005\u0002\u0005u\u0001\"CA\u0012a\u0005\u0005I\u0011AA\u0013\u0011%\tI\u0003MI\u0001\n\u0003\tY\u0003C\u0005\u0002BA\n\t\u0011\"\u0011\u0002D!I\u0011Q\u000b\u0019\u0002\u0002\u0013\u0005\u0011q\u000b\u0005\n\u0003?\u0002\u0014\u0011!C\u0001\u0003CB\u0011\"!\u001c1\u0003\u0003%\t%a\u001c\t\u0013\u0005u\u0004'!A\u0005\u0002\u0005}\u0004\"CAEa\u0005\u0005I\u0011IAF\u0011%\ty\tMA\u0001\n\u0003\n\t\nC\u0005\u0002\u0014B\n\t\u0011\"\u0011\u0002\u0016\"I\u0011q\u0013\u0019\u0002\u0002\u0013\u0005\u0013\u0011T\u0004\n\u0005\u0013J\u0011\u0011!E\u0005\u0005\u00172\u0001\"^\u0005\u0002\u0002#%!Q\n\u0005\u0007A\u0002#\tA!\u0016\t\u0013\u0005M\u0005)!A\u0005F\u0005U\u0005\"\u0003B\u0017\u0001\u0006\u0005I\u0011\u0011B,\u0011%\u0011)\u0004QA\u0001\n\u0003\u0013Y\u0006C\u0005\u0002.\u0002\u000b\t\u0011\"\u0003\u00020\"I!\u0011M\u0005C\u0002\u0013%!1\r\u0005\t\u0005KJ\u0001\u0015!\u0003\u0002 \tY\u0001+\u001b8h\u001b\u0006t\u0017mZ3s\u0015\tQ5*A\u0003iiR\u0004(G\u0003\u0002M\u001b\u0006!\u0001\u000e\u001e;q\u0015\tqu*A\u0003cY\u0006TXM\u0003\u0002Q#\u00061\u0001\u000e\u001e;qiMT\u0011AU\u0001\u0004_J<7\u0001A\n\u0003\u0001U\u0003\"AV-\u000e\u0003]S\u0011\u0001W\u0001\u0006g\u000e\fG.Y\u0005\u00035^\u0013a!\u00118z%\u00164\u0017aB:fgNLwN\u001c\t\u0003;zk\u0011!S\u0005\u0003?&\u00131bU3tg&|gnQ8sK\u00061A(\u001b8jiz\"\"AY2\u0011\u0005u\u0003\u0001\"B.\u0003\u0001\u0004a\u0016A\u00027pO\u001e,'\u000f\u0005\u0002gS6\tqM\u0003\u0002i#\u0006)An\\45g&\u0011!n\u001a\u0002\u0007\u0019><w-\u001a:\u0002\u000bM$\u0018\r^3\u0011\u00055\\aBA/\t\u0003-\u0001\u0016N\\4NC:\fw-\u001a:\u0011\u0005uK1CA\u0005V)\u0005y'!B*uCR,7CA\u0006VS\u0011Y\u0001'D\f\u0003\r\rcwn]3e'\u0015\u0001Tk^=}!\tA8\"D\u0001\n!\t1&0\u0003\u0002|/\n9\u0001K]8ek\u000e$\bcA?\u0002\f9\u0019a0a\u0002\u000f\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111A*\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0016bAA\u0005/\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u0007\u0003\u001f\u0011AbU3sS\u0006d\u0017N_1cY\u0016T1!!\u0003X\u0003\t)\u00070\u0006\u0002\u0002\u0016A\u0019Q0a\u0006\n\t\u0005e\u0011q\u0002\u0002\n\u000bb\u001cW\r\u001d;j_:\f1!\u001a=!)\u0011\ty\"!\t\u0011\u0005a\u0004\u0004bBA\tg\u0001\u0007\u0011QC\u0001\u0005G>\u0004\u0018\u0010\u0006\u0003\u0002 \u0005\u001d\u0002\"CA\tiA\u0005\t\u0019AA\u000b\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\f+\t\u0005U\u0011qF\u0016\u0003\u0003c\u0001B!a\r\u0002>5\u0011\u0011Q\u0007\u0006\u0005\u0003o\tI$A\u0005v]\u000eDWmY6fI*\u0019\u00111H,\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002@\u0005U\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0012\u0011\t\u0005\u001d\u0013\u0011K\u0007\u0003\u0003\u0013RA!a\u0013\u0002N\u0005!A.\u00198h\u0015\t\ty%\u0001\u0003kCZ\f\u0017\u0002BA*\u0003\u0013\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA-!\r1\u00161L\u0005\u0004\u0003;:&aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA2\u0003S\u00022AVA3\u0013\r\t9g\u0016\u0002\u0004\u0003:L\b\"CA6q\u0005\u0005\t\u0019AA-\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u000f\t\u0007\u0003g\nI(a\u0019\u000e\u0005\u0005U$bAA</\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005m\u0014Q\u000f\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0002\u0006\u001d\u0005c\u0001,\u0002\u0004&\u0019\u0011QQ,\u0003\u000f\t{w\u000e\\3b]\"I\u00111\u000e\u001e\u0002\u0002\u0003\u0007\u00111M\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002F\u00055\u0005\"CA6w\u0005\u0005\t\u0019AA-\u0003!A\u0017m\u001d5D_\u0012,GCAA-\u0003!!xn\u0015;sS:<GCAA#\u0003\u0019)\u0017/^1mgR!\u0011\u0011QAN\u0011%\tYGPA\u0001\u0002\u0004\t\u0019G\u0001\u0003JI2,7#B\u0007VofdHCAAR!\tAX\u0002\u0006\u0003\u0002d\u0005\u001d\u0006\"CA6#\u0005\u0005\t\u0019AA-)\u0011\t\t)a+\t\u0013\u0005-4#!AA\u0002\u0005\r\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAAY!\u0011\t9%a-\n\t\u0005U\u0016\u0011\n\u0002\u0007\u001f\nTWm\u0019;\u0003\u000fAKgnZ5oON)q#V<zy\u000691\u000f^1si\u0016$WCAA`!\r1\u0016\u0011Y\u0005\u0004\u0003\u0007<&\u0001\u0002'p]\u001e\f\u0001b\u001d;beR,G\rI\u0001\u0002aV\u0011\u00111\u001a\t\u0007\u0003\u001b\f\u0019.a6\u000e\u0005\u0005='bAAi/\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005U\u0017q\u001a\u0002\b!J|W.[:f!\u0011\tI.a8\u000e\u0005\u0005m'\u0002BAo\u0003\u001f\f\u0001\u0002Z;sCRLwN\\\u0005\u0005\u0003C\fYN\u0001\u0005EkJ\fG/[8o\u0003\t\u0001\b\u0005\u0006\u0004\u0002h\u0006%\u00181\u001e\t\u0003q^Aq!a/\u001d\u0001\u0004\ty\fC\u0004\u0002Hr\u0001\r!a3\u0015\r\u0005\u001d\u0018q^Ay\u0011%\tY,\bI\u0001\u0002\u0004\ty\fC\u0005\u0002Hv\u0001\n\u00111\u0001\u0002LV\u0011\u0011Q\u001f\u0016\u0005\u0003\u007f\u000by#\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005m(\u0006BAf\u0003_!B!a\u0019\u0002\u0000\"I\u00111\u000e\u0012\u0002\u0002\u0003\u0007\u0011\u0011\f\u000b\u0005\u0003\u0003\u0013\u0019\u0001C\u0005\u0002l\u0011\n\t\u00111\u0001\u0002dQ!\u0011Q\tB\u0004\u0011%\tY'JA\u0001\u0002\u0004\tI\u0006\u0006\u0003\u0002\u0002\n-\u0001\"CA6Q\u0005\u0005\t\u0019AA2\u0003\u0011IE\r\\3\u0002\u000fAKgnZ5oOB\u0011\u0001PK\n\u0006U\tU!\u0011\u0005\t\u000b\u0005/\u0011i\"a0\u0002L\u0006\u001dXB\u0001B\r\u0015\r\u0011YbV\u0001\beVtG/[7f\u0013\u0011\u0011yB!\u0007\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0003$\t%RB\u0001B\u0013\u0015\u0011\u00119#!\u0014\u0002\u0005%|\u0017\u0002BA\u0007\u0005K!\"A!\u0005\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005\u001d(\u0011\u0007B\u001a\u0011\u001d\tY,\fa\u0001\u0003\u007fCq!a2.\u0001\u0004\tY-A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\te\"Q\t\t\u0006-\nm\"qH\u0005\u0004\u0005{9&AB(qi&|g\u000eE\u0004W\u0005\u0003\ny,a3\n\u0007\t\rsK\u0001\u0004UkBdWM\r\u0005\n\u0005\u000fr\u0013\u0011!a\u0001\u0003O\f1\u0001\u001f\u00131\u0003\u0019\u0019En\\:fIB\u0011\u0001\u0010Q\n\u0006\u0001\n=#\u0011\u0005\t\t\u0005/\u0011\t&!\u0006\u0002 %!!1\u000bB\r\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u000b\u0003\u0005\u0017\"B!a\b\u0003Z!9\u0011\u0011C\"A\u0002\u0005UA\u0003\u0002B/\u0005?\u0002RA\u0016B\u001e\u0003+A\u0011Ba\u0012E\u0003\u0003\u0005\r!a\b\u0002\u001d\u001d\u0013\u0018mY3gk2\u001cEn\\:fIV\u0011\u0011qD\u0001\u0010\u000fJ\f7-\u001a4vY\u000ecwn]3eA\u0005!\u0001/\u001b8h)\t\u0011Y\u0007\u0005\u0004\u0002N\n5\u0014q[\u0005\u0005\u0005_\nyM\u0001\u0004GkR,(/Z\u0001\u0010a&tw-Q2l%\u0016\u001cW-\u001b<fIR!!Q\u000fB>!\r1&qO\u0005\u0004\u0005s:&\u0001B+oSRDqA! \u0007\u0001\u0004\u0011y(\u0001\u0003eCR\f\u0007#\u0002,\u0003\u0002\n\u0015\u0015b\u0001BB/\n)\u0011I\u001d:bsB\u0019aKa\"\n\u0007\t%uK\u0001\u0003CsR,\u0017!B2m_N,GC\u0001B;\u0001")
public class PingManager {
    private final SessionCore session;
    private final Logger logger;
    private State state;

    public Future<Duration> ping() {
        long time = System.currentTimeMillis();
        State state = this.state;
        if (PingManager$Idle$.MODULE$.equals(state)) {
            byte[] data = new byte[8];
            ByteBuffer.wrap(data).putLong(time);
            ByteBuffer pingFrame = this.session.http2Encoder().pingFrame(data);
            if (this.session.writeController().write(pingFrame)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(new StringBuilder(18).append("PING initiated at ").append(time).toString());
                }
                Promise p = Promise$.MODULE$.apply();
                this.state = new Pinging(time, (Promise<Duration>)p);
                return p.future();
            }
            Exception ex = new Exception("Socket closed");
            this.state = new Closed(ex);
            return Future$.MODULE$.failed((Throwable)ex);
        }
        if (state instanceof Pinging) {
            IllegalStateException ex = new IllegalStateException("Ping already in progress");
            return Future$.MODULE$.failed((Throwable)ex);
        }
        if (state instanceof Closed) {
            Closed closed = (Closed)state;
            Exception ex = closed.ex();
            return Future$.MODULE$.failed((Throwable)ex);
        }
        throw new MatchError((Object)state);
    }

    public void pingAckReceived(byte[] data) {
        State state = this.state;
        if (state instanceof Pinging) {
            Pinging pinging = (Pinging)state;
            long sent = pinging.started();
            Promise<Duration> continuation = pinging.p();
            this.state = PingManager$Idle$.MODULE$;
            if (ByteBuffer.wrap(data).getLong() != sent) {
                String msg = "Received ping response with unknown data.";
                Exception ex = new Exception(msg);
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn(msg, (Throwable)ex);
                }
                continuation.tryFailure((Throwable)ex);
                return;
            }
            FiniteDuration duration = Duration$.MODULE$.create(package$.MODULE$.max(0L, System.currentTimeMillis() - sent), TimeUnit.MILLISECONDS);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(new StringBuilder(15).append("Ping duration: ").append(duration).toString());
            }
            continuation.trySuccess((Object)duration);
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(new StringBuilder(20).append("Ping ACKed in state ").append(state).toString());
            return;
        }
    }

    public void close() {
        State state = this.state;
        if (state instanceof Closed) {
            return;
        }
        if (PingManager$Idle$.MODULE$.equals(state)) {
            this.state = PingManager$.MODULE$.org$http4s$blaze$http$http2$PingManager$$GracefulClosed();
            return;
        }
        if (state instanceof Pinging) {
            Pinging pinging = (Pinging)state;
            Promise<Duration> p = pinging.p();
            this.state = PingManager$.MODULE$.org$http4s$blaze$http$http2$PingManager$$GracefulClosed();
            p.failure((Throwable)new Exception("PING interrupted"));
            return;
        }
        throw new MatchError((Object)state);
    }

    public PingManager(SessionCore session) {
        this.session = session;
        this.logger = LoggerFactory.getLogger(PingManager.class);
        this.state = PingManager$Idle$.MODULE$;
    }

    private static class Closed
    implements State,
    Product,
    Serializable {
        private final Exception ex;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Exception ex() {
            return this.ex;
        }

        public Closed copy(Exception ex) {
            return new Closed(ex);
        }

        public Exception copy$default$1() {
            return this.ex();
        }

        public String productPrefix() {
            return "Closed";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.ex();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Closed;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "ex";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Closed)) return false;
            boolean bl = true;
            if (!bl) return false;
            Closed closed = (Closed)x$1;
            Exception exception = this.ex();
            Exception exception2 = closed.ex();
            if (exception == null) {
                if (exception2 != null) {
                    return false;
                }
            } else if (!exception.equals(exception2)) return false;
            if (!closed.canEqual(this)) return false;
            return true;
        }

        public Closed(Exception ex) {
            this.ex = ex;
            Product.$init$((Product)this);
        }
    }

    private static class Pinging
    implements State,
    Product,
    Serializable {
        private final long started;
        private final Promise<Duration> p;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long started() {
            return this.started;
        }

        public Promise<Duration> p() {
            return this.p;
        }

        public Pinging copy(long started, Promise<Duration> p) {
            return new Pinging(started, p);
        }

        public long copy$default$1() {
            return this.started();
        }

        public Promise<Duration> copy$default$2() {
            return this.p();
        }

        public String productPrefix() {
            return "Pinging";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.started());
                }
                case 1: {
                    return this.p();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Pinging;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "started";
                }
                case 1: {
                    return "p";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.started()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.p()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Pinging)) return false;
            boolean bl = true;
            if (!bl) return false;
            Pinging pinging = (Pinging)x$1;
            if (this.started() != pinging.started()) return false;
            Promise<Duration> promise = this.p();
            Promise<Duration> promise2 = pinging.p();
            if (promise == null) {
                if (promise2 != null) {
                    return false;
                }
            } else if (!promise.equals(promise2)) return false;
            if (!pinging.canEqual(this)) return false;
            return true;
        }

        public Pinging(long started, Promise<Duration> p) {
            this.started = started;
            this.p = p;
            Product.$init$((Product)this);
        }
    }

    private static interface State {
    }
}

